/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ModifiableObservableListBase;

public class FileHistory
extends ModifiableObservableListBase<Path> {
    private static final int HISTORY_SIZE = 8;
    private final List<Path> history;

    private FileHistory(List<Path> list) {
        this.history = new ArrayList<Path>(list);
    }

    public Path get(int index) {
        return this.history.get(index);
    }

    public int size() {
        return this.history.size();
    }

    protected void doAdd(int index, Path element) {
        this.history.add(index, element);
    }

    protected Path doSet(int index, Path element) {
        return this.history.set(index, element);
    }

    protected Path doRemove(int index) {
        return this.history.remove(index);
    }

    public void newFile(Path file) {
        this.removeItem(file);
        this.addFirst(file);
        while (this.size() > 8) {
            this.history.remove(8);
        }
    }

    public void removeItem(Path file) {
        this.remove(file);
    }

    public static FileHistory of(List<Path> list) {
        return new FileHistory(new ArrayList<Path>(list));
    }
}

