/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.gui.DialogService;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNameUniqueness {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileNameUniqueness.class);
    private static final Pattern DUPLICATE_MARK_PATTERN = Pattern.compile("(.*) \\(\\d+\\)");

    public static String getNonOverWritingFileName(Path targetDirectory, String fileName) {
        String fileNameWithoutExtension;
        Object extensionSuffix;
        Optional<String> extensionOptional = FileUtil.getFileExtension(fileName);
        if (extensionOptional.isPresent()) {
            extensionSuffix = "." + extensionOptional.get();
            fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(46));
        } else {
            extensionSuffix = "";
            fileNameWithoutExtension = fileName;
        }
        Object newFileName = fileName;
        int counter = 1;
        while (Files.exists(targetDirectory.resolve((String)newFileName), new LinkOption[0])) {
            newFileName = fileNameWithoutExtension + " (" + counter + ")" + (String)extensionSuffix;
            ++counter;
        }
        return newFileName;
    }

    public static boolean isDuplicatedFile(Path directory, Path fileName, DialogService dialogService) throws IOException {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(fileName);
        Objects.requireNonNull(dialogService);
        Object extensionSuffix = FileUtil.getFileExtension(fileName).orElse("");
        extensionSuffix = "".equals(extensionSuffix) ? extensionSuffix : "." + (String)extensionSuffix;
        String newFilename = FileUtil.getBaseName(fileName) + (String)extensionSuffix;
        String fileNameWithoutDuplicated = FileNameUniqueness.eraseDuplicateMarks(FileUtil.getBaseName(fileName));
        String originalFileName = fileNameWithoutDuplicated + (String)extensionSuffix;
        if (newFilename.equals(originalFileName)) {
            return false;
        }
        Path originalFile = directory.resolve(originalFileName);
        Path duplicateFile = directory.resolve(fileName);
        int counter = 1;
        while (Files.exists(originalFile, new LinkOption[0])) {
            if (com.google.common.io.Files.equal((File)originalFile.toFile(), (File)duplicateFile.toFile())) {
                try {
                    Files.delete(duplicateFile);
                    dialogService.notify(Localization.lang("File '%1' is a duplicate of '%0'. Keeping '%0'", originalFileName, fileName));
                }
                catch (IOException e) {
                    LOGGER.error("File '{}' is a duplicate of '{}'. Could not delete '{}'.", new Object[]{fileName, originalFileName, fileName});
                }
                return true;
            }
            originalFileName = fileNameWithoutDuplicated + " (" + counter + ")" + (String)extensionSuffix;
            ++counter;
            if (newFilename.equals(originalFileName)) {
                return false;
            }
            originalFile = directory.resolve(originalFileName);
        }
        return false;
    }

    public static String eraseDuplicateMarks(String fileName) {
        Matcher m = DUPLICATE_MARK_PATTERN.matcher(fileName);
        return m.find() ? fileName.substring(0, fileName.lastIndexOf(40) - 1) : fileName;
    }

    public static Path eraseDuplicateMarks(Path filePath) {
        String extensionSuffix = FileUtil.getFileExtension(filePath).map(ext -> "." + ext).orElse("");
        return filePath.resolveSibling(FileNameUniqueness.eraseDuplicateMarks(FileUtil.getBaseName(filePath)) + extensionSuffix);
    }
}

