/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.migrations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.importer.ParserResult;
import org.jabref.migrations.PostOpenMigration;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupTreeNode;

public class ConvertLegacyExplicitGroups
implements PostOpenMigration {
    @Override
    public void performMigration(ParserResult parserResult) {
        Objects.requireNonNull(parserResult);
        if (!parserResult.getMetaData().getGroups().isPresent()) {
            return;
        }
        for (ExplicitGroup group : this.getExplicitGroupsWithLegacyKeys(parserResult.getMetaData().getGroups().get())) {
            for (String entryKey : group.getLegacyEntryKeys()) {
                for (BibEntry entry : parserResult.getDatabase().getEntriesByCitationKey(entryKey)) {
                    group.add(entry);
                }
            }
            group.clearLegacyEntryKeys();
        }
    }

    private List<ExplicitGroup> getExplicitGroupsWithLegacyKeys(GroupTreeNode node) {
        ExplicitGroup group;
        Objects.requireNonNull(node);
        ArrayList<ExplicitGroup> findings = new ArrayList<ExplicitGroup>();
        if (node.getGroup() instanceof ExplicitGroup && !(group = (ExplicitGroup)node.getGroup()).getLegacyEntryKeys().isEmpty()) {
            findings.add(group);
        }
        node.getChildren().forEach(child -> findings.addAll(this.getExplicitGroupsWithLegacyKeys((GroupTreeNode)child)));
        return findings;
    }
}

