/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.EventBus;
import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.optional.OptionalBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.logic.bibtex.FileFieldWriter;
import org.jabref.logic.importer.util.FileFieldParser;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.CanonicalBibEntry;
import org.jabref.model.entry.Date;
import org.jabref.model.entry.EntryConverter;
import org.jabref.model.entry.EntryLinkList;
import org.jabref.model.entry.IdGenerator;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.Month;
import org.jabref.model.entry.ParsedEntryLink;
import org.jabref.model.entry.SharedBibEntryData;
import org.jabref.model.entry.event.EntriesEventSource;
import org.jabref.model.entry.event.FieldAddedOrRemovedEvent;
import org.jabref.model.entry.event.FieldChangedEvent;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.entry.identifier.ISBN;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.IEEETranEntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.LatexToUnicodeAdapter;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.MultiKeyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseLogic(value="because it needs access to parser and writers")
public class BibEntry
implements Cloneable {
    public static final EntryType DEFAULT_TYPE = StandardEntryType.Misc;
    private static final Logger LOGGER = LoggerFactory.getLogger(BibEntry.class);
    private final SharedBibEntryData sharedBibEntryData;
    private final Map<Field, Set<String>> fieldsAsWords = new HashMap<Field, Set<String>>();
    private final Map<Field, String> latexFreeFields = new ConcurrentHashMap<Field, String>();
    private final MultiKeyMap<StandardField, Character, KeywordList> fieldsAsKeywords = new MultiKeyMap(StandardField.class);
    private final EventBus eventBus = new EventBus();
    private String id;
    private final ObjectProperty<EntryType> type = new SimpleObjectProperty((Object)DEFAULT_TYPE);
    private ObservableMap<Field, String> fields = FXCollections.observableMap(new ConcurrentHashMap());
    private String commentsBeforeEntry = "";
    private String parsedSerialization = "";
    private boolean changed;

    public BibEntry() {
        this(DEFAULT_TYPE);
    }

    public BibEntry(String citationKey) {
        this();
        this.setCitationKey(citationKey);
    }

    public BibEntry(EntryType type) {
        this.id = IdGenerator.next();
        this.setType(type);
        this.sharedBibEntryData = new SharedBibEntryData();
    }

    public BibEntry(EntryType type, String citationKey) {
        this(type);
        this.setCitationKey(citationKey);
    }

    public Optional<FieldChange> setMonth(Month parsedMonth) {
        return this.setField(StandardField.MONTH, parsedMonth.getJabRefFormat());
    }

    public Optional<String> getResolvedFieldOrAlias(OrFields fields, BibDatabase database) {
        for (Field field : fields.getFields()) {
            Optional<String> value = this.getResolvedFieldOrAlias(field, database);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    private Optional<Field> getSourceField(Field targetField, EntryType targetEntry, EntryType sourceEntry) {
        if (targetField == StandardField.IDS || targetField == StandardField.CROSSREF || targetField == StandardField.XREF || targetField == StandardField.ENTRYSET || targetField == StandardField.RELATED || targetField == StandardField.SORTKEY) {
            return Optional.empty();
        }
        if (sourceEntry == StandardEntryType.MvBook && targetEntry == StandardEntryType.InBook || sourceEntry == StandardEntryType.MvBook && targetEntry == StandardEntryType.BookInBook || sourceEntry == StandardEntryType.MvBook && targetEntry == StandardEntryType.SuppBook || sourceEntry == StandardEntryType.Book && targetEntry == StandardEntryType.InBook || sourceEntry == StandardEntryType.Book && targetEntry == StandardEntryType.BookInBook || sourceEntry == StandardEntryType.Book && targetEntry == StandardEntryType.SuppBook) {
            if (targetField == StandardField.AUTHOR) {
                return Optional.of(StandardField.AUTHOR);
            }
            if (targetField == StandardField.BOOKAUTHOR) {
                return Optional.of(StandardField.AUTHOR);
            }
        }
        if (sourceEntry == StandardEntryType.MvBook && targetEntry == StandardEntryType.Book || sourceEntry == StandardEntryType.MvBook && targetEntry == StandardEntryType.InBook || sourceEntry == StandardEntryType.MvBook && targetEntry == StandardEntryType.BookInBook || sourceEntry == StandardEntryType.MvBook && targetEntry == StandardEntryType.SuppBook || sourceEntry == StandardEntryType.MvCollection && targetEntry == StandardEntryType.Collection || sourceEntry == StandardEntryType.MvCollection && targetEntry == StandardEntryType.InCollection || sourceEntry == StandardEntryType.MvCollection && targetEntry == StandardEntryType.SuppCollection || sourceEntry == StandardEntryType.MvProceedings && targetEntry == StandardEntryType.Proceedings || sourceEntry == StandardEntryType.MvProceedings && targetEntry == StandardEntryType.InProceedings || sourceEntry == StandardEntryType.MvReference && targetEntry == StandardEntryType.Reference || sourceEntry == StandardEntryType.MvReference && targetEntry == StandardEntryType.InReference) {
            if (targetField == StandardField.MAINTITLE) {
                return Optional.of(StandardField.TITLE);
            }
            if (targetField == StandardField.MAINSUBTITLE) {
                return Optional.of(StandardField.SUBTITLE);
            }
            if (targetField == StandardField.MAINTITLEADDON) {
                return Optional.of(StandardField.TITLEADDON);
            }
            if (targetField == StandardField.TITLE || targetField == StandardField.SUBTITLE || targetField == StandardField.TITLEADDON) {
                return Optional.empty();
            }
            if (targetField == StandardField.SHORTTITLE) {
                return Optional.empty();
            }
        }
        if (sourceEntry == StandardEntryType.Book && targetEntry == StandardEntryType.InBook || sourceEntry == StandardEntryType.Book && targetEntry == StandardEntryType.BookInBook || sourceEntry == StandardEntryType.Book && targetEntry == StandardEntryType.SuppBook || sourceEntry == StandardEntryType.Collection && targetEntry == StandardEntryType.InCollection || sourceEntry == StandardEntryType.Collection && targetEntry == StandardEntryType.SuppCollection || sourceEntry == StandardEntryType.Reference && targetEntry == StandardEntryType.InReference || sourceEntry == StandardEntryType.Proceedings && targetEntry == StandardEntryType.InProceedings) {
            if (targetField == StandardField.BOOKTITLE) {
                return Optional.of(StandardField.TITLE);
            }
            if (targetField == StandardField.BOOKSUBTITLE) {
                return Optional.of(StandardField.SUBTITLE);
            }
            if (targetField == StandardField.BOOKTITLEADDON) {
                return Optional.of(StandardField.TITLEADDON);
            }
            if (targetField == StandardField.TITLE || targetField == StandardField.SUBTITLE || targetField == StandardField.TITLEADDON) {
                return Optional.empty();
            }
            if (targetField == StandardField.SHORTTITLE) {
                return Optional.empty();
            }
        }
        if (sourceEntry == IEEETranEntryType.Periodical && targetEntry == StandardEntryType.Article || sourceEntry == IEEETranEntryType.Periodical && targetEntry == StandardEntryType.SuppPeriodical) {
            if (targetField == StandardField.JOURNALTITLE) {
                return Optional.of(StandardField.TITLE);
            }
            if (targetField == StandardField.JOURNALSUBTITLE) {
                return Optional.of(StandardField.SUBTITLE);
            }
            if (targetField == StandardField.TITLE || targetField == StandardField.SUBTITLE) {
                return Optional.empty();
            }
            if (targetField == StandardField.SHORTTITLE) {
                return Optional.empty();
            }
        }
        return Optional.ofNullable(targetField);
    }

    public Optional<String> getResolvedFieldOrAlias(Field field, BibDatabase database) {
        return this.genericGetResolvedFieldOrAlias(field, database, BibEntry::getFieldOrAlias);
    }

    public Optional<String> getResolvedFieldOrAliasLatexFree(Field field, BibDatabase database) {
        return this.genericGetResolvedFieldOrAlias(field, database, BibEntry::getFieldOrAliasLatexFree);
    }

    private Optional<String> genericGetResolvedFieldOrAlias(Field field, BibDatabase database, BiFunction<BibEntry, Field, Optional<String>> getFieldOrAlias) {
        Optional<BibEntry> referred;
        if (InternalField.TYPE_HEADER == field || InternalField.OBSOLETE_TYPE_HEADER == field) {
            return Optional.of(((EntryType)this.type.get()).getDisplayName());
        }
        if (InternalField.KEY_FIELD == field) {
            return this.getCitationKey();
        }
        Optional<String> result = getFieldOrAlias.apply(this, field);
        if (result.isEmpty() && database != null && (referred = database.getReferencedEntry(this)).isPresent()) {
            EntryType sourceEntry = (EntryType)referred.get().type.get();
            EntryType targetEntry = (EntryType)this.type.get();
            Optional<Field> sourceField = this.getSourceField(field, targetEntry, sourceEntry);
            if (sourceField.isPresent()) {
                result = getFieldOrAlias.apply(referred.get(), sourceField.get());
            }
        }
        return database == null || result.isEmpty() ? result : Optional.of(database.resolveForStrings(result.get()));
    }

    public String getId() {
        return this.id;
    }

    @VisibleForTesting
    public void setId(String id) {
        Objects.requireNonNull(id, "Every BibEntry must have an ID");
        String oldId = this.id;
        this.eventBus.post((Object)new FieldChangedEvent(this, InternalField.INTERNAL_ID_FIELD, id, oldId));
        this.id = id;
        this.changed = true;
    }

    public Optional<FieldChange> setCitationKey(String newKey) {
        return this.setField(InternalField.KEY_FIELD, newKey);
    }

    public BibEntry withCitationKey(String newKey) {
        this.setCitationKey(newKey);
        this.setChanged(false);
        return this;
    }

    public Optional<String> getCitationKey() {
        String key = (String)this.fields.get((Object)InternalField.KEY_FIELD);
        if (StringUtil.isBlank(key)) {
            return Optional.empty();
        }
        return Optional.of(key);
    }

    public boolean hasCitationKey() {
        return this.getCitationKey().isPresent();
    }

    public EntryType getType() {
        return (EntryType)this.type.getValue();
    }

    public ObjectProperty<EntryType> typeProperty() {
        return this.type;
    }

    public Optional<FieldChange> setType(EntryType type) {
        return this.setType(type, EntriesEventSource.LOCAL);
    }

    public Optional<FieldChange> setType(EntryType newType, EntriesEventSource eventSource) {
        Objects.requireNonNull(newType);
        EntryType oldType = (EntryType)this.type.get();
        if (newType.equals(oldType)) {
            return Optional.empty();
        }
        this.changed = true;
        this.type.setValue((Object)newType);
        FieldChange change = new FieldChange(this, InternalField.TYPE_HEADER, oldType.getName(), newType.getName());
        this.eventBus.post((Object)new FieldChangedEvent(change, eventSource));
        return Optional.of(change);
    }

    public SequencedSet<Field> getFields() {
        return new LinkedHashSet<Field>(this.fields.keySet());
    }

    public SequencedSet<Field> getFields(Predicate<Field> selector) {
        return this.getFields().stream().filter(selector).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Optional<String> getField(Field field) {
        return Optional.ofNullable((String)this.fields.get((Object)field));
    }

    public Optional<String> getFieldLatexFree(Field field) {
        if (InternalField.KEY_FIELD == field) {
            return this.getCitationKey();
        }
        if (InternalField.TYPE_HEADER == field) {
            return Optional.of(((EntryType)this.type.get()).getDisplayName());
        }
        if (this.latexFreeFields.containsKey(field)) {
            return Optional.ofNullable(this.latexFreeFields.get(field));
        }
        Optional<String> fieldValue = this.getField(field);
        if (fieldValue.isPresent()) {
            String latexFreeValue = LatexToUnicodeAdapter.format(fieldValue.get()).intern();
            this.latexFreeFields.put(field, latexFreeValue);
            return Optional.of(latexFreeValue);
        }
        return Optional.empty();
    }

    public boolean hasField(Field field) {
        return this.fields.containsKey((Object)field);
    }

    private Optional<String> genericGetFieldOrAlias(Field field, BiFunction<BibEntry, Field, Optional<String>> getFieldValue) {
        Optional<String> fieldValue = getFieldValue.apply(this, field);
        if (fieldValue.isPresent() && !fieldValue.get().isEmpty()) {
            return fieldValue;
        }
        Field aliasForField = EntryConverter.FIELD_ALIASES.get(field);
        if (aliasForField != null) {
            return getFieldValue.apply(this, aliasForField);
        }
        if (StandardField.DATE == field) {
            Optional<Date> date = Date.parse(getFieldValue.apply(this, StandardField.YEAR), getFieldValue.apply(this, StandardField.MONTH), getFieldValue.apply(this, StandardField.DAY));
            return date.map(Date::getNormalized);
        }
        if (StandardField.YEAR == field || StandardField.MONTH == field || StandardField.DAY == field) {
            Optional<String> date = getFieldValue.apply(this, StandardField.DATE);
            if (date.isEmpty()) {
                return Optional.empty();
            }
            Optional<Date> parsedDate = Date.parse(date.get());
            if (parsedDate.isPresent()) {
                if (StandardField.YEAR == field) {
                    return parsedDate.get().getYear().map(Object::toString);
                }
                if (StandardField.MONTH == field) {
                    return parsedDate.get().getMonth().map(Month::getJabRefFormat);
                }
                if (StandardField.DAY == field) {
                    return parsedDate.get().getDay().map(Object::toString);
                }
            } else {
                LOGGER.debug("Could not parse date {}", (Object)date.get());
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<String> getFieldOrAlias(Field field) {
        return this.genericGetFieldOrAlias(field, BibEntry::getField);
    }

    public Optional<String> getFieldOrAliasLatexFree(Field name) {
        return this.genericGetFieldOrAlias(name, BibEntry::getFieldLatexFree);
    }

    public void setField(Map<Field, String> fields) {
        Objects.requireNonNull(fields, "fields must not be null");
        fields.forEach(this::setField);
    }

    public Optional<FieldChange> setField(Field field, String value, EntriesEventSource eventSource) {
        Objects.requireNonNull(field, "field name must not be null");
        Objects.requireNonNull(value, "field value for field " + field.getName() + " must not be null");
        Objects.requireNonNull(eventSource, "field eventSource must not be null");
        if (value.isEmpty()) {
            return this.clearField(field);
        }
        String oldValue = this.getField(field).orElse(null);
        if (value.equals(oldValue)) {
            return Optional.empty();
        }
        boolean isNewField = oldValue == null;
        this.changed = true;
        this.invalidateFieldCache(field);
        this.fields.put((Object)field, (Object)value.intern());
        FieldChange change = new FieldChange(this, field, oldValue, value);
        if (isNewField) {
            this.eventBus.post((Object)new FieldAddedOrRemovedEvent(change, eventSource));
        } else {
            this.eventBus.post((Object)new FieldChangedEvent(change, eventSource));
        }
        return Optional.of(change);
    }

    public Optional<FieldChange> setField(Field field, String value) {
        return this.setField(field, value, EntriesEventSource.LOCAL);
    }

    public Optional<FieldChange> clearField(Field field) {
        return this.clearField(field, EntriesEventSource.LOCAL);
    }

    public Optional<FieldChange> clearField(Field field, EntriesEventSource eventSource) {
        Optional<String> oldValue = this.getField(field);
        if (oldValue.isEmpty()) {
            return Optional.empty();
        }
        this.changed = true;
        this.invalidateFieldCache(field);
        this.fields.remove((Object)field);
        FieldChange change = new FieldChange(this, field, oldValue.get(), null);
        this.eventBus.post((Object)new FieldAddedOrRemovedEvent(change, eventSource));
        return Optional.of(change);
    }

    public boolean allFieldsPresent(Collection<OrFields> fields, BibDatabase database) {
        return fields.stream().allMatch(field -> this.getResolvedFieldOrAlias((OrFields)field, database).isPresent());
    }

    public Object clone() {
        BibEntry clone = new BibEntry((EntryType)this.type.getValue());
        clone.fields = FXCollections.observableMap(new ConcurrentHashMap<Field, String>((Map<Field, String>)this.fields));
        clone.commentsBeforeEntry = this.commentsBeforeEntry;
        clone.parsedSerialization = this.parsedSerialization;
        clone.changed = this.changed;
        return clone;
    }

    public String toString() {
        return CanonicalBibEntry.getCanonicalRepresentation(this);
    }

    public String getAuthorTitleYear(int maxCharacters) {
        String[] s = new String[]{this.getField(StandardField.AUTHOR).orElse("N/A"), this.getField(StandardField.TITLE).orElse("N/A"), this.getField(StandardField.YEAR).orElse("N/A")};
        String text = s[0] + ": \"" + s[1] + "\" (" + s[2] + ")";
        if (maxCharacters <= 0 || text.length() <= maxCharacters) {
            return text;
        }
        return text.substring(0, maxCharacters + 1) + "...";
    }

    public Optional<String> getTitle() {
        return this.getField(StandardField.TITLE);
    }

    public Optional<DOI> getDOI() {
        return this.getField(StandardField.DOI).flatMap(DOI::parse);
    }

    public Optional<ISBN> getISBN() {
        return this.getField(StandardField.ISBN).flatMap(ISBN::parse);
    }

    public Optional<Date> getPublicationDate() {
        return this.getFieldOrAlias(StandardField.DATE).flatMap(Date::parse);
    }

    public String getParsedSerialization() {
        return this.parsedSerialization;
    }

    public void setParsedSerialization(String parsedSerialization) {
        this.changed = false;
        this.parsedSerialization = parsedSerialization;
    }

    public void setCommentsBeforeEntry(String parsedComments) {
        this.commentsBeforeEntry = parsedComments;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public BibEntry withChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    public Optional<FieldChange> putKeywords(List<String> keywords, Character delimiter) {
        Objects.requireNonNull(delimiter);
        return this.putKeywords(new KeywordList(keywords), delimiter);
    }

    public Optional<FieldChange> putKeywords(KeywordList keywords, Character delimiter) {
        Objects.requireNonNull(keywords);
        Optional<String> oldValue = this.getField(StandardField.KEYWORDS);
        if (keywords.isEmpty()) {
            if (oldValue.isPresent()) {
                return this.clearField(StandardField.KEYWORDS);
            }
            return Optional.empty();
        }
        String newValue = keywords.getAsString(delimiter);
        return this.setField(StandardField.KEYWORDS, newValue);
    }

    public void addKeyword(String keyword, Character delimiter) {
        Objects.requireNonNull(keyword, "keyword must not be null");
        if (keyword.isEmpty()) {
            return;
        }
        this.addKeyword(new Keyword(keyword), delimiter);
    }

    public void addKeyword(Keyword keyword, Character delimiter) {
        KeywordList keywords = this.getKeywords(delimiter);
        keywords.add(keyword);
        this.putKeywords(keywords, delimiter);
    }

    public void addKeywords(Collection<String> keywords, Character delimiter) {
        Objects.requireNonNull(keywords);
        keywords.forEach(keyword -> this.addKeyword((String)keyword, delimiter));
    }

    public KeywordList getKeywords(Character delimiter) {
        return this.getFieldAsKeywords(StandardField.KEYWORDS, delimiter);
    }

    public KeywordList getResolvedKeywords(Character delimiter, BibDatabase database) {
        Optional<String> keywordsContent = this.getResolvedFieldOrAlias(StandardField.KEYWORDS, database);
        return keywordsContent.map(content -> KeywordList.parse(content, delimiter)).orElse(new KeywordList());
    }

    public Optional<FieldChange> removeKeywords(KeywordList keywordsToRemove, Character keywordDelimiter) {
        KeywordList keywordList = this.getKeywords(keywordDelimiter);
        int oldSize = keywordList.size();
        keywordList.removeAll(keywordsToRemove);
        if (oldSize == keywordList.size()) {
            return Optional.empty();
        }
        return this.putKeywords(keywordList, keywordDelimiter);
    }

    public Optional<FieldChange> replaceKeywords(KeywordList keywordsToReplace, Keyword newValue, Character keywordDelimiter) {
        KeywordList keywordList = this.getKeywords(keywordDelimiter);
        keywordList.replaceAll(keywordsToReplace, newValue);
        return this.putKeywords(keywordList, keywordDelimiter);
    }

    public Collection<String> getFieldValues() {
        return this.fields.values();
    }

    public Map<Field, String> getFieldMap() {
        return this.fields;
    }

    public SharedBibEntryData getSharedBibEntryData() {
        return this.sharedBibEntryData;
    }

    public BibEntry withSharedBibEntryData(int sharedId, int version) {
        this.sharedBibEntryData.setSharedID(sharedId);
        this.sharedBibEntryData.setVersion(version);
        return this;
    }

    public BibEntry withSharedBibEntryData(SharedBibEntryData sharedBibEntryData) {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BibEntry entry = (BibEntry)o;
        return Objects.equals(this.type.getValue(), entry.type.getValue()) && Objects.equals(this.fields, entry.fields) && Objects.equals(this.commentsBeforeEntry, entry.commentsBeforeEntry);
    }

    public int hashCode() {
        return Objects.hash(this.type.getValue(), this.fields, this.commentsBeforeEntry);
    }

    public void registerListener(Object object) {
        this.eventBus.register(object);
    }

    public void unregisterListener(Object object) {
        try {
            this.eventBus.unregister(object);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Problem unregistering", (Throwable)e);
        }
    }

    public BibEntry withField(Field field, String value) {
        this.setField(field, value);
        this.setChanged(false);
        return this;
    }

    public BibEntry withFields(Map<Field, String> content) {
        this.fields = FXCollections.observableMap(new HashMap<Field, String>(content));
        this.setChanged(false);
        return this;
    }

    public BibEntry withDate(Date date) {
        this.setDate(date);
        this.setChanged(false);
        return this;
    }

    public BibEntry withMonth(Month parsedMonth) {
        this.setMonth(parsedMonth);
        this.setChanged(false);
        return this;
    }

    public String getUserComments() {
        return this.commentsBeforeEntry;
    }

    public BibEntry withUserComments(String commentsBeforeEntry) {
        this.commentsBeforeEntry = commentsBeforeEntry;
        this.setChanged(false);
        return this;
    }

    public List<ParsedEntryLink> getEntryLinkList(Field field, BibDatabase database) {
        return this.getField(field).map(fieldValue -> EntryLinkList.parse(fieldValue, database)).orElse(Collections.emptyList());
    }

    public Optional<FieldChange> setEntryLinkList(Field field, List<ParsedEntryLink> list) {
        return this.setField(field, EntryLinkList.serialize(list));
    }

    public Set<String> getFieldAsWords(Field field) {
        Set<String> storedList = this.fieldsAsWords.get(field);
        if (storedList != null) {
            return storedList;
        }
        String fieldValue = (String)this.fields.get((Object)field);
        if (fieldValue == null) {
            return Collections.emptySet();
        }
        HashSet<String> words = new HashSet<String>(StringUtil.getStringAsWords(fieldValue));
        this.fieldsAsWords.put(field, words);
        return words;
    }

    public KeywordList getFieldAsKeywords(Field field, Character keywordSeparator) {
        StandardField standardField;
        Optional<KeywordList> storedList;
        if (field instanceof StandardField && (storedList = this.fieldsAsKeywords.get(standardField = (StandardField)field, keywordSeparator)).isPresent()) {
            return storedList.get();
        }
        KeywordList keywords = this.getField(field).map(content -> KeywordList.parse(content, keywordSeparator)).orElse(new KeywordList());
        if (field instanceof StandardField) {
            StandardField standardField2 = (StandardField)field;
            this.fieldsAsKeywords.put(standardField2, keywordSeparator, keywords);
        }
        return keywords;
    }

    public Optional<FieldChange> clearCiteKey() {
        return this.clearField(InternalField.KEY_FIELD);
    }

    private void invalidateFieldCache(Field field) {
        this.latexFreeFields.remove(field);
        this.fieldsAsWords.remove(field);
        if (field instanceof StandardField) {
            StandardField standardField = (StandardField)field;
            this.fieldsAsKeywords.remove(standardField);
        }
    }

    public Optional<FieldChange> setFiles(List<LinkedFile> files) {
        Optional<String> oldValue = this.getField(StandardField.FILE);
        String newValue = FileFieldWriter.getStringRepresentation(files);
        if (oldValue.isPresent() && oldValue.get().equals(newValue)) {
            return Optional.empty();
        }
        return this.setField(StandardField.FILE, newValue);
    }

    public BibEntry withFiles(List<LinkedFile> files) {
        this.setFiles(files);
        this.setChanged(false);
        return this;
    }

    public List<LinkedFile> getFiles() {
        Optional<String> oldValue = this.getField(StandardField.FILE);
        if (oldValue.isEmpty()) {
            return new ArrayList<LinkedFile>();
        }
        return FileFieldParser.parse(oldValue.get());
    }

    public void setDate(Date date) {
        date.getYear().ifPresent(year -> this.setField(StandardField.YEAR, year.toString()));
        date.getMonth().ifPresent(this::setMonth);
        date.getDay().ifPresent(day -> this.setField(StandardField.DAY, day.toString()));
    }

    public Optional<Month> getMonth() {
        return this.getFieldOrAlias(StandardField.MONTH).flatMap(Month::parse);
    }

    public OptionalBinding<String> getFieldBinding(Field field) {
        if (field == InternalField.TYPE_HEADER || field == InternalField.OBSOLETE_TYPE_HEADER) {
            return EasyBind.wrapNullable(this.type).mapOpt(EntryType::getDisplayName);
        }
        return EasyBind.valueAt(this.fields, (Object)field);
    }

    public OptionalBinding<String> getCiteKeyBinding() {
        return this.getFieldBinding(InternalField.KEY_FIELD);
    }

    public Optional<FieldChange> addFile(LinkedFile file) {
        List<LinkedFile> linkedFiles = this.getFiles();
        linkedFiles.add(file);
        return this.setFiles(linkedFiles);
    }

    public Optional<FieldChange> addFile(int index, LinkedFile file) {
        List<LinkedFile> linkedFiles = this.getFiles();
        linkedFiles.add(index, file);
        return this.setFiles(linkedFiles);
    }

    public ObservableMap<Field, String> getFieldsObservable() {
        return this.fields;
    }

    public Observable[] getObservables() {
        return new Observable[]{this.fields, this.type};
    }

    public void replaceDownloadedFile(String linkToDownloadedFile, LinkedFile downloadedFile) {
        List<LinkedFile> linkedFiles = this.getFiles();
        int oldFileIndex = -1;
        for (int i = 0; i < linkedFiles.size() && oldFileIndex == -1; ++i) {
            LinkedFile file = linkedFiles.get(i);
            if (!file.getLink().equalsIgnoreCase(linkToDownloadedFile)) continue;
            oldFileIndex = i;
        }
        if (oldFileIndex == -1) {
            linkedFiles.addFirst(downloadedFile);
        } else {
            linkedFiles.set(oldFileIndex, downloadedFile);
        }
        this.setFiles(linkedFiles);
    }

    public void mergeWith(BibEntry other) {
        this.mergeWith(other, Set.of());
    }

    public void mergeWith(BibEntry other, Set<Field> otherPrioritizedFields) {
        TreeSet<Field> thisFields = new TreeSet<Field>(Comparator.comparing(Field::getName));
        TreeSet<Field> otherFields = new TreeSet<Field>(Comparator.comparing(Field::getName));
        thisFields.addAll(this.getFields());
        otherFields.addAll(other.getFields());
        Set thisFieldsNames = thisFields.stream().map(Field::getName).collect(Collectors.toSet());
        Set otherPrioritizedFieldsNames = otherPrioritizedFields.stream().map(Field::getName).collect(Collectors.toSet());
        for (Field otherField : otherFields) {
            Optional<String> otherFieldValue = other.getField(otherField);
            if (thisFieldsNames.contains(otherField.getName()) && !otherPrioritizedFieldsNames.contains(otherField.getName())) continue;
            otherFieldValue.ifPresent(s -> this.setField(otherField, (String)s));
        }
    }

    public boolean isEmpty() {
        if (this.fields.isEmpty()) {
            return true;
        }
        return StandardField.AUTOMATIC_FIELDS.containsAll(this.getFields());
    }
}

