/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.field.BibField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldPriority;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibEntryTypeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BibEntryTypeBuilder.class);
    private final SequencedSet<OrFields> requiredFields = new LinkedHashSet<OrFields>();
    private final Set<Field> seenFields = new HashSet<Field>();
    private SequencedSet<BibField> optionalFields = new LinkedHashSet<BibField>();
    private EntryType type = StandardEntryType.Misc;
    private boolean hasWarnings = false;

    public BibEntryTypeBuilder withType(EntryType type) {
        this.type = type;
        return this;
    }

    public BibEntryTypeBuilder withImportantFields(SequencedSet<Field> newFields) {
        List<Field> containedFields = this.containedInSeenFields(newFields);
        if (!containedFields.isEmpty()) {
            LOGGER.warn("Fields {} already added to type {}.", containedFields, (Object)this.type.getDisplayName());
            this.hasWarnings = true;
        }
        this.seenFields.addAll(newFields);
        this.optionalFields = Streams.concat((Stream[])new Stream[]{this.optionalFields.stream(), newFields.stream().map(field -> new BibField((Field)field, FieldPriority.IMPORTANT))}).collect(Collectors.toCollection(LinkedHashSet::new));
        return this;
    }

    public BibEntryTypeBuilder withImportantFields(Field ... newFields) {
        return this.withImportantFields(Arrays.stream(newFields).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public BibEntryTypeBuilder withDetailFields(SequencedCollection<Field> newFields) {
        List<Field> containedFields = this.containedInSeenFields(newFields);
        if (!containedFields.isEmpty()) {
            LOGGER.warn("Fields {} already added to type {}.", containedFields, (Object)this.type.getDisplayName());
            this.hasWarnings = true;
        }
        this.seenFields.addAll(newFields);
        this.optionalFields = Streams.concat((Stream[])new Stream[]{this.optionalFields.stream(), newFields.stream().map(field -> new BibField((Field)field, FieldPriority.DETAIL))}).collect(Collectors.toCollection(LinkedHashSet::new));
        return this;
    }

    public BibEntryTypeBuilder withDetailFields(Field ... fields) {
        return this.withDetailFields(Arrays.asList(fields));
    }

    public BibEntryTypeBuilder withRequiredFields(SequencedSet<OrFields> requiredFields) {
        return this.addRequiredFields(requiredFields);
    }

    public BibEntryTypeBuilder addRequiredFields(SequencedSet<OrFields> requiredFields) {
        Set<Field> fieldsToAdd = requiredFields.stream().map(OrFields::getFields).flatMap(Collection::stream).collect(Collectors.toSet());
        List<Field> containedFields = this.containedInSeenFields(fieldsToAdd);
        if (!containedFields.isEmpty()) {
            LOGGER.warn("Fields {} already added to type {}.", containedFields, (Object)this.type.getDisplayName());
            this.hasWarnings = true;
        }
        this.seenFields.addAll(fieldsToAdd);
        this.requiredFields.addAll(requiredFields);
        return this;
    }

    public BibEntryTypeBuilder addRequiredFields(OrFields ... requiredFields) {
        return this.addRequiredFields(new LinkedHashSet<OrFields>(List.of(requiredFields)));
    }

    public BibEntryTypeBuilder addRequiredFields(Field ... requiredFields) {
        return this.addRequiredFields(Arrays.stream(requiredFields).map(OrFields::new).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public BibEntryTypeBuilder withRequiredFields(Field ... requiredFields) {
        return this.addRequiredFields(requiredFields);
    }

    public BibEntryTypeBuilder withRequiredFields(OrFields first, Field ... requiredFields) {
        return this.addRequiredFields(Stream.concat(Stream.of(first), Arrays.stream(requiredFields).map(OrFields::new)).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public BibEntryTypeBuilder withRequiredFields(SequencedSet<OrFields> first, Field ... requiredFields) {
        return this.addRequiredFields(Stream.concat(first.stream(), Arrays.stream(requiredFields).map(OrFields::new)).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public BibEntryType build() {
        Stream<BibField> requiredAsImportant = this.requiredFields.stream().map(OrFields::getFields).flatMap(Collection::stream).map(field -> new BibField((Field)field, FieldPriority.IMPORTANT));
        SequencedSet allFields = Stream.concat(this.optionalFields.stream(), requiredAsImportant).collect(Collectors.toCollection(LinkedHashSet::new));
        return new BibEntryType(this.type, allFields, this.requiredFields);
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    private List<Field> containedInSeenFields(Collection<Field> fields) {
        return fields.stream().filter(this.seenFields::contains).toList();
    }
}

