/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.gui.DialogService;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@AllowedToUseLogic(value="Uses FileUtil from logic")
public class LinkedFile
implements Serializable {
    private static final String REGEX_URL = "^((?:https?\\:\\/\\/|www\\.)(?:[-a-z0-9]+\\.)*[-a-z0-9]+.*)";
    private static final Pattern URL_PATTERN = Pattern.compile("^((?:https?\\:\\/\\/|www\\.)(?:[-a-z0-9]+\\.)*[-a-z0-9]+.*)");
    private static final LinkedFile NULL_OBJECT = new LinkedFile("", Path.of("", new String[0]), "");
    private transient StringProperty description = new SimpleStringProperty();
    private transient StringProperty link = new SimpleStringProperty();
    private transient StringProperty fileType = new SimpleStringProperty();
    private transient StringProperty sourceURL = new SimpleStringProperty();

    public LinkedFile(String description, Path link, String fileType) {
        this(Objects.requireNonNull(description), Objects.requireNonNull(link).toString(), Objects.requireNonNull(fileType));
    }

    public LinkedFile(String description, Path link, String fileType, String sourceUrl) {
        this(Objects.requireNonNull(description), Objects.requireNonNull(link).toString(), Objects.requireNonNull(fileType), Objects.requireNonNull(sourceUrl));
    }

    public LinkedFile(String description, String link, FileType fileType) {
        this(description, link, fileType.getName());
    }

    public LinkedFile(String description, String link, String fileType, String sourceUrl) {
        this.description.setValue(Objects.requireNonNull(description));
        this.setLink(link);
        this.fileType.setValue(Objects.requireNonNull(fileType));
        this.sourceURL.setValue(sourceUrl);
    }

    public LinkedFile(String description, String link, String fileType) {
        this(description, link, fileType, "");
    }

    public LinkedFile(URL link, String fileType) {
        this("", Objects.requireNonNull(link).toString(), Objects.requireNonNull(fileType));
    }

    public LinkedFile(String description, URL link, String fileType) {
        this(description, Objects.requireNonNull(link).toString(), Objects.requireNonNull(fileType));
    }

    public LinkedFile(String description, URL link, String fileType, String sourceUrl) {
        this(description, Objects.requireNonNull(link).toString(), Objects.requireNonNull(fileType), Objects.requireNonNull(sourceUrl));
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public StringProperty linkProperty() {
        return this.link;
    }

    public StringProperty fileTypeProperty() {
        return this.fileType;
    }

    public StringProperty sourceUrlProperty() {
        return this.sourceURL;
    }

    public String getFileType() {
        return (String)this.fileType.get();
    }

    public void setFileType(String fileType) {
        this.fileType.setValue(fileType);
    }

    public void setFileType(FileType fileType) {
        this.setFileType(fileType.getName());
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.setValue(description);
    }

    public String getLink() {
        return (String)this.link.get();
    }

    public void setLink(String link) {
        if (!LinkedFile.isOnlineLink(link)) {
            this.link.setValue(link.replace("\\", "/"));
        } else {
            this.link.setValue(link);
        }
    }

    public String getSourceUrl() {
        return (String)this.sourceURL.get();
    }

    public void setSourceURL(String url) {
        this.sourceURL.setValue(url);
    }

    public Observable[] getObservables() {
        return new Observable[]{this.link, this.description, this.fileType, this.sourceURL};
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LinkedFile) {
            LinkedFile that = (LinkedFile)o;
            return Objects.equals(this.description.get(), that.description.get()) && Objects.equals(this.link.get(), that.link.get()) && Objects.equals(this.fileType.get(), that.fileType.get()) && Objects.equals(this.sourceURL.get(), that.sourceURL.get());
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.getFileType());
        out.writeUTF(this.getLink());
        out.writeUTF(this.getDescription());
        out.writeUTF(this.getSourceUrl());
        out.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.fileType = new SimpleStringProperty(in.readUTF());
        this.link = new SimpleStringProperty(in.readUTF());
        this.description = new SimpleStringProperty(in.readUTF());
        this.sourceURL = new SimpleStringProperty(in.readUTF());
    }

    public static boolean isOnlineLink(String toCheck) {
        String normalizedFilePath = toCheck.trim().toLowerCase();
        return URL_PATTERN.matcher(normalizedFilePath).matches();
    }

    public int hashCode() {
        return Objects.hash(this.description.get(), this.link.get(), this.fileType.get(), this.sourceURL.get());
    }

    public String toString() {
        return "ParsedFileField{description='" + (String)this.description.get() + "', link='" + (String)this.link.get() + "', fileType='" + (String)this.fileType.get() + "'" + (String)(StringUtil.isNullOrEmpty((String)this.sourceURL.get()) ? "" : ", sourceUrl='" + (String)this.sourceURL.get() + "'") + "}";
    }

    public boolean isEmpty() {
        return NULL_OBJECT.equals(this);
    }

    public boolean isOnlineLink() {
        return LinkedFile.isOnlineLink((String)this.link.get());
    }

    public Optional<Path> findIn(BibDatabaseContext databaseContext, FilePreferences filePreferences) {
        List<Path> dirs = databaseContext.getFileDirectories(filePreferences);
        return this.findIn(dirs);
    }

    public Optional<Path> findIn(List<Path> directories) {
        try {
            if (((String)this.link.get()).isEmpty()) {
                return Optional.empty();
            }
            Path file = Path.of((String)this.link.get(), new String[0]);
            if (file.isAbsolute() || directories.isEmpty()) {
                if (Files.exists(file, new LinkOption[0])) {
                    return Optional.of(file);
                }
                return Optional.empty();
            }
            return FileUtil.find((String)this.link.get(), directories);
        }
        catch (InvalidPathException ex) {
            return Optional.empty();
        }
    }

    public LinkedFileViewModel toModel(BibEntry entry, BibDatabaseContext databaseContext, TaskExecutor taskExecutor, DialogService dialogService, PreferencesService preferencesService) {
        return new LinkedFileViewModel(this, entry, databaseContext, taskExecutor, dialogService, preferencesService);
    }
}

