/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Objects;
import java.util.Optional;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class ParsedEntryLink {
    private String key;
    private Optional<BibEntry> linkedEntry;
    private BibDatabase database;

    public ParsedEntryLink(String key, BibDatabase database) {
        this.key = key;
        this.linkedEntry = database.getEntryByCitationKey(this.key);
        this.database = database;
    }

    public ParsedEntryLink(BibEntry bibEntry) {
        this.key = bibEntry.getCitationKey().orElse("");
        this.linkedEntry = Optional.of(bibEntry);
    }

    public String getKey() {
        return this.key;
    }

    public Optional<BibEntry> getLinkedEntry() {
        return this.linkedEntry;
    }

    public void setKey(String newKey) {
        this.key = newKey;
        this.linkedEntry = this.getDatabase().getEntryByCitationKey(this.key);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.linkedEntry);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedEntryLink)) {
            return false;
        }
        ParsedEntryLink other = (ParsedEntryLink)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.linkedEntry, other.linkedEntry);
    }

    public BibDatabase getDatabase() {
        return this.database;
    }
}

