/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.field;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.types.BiblatexApaEntryType;

public enum BiblatexApaField implements Field
{
    AMENDMENT("amendment"),
    ARTICLE("article"),
    CITATION("citation"),
    CITATION_CITEORG("citation_citeorg"),
    CITATION_CITEDATE("citation_citedate", FieldProperty.DATE, new FieldProperty[0]),
    CITATION_CITEINFO("citation_citeinfo"),
    SECTION("section", FieldProperty.NUMERIC, new FieldProperty[0]),
    SOURCE("source");

    private final String name;
    private final String displayName;
    private final EnumSet<FieldProperty> properties;

    private BiblatexApaField(String name) {
        this.name = name;
        this.displayName = null;
        this.properties = EnumSet.noneOf(FieldProperty.class);
    }

    private BiblatexApaField(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.properties = EnumSet.noneOf(FieldProperty.class);
    }

    private BiblatexApaField(String name, String displayName, FieldProperty first, FieldProperty ... rest) {
        this.name = name;
        this.displayName = displayName;
        this.properties = EnumSet.of(first, rest);
    }

    private BiblatexApaField(String name, FieldProperty first, FieldProperty ... rest) {
        this.name = name;
        this.displayName = null;
        this.properties = EnumSet.of(first, rest);
    }

    public static <T> Optional<BiblatexApaField> fromName(T type, String name) {
        if (!(type instanceof BiblatexApaEntryType)) {
            return Optional.empty();
        }
        return Arrays.stream(BiblatexApaField.values()).filter(field -> field.getName().equalsIgnoreCase(name)).findAny();
    }

    @Override
    public EnumSet<FieldProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStandardField() {
        return false;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            return Field.super.getDisplayName();
        }
        return this.displayName;
    }
}

