/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.field;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;

public enum IEEEField implements Field
{
    CTLALT_STRETCH_FACTOR("ctlalt_stretch_factor", FieldProperty.NUMERIC, new FieldProperty[0]),
    CTLDASH_REPEATED_NAMES("ctldash_repeated_names", FieldProperty.YES_NO, new FieldProperty[0]),
    CTLMAX_NAMES_FORCED_ETAL("ctlmax_names_forced_etal", FieldProperty.NUMERIC, new FieldProperty[0]),
    CTLNAME_FORMAT_STRING("ctlname_format_string", FieldProperty.VERBATIM, new FieldProperty[0]),
    CTLNAME_LATEX_CMD("ctlname_latex_cmd", FieldProperty.VERBATIM, new FieldProperty[0]),
    CTLNAME_URL_PREFIX("ctlname_url_prefix", FieldProperty.VERBATIM, new FieldProperty[0]),
    CTLNAMES_SHOW_ETAL("ctlnames_show_etal", FieldProperty.NUMERIC, new FieldProperty[0]),
    CTLUSE_ALT_SPACING("ctluse_alt_spacing", FieldProperty.YES_NO, new FieldProperty[0]),
    CTLUSE_ARTICLE_NUMBER("ctluse_article_number", FieldProperty.YES_NO, new FieldProperty[0]),
    CTLUSE_FORCED_ETAL("ctluse_forced_etal", FieldProperty.YES_NO, new FieldProperty[0]),
    CTLUSE_PAPER("ctluse_paper", FieldProperty.YES_NO, new FieldProperty[0]),
    CTLUSE_URL("ctluse_url", FieldProperty.YES_NO, new FieldProperty[0]);

    private final String name;
    private final EnumSet<FieldProperty> properties;

    private IEEEField(String name, FieldProperty first, FieldProperty ... rest) {
        this.name = name;
        this.properties = EnumSet.of(first, rest);
    }

    public static Optional<IEEEField> fromName(String name) {
        return Arrays.stream(IEEEField.values()).filter(field -> field.getName().equalsIgnoreCase(name)).findAny();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStandardField() {
        return false;
    }

    @Override
    public EnumSet<FieldProperty> getProperties() {
        return this.properties;
    }
}

