/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.field;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;

public enum StandardField implements Field
{
    ABSTRACT("abstract", FieldProperty.MULTILINE_TEXT, new FieldProperty[0]),
    ADDENDUM("addendum"),
    ADDRESS("address"),
    AFTERWORD("afterword", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    ANNOTE("annote"),
    ANNOTATION("annotation"),
    ANNOTATOR("annotator", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    ARCHIVEPREFIX("archiveprefix"),
    ASSIGNEE("assignee", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    AUTHOR("author", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    BOOKAUTHOR("bookauthor", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    BOOKPAGINATION("bookpagination", FieldProperty.PAGINATION, new FieldProperty[0]),
    BOOKSUBTITLE("booksubtitle", FieldProperty.BOOK_NAME, new FieldProperty[0]),
    BOOKTITLE("booktitle", FieldProperty.BOOK_NAME, new FieldProperty[0]),
    BOOKTITLEADDON("booktitleaddon"),
    CHAPTER("chapter"),
    COMMENTATOR("commentator", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    COMMENT("comment", FieldProperty.MULTILINE_TEXT, FieldProperty.MARKDOWN),
    CROSSREF("crossref", FieldProperty.SINGLE_ENTRY_LINK, new FieldProperty[0]),
    CITES("cites", FieldProperty.MULTIPLE_ENTRY_LINK, new FieldProperty[0]),
    DATE("date", FieldProperty.DATE, new FieldProperty[0]),
    DAY("day"),
    DAYFILED("dayfiled"),
    DOI("doi", "DOI", FieldProperty.VERBATIM, FieldProperty.IDENTIFIER),
    EDITION("edition", FieldProperty.NUMERIC, new FieldProperty[0]),
    EDITOR("editor", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    EDITORA("editora", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    EDITORB("editorb", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    EDITORC("editorc", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    EDITORTYPE("editortype", FieldProperty.EDITOR_TYPE, new FieldProperty[0]),
    EDITORATYPE("editoratype", FieldProperty.EDITOR_TYPE, new FieldProperty[0]),
    EDITORBTYPE("editorbtype", FieldProperty.EDITOR_TYPE, new FieldProperty[0]),
    EDITORCTYPE("editorctype", FieldProperty.EDITOR_TYPE, new FieldProperty[0]),
    EID("eid"),
    ENTRYSET("entryset", FieldProperty.MULTIPLE_ENTRY_LINK, new FieldProperty[0]),
    EPRINT("eprint", FieldProperty.VERBATIM, FieldProperty.IDENTIFIER),
    EPRINTCLASS("eprintclass"),
    EPRINTTYPE("eprinttype"),
    EVENTDATE("eventdate", FieldProperty.DATE, new FieldProperty[0]),
    EVENTTITLE("eventtitle"),
    EVENTTITLEADDON("eventtitleaddon"),
    FILE("file", FieldProperty.VERBATIM, new FieldProperty[0]),
    FOREWORD("foreword", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    FOLDER("folder"),
    GENDER("gender"),
    HOLDER("holder", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    HOWPUBLISHED("howpublished"),
    IDS("ids", FieldProperty.MULTIPLE_ENTRY_LINK, new FieldProperty[0]),
    INSTITUTION("institution"),
    INTRODUCTION("introduction", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    ISBN("isbn", "ISBN", FieldProperty.VERBATIM, new FieldProperty[0]),
    ISRN("isrn", "ISRN", FieldProperty.VERBATIM, new FieldProperty[0]),
    ISSN("issn", "ISSN", FieldProperty.VERBATIM, new FieldProperty[0]),
    ISSUE("issue"),
    ISSUETITLE("issuetitle"),
    ISSUESUBTITLE("issuesubtitle"),
    JOURNAL("journal", FieldProperty.JOURNAL_NAME, new FieldProperty[0]),
    JOURNALSUBTITLE("journalsubtitle", FieldProperty.JOURNAL_NAME, new FieldProperty[0]),
    JOURNALTITLE("journaltitle", FieldProperty.JOURNAL_NAME, new FieldProperty[0]),
    KEY("key"),
    KEYWORDS("keywords"),
    LANGUAGE("language", FieldProperty.LANGUAGE, new FieldProperty[0]),
    LANGUAGEID("langid", FieldProperty.LANGUAGE, new FieldProperty[0]),
    LABEL("label"),
    LIBRARY("library"),
    LOCATION("location"),
    MAINSUBTITLE("mainsubtitle", FieldProperty.BOOK_NAME, new FieldProperty[0]),
    MAINTITLE("maintitle", FieldProperty.BOOK_NAME, new FieldProperty[0]),
    MAINTITLEADDON("maintitleaddon"),
    MONTH("month", FieldProperty.MONTH, new FieldProperty[0]),
    MONTHFILED("monthfiled", FieldProperty.MONTH, new FieldProperty[0]),
    NAMEADDON("nameaddon"),
    NATIONALITY("nationality"),
    NOTE("note"),
    NUMBER("number", FieldProperty.NUMERIC, new FieldProperty[0]),
    ORGANIZATION("organization"),
    ORIGDATE("origdate", FieldProperty.DATE, new FieldProperty[0]),
    ORIGLANGUAGE("origlanguage", FieldProperty.LANGUAGE, new FieldProperty[0]),
    PAGES("pages"),
    PAGETOTAL("pagetotal"),
    PAGINATION("pagination", FieldProperty.PAGINATION, new FieldProperty[0]),
    PART("part"),
    PDF("pdf", "PDF"),
    PMID("pmid", "PMID", FieldProperty.NUMERIC, FieldProperty.IDENTIFIER),
    PS("ps", "PS"),
    PUBLISHER("publisher"),
    PUBSTATE("pubstate"),
    PRIMARYCLASS("primaryclass"),
    RELATED("related", FieldProperty.MULTIPLE_ENTRY_LINK, new FieldProperty[0]),
    REPORTNO("reportno"),
    REVIEW("review", FieldProperty.MULTILINE_TEXT, FieldProperty.VERBATIM, FieldProperty.MARKDOWN),
    REVISION("revision"),
    SCHOOL("school"),
    SERIES("series"),
    SHORTAUTHOR("shortauthor", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    SHORTEDITOR("shorteditor", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    SHORTTITLE("shorttitle"),
    SORTKEY("sortkey"),
    SORTNAME("sortname", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    SUBTITLE("subtitle"),
    TITLE("title"),
    TITLEADDON("titleaddon"),
    TRANSLATOR("translator", FieldProperty.PERSON_NAMES, new FieldProperty[0]),
    TYPE("type"),
    URI("uri", "URI", FieldProperty.EXTERNAL, FieldProperty.VERBATIM),
    URL("url", "URL", FieldProperty.EXTERNAL, FieldProperty.VERBATIM),
    URLDATE("urldate", FieldProperty.DATE, new FieldProperty[0]),
    VENUE("venue"),
    VERSION("version"),
    VOLUME("volume", FieldProperty.NUMERIC, new FieldProperty[0]),
    VOLUMES("volumes", FieldProperty.NUMERIC, new FieldProperty[0]),
    YEAR("year", FieldProperty.NUMERIC, new FieldProperty[0]),
    YEARFILED("yearfiled"),
    MR_NUMBER("mrnumber"),
    ZBL_NUMBER("zbl"),
    XDATA("xdata", FieldProperty.MULTIPLE_ENTRY_LINK, new FieldProperty[0]),
    XREF("xref", FieldProperty.SINGLE_ENTRY_LINK, new FieldProperty[0]),
    GROUPS("groups"),
    OWNER("owner"),
    TIMESTAMP("timestamp", FieldProperty.DATE, new FieldProperty[0]),
    CREATIONDATE("creationdate", FieldProperty.DATE, new FieldProperty[0]),
    MODIFICATIONDATE("modificationdate", FieldProperty.DATE, new FieldProperty[0]);

    public static final Set<Field> AUTOMATIC_FIELDS;
    private static final Map<String, StandardField> NAME_TO_STANDARD_FIELD;
    private final String name;
    private final String displayName;
    private final EnumSet<FieldProperty> properties;

    private StandardField(String name) {
        this.name = name;
        this.displayName = null;
        this.properties = EnumSet.noneOf(FieldProperty.class);
    }

    private StandardField(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.properties = EnumSet.noneOf(FieldProperty.class);
    }

    private StandardField(String name, String displayName, FieldProperty first, FieldProperty ... rest) {
        this.name = name;
        this.displayName = displayName;
        this.properties = EnumSet.of(first, rest);
    }

    private StandardField(String name, FieldProperty first, FieldProperty ... rest) {
        this.name = name;
        this.displayName = null;
        this.properties = EnumSet.of(first, rest);
    }

    public static Optional<StandardField> fromName(String name) {
        return Optional.ofNullable(NAME_TO_STANDARD_FIELD.get(name.toLowerCase(Locale.ROOT)));
    }

    @Override
    public EnumSet<FieldProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStandardField() {
        return true;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            return Field.super.getDisplayName();
        }
        return this.displayName;
    }

    static {
        AUTOMATIC_FIELDS = Set.of(OWNER, TIMESTAMP, CREATIONDATE, MODIFICATIONDATE);
        NAME_TO_STANDARD_FIELD = new HashMap<String, StandardField>();
        for (StandardField field : StandardField.values()) {
            NAME_TO_STANDARD_FIELD.put(field.getName().toLowerCase(Locale.ROOT), field);
        }
    }
}

