/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.entry.identifier.EprintIdentifier;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArXivIdentifier
extends EprintIdentifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArXivIdentifier.class);
    private static final String ARXIV_PREFIX = "http(s)?://arxiv.org/(abs|pdf)/|arxiv|arXiv";
    private final String identifier;
    private final String classification;
    private final String version;

    ArXivIdentifier(String identifier) {
        this(identifier, "", "");
    }

    ArXivIdentifier(String identifier, String classification) {
        this(identifier, "", classification);
    }

    ArXivIdentifier(String identifier, String version, String classification) {
        this.identifier = identifier.trim();
        this.version = version.trim();
        this.classification = classification.trim();
    }

    public static Optional<ArXivIdentifier> parse(String value) {
        String identifier = value.replace(" ", "");
        Pattern identifierPattern = Pattern.compile("(http(s)?://arxiv.org/(abs|pdf)/|arxiv|arXiv)?\\s?:?\\s?(?<id>\\d{4}\\.\\d{4,5})(v(?<version>\\d+))?\\s?(\\[(?<classification>\\S+)\\])?");
        Matcher identifierMatcher = identifierPattern.matcher(identifier);
        if (identifierMatcher.matches()) {
            return ArXivIdentifier.getArXivIdentifier(identifierMatcher);
        }
        Pattern oldIdentifierPattern = Pattern.compile("(http(s)?://arxiv.org/(abs|pdf)/|arxiv|arXiv)?\\s?:?\\s?(?<id>(?<classification>[a-z\\-]+(\\.[A-Z]{2})?)/\\d{7})(v(?<version>\\d+))?");
        Matcher oldIdentifierMatcher = oldIdentifierPattern.matcher(identifier);
        if (oldIdentifierMatcher.matches()) {
            return ArXivIdentifier.getArXivIdentifier(oldIdentifierMatcher);
        }
        return Optional.empty();
    }

    private static Optional<ArXivIdentifier> getArXivIdentifier(Matcher matcher) {
        String version;
        String id = matcher.group("id");
        String classification = matcher.group("classification");
        if (classification == null) {
            classification = "";
        }
        if ((version = matcher.group("version")) == null) {
            version = "";
        }
        return Optional.of(new ArXivIdentifier(id, version, classification));
    }

    public Optional<String> getClassification() {
        if (this.classification.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.classification);
    }

    public Optional<DOI> inferDOI() {
        if (StringUtil.isBlank(this.identifier)) {
            return Optional.empty();
        }
        return DOI.parse("10.48550/arxiv." + this.identifier);
    }

    public String toString() {
        return "ArXivIdentifier{identifier='" + this.identifier + "', classification='" + this.classification + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArXivIdentifier that = (ArXivIdentifier)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.classification, that.classification);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.classification);
    }

    @Override
    public String getNormalized() {
        if (StringUtil.isNotBlank(this.version)) {
            return this.identifier + "v" + this.version;
        }
        return this.identifier;
    }

    public String getNormalizedWithoutVersion() {
        return this.identifier;
    }

    @Override
    public Optional<URI> getExternalURI() {
        try {
            return Optional.of(new URI("https://arxiv.org/abs/" + this.getNormalized()));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }
}

