/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.field.Field;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AutomaticGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.WordKeywordGroup;
import org.jabref.model.strings.StringUtil;

public class AutomaticKeywordGroup
extends AutomaticGroup {
    private final Character keywordDelimiter;
    private final Character keywordHierarchicalDelimiter;
    private final Field field;

    public AutomaticKeywordGroup(String name, GroupHierarchyType context, Field field, Character keywordDelimiter, Character keywordHierarchicalDelimiter) {
        super(name, context);
        this.field = field;
        this.keywordDelimiter = keywordDelimiter;
        this.keywordHierarchicalDelimiter = keywordHierarchicalDelimiter;
    }

    public Character getKeywordHierarchicalDelimiter() {
        return this.keywordHierarchicalDelimiter;
    }

    public Character getKeywordDelimiter() {
        return this.keywordDelimiter;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public AbstractGroup deepCopy() {
        return new AutomaticKeywordGroup(this.name.getValue(), this.context, this.field, this.keywordDelimiter, this.keywordHierarchicalDelimiter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutomaticKeywordGroup that = (AutomaticKeywordGroup)o;
        return Objects.equals(this.keywordDelimiter, that.keywordDelimiter) && Objects.equals(this.field, that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keywordDelimiter, this.field);
    }

    @Override
    public Set<GroupTreeNode> createSubgroups(BibEntry entry) {
        KeywordList keywordList = entry.getFieldAsKeywords(this.field, this.keywordDelimiter);
        return keywordList.stream().filter(keyword -> StringUtil.isNotBlank(keyword.get())).map(this::createGroup).collect(Collectors.toSet());
    }

    private GroupTreeNode createGroup(Keyword keywordChain) {
        WordKeywordGroup rootGroup = new WordKeywordGroup(keywordChain.get(), GroupHierarchyType.INCLUDING, this.field, keywordChain.getPathFromRootAsString(this.keywordHierarchicalDelimiter), true, this.keywordDelimiter, true);
        GroupTreeNode root = new GroupTreeNode(rootGroup);
        keywordChain.getChild().map(this::createGroup).ifPresent(root::addChild);
        return root;
    }
}

