/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.Objects;
import org.jabref.model.entry.field.Field;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;

public abstract class KeywordGroup
extends AbstractGroup {
    protected final Field searchField;
    protected final String searchExpression;
    protected final boolean caseSensitive;

    public KeywordGroup(String name, GroupHierarchyType context, Field searchField, String searchExpression, boolean caseSensitive) {
        super(name, context);
        this.caseSensitive = caseSensitive;
        this.searchField = searchField;
        this.searchExpression = searchExpression;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public Field getSearchField() {
        return this.searchField;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeywordGroup that = (KeywordGroup)o;
        return this.isCaseSensitive() == that.isCaseSensitive() && Objects.equals(this.getSearchField(), that.getSearchField()) && Objects.equals(this.getSearchExpression(), that.getSearchExpression());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSearchField(), this.getSearchExpression(), this.isCaseSensitive());
    }
}

