/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.KeywordGroup;

public class RegexKeywordGroup
extends KeywordGroup {
    private Pattern pattern;

    public RegexKeywordGroup(String name, GroupHierarchyType context, Field searchField, String searchExpression, boolean caseSensitive) {
        super(name, context, searchField, searchExpression, caseSensitive);
        this.pattern = RegexKeywordGroup.compilePattern(searchExpression, caseSensitive);
    }

    private static Pattern compilePattern(String searchExpression, boolean caseSensitive) {
        return caseSensitive ? Pattern.compile("\\b" + searchExpression + "\\b") : Pattern.compile("\\b" + searchExpression + "\\b", 2);
    }

    @Override
    public boolean contains(BibEntry entry) {
        Optional<String> content = entry.getField(this.searchField);
        return content.map(value -> this.pattern.matcher((CharSequence)value).find()).orElse(false);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexKeywordGroup)) {
            return false;
        }
        RegexKeywordGroup other = (RegexKeywordGroup)o;
        return this.getName().equals(other.getName()) && this.getHierarchicalContext() == other.getHierarchicalContext() && this.searchField.equals(other.searchField) && this.searchExpression.equals(other.searchExpression) && this.caseSensitive == other.caseSensitive;
    }

    @Override
    public AbstractGroup deepCopy() {
        return new RegexKeywordGroup(this.getName(), this.getHierarchicalContext(), this.searchField, this.searchExpression, this.caseSensitive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getHierarchicalContext(), this.searchField, this.searchExpression, this.caseSensitive});
    }
}

