/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupEntryChanger;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.ListUtil;

public class WordKeywordGroup
extends KeywordGroup
implements GroupEntryChanger {
    protected final Character keywordSeparator;
    private final SearchStrategy searchStrategy;
    private final boolean onlySplitWordsAtSeparator;

    public WordKeywordGroup(String name, GroupHierarchyType context, Field searchField, String searchExpression, boolean caseSensitive, Character keywordSeparator, boolean onlySplitWordsAtSeparator) {
        super(name, context, searchField, searchExpression, caseSensitive);
        this.keywordSeparator = keywordSeparator;
        this.onlySplitWordsAtSeparator = onlySplitWordsAtSeparator;
        this.searchStrategy = onlySplitWordsAtSeparator ? (InternalField.TYPE_HEADER == searchField ? new TypeSearchStrategy(this) : new KeywordListSearchStrategy()) : new StringSearchStrategy();
    }

    private static boolean containsCaseInsensitive(Set<String> searchIn, Collection<String> searchFor) {
        for (String searchWord : searchFor) {
            if (WordKeywordGroup.containsCaseInsensitive(searchIn, searchWord)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsCaseInsensitive(Set<String> searchIn, String searchFor) {
        for (String word : searchIn) {
            if (!word.equalsIgnoreCase(searchFor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FieldChange> add(Collection<BibEntry> entriesToAdd) {
        Objects.requireNonNull(entriesToAdd);
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (BibEntry entry : new ArrayList<BibEntry>(entriesToAdd)) {
            if (this.contains(entry)) continue;
            String oldContent = entry.getField(this.searchField).orElse("");
            KeywordList wordlist = KeywordList.parse(oldContent, this.keywordSeparator);
            wordlist.add(this.searchExpression);
            String newContent = wordlist.getAsString(this.keywordSeparator);
            entry.setField(this.searchField, newContent).ifPresent(changes::add);
        }
        return changes;
    }

    @Override
    public List<FieldChange> remove(List<BibEntry> entriesToRemove) {
        Objects.requireNonNull(entriesToRemove);
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (BibEntry entry : new ArrayList<BibEntry>(entriesToRemove)) {
            if (!this.contains(entry)) continue;
            String oldContent = entry.getField(this.searchField).orElse("");
            KeywordList wordlist = KeywordList.parse(oldContent, this.keywordSeparator);
            wordlist.remove(this.searchExpression);
            String newContent = wordlist.getAsString(this.keywordSeparator);
            entry.setField(this.searchField, newContent).ifPresent(changes::add);
        }
        return changes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WordKeywordGroup)) {
            return false;
        }
        WordKeywordGroup other = (WordKeywordGroup)o;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals((Object)this.getHierarchicalContext(), (Object)other.getHierarchicalContext()) && Objects.equals(this.searchField, other.searchField) && Objects.equals(this.searchExpression, other.searchExpression) && Objects.equals(this.caseSensitive, other.caseSensitive) && Objects.equals(this.keywordSeparator, other.keywordSeparator) && Objects.equals(this.onlySplitWordsAtSeparator, other.onlySplitWordsAtSeparator);
    }

    @Override
    public boolean contains(BibEntry entry) {
        return this.searchStrategy.contains(entry);
    }

    @Override
    public AbstractGroup deepCopy() {
        return new WordKeywordGroup(this.getName(), this.getHierarchicalContext(), this.searchField, this.searchExpression, this.caseSensitive, this.keywordSeparator, this.onlySplitWordsAtSeparator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getHierarchicalContext(), this.searchField, this.searchExpression, this.caseSensitive, this.keywordSeparator, this.onlySplitWordsAtSeparator});
    }

    class TypeSearchStrategy
    implements SearchStrategy {
        Set<EntryType> searchWords;

        TypeSearchStrategy(WordKeywordGroup this$0) {
            this.searchWords = KeywordList.parse(this$0.searchExpression, this$0.keywordSeparator).stream().map(word -> EntryTypeFactory.parse(word.get())).collect(Collectors.toSet());
        }

        @Override
        public boolean contains(BibEntry entry) {
            return this.searchWords.stream().anyMatch(word -> entry.getType().equals(word));
        }
    }

    static interface SearchStrategy {
        public boolean contains(BibEntry var1);
    }

    class KeywordListSearchStrategy
    implements SearchStrategy {
        private final KeywordList searchWords;

        KeywordListSearchStrategy() {
            this.searchWords = KeywordList.parse(WordKeywordGroup.this.searchExpression, WordKeywordGroup.this.keywordSeparator);
        }

        @Override
        public boolean contains(BibEntry entry) {
            KeywordList fieldValue = entry.getFieldAsKeywords(WordKeywordGroup.this.searchField, WordKeywordGroup.this.keywordSeparator);
            return ListUtil.allMatch(this.searchWords, fieldValue::contains);
        }
    }

    class StringSearchStrategy
    implements SearchStrategy {
        Set<String> searchWords;

        StringSearchStrategy() {
            this.searchWords = new HashSet<String>(StringUtil.getStringAsWords(WordKeywordGroup.this.searchExpression));
        }

        @Override
        public boolean contains(BibEntry entry) {
            Set<String> content = entry.getFieldAsWords(WordKeywordGroup.this.searchField);
            if (WordKeywordGroup.this.caseSensitive) {
                return content.containsAll(this.searchWords);
            }
            return WordKeywordGroup.containsCaseInsensitive(content, this.searchWords);
        }
    }
}

