/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.metadata.ContentSelector;

public class ContentSelectors {
    public static final List<Field> DEFAULT_FIELD_NAMES = List.of(StandardField.AUTHOR, StandardField.JOURNAL, StandardField.KEYWORDS, StandardField.PUBLISHER);
    private final SortedSet<ContentSelector> contentSelectors = new TreeSet<ContentSelector>(new Comparator<ContentSelector>(this){

        @Override
        public int compare(ContentSelector o1, ContentSelector o2) {
            int result = o1.getField().getName().compareTo(o2.getField().getName());
            if (result != 0) {
                return result;
            }
            List properties1 = o1.getField().getProperties().stream().sorted().toList();
            List properties2 = o2.getField().getProperties().stream().sorted().toList();
            return properties1.toString().compareTo(properties2.toString());
        }
    });

    public void addContentSelector(ContentSelector contentSelector) {
        Objects.requireNonNull(contentSelector);
        this.contentSelectors.add(contentSelector);
    }

    public static ContentSelector parse(Field key, String values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(values);
        List<String> valueList = Arrays.asList(values.split(";"));
        return new ContentSelector(key, valueList);
    }

    public List<String> getSelectorValuesForField(Field field) {
        for (ContentSelector selector : this.contentSelectors) {
            if (!selector.getField().equals(field)) continue;
            return selector.getValues();
        }
        return Collections.emptyList();
    }

    public SortedSet<ContentSelector> getContentSelectors() {
        return this.contentSelectors;
    }

    public void removeSelector(Field field) {
        ContentSelector toRemove = null;
        for (ContentSelector selector : this.contentSelectors) {
            if (!selector.getField().equals(field)) continue;
            toRemove = selector;
            break;
        }
        if (toRemove != null) {
            this.contentSelectors.remove(toRemove);
        }
    }

    public List<Field> getFieldsWithSelectors() {
        ArrayList<Field> result = new ArrayList<Field>(this.contentSelectors.size());
        for (ContentSelector selector : this.contentSelectors) {
            result.add(selector.getField());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentSelectors that = (ContentSelectors)o;
        return Objects.equals(this.contentSelectors, that.contentSelectors);
    }

    public int hashCode() {
        return Objects.hash(this.contentSelectors);
    }

    public String toString() {
        return "ContentSelectors{contentSelectors=" + String.valueOf(this.contentSelectors) + ", fieldsWithSelectors=" + String.valueOf(this.getFieldsWithSelectors()) + "}";
    }

    public static boolean isDefaultMap(Map<Field, List<String>> fieldKeywordsMap) {
        if (fieldKeywordsMap.size() != DEFAULT_FIELD_NAMES.size()) {
            return false;
        }
        for (Field field : DEFAULT_FIELD_NAMES) {
            if (!fieldKeywordsMap.containsKey(field)) {
                return false;
            }
            if (fieldKeywordsMap.get(field).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static Map<Field, List<String>> getFieldKeywordsMap(SortedSet<ContentSelector> contentSelectors) {
        HashMap<Field, List<String>> fieldKeywordsMap = new HashMap<Field, List<String>>();
        contentSelectors.forEach(existingContentSelector -> fieldKeywordsMap.put(existingContentSelector.getField(), new ArrayList<String>(existingContentSelector.getValues())));
        return fieldKeywordsMap;
    }
}

