/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice;

import java.util.Objects;
import java.util.Optional;

public class CitationEntry
implements Comparable<CitationEntry> {
    private final String refMarkName;
    private final Optional<String> pageInfo;
    private final String context;

    public CitationEntry(String refMarkName, String context) {
        this(refMarkName, context, Optional.empty());
    }

    public CitationEntry(String refMarkName, String context, String pageInfo) {
        this(refMarkName, context, Optional.ofNullable(pageInfo));
    }

    public CitationEntry(String refMarkName, String context, Optional<String> pageInfo) {
        this.refMarkName = refMarkName;
        this.context = context;
        this.pageInfo = pageInfo;
    }

    public Optional<String> getPageInfo() {
        return this.pageInfo;
    }

    public String getRefMarkName() {
        return this.refMarkName;
    }

    @Override
    public int compareTo(CitationEntry other) {
        return this.refMarkName.compareTo(other.refMarkName);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CitationEntry) {
            CitationEntry other = (CitationEntry)object;
            return Objects.equals(this.refMarkName, other.refMarkName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.refMarkName);
    }

    public String getContext() {
        return this.context;
    }
}

