/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.ootext;

import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.strings.StringUtil;

public class OOFormat {
    private OOFormat() {
    }

    public static OOText setLocale(OOText ootext, String locale) {
        return OOText.fromString("<span lang=\"%s\">".formatted(locale) + ootext.toString() + "</span>");
    }

    public static OOText setLocaleNone(OOText ootext) {
        return OOFormat.setLocale(ootext, "zxx");
    }

    public static OOText setCharStyle(OOText ootext, String charStyle) {
        return OOText.fromString("<span oo:CharStyleName=\"%s\">".formatted(charStyle) + ootext.toString() + "</span>");
    }

    public static OOText paragraph(OOText ootext, String paraStyle) {
        if (StringUtil.isNullOrEmpty(paraStyle)) {
            return OOFormat.paragraph(ootext);
        }
        String startTag = "<p oo:ParaStyleName=\"%s\">".formatted(paraStyle);
        return OOText.fromString(startTag + ootext.toString() + "</p>");
    }

    public static OOText paragraph(OOText ootext) {
        return OOText.fromString("<p>" + ootext.toString() + "</p>");
    }

    public static OOText formatReferenceToPageNumberOfReferenceMark(String referenceMarkName) {
        String string = "<oo:referenceToPageNumberOfReferenceMark target=\"%s\">".formatted(referenceMarkName);
        return OOText.fromString(string);
    }
}

