/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.ootext;

import com.sun.star.awt.FontSlant;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XMultiPropertyStates;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XPropertyState;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.architecture.AllowedToUseAwt;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoCrossRef;
import org.jabref.model.openoffice.util.OOPair;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseAwt(value="Requires AWT for changing document properties")
public class OOTextIntoOO {
    private static final Logger LOGGER = LoggerFactory.getLogger(OOTextIntoOO.class);
    private static final String PARA_STYLE_NAME = "ParaStyleName";
    private static final String CHAR_ESCAPEMENT_HEIGHT = "CharEscapementHeight";
    private static final String CHAR_ESCAPEMENT = "CharEscapement";
    private static final String CHAR_STYLE_NAME = "CharStyleName";
    private static final String CHAR_UNDERLINE = "CharUnderline";
    private static final String CHAR_STRIKEOUT = "CharStrikeout";
    private static final short CHAR_ESCAPEMENT_VALUE_DEFAULT = 0;
    private static final short SUPERSCRIPT_VALUE = 33;
    private static final short SUBSCRIPT_VALUE = -10;
    private static final byte CHAR_ESCAPEMENT_HEIGHT_DEFAULT = 100;
    private static final byte SUPERSCRIPT_HEIGHT = 58;
    private static final byte SUBSCRIPT_HEIGHT = 58;
    private static final String TAG_NAME_REGEXP = "(?:b|i|em|tt|smallcaps|sup|sub|u|s|p|span|oo:referenceToPageNumberOfReferenceMark)";
    private static final String ATTRIBUTE_NAME_REGEXP = "(?:oo:ParaStyleName|oo:CharStyleName|lang|style|target)";
    private static final String ATTRIBUTE_VALUE_REGEXP = "\"([^\"]*)\"";
    private static final Pattern HTML_TAG = Pattern.compile("<(/(?:b|i|em|tt|smallcaps|sup|sub|u|s|p|span|oo:referenceToPageNumberOfReferenceMark))>|<((?:b|i|em|tt|smallcaps|sup|sub|u|s|p|span|oo:referenceToPageNumberOfReferenceMark))((?:\\s+((?:oo:ParaStyleName|oo:CharStyleName|lang|style|target))=\"([^\"]*)\")*)>");
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\s+((?:oo:ParaStyleName|oo:CharStyleName|lang|style|target))=\"([^\"]*)\"");

    private OOTextIntoOO() {
    }

    public static void write(XTextDocument doc, XTextCursor position, OOText ootext) throws WrappedTargetException, CreationException {
        Objects.requireNonNull(doc);
        Objects.requireNonNull(ootext);
        Objects.requireNonNull(position);
        String lText = OOText.toString(ootext);
        LOGGER.debug(lText);
        XText text = position.getText();
        XTextCursor cursor = text.createTextCursorByRange((XTextRange)position);
        cursor.collapseToEnd();
        MyPropertyStack formatStack = new MyPropertyStack(cursor);
        ArrayDeque<CallSite> expectEnd = new ArrayDeque<CallSite>();
        int piv = 0;
        Matcher tagMatcher = HTML_TAG.matcher(lText);
        while (tagMatcher.find()) {
            String currentSubstring = lText.substring(piv, tagMatcher.start());
            if (!currentSubstring.isEmpty()) {
                cursor.setString(currentSubstring);
            }
            formatStack.apply(cursor);
            cursor.collapseToEnd();
            String endTagName = tagMatcher.group(1);
            String string = tagMatcher.group(2);
            String attributeListPart = tagMatcher.group(3);
            boolean isStartTag = StringUtil.isNullOrEmpty(endTagName);
            String tagName = isStartTag ? string : endTagName;
            Objects.requireNonNull(tagName);
            List<OOPair<String, String>> attributes = OOTextIntoOO.parseAttributes(attributeListPart);
            switch (tagName) {
                case "b": {
                    formatStack.pushLayer(OOTextIntoOO.setCharWeight(150.0f));
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "i": 
                case "em": {
                    formatStack.pushLayer(OOTextIntoOO.setCharPosture(FontSlant.ITALIC));
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "smallcaps": {
                    formatStack.pushLayer(OOTextIntoOO.setCharCaseMap((short)4));
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "sup": {
                    formatStack.pushLayer(OOTextIntoOO.setSuperScript(formatStack));
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "sub": {
                    formatStack.pushLayer(OOTextIntoOO.setSubScript(formatStack));
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "u": {
                    formatStack.pushLayer(OOTextIntoOO.setCharUnderline((short)1));
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "s": {
                    formatStack.pushLayer(OOTextIntoOO.setCharStrikeout((short)1));
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "/p": {
                    break;
                }
                case "p": {
                    String value;
                    OOTextIntoOO.insertParagraphBreak(text, cursor);
                    cursor.collapseToEnd();
                    block63: for (OOPair<String, String> pair : attributes) {
                        String string2 = (String)pair.a;
                        value = (String)pair.b;
                        switch (string2) {
                            case "oo:ParaStyleName": {
                                if (StringUtil.isNullOrEmpty(value)) {
                                    LOGGER.debug("oo:ParaStyleName inherited");
                                    continue block63;
                                }
                                if (!OOTextIntoOO.setParagraphStyle(cursor, value)) continue block63;
                                LOGGER.debug("oo:ParaStyleName=\"%s\" failed".formatted(value));
                                continue block63;
                            }
                        }
                        LOGGER.warn("Unexpected attribute '%s' for <%s>".formatted(string2, tagName));
                    }
                    break;
                }
                case "oo:referenceToPageNumberOfReferenceMark": {
                    String value;
                    block64: for (OOPair<String, String> pair : attributes) {
                        String string3 = (String)pair.a;
                        value = (String)pair.b;
                        switch (string3) {
                            case "target": {
                                UnoCrossRef.insertReferenceToPageNumberOfReferenceMark(doc, value, (XTextRange)cursor);
                                continue block64;
                            }
                        }
                        LOGGER.warn("Unexpected attribute '%s' for <%s>".formatted(string3, tagName));
                    }
                    break;
                }
                case "tt": {
                    formatStack.pushLayer(OOTextIntoOO.setCharStyleName("Example"));
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "span": {
                    ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
                    block65: for (OOPair oOPair : attributes) {
                        String key = (String)oOPair.a;
                        String value = (String)oOPair.b;
                        switch (key) {
                            case "oo:CharStyleName": {
                                settings.addAll(OOTextIntoOO.setCharStyleName(value));
                                continue block65;
                            }
                            case "lang": {
                                settings.addAll(OOTextIntoOO.setCharLocale(value));
                                continue block65;
                            }
                            case "style": {
                                if ("font-variant: small-caps".equals(value)) {
                                    settings.addAll(OOTextIntoOO.setCharCaseMap((short)4));
                                    continue block65;
                                }
                                LOGGER.warn("Unexpected value %s for attribute '%s' for <%s>".formatted(value, key, tagName));
                                continue block65;
                            }
                        }
                        LOGGER.warn("Unexpected attribute '%s' for <%s>".formatted(key, tagName));
                    }
                    formatStack.pushLayer(settings);
                    expectEnd.push((CallSite)((Object)("/" + tagName)));
                    break;
                }
                case "/b": 
                case "/i": 
                case "/em": 
                case "/tt": 
                case "/smallcaps": 
                case "/sup": 
                case "/sub": 
                case "/u": 
                case "/s": 
                case "/span": {
                    formatStack.popLayer();
                    String expected = (String)expectEnd.pop();
                    if (tagName.equals(expected)) break;
                    LOGGER.warn("expected '<%s>', found '<%s>' after '%s'".formatted(expected, tagName, currentSubstring));
                    break;
                }
                default: {
                    LOGGER.warn("ignoring unknown tag '<%s>'".formatted(tagName));
                }
            }
            piv = tagMatcher.end();
        }
        if (piv < lText.length()) {
            cursor.setString(lText.substring(piv));
        }
        formatStack.apply(cursor);
        cursor.collapseToEnd();
        if (!expectEnd.isEmpty()) {
            StringBuilder rest = new StringBuilder();
            for (String string : expectEnd) {
                rest.insert(0, "<%s>".formatted(string));
            }
            LOGGER.warn("OOTextIntoOO.write: expectEnd stack is not empty at the end: %s%n".formatted(rest));
        }
    }

    public static void removeDirectFormatting(XTextCursor cursor) {
        XMultiPropertyStates mpss = UnoCast.cast(XMultiPropertyStates.class, cursor).get();
        XPropertySet propertySet = UnoCast.cast(XPropertySet.class, cursor).get();
        XPropertyState xPropertyState = UnoCast.cast(XPropertyState.class, cursor).get();
        try {
            propertySet.setPropertyValue(CHAR_STYLE_NAME, (Object)"Standard");
            xPropertyState.setPropertyToDefault("CharCaseMap");
        }
        catch (PropertyVetoException | UnknownPropertyException | WrappedTargetException ex) {
            LOGGER.warn("exception caught", ex);
        }
        mpss.setAllPropertiesToDefault();
        Set<String> knownToFail = Set.of("ListAutoFormat", "ListId", "NumberingIsNumber", "NumberingLevel", "NumberingRules", "NumberingStartValue", "ParaChapterNumberingLevel", "ParaIsNumberingRestart", PARA_STYLE_NAME);
        propertySet = UnoCast.cast(XPropertySet.class, cursor).get();
        XPropertySetInfo propertySetInfo = propertySet.getPropertySetInfo();
        for (Property p : propertySetInfo.getProperties()) {
            if ((p.Attributes & 0x10) != 0) continue;
            try {
                if (OOTextIntoOO.isPropertyDefault(cursor, p.Name)) {
                    continue;
                }
            }
            catch (UnknownPropertyException ex) {
                throw new IllegalStateException("Unexpected UnknownPropertyException", ex);
            }
            if (knownToFail.contains(p.Name)) continue;
            LOGGER.warn("OOTextIntoOO.removeDirectFormatting failed on '%s'".formatted(p.Name));
        }
    }

    private static List<OOPair<String, String>> parseAttributes(String attributes) {
        ArrayList<OOPair<String, String>> res = new ArrayList<OOPair<String, String>>();
        if (attributes == null) {
            return res;
        }
        Matcher attributeMatcher = ATTRIBUTE_PATTERN.matcher(attributes);
        while (attributeMatcher.find()) {
            String key = attributeMatcher.group(1);
            String value = attributeMatcher.group(2);
            res.add(new OOPair<String, String>(key, value));
        }
        return res;
    }

    private static boolean isPropertyDefault(XTextCursor cursor, String propertyName) throws UnknownPropertyException {
        XPropertyState xPropertyState = UnoCast.cast(XPropertyState.class, cursor).get();
        PropertyState state = xPropertyState.getPropertyState(propertyName);
        if (state == PropertyState.AMBIGUOUS_VALUE) {
            throw new java.lang.IllegalArgumentException("PropertyState.AMBIGUOUS_VALUE (expected properties for a homogeneous cursor)");
        }
        return state == PropertyState.DEFAULT_VALUE;
    }

    private static List<OOPair<String, Object>> setCharWeight(float value) {
        ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
        settings.add(new OOPair<String, Float>("CharWeight", Float.valueOf(value)));
        return settings;
    }

    private static List<OOPair<String, Object>> setCharPosture(FontSlant value) {
        ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
        settings.add(new OOPair<String, FontSlant>("CharPosture", value));
        return settings;
    }

    private static List<OOPair<String, Object>> setCharCaseMap(short value) {
        ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
        settings.add(new OOPair<String, Short>("CharCaseMap", value));
        return settings;
    }

    private static List<OOPair<String, Object>> setCharUnderline(short value) {
        ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
        settings.add(new OOPair<String, Short>(CHAR_UNDERLINE, value));
        return settings;
    }

    private static List<OOPair<String, Object>> setCharStrikeout(short value) {
        ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
        settings.add(new OOPair<String, Short>(CHAR_STRIKEOUT, value));
        return settings;
    }

    private static List<OOPair<String, Object>> setCharStyleName(String value) {
        ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
        if (StringUtil.isNullOrEmpty(value)) {
            LOGGER.warn("setCharStyleName: received null or empty value");
        } else {
            settings.add(new OOPair<String, String>(CHAR_STYLE_NAME, value));
        }
        return settings;
    }

    private static List<OOPair<String, Object>> setCharLocale(Locale value) {
        ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
        settings.add(new OOPair<String, Locale>("CharLocale", value));
        return settings;
    }

    private static List<OOPair<String, Object>> setCharLocale(String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            throw new java.lang.IllegalArgumentException("setCharLocale \"\" or null");
        }
        String[] parts = value.split("-");
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        String variant = parts.length > 2 ? parts[2] : "";
        return OOTextIntoOO.setCharLocale(new Locale(language, country, variant));
    }

    private static List<OOPair<String, Object>> setCharEscapement(Optional<Short> value, Optional<Byte> height, boolean relative, MyPropertyStack formatStack) {
        ArrayList<OOPair<String, Object>> settings = new ArrayList<OOPair<String, Object>>();
        Optional<Short> oldValue = formatStack.getPropertyValue(CHAR_ESCAPEMENT).map(e -> (short)((Short)e));
        Optional<Byte> oldHeight = formatStack.getPropertyValue(CHAR_ESCAPEMENT_HEIGHT).map(e -> (byte)((Byte)e));
        if (relative && (value.isPresent() || height.isPresent())) {
            double oldHeightFloat = (double)oldHeight.orElse((byte)100).byteValue() * 0.01;
            double oldValueFloat = oldValue.orElse((short)0).shortValue();
            double heightFloat = height.orElse((byte)100).byteValue();
            double valueFloat = value.orElse((short)0).shortValue();
            byte newHeight = (byte)Math.round(heightFloat * oldHeightFloat);
            short newValue = (short)Math.round(valueFloat * oldHeightFloat + oldValueFloat);
            if (value.isPresent()) {
                settings.add(new OOPair<String, Short>(CHAR_ESCAPEMENT, newValue));
            }
            if (height.isPresent()) {
                settings.add(new OOPair<String, Byte>(CHAR_ESCAPEMENT_HEIGHT, newHeight));
            }
        } else {
            if (value.isPresent()) {
                settings.add(new OOPair<String, Short>(CHAR_ESCAPEMENT, value.get()));
            }
            if (height.isPresent()) {
                settings.add(new OOPair<String, Byte>(CHAR_ESCAPEMENT_HEIGHT, height.get()));
            }
        }
        return settings;
    }

    private static List<OOPair<String, Object>> setSubScript(MyPropertyStack formatStack) {
        return OOTextIntoOO.setCharEscapement(Optional.of((short)-10), Optional.of((byte)58), true, formatStack);
    }

    private static List<OOPair<String, Object>> setSuperScript(MyPropertyStack formatStack) {
        return OOTextIntoOO.setCharEscapement(Optional.of((short)33), Optional.of((byte)58), true, formatStack);
    }

    public static boolean setParagraphStyle(XTextCursor cursor, String paragraphStyle) {
        boolean FAIL = true;
        boolean PASS = false;
        XParagraphCursor paragraphCursor = UnoCast.cast(XParagraphCursor.class, cursor).get();
        XPropertySet propertySet = UnoCast.cast(XPropertySet.class, paragraphCursor).get();
        try {
            propertySet.setPropertyValue(PARA_STYLE_NAME, (Object)paragraphStyle);
            return false;
        }
        catch (PropertyVetoException | UnknownPropertyException | IllegalArgumentException | WrappedTargetException ex) {
            return true;
        }
    }

    private static void insertParagraphBreak(XText text, XTextCursor cursor) {
        try {
            text.insertControlCharacter((XTextRange)cursor, (short)0, true);
        }
        catch (IllegalArgumentException ex) {
            throw new java.lang.IllegalArgumentException("Caught unexpected com.sun.star.lang.IllegalArgumentException", ex);
        }
    }

    static class MyPropertyStack {
        static final Set<String> CONTROLLED_PROPERTIES = Set.of("CharEscapement", "CharEscapementHeight", "CharAutoEscapement", "CharWeight", "CharPosture", "CharStrikeout", "CharCrossedOut", "CharUnderline", "CharLocale", "CharStyleName", "CharCaseMap");
        final int goodSize;
        final Map<String, Integer> goodNameToIndex;
        final String[] goodNames;
        final Deque<ArrayList<Optional<Object>>> layers;

        MyPropertyStack(XTextCursor cursor) {
            PropertyState[] propertyStateArray;
            XPropertySet propertySet = UnoCast.cast(XPropertySet.class, cursor).get();
            XPropertySetInfo propertySetInfo = propertySet.getPropertySetInfo();
            this.goodNameToIndex = new HashMap<String, Integer>();
            int nextIndex = 0;
            for (Property p : propertySetInfo.getProperties()) {
                if ((p.Attributes & 0x10) != 0 || !CONTROLLED_PROPERTIES.contains(p.Name)) continue;
                this.goodNameToIndex.put(p.Name, nextIndex);
                ++nextIndex;
            }
            this.goodSize = nextIndex;
            this.goodNames = new String[this.goodSize];
            for (Map.Entry entry : this.goodNameToIndex.entrySet()) {
                this.goodNames[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
            }
            Arrays.sort(this.goodNames);
            for (int i = 0; i < this.goodSize; ++i) {
                this.goodNameToIndex.put(this.goodNames[i], i);
            }
            XMultiPropertyStates mpss = UnoCast.cast(XMultiPropertyStates.class, cursor).get();
            try {
                propertyStateArray = mpss.getPropertyStates(this.goodNames);
            }
            catch (UnknownPropertyException ex) {
                throw new IllegalStateException("Caught unexpected UnknownPropertyException", ex);
            }
            XMultiPropertySet mps = UnoCast.cast(XMultiPropertySet.class, cursor).get();
            Object[] initialValues = mps.getPropertyValues(this.goodNames);
            ArrayList initialValuesOpt = new ArrayList(this.goodSize);
            for (int i = 0; i < this.goodSize; ++i) {
                if (propertyStateArray[i] == PropertyState.DIRECT_VALUE) {
                    initialValuesOpt.add(Optional.of(initialValues[i]));
                    continue;
                }
                initialValuesOpt.add(Optional.empty());
            }
            this.layers = new ArrayDeque<ArrayList<Optional<Object>>>();
            this.layers.push(initialValuesOpt);
        }

        void pushLayer(List<OOPair<String, Object>> settings) {
            ArrayList<Optional<Object>> oldLayer = this.layers.peek();
            ArrayList<Optional<Object>> newLayer = new ArrayList<Optional<Object>>(oldLayer);
            for (OOPair<String, Object> pair : settings) {
                String name = (String)pair.a;
                Integer index = this.goodNameToIndex.get(name);
                if (index == null) {
                    LOGGER.warn("pushLayer: '%s' is not in goodNameToIndex".formatted(name));
                    continue;
                }
                Object newValue = pair.b;
                newLayer.set(index, Optional.ofNullable(newValue));
            }
            this.layers.push(newLayer);
        }

        void popLayer() {
            if (this.layers.size() <= 1) {
                LOGGER.warn("popLayer: underflow");
                return;
            }
            this.layers.pop();
        }

        void apply(XTextCursor cursor) {
            XMultiPropertySet mps = UnoCast.cast(XMultiPropertySet.class, cursor).get();
            XMultiPropertyStates mpss = UnoCast.cast(XMultiPropertyStates.class, cursor).get();
            ArrayList<Optional<Object>> topLayer = this.layers.peek();
            try {
                ArrayList<String> names = new ArrayList<String>(this.goodSize);
                ArrayList<Object> values = new ArrayList<Object>(this.goodSize);
                ArrayList<String> delNames = new ArrayList<String>(this.goodSize);
                for (int i = 0; i < this.goodSize; ++i) {
                    if (topLayer.get(i).isPresent()) {
                        names.add(this.goodNames[i]);
                        values.add(topLayer.get(i).get());
                        continue;
                    }
                    delNames.add(this.goodNames[i]);
                }
                String[] namesArray = names.toArray(new String[0]);
                String[] delNamesArray = delNames.toArray(new String[0]);
                mpss.setPropertiesToDefault(delNamesArray);
                mps.setPropertyValues(namesArray, values.toArray());
            }
            catch (UnknownPropertyException ex) {
                LOGGER.warn("UnknownPropertyException in MyPropertyStack.apply", (Throwable)ex);
            }
            catch (PropertyVetoException ex) {
                LOGGER.warn("PropertyVetoException in MyPropertyStack.apply");
            }
            catch (WrappedTargetException ex) {
                LOGGER.warn("WrappedTargetException in MyPropertyStack.apply");
            }
        }

        Optional<Object> getPropertyValue(String name) {
            if (this.goodNameToIndex.containsKey(name)) {
                int index = this.goodNameToIndex.get(name);
                ArrayList<Optional<Object>> topLayer = this.layers.peek();
                return topLayer.get(index);
            }
            return Optional.empty();
        }
    }
}

