/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.rangesort;

import com.sun.star.text.XText;
import com.sun.star.text.XTextRangeCompare;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jabref.model.openoffice.rangesort.RangeHolder;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoTextRange;

public class RangeSort {
    private RangeSort() {
    }

    public static <V extends RangeHolder> void sortWithinPartition(List<V> rangeHolders) {
        if (rangeHolders.isEmpty()) {
            return;
        }
        XText text = ((RangeHolder)rangeHolders.getFirst()).getRange().getText();
        rangeHolders.sort(new HolderComparatorWithinPartition(text));
    }

    public static <V extends RangeHolder> RangePartitions<V> partitionRanges(List<V> holders) {
        RangePartitions<RangeHolder> result = new RangePartitions<RangeHolder>();
        for (RangeHolder holder : holders) {
            result.add(holder);
        }
        return result;
    }

    public static <V extends RangeHolder> RangePartitions<V> partitionAndSortRanges(List<V> holders) {
        RangePartitions<V> result = RangeSort.partitionRanges(holders);
        for (List<V> partition : result.getPartitions()) {
            RangeSort.sortWithinPartition(partition);
        }
        return result;
    }

    private static class HolderComparatorWithinPartition
    implements Comparator<RangeHolder> {
        private final XTextRangeCompare cmp;

        HolderComparatorWithinPartition(XText text) {
            this.cmp = UnoCast.cast(XTextRangeCompare.class, text).orElseThrow(IllegalArgumentException::new);
        }

        @Override
        public int compare(RangeHolder a, RangeHolder b) {
            return UnoTextRange.compareStartsThenEndsUnsafe(this.cmp, a.getRange(), b.getRange());
        }
    }

    public static class RangePartitions<V extends RangeHolder> {
        private final Map<XText, List<V>> partitions = new HashMap<XText, List<V>>();

        public void add(V holder) {
            XText partitionKey = holder.getRange().getText();
            List partition = this.partitions.computeIfAbsent(partitionKey, unused -> new ArrayList());
            partition.add(holder);
        }

        public List<List<V>> getPartitions() {
            return new ArrayList<List<V>>(this.partitions.values());
        }
    }
}

