/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.rangesort;

import com.sun.star.awt.Point;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import java.util.ArrayList;
import java.util.List;
import org.jabref.model.openoffice.rangesort.FunctionalTextViewCursor;
import org.jabref.model.openoffice.rangesort.RangeSortable;
import org.jabref.model.openoffice.uno.UnoScreenRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeSortVisual {
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeSortVisual.class);

    private RangeSortVisual() {
    }

    public static <T> List<RangeSortable<T>> visualSort(List<RangeSortable<T>> inputs, XTextDocument doc, FunctionalTextViewCursor fcursor) {
        if (UnoScreenRefresh.hasControllersLocked(doc)) {
            String msg = "visualSort: with ControllersLocked, viewCursor.gotoRange is probably useless";
            LOGGER.warn("visualSort: with ControllersLocked, viewCursor.gotoRange is probably useless");
            throw new IllegalStateException("visualSort: with ControllersLocked, viewCursor.gotoRange is probably useless");
        }
        XTextViewCursor viewCursor = fcursor.getViewCursor();
        int inputSize = inputs.size();
        ArrayList<Point> positions = new ArrayList<Point>(inputSize);
        for (RangeSortable<T> v : inputs) {
            positions.add(RangeSortVisual.findPositionOfTextRange(v.getRange(), viewCursor));
        }
        fcursor.restore(doc);
        ArrayList<ComparableMark<RangeSortable<T>>> comparableMarks = new ArrayList<ComparableMark<RangeSortable<T>>>(inputSize);
        for (int i = 0; i < inputSize; ++i) {
            RangeSortable<T> input = inputs.get(i);
            comparableMarks.add(new ComparableMark<RangeSortable<T>>((Point)positions.get(i), input.getIndexInPosition(), input));
        }
        comparableMarks.sort(RangeSortVisual::compareTopToBottomLeftToRight);
        ArrayList<RangeSortable<T>> result = new ArrayList<RangeSortable<T>>(comparableMarks.size());
        for (ComparableMark comparableMark : comparableMarks) {
            result.add((RangeSortable)comparableMark.getContent());
        }
        if (result.size() != inputSize) {
            throw new IllegalStateException("visualSort: result.size() != inputSize");
        }
        return result;
    }

    private static Point findPositionOfTextRange(XTextRange range, XTextViewCursor cursor) {
        cursor.gotoRange(range, false);
        return cursor.getPosition();
    }

    private static <T> int compareTopToBottomLeftToRight(ComparableMark<T> a, ComparableMark<T> b) {
        if (a.position.Y != b.position.Y) {
            return a.position.Y - b.position.Y;
        }
        if (a.position.X != b.position.X) {
            return a.position.X - b.position.X;
        }
        return a.indexInPosition - b.indexInPosition;
    }

    private static class ComparableMark<T> {
        private final Point position;
        private final int indexInPosition;
        private final T content;

        public ComparableMark(Point position, int indexInPosition, T content) {
            this.position = position;
            this.indexInPosition = indexInPosition;
            this.content = content;
        }

        public T getContent() {
            return this.content;
        }
    }
}

