/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.util.XRefreshable;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.UnoCast;

public class UnoCrossRef {
    private UnoCrossRef() {
    }

    public static void refresh(XTextDocument doc) {
        XRefreshable xRefresh = UnoCast.cast(XRefreshable.class, doc).get();
        xRefresh.refresh();
    }

    public static void insertReferenceToPageNumberOfReferenceMark(XTextDocument doc, String referenceMarkName, XTextRange cursor) throws CreationException, WrappedTargetException {
        XPropertySet xFieldProps;
        XMultiServiceFactory msf = UnoCast.cast(XMultiServiceFactory.class, doc).get();
        try {
            String name = "com.sun.star.text.textfield.GetReference";
            xFieldProps = UnoCast.cast(XPropertySet.class, msf.createInstance(name)).get();
        }
        catch (Exception e) {
            throw new CreationException(e.getMessage());
        }
        try {
            xFieldProps.setPropertyValue("SourceName", (Object)referenceMarkName);
        }
        catch (UnknownPropertyException ex) {
            throw new IllegalStateException("The created GetReference does not have property 'SourceName'");
        }
        catch (PropertyVetoException ex) {
            throw new IllegalStateException("Caught PropertyVetoException on 'SourceName'");
        }
        try {
            xFieldProps.setPropertyValue("ReferenceFieldSource", (Object)0);
        }
        catch (UnknownPropertyException ex) {
            throw new IllegalStateException("The created GetReference does not have property 'ReferenceFieldSource'");
        }
        catch (PropertyVetoException ex) {
            throw new IllegalStateException("Caught PropertyVetoException on 'ReferenceFieldSource'");
        }
        try {
            xFieldProps.setPropertyValue("ReferenceFieldPart", (Object)0);
        }
        catch (UnknownPropertyException ex) {
            throw new IllegalStateException("The created GetReference does not have property 'ReferenceFieldPart'");
        }
        catch (PropertyVetoException ex) {
            throw new IllegalStateException("Caught PropertyVetoException on 'ReferenceFieldPart'");
        }
        XTextContent xRefContent = UnoCast.cast(XTextContent.class, xFieldProps).get();
        cursor.getText().insertTextContent(cursor.getEnd(), xRefContent, false);
    }
}

