/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XReferenceMarksSupplier;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jabref.model.openoffice.DocumentAnnotation;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoNameAccess;
import org.jabref.model.openoffice.uno.UnoNamed;

public class UnoReferenceMark {
    private UnoReferenceMark() {
    }

    public static XNameAccess getNameAccess(XTextDocument doc) throws NoDocumentException {
        XReferenceMarksSupplier supplier = UnoCast.cast(XReferenceMarksSupplier.class, doc).get();
        try {
            return supplier.getReferenceMarks();
        }
        catch (DisposedException ex) {
            throw new NoDocumentException("UnoReferenceMarks.getNameAccess failed with" + String.valueOf((Object)ex));
        }
    }

    public static List<String> getListOfNames(XTextDocument doc) throws NoDocumentException {
        XNameAccess nameAccess = UnoReferenceMark.getNameAccess(doc);
        String[] names = nameAccess.getElementNames();
        if (names == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(names);
    }

    public static void removeIfExists(XTextDocument doc, String name) throws WrappedTargetException, NoDocumentException {
        XNameAccess xReferenceMarks = UnoReferenceMark.getNameAccess(doc);
        if (xReferenceMarks.hasByName(name)) {
            Optional<XTextContent> mark = UnoNameAccess.getTextContentByName(xReferenceMarks, name);
            if (mark.isEmpty()) {
                return;
            }
            try {
                doc.getText().removeTextContent(mark.get());
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public static Optional<XTextContent> getAsTextContent(XTextDocument doc, String name) throws NoDocumentException, WrappedTargetException {
        XNameAccess nameAccess = UnoReferenceMark.getNameAccess(doc);
        return UnoNameAccess.getTextContentByName(nameAccess, name);
    }

    public static Optional<XTextRange> getAnchor(XTextDocument doc, String name) throws NoDocumentException, WrappedTargetException {
        return UnoReferenceMark.getAsTextContent(doc, name).map(XTextContent::getAnchor);
    }

    public static XNamed create(DocumentAnnotation documentAnnotation) throws CreationException {
        return UnoNamed.insertNamedTextContent("com.sun.star.text.ReferenceMark", documentAnnotation);
    }
}

