/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.frame.XController;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextDocument;
import com.sun.star.view.XSelectionSupplier;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoTextDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnoSelection {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnoSelection.class);

    private UnoSelection() {
    }

    private static Optional<XSelectionSupplier> getSelectionSupplier(XTextDocument doc) {
        if (doc == null) {
            LOGGER.warn("UnoSelection.getSelectionSupplier: doc is null");
            return Optional.empty();
        }
        Optional<XController> controller = UnoTextDocument.getCurrentController(doc);
        if (controller.isEmpty()) {
            LOGGER.warn("UnoSelection.getSelectionSupplier: getCurrentController(doc) returned empty");
            return Optional.empty();
        }
        Optional<XSelectionSupplier> supplier = UnoCast.cast(XSelectionSupplier.class, controller.get());
        if (supplier.isEmpty()) {
            LOGGER.warn("UnoSelection.getSelectionSupplier: cast to XSelectionSupplier returned empty");
            return Optional.empty();
        }
        return supplier;
    }

    public static Optional<XServiceInfo> getSelectionAsXServiceInfo(XTextDocument doc) {
        Objects.requireNonNull(doc);
        Optional<XSelectionSupplier> supplier = UnoSelection.getSelectionSupplier(doc);
        if (supplier.isEmpty()) {
            LOGGER.warn("getSelectionSupplier returned empty");
            return Optional.empty();
        }
        Object selection = supplier.get().getSelection();
        if (selection == null) {
            return Optional.empty();
        }
        Optional<XServiceInfo> result = UnoCast.cast(XServiceInfo.class, selection);
        if (result.isEmpty()) {
            LOGGER.warn("cast to XServiceInfo returned empty");
            return Optional.empty();
        }
        return result;
    }

    public static void select(XTextDocument doc, Object newSelection) {
        Objects.requireNonNull(doc);
        UnoSelection.getSelectionSupplier(doc).ifPresent(e -> e.select(newSelection));
    }
}

