/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.text.XFootnote;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import java.util.Optional;
import org.jabref.model.openoffice.uno.UnoCast;

public class UnoTextRange {
    private UnoTextRange() {
    }

    public static Optional<XTextRange> getFootnoteMarkRange(XTextRange original) {
        Optional<XFootnote> footer = UnoCast.cast(XFootnote.class, original.getText());
        return footer.map(XTextContent::getAnchor);
    }

    public static boolean comparables(XTextRange a, XTextRange b) {
        return a.getText() == b.getText();
    }

    public static int compareStartsUnsafe(XTextRangeCompare compare, XTextRange a, XTextRange b) {
        return -1 * compare.compareRegionStarts(a, b);
    }

    public static int compareStarts(XTextRange a, XTextRange b) {
        if (!UnoTextRange.comparables(a, b)) {
            throw new IllegalArgumentException("compareStarts: got incomparable regions");
        }
        XTextRangeCompare compare = UnoCast.cast(XTextRangeCompare.class, a.getText()).get();
        return UnoTextRange.compareStartsUnsafe(compare, a, b);
    }

    public static int compareEnds(XTextRange a, XTextRange b) {
        if (!UnoTextRange.comparables(a, b)) {
            throw new IllegalArgumentException("compareEnds: got incomparable regions");
        }
        XTextRangeCompare compare = UnoCast.cast(XTextRangeCompare.class, a.getText()).get();
        return -1 * compare.compareRegionEnds(a, b);
    }

    public static int compareStartsThenEndsUnsafe(XTextRangeCompare compare, XTextRange a, XTextRange b) {
        short res = compare.compareRegionStarts(a, b);
        if (res != 0) {
            return -1 * res;
        }
        return -1 * compare.compareRegionEnds(a, b);
    }

    public static int compareStartsThenEnds(XTextRange a, XTextRange b) {
        if (!UnoTextRange.comparables(a, b)) {
            throw new IllegalArgumentException("compareStartsThenEnds: got incomparable regions");
        }
        XTextRangeCompare compare = UnoCast.cast(XTextRangeCompare.class, a.getText()).get();
        return UnoTextRange.compareStartsThenEndsUnsafe(compare, a, b);
    }
}

