/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.document.XUndoManager;
import com.sun.star.document.XUndoManagerSupplier;
import com.sun.star.text.XTextDocument;
import com.sun.star.util.InvalidStateException;
import java.util.Optional;
import org.jabref.model.openoffice.uno.UnoCast;

public class UnoUndo {
    private UnoUndo() {
    }

    public static Optional<XUndoManager> getXUndoManager(XTextDocument doc) {
        return UnoCast.cast(XUndoManagerSupplier.class, doc).map(XUndoManagerSupplier::getUndoManager);
    }

    public static void enterUndoContext(XTextDocument doc, String title) {
        UnoUndo.getXUndoManager(doc).ifPresent(undoManager -> undoManager.enterUndoContext(title));
    }

    public static void leaveUndoContext(XTextDocument doc) {
        Optional<XUndoManager> undoManager = UnoUndo.getXUndoManager(doc);
        if (undoManager.isPresent()) {
            try {
                undoManager.get().leaveUndoContext();
            }
            catch (InvalidStateException ex) {
                throw new IllegalStateException("leaveUndoContext reported InvalidStateException");
            }
        }
    }
}

