/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyExistException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyContainer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.model.openoffice.uno.UnoProperties;
import org.jabref.model.openoffice.uno.UnoTextDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnoUserDefinedProperty {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnoUserDefinedProperty.class);

    private UnoUserDefinedProperty() {
    }

    public static Optional<XPropertyContainer> getPropertyContainer(XTextDocument doc) {
        return UnoTextDocument.getDocumentProperties(doc).map(XDocumentProperties::getUserDefinedProperties);
    }

    public static List<String> getListOfNames(XTextDocument doc) {
        return UnoUserDefinedProperty.getPropertyContainer(doc).map(UnoProperties::getPropertyNames).orElse(new ArrayList());
    }

    public static Optional<String> getStringValue(XTextDocument doc, String property) throws WrappedTargetException {
        Optional propertySet = UnoUserDefinedProperty.getPropertyContainer(doc).flatMap(UnoProperties::asPropertySet);
        if (propertySet.isEmpty()) {
            throw new IllegalArgumentException("getting UserDefinedProperties as XPropertySet failed");
        }
        try {
            String value = ((XPropertySet)propertySet.get()).getPropertyValue(property).toString();
            return Optional.ofNullable(value);
        }
        catch (UnknownPropertyException ex) {
            return Optional.empty();
        }
    }

    public static void setStringProperty(XTextDocument doc, String property, String value) throws IllegalTypeException, PropertyVetoException, WrappedTargetException {
        Objects.requireNonNull(property);
        Objects.requireNonNull(value);
        Optional<XPropertyContainer> container = UnoUserDefinedProperty.getPropertyContainer(doc);
        if (container.isEmpty()) {
            throw new IllegalArgumentException("UnoUserDefinedProperty.getPropertyContainer failed");
        }
        Optional propertySet = container.flatMap(UnoProperties::asPropertySet);
        if (propertySet.isEmpty()) {
            throw new IllegalArgumentException("asPropertySet failed");
        }
        XPropertySetInfo propertySetInfo = ((XPropertySet)propertySet.get()).getPropertySetInfo();
        if (propertySetInfo.hasPropertyByName(property)) {
            try {
                ((XPropertySet)propertySet.get()).setPropertyValue(property, (Object)value);
                return;
            }
            catch (UnknownPropertyException unknownPropertyException) {
                // empty catch block
            }
        }
        try {
            container.get().addProperty(property, (short)128, (Object)new Any(Type.STRING, (Object)value));
        }
        catch (PropertyExistException ex) {
            throw new IllegalStateException("Caught PropertyExistException for property assumed not to exist");
        }
    }

    public static void remove(XTextDocument doc, String property) throws NotRemoveableException {
        Objects.requireNonNull(property);
        Optional<XPropertyContainer> container = UnoUserDefinedProperty.getPropertyContainer(doc);
        if (container.isEmpty()) {
            throw new IllegalArgumentException("getUserDefinedPropertiesAsXPropertyContainer failed");
        }
        try {
            container.get().removeProperty(property);
        }
        catch (UnknownPropertyException ex) {
            LOGGER.warn("UnoUserDefinedProperty.remove(%s) This property was not there to remove".formatted(property));
        }
    }

    public static void removeIfExists(XTextDocument doc, String property) throws NotRemoveableException {
        Objects.requireNonNull(property);
        Optional<XPropertyContainer> container = UnoUserDefinedProperty.getPropertyContainer(doc);
        if (container.isEmpty()) {
            throw new IllegalArgumentException("getUserDefinedPropertiesAsXPropertyContainer failed");
        }
        try {
            container.get().removeProperty(property);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            // empty catch block
        }
    }
}

