/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.util;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jabref.model.openoffice.util.OOVoidResult;

public class OOResult<R, E> {
    private final Optional<R> result;
    private final Optional<E> error;

    private OOResult(Optional<R> result, Optional<E> error) {
        this.result = result;
        this.error = error;
    }

    public static <R, E> OOResult<R, E> ok(R result) {
        return new OOResult(Optional.of(result), Optional.empty());
    }

    public static <R, E> OOResult<R, E> error(E error) {
        return new OOResult(Optional.empty(), Optional.of(error));
    }

    public boolean isPresent() {
        return this.result.isPresent();
    }

    public boolean isEmpty() {
        return !this.isPresent();
    }

    public boolean isError() {
        return this.error.isPresent();
    }

    public boolean isOK() {
        return !this.isError();
    }

    public R get() {
        if (this.isError()) {
            throw new NoSuchElementException("Cannot get from error");
        }
        return this.result.get();
    }

    public E getError() {
        return this.error.get();
    }

    public OOResult<R, E> ifPresent(Consumer<R> fun) {
        if (this.isPresent()) {
            fun.accept(this.get());
        }
        return this;
    }

    public OOResult<R, E> ifError(Consumer<E> fun) {
        if (this.isError()) {
            fun.accept(this.getError());
        }
        return this;
    }

    public <S> OOResult<S, E> map(Function<R, S> fun) {
        if (this.isError()) {
            return OOResult.error(this.getError());
        }
        return OOResult.ok(fun.apply(this.get()));
    }

    public <F> OOResult<R, F> mapError(Function<E, F> fun) {
        if (this.isError()) {
            return OOResult.error(fun.apply(this.getError()));
        }
        return OOResult.ok(this.get());
    }

    public Optional<R> getOptional() {
        return this.result;
    }

    public OOVoidResult<E> asVoidResult() {
        if (this.isError()) {
            return OOVoidResult.error(this.getError());
        }
        return OOVoidResult.ok();
    }
}

