/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search.rules;

import java.util.EnumSet;
import java.util.regex.Pattern;
import org.jabref.model.search.rules.ContainsBasedSearchRule;
import org.jabref.model.search.rules.GrammarBasedSearchRule;
import org.jabref.model.search.rules.RegexBasedSearchRule;
import org.jabref.model.search.rules.SearchRule;

public class SearchRules {
    private static final Pattern SIMPLE_EXPRESSION = Pattern.compile("[^\\p{Punct}]*");

    private SearchRules() {
    }

    public static SearchRule getSearchRuleByQuery(String query, EnumSet<SearchFlags> searchFlags) {
        if (SearchRules.isSimpleQuery(query)) {
            return new ContainsBasedSearchRule(searchFlags);
        }
        GrammarBasedSearchRule searchExpression = new GrammarBasedSearchRule(searchFlags);
        if (searchExpression.validateSearchStrings(query)) {
            return searchExpression;
        }
        return SearchRules.getSearchRule(searchFlags);
    }

    private static boolean isSimpleQuery(String query) {
        return SIMPLE_EXPRESSION.matcher(query).matches();
    }

    static SearchRule getSearchRule(EnumSet<SearchFlags> searchFlags) {
        if (searchFlags.contains((Object)SearchFlags.REGULAR_EXPRESSION)) {
            return new RegexBasedSearchRule(searchFlags);
        }
        return new ContainsBasedSearchRule(searchFlags);
    }

    public static enum SearchFlags {
        CASE_SENSITIVE,
        REGULAR_EXPRESSION,
        FULLTEXT,
        KEEP_SEARCH_STRING;

    }
}

