/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.texparser;

import java.nio.file.Path;
import java.util.Objects;

public record Citation(Path path, int line, int colStart, int colEnd, String lineText) {
    private static final int CONTEXT_WIDTH = 300;

    public Citation(Path path, int line, int colStart, int colEnd, String lineText) {
        if (line <= 0) {
            throw new IllegalArgumentException("Line has to be greater than 0.");
        }
        if (colStart < 0 || colEnd > lineText.length()) {
            throw new IllegalArgumentException("Citation has to be between 0 and line length.");
        }
        this.path = Objects.requireNonNull(path);
        this.line = line;
        this.colStart = colStart;
        this.colEnd = colEnd;
        this.lineText = lineText;
    }

    public String getContext() {
        int center = (this.colStart + this.colEnd) / 2;
        int lineLength = this.lineText.length();
        int start = Math.max(0, center + 150 < lineLength ? center - 150 : lineLength - 300);
        int end = Math.min(lineLength, start + 300);
        return "%s%s%s".formatted(start > 0 ? "..." : "", this.lineText.substring(start, end).trim(), end < lineLength ? "..." : "");
    }

    @Override
    public String toString() {
        return "Citation{path=%s, line=%s, colStart=%s, colEnd=%s, lineText='%s'}".formatted(this.path, this.line, this.colStart, this.colEnd, this.lineText);
    }
}

