/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.texparser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jabref.model.texparser.Citation;
import org.jabref.model.texparser.LatexParserResult;

public class LatexParserResults {
    private final Map<Path, LatexParserResult> parsedTexFiles = new HashMap<Path, LatexParserResult>();

    public LatexParserResults() {
    }

    @VisibleForTesting
    public LatexParserResults(LatexParserResult ... parsedFiles) {
        this();
        for (LatexParserResult parsedFile : parsedFiles) {
            this.add(parsedFile.getPath(), parsedFile);
        }
    }

    public void add(Path texFile, LatexParserResult parsedFile) {
        this.parsedTexFiles.put(texFile, parsedFile);
    }

    public LatexParserResult remove(Path texFile) {
        return this.parsedTexFiles.remove(texFile);
    }

    public Set<Path> getBibFiles() {
        HashSet<Path> bibFiles = new HashSet<Path>();
        this.parsedTexFiles.values().forEach(result -> bibFiles.addAll(result.getBibFiles()));
        return bibFiles;
    }

    public Multimap<String, Citation> getCitations() {
        HashMultimap citations = HashMultimap.create();
        this.parsedTexFiles.forEach((arg_0, arg_1) -> LatexParserResults.lambda$getCitations$1((Multimap)citations, arg_0, arg_1));
        return citations;
    }

    public Collection<Citation> getCitationsByKey(String key) {
        ArrayList<Citation> citations = new ArrayList<Citation>();
        this.parsedTexFiles.values().forEach(result -> citations.addAll(result.getCitationsByKey(key)));
        return citations;
    }

    public void clear() {
        this.parsedTexFiles.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LatexParserResults that = (LatexParserResults)obj;
        return Objects.equals(this.parsedTexFiles, that.parsedTexFiles);
    }

    public int hashCode() {
        return Objects.hash(this.parsedTexFiles);
    }

    private static /* synthetic */ void lambda$getCitations$1(Multimap citations, Path path, LatexParserResult result) {
        citations.putAll(result.getCitations());
    }
}

