/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import com.airhacks.afterburner.injection.Injector;
import com.github.javakeyring.Keyring;
import com.github.javakeyring.PasswordAccessException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import org.jabref.gui.autocompleter.AutoCompleteFirstNameMode;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.gui.duplicationFinder.DuplicateResolverDialog;
import org.jabref.gui.entryeditor.EntryEditorPreferences;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.groups.GroupViewMode;
import org.jabref.gui.groups.GroupsPreferences;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.maintable.ColumnPreferences;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.maintable.MainTablePreferences;
import org.jabref.gui.maintable.NameDisplayPreferences;
import org.jabref.gui.mergeentries.DiffMode;
import org.jabref.gui.search.SearchDisplayMode;
import org.jabref.gui.sidepane.SidePaneType;
import org.jabref.gui.specialfields.SpecialFieldsPreferences;
import org.jabref.gui.theme.Theme;
import org.jabref.logic.JabRefException;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.bst.BstPreviewLayout;
import org.jabref.logic.citationkeypattern.CitationKeyPattern;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.citationkeypattern.GlobalCitationKeyPatterns;
import org.jabref.logic.citationstyle.CitationStyle;
import org.jabref.logic.citationstyle.CitationStylePreviewLayout;
import org.jabref.logic.cleanup.FieldFormatterCleanups;
import org.jabref.logic.exporter.BibDatabaseWriter;
import org.jabref.logic.exporter.MetaDataSerializer;
import org.jabref.logic.exporter.SelfContainedSaveConfiguration;
import org.jabref.logic.exporter.TemplateExporter;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.fetcher.GrobidPreferences;
import org.jabref.logic.importer.fileformat.CustomImporter;
import org.jabref.logic.importer.util.MetaDataParser;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Language;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.TextBasedPreviewLayout;
import org.jabref.logic.layout.format.NameFormatterPreferences;
import org.jabref.logic.net.ProxyPreferences;
import org.jabref.logic.net.ssl.SSLPreferences;
import org.jabref.logic.net.ssl.TrustStoreManager;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.preferences.DOIPreferences;
import org.jabref.logic.preferences.FetcherApiKey;
import org.jabref.logic.preferences.OwnerPreferences;
import org.jabref.logic.preferences.TimestampPreferences;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.logic.protectedterms.ProtectedTermsPreferences;
import org.jabref.logic.push.CitationCommandString;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.shared.prefs.SharedDatabasePreferences;
import org.jabref.logic.shared.security.Password;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.Version;
import org.jabref.logic.util.io.AutoLinkPreferences;
import org.jabref.logic.util.io.FileHistory;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.model.metadata.SelfContainedSaveOrder;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.BibEntryPreferences;
import org.jabref.preferences.CleanupPreferences;
import org.jabref.preferences.ExportPreferences;
import org.jabref.preferences.ExternalApplicationsPreferences;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.GuiPreferences;
import org.jabref.preferences.InternalPreferences;
import org.jabref.preferences.LibraryPreferences;
import org.jabref.preferences.MergeDialogPreferences;
import org.jabref.preferences.MrDlibPreferences;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PreviewPreferences;
import org.jabref.preferences.PushToApplicationPreferences;
import org.jabref.preferences.SearchPreferences;
import org.jabref.preferences.SidePanePreferences;
import org.jabref.preferences.WorkspacePreferences;
import org.jvnet.hk2.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Service
public class JabRefPreferences
implements PreferencesService {
    public static final String PUSH_EMACS_PATH = "emacsPath";
    public static final String PUSH_EMACS_ADDITIONAL_PARAMETERS = "emacsParameters";
    public static final String PUSH_LYXPIPE = "lyxpipe";
    public static final String PUSH_TEXSTUDIO_PATH = "TeXstudioPath";
    public static final String PUSH_TEXWORKS_PATH = "TeXworksPath";
    public static final String PUSH_WINEDT_PATH = "winEdtPath";
    public static final String PUSH_TEXMAKER_PATH = "texmakerPath";
    public static final String PUSH_VIM_SERVER = "vimServer";
    public static final String PUSH_VIM = "vim";
    public static final String PUSH_SUBLIME_TEXT_PATH = "sublimeTextPath";
    public static final String EXTERNAL_FILE_TYPES = "externalFileTypes";
    public static final String THEME = "fxTheme";
    public static final String THEME_SYNC_OS = "themeSyncOs";
    public static final String LANGUAGE = "language";
    public static final String NAMES_LAST_ONLY = "namesLastOnly";
    public static final String ABBR_AUTHOR_NAMES = "abbrAuthorNames";
    public static final String NAMES_NATBIB = "namesNatbib";
    public static final String NAMES_FIRST_LAST = "namesFf";
    public static final String BIBLATEX_DEFAULT_MODE = "biblatexMode";
    public static final String NAMES_AS_IS = "namesAsIs";
    public static final String ENTRY_EDITOR_HEIGHT = "entryEditorHeightFX";
    public static final String ENTRY_EDITOR_PREVIEW_DIVIDER_POS = "entryEditorPreviewDividerPos";
    public static final String AUTO_RESIZE_MODE = "autoResizeMode";
    public static final String WINDOW_MAXIMISED = "windowMaximised";
    public static final String WINDOW_FULLSCREEN = "windowFullscreen";
    public static final String REFORMAT_FILE_ON_SAVE_AND_EXPORT = "reformatFileOnSaveAndExport";
    public static final String EXPORT_IN_ORIGINAL_ORDER = "exportInOriginalOrder";
    public static final String EXPORT_IN_SPECIFIED_ORDER = "exportInSpecifiedOrder";
    public static final String EXPORT_PRIMARY_SORT_FIELD = "exportPriSort";
    public static final String EXPORT_PRIMARY_SORT_DESCENDING = "exportPriDescending";
    public static final String EXPORT_SECONDARY_SORT_FIELD = "exportSecSort";
    public static final String EXPORT_SECONDARY_SORT_DESCENDING = "exportSecDescending";
    public static final String EXPORT_TERTIARY_SORT_FIELD = "exportTerSort";
    public static final String EXPORT_TERTIARY_SORT_DESCENDING = "exportTerDescending";
    public static final String NEWLINE = "newline";
    public static final String COLUMN_NAMES = "mainTableColumnNames";
    public static final String COLUMN_WIDTHS = "mainTableColumnWidths";
    public static final String COLUMN_SORT_TYPES = "mainTableColumnSortTypes";
    public static final String COLUMN_SORT_ORDER = "mainTableColumnSortOrder";
    public static final String SEARCH_DIALOG_COLUMN_WIDTHS = "searchTableColumnWidths";
    public static final String SEARCH_DIALOG_COLUMN_SORT_TYPES = "searchDialogColumnSortTypes";
    public static final String SEARCH_DIALOG_COLUMN_SORT_ORDER = "searchDalogColumnSortOrder";
    public static final String SIDE_PANE_COMPONENT_PREFERRED_POSITIONS = "sidePaneComponentPreferredPositions";
    public static final String SIDE_PANE_COMPONENT_NAMES = "sidePaneComponentNames";
    public static final String XMP_PRIVACY_FILTERS = "xmpPrivacyFilters";
    public static final String USE_XMP_PRIVACY_FILTER = "useXmpPrivacyFilter";
    public static final String DEFAULT_SHOW_SOURCE = "defaultShowSource";
    public static final String SIZE_Y = "mainWindowSizeY";
    public static final String SIZE_X = "mainWindowSizeX";
    public static final String POS_Y = "mainWindowPosY";
    public static final String POS_X = "mainWindowPosX";
    public static final String LAST_EDITED = "lastEdited";
    public static final String OPEN_LAST_EDITED = "openLastEdited";
    public static final String LAST_FOCUSED = "lastFocused";
    public static final String AUTO_OPEN_FORM = "autoOpenForm";
    public static final String IMPORT_WORKING_DIRECTORY = "importWorkingDirectory";
    public static final String LAST_USED_EXPORT = "lastUsedExport";
    public static final String EXPORT_WORKING_DIRECTORY = "exportWorkingDirectory";
    public static final String WORKING_DIRECTORY = "workingDirectory";
    public static final String BACKUP_DIRECTORY = "backupDirectory";
    public static final String CREATE_BACKUP = "createBackup";
    public static final String KEYWORD_SEPARATOR = "groupKeywordSeparator";
    public static final String AUTO_ASSIGN_GROUP = "autoAssignGroup";
    public static final String DISPLAY_GROUP_COUNT = "displayGroupCount";
    public static final String EXTRA_FILE_COLUMNS = "extraFileColumns";
    public static final String OVERRIDE_DEFAULT_FONT_SIZE = "overrideDefaultFontSize";
    public static final String MAIN_FONT_SIZE = "mainFontSize";
    public static final String RECENT_DATABASES = "recentDatabases";
    public static final String MEMORY_STICK_MODE = "memoryStickMode";
    public static final String SHOW_ADVANCED_HINTS = "showAdvancedHints";
    public static final String DEFAULT_ENCODING = "defaultEncoding";
    public static final String BASE_DOI_URI = "baseDOIURI";
    public static final String USE_CUSTOM_DOI_URI = "useCustomDOIURI";
    public static final String USE_OWNER = "useOwner";
    public static final String DEFAULT_OWNER = "defaultOwner";
    public static final String OVERWRITE_OWNER = "overwriteOwner";
    public static final String UPDATE_TIMESTAMP = "updateTimestamp";
    public static final String TIME_STAMP_FIELD = "timeStampField";
    public static final String TIME_STAMP_FORMAT = "timeStampFormat";
    public static final String ADD_CREATION_DATE = "addCreationDate";
    public static final String ADD_MODIFICATION_DATE = "addModificationDate";
    public static final String WARN_ABOUT_DUPLICATES_IN_INSPECTION = "warnAboutDuplicatesInInspection";
    public static final String NON_WRAPPABLE_FIELDS = "nonWrappableFields";
    public static final String RESOLVE_STRINGS_FOR_FIELDS = "resolveStringsForFields";
    public static final String DO_NOT_RESOLVE_STRINGS = "doNotResolveStrings";
    public static final String MERGE_ENTRIES_DIFF_MODE = "mergeEntriesDiffMode";
    public static final String MERGE_ENTRIES_SHOULD_SHOW_DIFF = "mergeEntriesShouldShowDiff";
    public static final String MERGE_ENTRIES_SHOULD_SHOW_UNIFIED_DIFF = "mergeEntriesShouldShowUnifiedDiff";
    public static final String MERGE_ENTRIES_HIGHLIGHT_WORDS = "mergeEntriesHighlightWords";
    public static final String MERGE_SHOW_ONLY_CHANGED_FIELDS = "mergeShowOnlyChangedFields";
    public static final String SHOW_USER_COMMENTS_FIELDS = "showUserCommentsFields";
    public static final String MERGE_APPLY_TO_ALL_ENTRIES = "mergeApplyToAllEntries";
    public static final String DUPLICATE_RESOLVER_DECISION_RESULT_ALL_ENTRIES = "duplicateResolverDecisionResult";
    public static final String CUSTOM_EXPORT_FORMAT = "customExportFormat";
    public static final String CUSTOM_IMPORT_FORMAT = "customImportFormat";
    public static final String KEY_PATTERN_REGEX = "KeyPatternRegex";
    public static final String KEY_PATTERN_REPLACEMENT = "KeyPatternReplacement";
    public static final String CONSOLE_COMMAND = "consoleCommand";
    public static final String USE_DEFAULT_CONSOLE_APPLICATION = "useDefaultConsoleApplication";
    public static final String USE_DEFAULT_FILE_BROWSER_APPLICATION = "userDefaultFileBrowserApplication";
    public static final String FILE_BROWSER_COMMAND = "fileBrowserCommand";
    public static final String MAIN_FILE_DIRECTORY = "fileDirectory";
    public static final String SEARCH_DISPLAY_MODE = "searchDisplayMode";
    public static final String SEARCH_CASE_SENSITIVE = "caseSensitiveSearch";
    public static final String SEARCH_REG_EXP = "regExpSearch";
    public static final String SEARCH_FULLTEXT = "fulltextSearch";
    public static final String SEARCH_KEEP_SEARCH_STRING = "keepSearchString";
    public static final String SEARCH_KEEP_GLOBAL_WINDOW_ON_TOP = "keepOnTop";
    public static final String SEARCH_WINDOW_HEIGHT = "searchWindowHeight";
    public static final String SEARCH_WINDOW_WIDTH = "searchWindowWidth";
    public static final String SEARCH_CATALOGS = "searchCatalogs";
    public static final String IMPORTERS_ENABLED = "importersEnabled";
    public static final String GENERATE_KEY_ON_IMPORT = "generateKeyOnImport";
    public static final String GROBID_ENABLED = "grobidEnabled";
    public static final String GROBID_OPT_OUT = "grobidOptOut";
    public static final String GROBID_URL = "grobidURL";
    public static final String JOURNAL_POPUP = "journalPopup";
    public static final String DEFAULT_CITATION_KEY_PATTERN = "defaultBibtexKeyPattern";
    public static final String UNWANTED_CITATION_KEY_CHARACTERS = "defaultUnwantedBibtexKeyCharacters";
    public static final String CONFIRM_DELETE = "confirmDelete";
    public static final String CONFIRM_LINKED_FILE_DELETE = "confirmLinkedFileDelete";
    public static final String TRASH_INSTEAD_OF_DELETE = "trashInsteadOfDelete";
    public static final String WARN_BEFORE_OVERWRITING_KEY = "warnBeforeOverwritingKey";
    public static final String AVOID_OVERWRITING_KEY = "avoidOverwritingKey";
    public static final String AUTOLINK_EXACT_KEY_ONLY = "autolinkExactKeyOnly";
    public static final String AUTOLINK_FILES_ENABLED = "autoLinkFilesEnabled";
    public static final String SIDE_PANE_WIDTH = "sidePaneWidthFX";
    public static final String CITE_COMMAND = "citeCommand";
    public static final String GENERATE_KEYS_BEFORE_SAVING = "generateKeysBeforeSaving";
    public static final String EMAIL_SUBJECT = "emailSubject";
    public static final String KINDLE_EMAIL = "kindleEmail";
    public static final String OPEN_FOLDERS_OF_ATTACHED_FILES = "openFoldersOfAttachedFiles";
    public static final String KEY_GEN_ALWAYS_ADD_LETTER = "keyGenAlwaysAddLetter";
    public static final String KEY_GEN_FIRST_LETTER_A = "keyGenFirstLetterA";
    public static final String ALLOW_INTEGER_EDITION_BIBTEX = "allowIntegerEditionBibtex";
    public static final String LOCAL_AUTO_SAVE = "localAutoSave";
    public static final String AUTOLINK_REG_EXP_SEARCH_EXPRESSION_KEY = "regExpSearchExpression";
    public static final String AUTOLINK_USE_REG_EXP_SEARCH_KEY = "useRegExpSearch";
    public static final String STORE_RELATIVE_TO_BIB = "bibLocAsPrimaryDir";
    public static final String SELECTED_FETCHER_INDEX = "selectedFetcherIndex";
    public static final String WEB_SEARCH_VISIBLE = "webSearchVisible";
    public static final String GROUP_SIDEPANE_VISIBLE = "groupSidepaneVisible";
    public static final String CUSTOM_TAB_NAME = "customTabName_";
    public static final String CUSTOM_TAB_FIELDS = "customTabFields_";
    public static final String ASK_AUTO_NAMING_PDFS_AGAIN = "AskAutoNamingPDFsAgain";
    public static final String CLEANUP_JOBS = "CleanUpJobs";
    public static final String CLEANUP_FIELD_FORMATTERS_ENABLED = "CleanUpFormattersEnabled";
    public static final String CLEANUP_FIELD_FORMATTERS = "CleanUpFormatters";
    public static final String IMPORT_FILENAMEPATTERN = "importFileNamePattern";
    public static final String IMPORT_FILEDIRPATTERN = "importFileDirPattern";
    public static final String NAME_FORMATTER_VALUE = "nameFormatterFormats";
    public static final String NAME_FORMATER_KEY = "nameFormatterNames";
    public static final String PUSH_TO_APPLICATION = "pushToApplication";
    public static final String SHOW_RECOMMENDATIONS = "showRecommendations";
    public static final String ACCEPT_RECOMMENDATIONS = "acceptRecommendations";
    public static final String SHOW_LATEX_CITATIONS = "showLatexCitations";
    public static final String SEND_LANGUAGE_DATA = "sendLanguageData";
    public static final String SEND_OS_DATA = "sendOSData";
    public static final String SEND_TIMEZONE_DATA = "sendTimezoneData";
    public static final String VALIDATE_IN_ENTRY_EDITOR = "validateInEntryEditor";
    public static final String SHOW_SCITE_TAB = "showSciteTab";
    public static final String OO_EXECUTABLE_PATH = "ooExecutablePath";
    public static final String OO_SHOW_PANEL = "showOOPanel";
    public static final String OO_SYNC_WHEN_CITING = "syncOOWhenCiting";
    public static final String OO_USE_ALL_OPEN_BASES = "useAllOpenBases";
    public static final String OO_BIBLIOGRAPHY_STYLE_FILE = "ooBibliographyStyleFile";
    public static final String OO_EXTERNAL_STYLE_FILES = "ooExternalStyleFiles";
    public static final String SPECIALFIELDSENABLED = "specialFieldsEnabled";
    public static final String CITATION_KEY_PATTERNS_NODE = "bibtexkeypatterns";
    public static final String CUSTOMIZED_BIBTEX_TYPES = "customizedBibtexTypes";
    public static final String CUSTOMIZED_BIBLATEX_TYPES = "customizedBiblatexTypes";
    public static final String VERSION_IGNORED_UPDATE = "versionIgnoreUpdate";
    public static final String VERSION_CHECK_ENABLED = "versionCheck";
    public static final String BINDINGS = "bindings";
    public static final String AUTOCOMPLETER_COMPLETE_FIELDS = "autoCompleteFields";
    public static final String ID_ENTRY_GENERATOR = "idEntryGenerator";
    public static final Character STRINGLIST_DELIMITER = Character.valueOf(';');
    public static final String PREVIEW_STYLE = "previewStyle";
    public static final String CYCLE_PREVIEW_POS = "cyclePreviewPos";
    public static final String CYCLE_PREVIEW = "cyclePreview";
    public static final String PREVIEW_AS_TAB = "previewAsTab";
    public static final String PREVIEW_IN_ENTRY_TABLE_TOOLTIP = "previewInEntryTableTooltip";
    public static final String PREVIEW_BST_LAYOUT_PATHS = "previewBstLayoutPaths";
    private static final String FONT_FAMILY = "fontFamily";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_HOSTNAME = "proxyHostname";
    private static final String PROXY_USE = "useProxy";
    private static final String PROXY_USE_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_USERNAME = "proxyUsername";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final String PROXY_PERSIST_PASSWORD = "persistPassword";
    private static final String FETCHER_CUSTOM_KEY_NAMES = "fetcherCustomKeyNames";
    private static final String FETCHER_CUSTOM_KEY_USES = "fetcherCustomKeyUses";
    private static final String FETCHER_CUSTOM_KEY_PERSIST = "fetcherCustomKeyPersist";
    private static final String TRUSTSTORE_PATH = "truststorePath";
    private static final String AUTO_COMPLETE = "autoComplete";
    private static final String AUTOCOMPLETER_FIRSTNAME_MODE = "autoCompFirstNameMode";
    private static final String AUTOCOMPLETER_LAST_FIRST = "autoCompLF";
    private static final String AUTOCOMPLETER_FIRST_LAST = "autoCompFF";
    private static final String BIND_NAMES = "bindNames";
    private static final String USER_ID = "userId";
    private static final String EXTERNAL_JOURNAL_LISTS = "externalJournalLists";
    private static final String USE_AMS_FJOURNAL = "useAMSFJournal";
    private static final String PROTECTED_TERMS_ENABLED_EXTERNAL = "protectedTermsEnabledExternal";
    private static final String PROTECTED_TERMS_DISABLED_EXTERNAL = "protectedTermsDisabledExternal";
    private static final String PROTECTED_TERMS_ENABLED_INTERNAL = "protectedTermsEnabledInternal";
    private static final String PROTECTED_TERMS_DISABLED_INTERNAL = "protectedTermsDisabledInternal";
    private static final String GROUP_INTERSECT_UNION_VIEW_MODE = "groupIntersectUnionViewModes";
    private static final String DEFAULT_HIERARCHICAL_CONTEXT = "defaultHierarchicalContext";
    private static final String PREFS_EXPORT_PATH = "prefsExportPath";
    private static final String DOWNLOAD_LINKED_FILES = "downloadLinkedFiles";
    private static final String FULLTEXT_INDEX_LINKED_FILES = "fulltextIndexLinkedFiles";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final int EXPORTER_NAME_INDEX = 0;
    private static final int EXPORTER_FILENAME_INDEX = 1;
    private static final int EXPORTER_EXTENSION_INDEX = 2;
    private static final String USE_REMOTE_SERVER = "useRemoteServer";
    private static final String REMOTE_SERVER_PORT = "remoteServerPort";
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefPreferences.class);
    private static final Preferences PREFS_NODE = Preferences.userRoot().node("/org/jabref");
    private static JabRefPreferences singleton;
    public final Map<String, Object> defaults = new HashMap<String, Object>();
    private final Preferences prefs;
    private String userAndHost;
    private LibraryPreferences libraryPreferences;
    private DOIPreferences doiPreferences;
    private OwnerPreferences ownerPreferences;
    private TimestampPreferences timestampPreferences;
    private PreviewPreferences previewPreferences;
    private OpenOfficePreferences openOfficePreferences;
    private SidePanePreferences sidePanePreferences;
    private WorkspacePreferences workspacePreferences;
    private ImporterPreferences importerPreferences;
    private GrobidPreferences grobidPreferences;
    private ProtectedTermsPreferences protectedTermsPreferences;
    private MrDlibPreferences mrDlibPreferences;
    private EntryEditorPreferences entryEditorPreferences;
    private FilePreferences filePreferences;
    private GuiPreferences guiPreferences;
    private RemotePreferences remotePreferences;
    private ProxyPreferences proxyPreferences;
    private SSLPreferences sslPreferences;
    private SearchPreferences searchPreferences;
    private AutoLinkPreferences autoLinkPreferences;
    private ExportPreferences exportPreferences;
    private NameFormatterPreferences nameFormatterPreferences;
    private BibEntryPreferences bibEntryPreferences;
    private InternalPreferences internalPreferences;
    private SpecialFieldsPreferences specialFieldsPreferences;
    private GroupsPreferences groupsPreferences;
    private XmpPreferences xmpPreferences;
    private AutoCompletePreferences autoCompletePreferences;
    private CleanupPreferences cleanupPreferences;
    private PushToApplicationPreferences pushToApplicationPreferences;
    private ExternalApplicationsPreferences externalApplicationsPreferences;
    private CitationKeyPatternPreferences citationKeyPatternPreferences;
    private NameDisplayPreferences nameDisplayPreferences;
    private MainTablePreferences mainTablePreferences;
    private ColumnPreferences mainTableColumnPreferences;
    private ColumnPreferences searchDialogColumnPreferences;
    private JournalAbbreviationPreferences journalAbbreviationPreferences;
    private FieldPreferences fieldPreferences;
    private MergeDialogPreferences mergeDialogPreferences;
    private KeyBindingRepository keyBindingRepository;

    private JabRefPreferences() {
        try {
            if (new File("jabref.xml").exists()) {
                this.importPreferences(Path.of("jabref.xml", new String[0]));
            }
        }
        catch (JabRefException e) {
            LOGGER.warn("Could not import preferences from jabref.xml: {}", (Object)e.getMessage(), (Object)e);
        }
        this.prefs = PREFS_NODE;
        Localization.setLanguage(this.getLanguage());
        this.defaults.put(SEARCH_DISPLAY_MODE, SearchDisplayMode.FILTER.toString());
        this.defaults.put(SEARCH_CASE_SENSITIVE, Boolean.FALSE);
        this.defaults.put(SEARCH_REG_EXP, Boolean.FALSE);
        this.defaults.put(SEARCH_FULLTEXT, Boolean.FALSE);
        this.defaults.put(SEARCH_KEEP_SEARCH_STRING, Boolean.FALSE);
        this.defaults.put(SEARCH_KEEP_GLOBAL_WINDOW_ON_TOP, Boolean.TRUE);
        this.defaults.put(SEARCH_WINDOW_HEIGHT, 176.0);
        this.defaults.put(SEARCH_WINDOW_WIDTH, 600.0);
        this.defaults.put(SEARCH_CATALOGS, JabRefPreferences.convertListToString(List.of("ACM Portal", "Springer", "DBLP", "IEEEXplore")));
        this.defaults.put(IMPORTERS_ENABLED, Boolean.TRUE);
        this.defaults.put(GENERATE_KEY_ON_IMPORT, Boolean.TRUE);
        this.defaults.put(GROBID_ENABLED, Boolean.FALSE);
        this.defaults.put(GROBID_OPT_OUT, Boolean.FALSE);
        this.defaults.put(GROBID_URL, "http://grobid.jabref.org:8070");
        this.defaults.put(JOURNAL_POPUP, EntryEditorPreferences.JournalPopupEnabled.FIRST_START.toString());
        this.defaults.put(PUSH_TEXMAKER_PATH, OS.getNativeDesktop().detectProgramPath("texmaker", "Texmaker"));
        this.defaults.put(PUSH_WINEDT_PATH, OS.getNativeDesktop().detectProgramPath("WinEdt", "WinEdt Team\\WinEdt"));
        this.defaults.put(PUSH_TEXSTUDIO_PATH, OS.getNativeDesktop().detectProgramPath("texstudio", "TeXstudio"));
        this.defaults.put(PUSH_TEXWORKS_PATH, OS.getNativeDesktop().detectProgramPath("texworks", "TeXworks"));
        this.defaults.put(PUSH_SUBLIME_TEXT_PATH, OS.getNativeDesktop().detectProgramPath("subl", "Sublime"));
        this.defaults.put(PUSH_LYXPIPE, USER_HOME + File.separator + ".lyx/lyxpipe");
        this.defaults.put(PUSH_VIM, PUSH_VIM);
        this.defaults.put(PUSH_VIM_SERVER, PUSH_VIM);
        this.defaults.put(PUSH_EMACS_ADDITIONAL_PARAMETERS, "-n -e");
        this.defaults.put(BIBLATEX_DEFAULT_MODE, Boolean.FALSE);
        this.defaults.put(ID_ENTRY_GENERATOR, "DOI");
        this.defaults.put(USE_CUSTOM_DOI_URI, Boolean.FALSE);
        this.defaults.put(BASE_DOI_URI, "https://doi.org");
        if (OS.OS_X) {
            this.defaults.put(FONT_FAMILY, "SansSerif");
            this.defaults.put(PUSH_EMACS_PATH, "emacsclient");
        } else if (OS.WINDOWS) {
            this.defaults.put(PUSH_EMACS_PATH, "emacsclient.exe");
        } else {
            this.defaults.put(FONT_FAMILY, "SansSerif");
            this.defaults.put(PUSH_EMACS_PATH, "emacsclient");
        }
        this.defaults.put(PUSH_TO_APPLICATION, "TeXstudio");
        this.defaults.put(RECENT_DATABASES, "");
        this.defaults.put(EXTERNAL_FILE_TYPES, "");
        this.defaults.put(KEY_PATTERN_REGEX, "");
        this.defaults.put(KEY_PATTERN_REPLACEMENT, "");
        this.defaults.put(PROXY_USE, Boolean.FALSE);
        this.defaults.put(PROXY_HOSTNAME, "");
        this.defaults.put(PROXY_PORT, "80");
        this.defaults.put(PROXY_USE_AUTHENTICATION, Boolean.FALSE);
        this.defaults.put(PROXY_USERNAME, "");
        this.defaults.put(PROXY_PASSWORD, "");
        this.defaults.put(PROXY_PERSIST_PASSWORD, Boolean.FALSE);
        this.defaults.put(TRUSTSTORE_PATH, OS.getNativeDesktop().getSslDirectory().resolve("truststore.jks").toString());
        this.defaults.put(POS_X, 0);
        this.defaults.put(POS_Y, 0);
        this.defaults.put(SIZE_X, 1024);
        this.defaults.put(SIZE_Y, 768);
        this.defaults.put(WINDOW_MAXIMISED, Boolean.TRUE);
        this.defaults.put(WINDOW_FULLSCREEN, Boolean.FALSE);
        this.defaults.put(AUTO_RESIZE_MODE, Boolean.FALSE);
        this.defaults.put(ENTRY_EDITOR_HEIGHT, 0.65);
        this.defaults.put(ENTRY_EDITOR_PREVIEW_DIVIDER_POS, 0.5);
        this.defaults.put(NAMES_AS_IS, Boolean.FALSE);
        this.defaults.put(NAMES_FIRST_LAST, Boolean.FALSE);
        this.defaults.put(NAMES_NATBIB, Boolean.TRUE);
        this.defaults.put(ABBR_AUTHOR_NAMES, Boolean.TRUE);
        this.defaults.put(NAMES_LAST_ONLY, Boolean.TRUE);
        this.defaults.put(LANGUAGE, Locale.getDefault().getLanguage());
        this.defaults.put(REFORMAT_FILE_ON_SAVE_AND_EXPORT, Boolean.FALSE);
        this.defaults.put(EXPORT_IN_ORIGINAL_ORDER, Boolean.TRUE);
        this.defaults.put(EXPORT_IN_SPECIFIED_ORDER, Boolean.FALSE);
        this.defaults.put(EXPORT_PRIMARY_SORT_FIELD, InternalField.KEY_FIELD.getName());
        this.defaults.put(EXPORT_PRIMARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(EXPORT_SECONDARY_SORT_FIELD, StandardField.AUTHOR.getName());
        this.defaults.put(EXPORT_SECONDARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(EXPORT_TERTIARY_SORT_FIELD, StandardField.TITLE.getName());
        this.defaults.put(EXPORT_TERTIARY_SORT_DESCENDING, Boolean.FALSE);
        this.defaults.put(NEWLINE, System.lineSeparator());
        this.defaults.put(SIDE_PANE_COMPONENT_NAMES, "");
        this.defaults.put(SIDE_PANE_COMPONENT_PREFERRED_POSITIONS, "");
        this.defaults.put(COLUMN_NAMES, "groups;group_icons;files;linked_id;field:entrytype;field:author/editor;field:title;field:year;field:journal/booktitle;special:ranking;special:readstatus;special:priority");
        this.defaults.put(COLUMN_WIDTHS, "28;40;28;28;75;300;470;60;130;50;50;50");
        this.defaults.put(XMP_PRIVACY_FILTERS, "pdf;timestamp;keywords;owner;note;review");
        this.defaults.put(USE_XMP_PRIVACY_FILTER, Boolean.FALSE);
        this.defaults.put(WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(EXPORT_WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(CREATE_BACKUP, Boolean.TRUE);
        this.defaults.put(IMPORT_WORKING_DIRECTORY, USER_HOME);
        this.defaults.put(PREFS_EXPORT_PATH, USER_HOME);
        this.defaults.put(AUTO_OPEN_FORM, Boolean.TRUE);
        this.defaults.put(OPEN_LAST_EDITED, Boolean.TRUE);
        this.defaults.put(LAST_EDITED, "");
        this.defaults.put(LAST_FOCUSED, "");
        this.defaults.put(DEFAULT_SHOW_SOURCE, Boolean.FALSE);
        this.defaults.put(MERGE_ENTRIES_DIFF_MODE, DiffMode.WORD.name());
        this.defaults.put(MERGE_ENTRIES_SHOULD_SHOW_DIFF, Boolean.TRUE);
        this.defaults.put(MERGE_ENTRIES_SHOULD_SHOW_UNIFIED_DIFF, Boolean.TRUE);
        this.defaults.put(MERGE_ENTRIES_HIGHLIGHT_WORDS, Boolean.TRUE);
        this.defaults.put(MERGE_SHOW_ONLY_CHANGED_FIELDS, Boolean.FALSE);
        this.defaults.put(MERGE_APPLY_TO_ALL_ENTRIES, Boolean.FALSE);
        this.defaults.put(DUPLICATE_RESOLVER_DECISION_RESULT_ALL_ENTRIES, DuplicateResolverDialog.DuplicateResolverResult.BREAK.name());
        this.defaults.put(SHOW_USER_COMMENTS_FIELDS, Boolean.TRUE);
        this.defaults.put(SHOW_RECOMMENDATIONS, Boolean.TRUE);
        this.defaults.put(ACCEPT_RECOMMENDATIONS, Boolean.FALSE);
        this.defaults.put(SHOW_LATEX_CITATIONS, Boolean.TRUE);
        this.defaults.put(SHOW_SCITE_TAB, Boolean.TRUE);
        this.defaults.put(SEND_LANGUAGE_DATA, Boolean.FALSE);
        this.defaults.put(SEND_OS_DATA, Boolean.FALSE);
        this.defaults.put(SEND_TIMEZONE_DATA, Boolean.FALSE);
        this.defaults.put(VALIDATE_IN_ENTRY_EDITOR, Boolean.TRUE);
        this.defaults.put(AUTO_COMPLETE, Boolean.FALSE);
        this.defaults.put(AUTOCOMPLETER_FIRSTNAME_MODE, AutoCompleteFirstNameMode.BOTH.name());
        this.defaults.put(AUTOCOMPLETER_FIRST_LAST, Boolean.FALSE);
        this.defaults.put(AUTOCOMPLETER_LAST_FIRST, Boolean.FALSE);
        this.defaults.put(AUTOCOMPLETER_COMPLETE_FIELDS, "author;editor;title;journal;publisher;keywords;crossref;related;entryset");
        this.defaults.put(AUTO_ASSIGN_GROUP, Boolean.TRUE);
        this.defaults.put(DISPLAY_GROUP_COUNT, Boolean.TRUE);
        this.defaults.put(GROUP_INTERSECT_UNION_VIEW_MODE, GroupViewMode.INTERSECTION.name());
        this.defaults.put(DEFAULT_HIERARCHICAL_CONTEXT, GroupHierarchyType.INDEPENDENT.name());
        this.defaults.put(KEYWORD_SEPARATOR, ", ");
        this.defaults.put(DEFAULT_ENCODING, StandardCharsets.UTF_8.name());
        this.defaults.put(DEFAULT_OWNER, System.getProperty("user.name"));
        this.defaults.put(MEMORY_STICK_MODE, Boolean.FALSE);
        this.defaults.put(SHOW_ADVANCED_HINTS, Boolean.TRUE);
        this.defaults.put(EXTRA_FILE_COLUMNS, Boolean.FALSE);
        this.defaults.put(PROTECTED_TERMS_ENABLED_INTERNAL, JabRefPreferences.convertListToString(ProtectedTermsLoader.getInternalLists()));
        this.defaults.put(PROTECTED_TERMS_DISABLED_INTERNAL, "");
        this.defaults.put(PROTECTED_TERMS_ENABLED_EXTERNAL, "");
        this.defaults.put(PROTECTED_TERMS_DISABLED_EXTERNAL, "");
        if (OS.WINDOWS) {
            this.defaults.put(OO_EXECUTABLE_PATH, "C:\\Program Files\\LibreOffice\\program");
        } else if (OS.OS_X) {
            this.defaults.put(OO_EXECUTABLE_PATH, "/Applications/LibreOffice.app/Contents/MacOS/soffice");
        } else {
            this.defaults.put(OO_EXECUTABLE_PATH, "/usr/lib/libreoffice/program/soffice");
        }
        this.defaults.put(OO_SYNC_WHEN_CITING, Boolean.TRUE);
        this.defaults.put(OO_SHOW_PANEL, Boolean.FALSE);
        this.defaults.put(OO_USE_ALL_OPEN_BASES, Boolean.TRUE);
        this.defaults.put(OO_BIBLIOGRAPHY_STYLE_FILE, "/resource/openoffice/default_authoryear.jstyle");
        this.defaults.put(OO_EXTERNAL_STYLE_FILES, "");
        this.defaults.put(SPECIALFIELDSENABLED, Boolean.TRUE);
        this.defaults.put(FETCHER_CUSTOM_KEY_NAMES, "Springer;IEEEXplore;SAO/NASA ADS;ScienceDirect;Biodiversity Heritage");
        this.defaults.put(FETCHER_CUSTOM_KEY_USES, "FALSE;FALSE;FALSE;FALSE;FALSE");
        this.defaults.put(FETCHER_CUSTOM_KEY_PERSIST, Boolean.FALSE);
        this.defaults.put(USE_OWNER, Boolean.FALSE);
        this.defaults.put(OVERWRITE_OWNER, Boolean.FALSE);
        this.defaults.put(AVOID_OVERWRITING_KEY, Boolean.FALSE);
        this.defaults.put(WARN_BEFORE_OVERWRITING_KEY, Boolean.TRUE);
        this.defaults.put(CONFIRM_DELETE, Boolean.TRUE);
        this.defaults.put(CONFIRM_LINKED_FILE_DELETE, Boolean.TRUE);
        this.defaults.put(DEFAULT_CITATION_KEY_PATTERN, "[auth][year]");
        this.defaults.put(UNWANTED_CITATION_KEY_CHARACTERS, "-`\u02b9:!;?^");
        this.defaults.put(RESOLVE_STRINGS_FOR_FIELDS, "author;booktitle;editor;editora;editorb;editorc;institution;issuetitle;journal;journalsubtitle;journaltitle;mainsubtitle;month;publisher;shortauthor;shorteditor;subtitle;titleaddon");
        this.defaults.put(DO_NOT_RESOLVE_STRINGS, Boolean.FALSE);
        this.defaults.put(NON_WRAPPABLE_FIELDS, "pdf;ps;url;doi;file;isbn;issn");
        this.defaults.put(WARN_ABOUT_DUPLICATES_IN_INSPECTION, Boolean.TRUE);
        this.defaults.put(ADD_CREATION_DATE, Boolean.FALSE);
        this.defaults.put(ADD_MODIFICATION_DATE, Boolean.FALSE);
        this.defaults.put(UPDATE_TIMESTAMP, Boolean.FALSE);
        this.defaults.put(TIME_STAMP_FIELD, StandardField.TIMESTAMP.getName());
        this.defaults.put(TIME_STAMP_FORMAT, "yyyy-MM-dd");
        this.defaults.put(GENERATE_KEYS_BEFORE_SAVING, Boolean.FALSE);
        this.defaults.put(USE_REMOTE_SERVER, Boolean.TRUE);
        this.defaults.put(REMOTE_SERVER_PORT, 6050);
        this.defaults.put(EXTERNAL_JOURNAL_LISTS, "");
        this.defaults.put(USE_AMS_FJOURNAL, true);
        this.defaults.put(CITE_COMMAND, "\\cite{key1,key2}");
        this.defaults.put(LAST_USED_EXPORT, "");
        this.defaults.put(SIDE_PANE_WIDTH, 0.15);
        this.defaults.put(MAIN_FONT_SIZE, 9);
        this.defaults.put(OVERRIDE_DEFAULT_FONT_SIZE, false);
        this.defaults.put(AUTOLINK_EXACT_KEY_ONLY, Boolean.FALSE);
        this.defaults.put(AUTOLINK_FILES_ENABLED, Boolean.TRUE);
        this.defaults.put(LOCAL_AUTO_SAVE, Boolean.FALSE);
        this.defaults.put(ALLOW_INTEGER_EDITION_BIBTEX, Boolean.FALSE);
        this.defaults.put(KEY_GEN_FIRST_LETTER_A, Boolean.TRUE);
        this.defaults.put(KEY_GEN_ALWAYS_ADD_LETTER, Boolean.FALSE);
        this.defaults.put(EMAIL_SUBJECT, Localization.lang("References", new Object[0]));
        this.defaults.put(KINDLE_EMAIL, "");
        if (OS.WINDOWS) {
            this.defaults.put(OPEN_FOLDERS_OF_ATTACHED_FILES, Boolean.TRUE);
        } else {
            this.defaults.put(OPEN_FOLDERS_OF_ATTACHED_FILES, Boolean.FALSE);
        }
        this.defaults.put(WEB_SEARCH_VISIBLE, Boolean.TRUE);
        this.defaults.put(GROUP_SIDEPANE_VISIBLE, Boolean.TRUE);
        this.defaults.put(SELECTED_FETCHER_INDEX, 0);
        this.defaults.put(STORE_RELATIVE_TO_BIB, Boolean.TRUE);
        this.defaults.put(ASK_AUTO_NAMING_PDFS_AGAIN, Boolean.TRUE);
        this.defaults.put(CLEANUP_JOBS, JabRefPreferences.convertListToString(JabRefPreferences.getDefaultCleanupJobs().stream().map(Enum::name).toList()));
        this.defaults.put(CLEANUP_FIELD_FORMATTERS_ENABLED, Boolean.FALSE);
        this.defaults.put(CLEANUP_FIELD_FORMATTERS, FieldFormatterCleanups.getMetaDataString(FieldFormatterCleanups.DEFAULT_SAVE_ACTIONS, OS.NEWLINE));
        this.defaults.put(IMPORT_FILENAMEPATTERN, FilePreferences.DEFAULT_FILENAME_PATTERNS[1]);
        this.defaults.put(IMPORT_FILEDIRPATTERN, "");
        this.defaults.put(DOWNLOAD_LINKED_FILES, true);
        this.defaults.put(FULLTEXT_INDEX_LINKED_FILES, true);
        String defaultExpression = "**/.*[citationkey].*\\\\.[extension]";
        this.defaults.put(AUTOLINK_REG_EXP_SEARCH_EXPRESSION_KEY, defaultExpression);
        this.defaults.put(AUTOLINK_USE_REG_EXP_SEARCH_KEY, Boolean.FALSE);
        this.defaults.put(USE_DEFAULT_CONSOLE_APPLICATION, Boolean.TRUE);
        this.defaults.put(USE_DEFAULT_FILE_BROWSER_APPLICATION, Boolean.TRUE);
        if (OS.WINDOWS) {
            this.defaults.put(CONSOLE_COMMAND, "C:\\Program Files\\ConEmu\\ConEmu64.exe /single /dir \"%DIR\"");
            this.defaults.put(FILE_BROWSER_COMMAND, "explorer.exe /select, \"%DIR\"");
        } else {
            this.defaults.put(CONSOLE_COMMAND, "");
            this.defaults.put(FILE_BROWSER_COMMAND, "");
        }
        this.defaults.put(VERSION_IGNORED_UPDATE, "");
        this.defaults.put(VERSION_CHECK_ENABLED, Boolean.TRUE);
        this.defaults.put(CYCLE_PREVIEW, "Preview;/ieee.csl");
        this.defaults.put(CYCLE_PREVIEW_POS, 0);
        this.defaults.put(PREVIEW_AS_TAB, Boolean.FALSE);
        this.defaults.put(PREVIEW_IN_ENTRY_TABLE_TOOLTIP, Boolean.FALSE);
        this.defaults.put(PREVIEW_STYLE, "<font face=\"sans-serif\"><b>\\bibtextype</b><a name=\"\\citationkey\">\\begin{citationkey} (\\citationkey)</a>\\end{citationkey}__NEWLINE__\\begin{author}<BR><BR>\\format[Authors(LastFirst, FullName,Sep= / ,LastSep= / ),HTMLChars]{\\author}\\end{author}__NEWLINE__\\begin{editor & !author}<BR><BR>\\format[Authors(LastFirst,FullName,Sep= / ,LastSep= / ),HTMLChars]{\\editor} (\\format[IfPlural(Eds.,Ed.)]{\\editor})\\end{editor & !author}__NEWLINE__\\begin{title}<BR><b>\\format[HTMLChars]{\\title}</b> \\end{title}__NEWLINE__<BR>\\begin{date}\\date\\end{date}\\begin{edition}, \\edition. edition\\end{edition}__NEWLINE__\\begin{editor & author}<BR><BR>\\format[Authors(LastFirst,FullName,Sep= / ,LastSep= / ),HTMLChars]{\\editor} (\\format[IfPlural(Eds.,Ed.)]{\\editor})\\end{editor & author}__NEWLINE__\\begin{booktitle}<BR><i>\\format[HTMLChars]{\\booktitle}</i>\\end{booktitle}__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}\\begin{editor & !author}<BR>\\end{editor & !author}\\begin{!editor}<BR>\\end{!editor}\\begin{journal}<BR><i>\\format[HTMLChars]{\\journal}</i> \\end{journal} \\begin{volume}, Vol. \\volume\\end{volume}\\begin{series}<BR>\\format[HTMLChars]{\\series}\\end{series}\\begin{number}, No. \\format[HTMLChars]{\\number}\\end{number}__NEWLINE__\\begin{school} \\format[HTMLChars]{\\school}, \\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher}<BR>\\format[HTMLChars]{\\publisher}\\end{publisher}\\begin{location}: \\format[HTMLChars]{\\location} \\end{location}__NEWLINE__\\begin{pages}<BR> p. \\format[FormatPagesForHTML]{\\pages}\\end{pages}__NEWLINE__\\begin{abstract}<BR><BR><b>Abstract: </b>\\format[HTMLChars]{\\abstract} \\end{abstract}__NEWLINE__\\begin{owncitation}<BR><BR><b>Own citation: </b>\\format[HTMLChars]{\\owncitation} \\end{owncitation}__NEWLINE__\\begin{comment}<BR><BR><b>Comment: </b>\\format[Markdown,HTMLChars(keepCurlyBraces)]{\\comment}\\end{comment}__NEWLINE__</font>__NEWLINE__");
        this.defaults.put(THEME, "Base.css");
        this.defaults.put(THEME_SYNC_OS, Boolean.FALSE);
        this.setLanguageDependentDefaultValues();
    }

    public void setLanguageDependentDefaultValues() {
        this.defaults.put("customTabName__def0", Localization.lang("General", new Object[0]));
        String fieldNames = FieldFactory.getDefaultGeneralFields().stream().map(Field::getName).collect(Collectors.joining(STRINGLIST_DELIMITER.toString()));
        this.defaults.put("customTabFields__def0", fieldNames);
        this.defaults.put("customTabFields__def1", StandardField.ABSTRACT.getName());
        this.defaults.put("customTabName__def1", Localization.lang("Abstract", new Object[0]));
        this.defaults.put(EMAIL_SUBJECT, Localization.lang("References", new Object[0]));
    }

    @Deprecated
    public static JabRefPreferences getInstance() {
        if (singleton == null) {
            singleton = new JabRefPreferences();
        }
        return singleton;
    }

    @VisibleForTesting
    static String convertListToString(List<String> value) {
        return value.stream().map(val -> StringUtil.quote(val, STRINGLIST_DELIMITER.toString(), '\\')).collect(Collectors.joining(STRINGLIST_DELIMITER.toString()));
    }

    @VisibleForTesting
    static List<String> convertStringToList(String toConvert) {
        if (StringUtil.isBlank(toConvert)) {
            return Collections.emptyList();
        }
        return Splitter.on((char)STRINGLIST_DELIMITER.charValue()).splitToList((CharSequence)toConvert);
    }

    public boolean hasKey(String key) {
        return this.prefs.get(key, null) != null;
    }

    public String get(String key) {
        return this.prefs.get(key, (String)this.defaults.get(key));
    }

    public String getEmptyIsDefault(String key) {
        String defaultValue = (String)this.defaults.get(key);
        String result = this.prefs.get(key, defaultValue);
        if ("".equals(result)) {
            return defaultValue;
        }
        return result;
    }

    public Optional<String> getAsOptional(String key) {
        return Optional.ofNullable(this.prefs.get(key, (String)this.defaults.get(key)));
    }

    public String get(String key, String def) {
        return this.prefs.get(key, def);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, this.getBooleanDefault(key));
    }

    public boolean getBoolean(String key, boolean def) {
        return this.prefs.getBoolean(key, def);
    }

    private boolean getBooleanDefault(String key) {
        return (Boolean)this.defaults.get(key);
    }

    public int getInt(String key) {
        return this.prefs.getInt(key, this.getIntDefault(key));
    }

    public double getDouble(String key) {
        return this.prefs.getDouble(key, this.getDoubleDefault(key));
    }

    public int getIntDefault(String key) {
        return (Integer)this.defaults.get(key);
    }

    private double getDoubleDefault(String key) {
        return ((Number)this.defaults.get(key)).doubleValue();
    }

    public void put(String key, String value) {
        this.prefs.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.prefs.putBoolean(key, value);
    }

    public void putInt(String key, int value) {
        this.prefs.putInt(key, value);
    }

    public void putInt(String key, Number value) {
        this.prefs.putInt(key, value.intValue());
    }

    public void putDouble(String key, double value) {
        this.prefs.putDouble(key, value);
    }

    private void remove(String key) {
        this.prefs.remove(key);
    }

    public void putStringList(String key, List<String> value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        this.put(key, JabRefPreferences.convertListToString(value));
    }

    public List<String> getStringList(String key) {
        return JabRefPreferences.convertStringToList(this.get(key));
    }

    private Path getPath(String key, Path defaultValue) {
        String rawPath = this.get(key);
        return StringUtil.isNotBlank(rawPath) ? Path.of(rawPath, new String[0]) : defaultValue;
    }

    @Override
    public void clear() throws BackingStoreException {
        this.clearAllBibEntryTypes();
        this.clearCitationKeyPatterns();
        this.clearTruststoreFromCustomCertificates();
        this.clearCustomFetcherKeys();
        this.prefs.clear();
        new SharedDatabasePreferences().clear();
    }

    private void clearTruststoreFromCustomCertificates() {
        TrustStoreManager trustStoreManager = new TrustStoreManager(Path.of(this.defaults.get(TRUSTSTORE_PATH).toString(), new String[0]));
        trustStoreManager.clearCustomCertificates();
    }

    @Override
    public void deleteKey(String key) throws IllegalArgumentException {
        String keyTrimmed = key.trim();
        if (!this.hasKey(keyTrimmed)) {
            throw new IllegalArgumentException("Unknown preference key");
        }
        this.remove(keyTrimmed);
    }

    @Override
    public void flush() {
        if (this.getBoolean(MEMORY_STICK_MODE)) {
            try {
                this.exportPreferences(Path.of("jabref.xml", new String[0]));
            }
            catch (JabRefException e) {
                LOGGER.warn("Could not export preferences for memory stick mode: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOGGER.warn("Cannot communicate with backing store", (Throwable)ex);
        }
    }

    @Override
    public Map<String, Object> getPreferences() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.addPrefsRecursively(this.prefs, result);
        }
        catch (BackingStoreException e) {
            LOGGER.info("could not retrieve preference keys", (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Object> getDefaults() {
        return this.defaults;
    }

    private void addPrefsRecursively(Preferences prefs, Map<String, Object> result) throws BackingStoreException {
        for (String key : prefs.keys()) {
            result.put(key, this.getObject(prefs, key));
        }
        for (String child : prefs.childrenNames()) {
            this.addPrefsRecursively(prefs.node(child), result);
        }
    }

    private Object getObject(Preferences prefs, String key) {
        try {
            return prefs.get(key, (String)this.defaults.get(key));
        }
        catch (ClassCastException e) {
            try {
                return prefs.getBoolean(key, this.getBooleanDefault(key));
            }
            catch (ClassCastException e2) {
                try {
                    return prefs.getInt(key, this.getIntDefault(key));
                }
                catch (ClassCastException e3) {
                    return prefs.getDouble(key, this.getDoubleDefault(key));
                }
            }
        }
    }

    private List<String> getSeries(String key) {
        String item;
        int i = 0;
        ArrayList<String> series = new ArrayList<String>();
        while (!StringUtil.isBlank(item = this.get(key + i))) {
            series.add(item);
            ++i;
        }
        return series;
    }

    private void purgeSeries(String prefix, int number) {
        int n = number;
        while (this.get(prefix + n) != null) {
            this.remove(prefix + n);
            ++n;
        }
    }

    @Override
    public void exportPreferences(Path path) throws JabRefException {
        LOGGER.debug("Exporting preferences {}", (Object)path.toAbsolutePath());
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.prefs.exportSubtree(os);
        }
        catch (IOException | BackingStoreException ex) {
            throw new JabRefException("Could not export preferences", Localization.lang("Could not export preferences", new Object[0]), ex);
        }
    }

    @Override
    public void importPreferences(Path file) throws JabRefException {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            Preferences.importPreferences(is);
        }
        catch (IOException | InvalidPreferencesFormatException ex) {
            throw new JabRefException("Could not import preferences", Localization.lang("Could not import preferences", new Object[0]), ex);
        }
    }

    @Override
    public LayoutFormatterPreferences getLayoutFormatterPreferences() {
        return new LayoutFormatterPreferences(this.getNameFormatterPreferences(), this.getDOIPreferences(), this.getFilePreferences().mainFileDirectoryProperty());
    }

    @Override
    public KeyBindingRepository getKeyBindingRepository() {
        if (this.keyBindingRepository != null) {
            return this.keyBindingRepository;
        }
        this.keyBindingRepository = new KeyBindingRepository(this.getStringList(BIND_NAMES), this.getStringList(BINDINGS));
        EasyBind.listen(this.keyBindingRepository.getBindingsProperty(), (obs, oldValue, newValue) -> {
            this.putStringList(BIND_NAMES, this.keyBindingRepository.getBindNames());
            this.putStringList(BINDINGS, this.keyBindingRepository.getBindings());
        });
        return this.keyBindingRepository;
    }

    @Override
    public JournalAbbreviationPreferences getJournalAbbreviationPreferences() {
        if (this.journalAbbreviationPreferences != null) {
            return this.journalAbbreviationPreferences;
        }
        this.journalAbbreviationPreferences = new JournalAbbreviationPreferences(this.getStringList(EXTERNAL_JOURNAL_LISTS), this.getBoolean(USE_AMS_FJOURNAL));
        this.journalAbbreviationPreferences.getExternalJournalLists().addListener(change -> this.putStringList(EXTERNAL_JOURNAL_LISTS, (List<String>)this.journalAbbreviationPreferences.getExternalJournalLists()));
        EasyBind.listen((ObservableValue)this.journalAbbreviationPreferences.useFJournalFieldProperty(), (obs, oldValue, newValue) -> this.putBoolean(USE_AMS_FJOURNAL, (boolean)newValue));
        return this.journalAbbreviationPreferences;
    }

    @Override
    public BibEntryTypesManager getCustomEntryTypesRepository() {
        BibEntryTypesManager bibEntryTypesManager = new BibEntryTypesManager();
        EnumSet.allOf(BibDatabaseMode.class).forEach(mode -> bibEntryTypesManager.addCustomOrModifiedTypes(this.getBibEntryTypes((BibDatabaseMode)((Object)mode)), (BibDatabaseMode)((Object)mode)));
        return bibEntryTypesManager;
    }

    private List<BibEntryType> getBibEntryTypes(BibDatabaseMode bibDatabaseMode) {
        ArrayList<BibEntryType> storedEntryTypes = new ArrayList<BibEntryType>();
        Preferences prefsNode = JabRefPreferences.getPrefsNodeForCustomizedEntryTypes(bibDatabaseMode);
        try {
            Arrays.stream(prefsNode.keys()).map(key -> prefsNode.get((String)key, null)).filter(Objects::nonNull).forEach(typeString -> MetaDataParser.parseCustomEntryType(typeString).ifPresent(storedEntryTypes::add));
        }
        catch (BackingStoreException e) {
            LOGGER.info("Parsing customized entry types failed.", (Throwable)e);
        }
        return storedEntryTypes;
    }

    private void clearAllBibEntryTypes() {
        for (BibDatabaseMode mode : BibDatabaseMode.values()) {
            this.clearBibEntryTypes(mode);
        }
    }

    private void clearBibEntryTypes(BibDatabaseMode mode) {
        try {
            Preferences prefsNode = JabRefPreferences.getPrefsNodeForCustomizedEntryTypes(mode);
            prefsNode.clear();
            prefsNode.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.error("Resetting customized entry types failed.", (Throwable)e);
        }
    }

    @Override
    public void storeCustomEntryTypesRepository(BibEntryTypesManager entryTypesManager) {
        this.clearAllBibEntryTypes();
        this.storeBibEntryTypes(entryTypesManager.getAllCustomizedTypes(BibDatabaseMode.BIBTEX), BibDatabaseMode.BIBTEX);
        this.storeBibEntryTypes(entryTypesManager.getAllCustomizedTypes(BibDatabaseMode.BIBLATEX), BibDatabaseMode.BIBLATEX);
    }

    private void storeBibEntryTypes(Collection<BibEntryType> bibEntryTypes, BibDatabaseMode bibDatabaseMode) {
        Preferences prefsNode = JabRefPreferences.getPrefsNodeForCustomizedEntryTypes(bibDatabaseMode);
        try {
            this.clearBibEntryTypes(bibDatabaseMode);
            bibEntryTypes.forEach(type -> prefsNode.put(type.getType().getName(), MetaDataSerializer.serializeCustomEntryTypes(type)));
            prefsNode.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.info("Updating stored custom entry types failed.", (Throwable)e);
        }
    }

    private static Preferences getPrefsNodeForCustomizedEntryTypes(BibDatabaseMode mode) {
        return mode == BibDatabaseMode.BIBTEX ? PREFS_NODE.node(CUSTOMIZED_BIBTEX_TYPES) : PREFS_NODE.node(CUSTOMIZED_BIBLATEX_TYPES);
    }

    @Override
    public OpenOfficePreferences getOpenOfficePreferences() {
        if (this.openOfficePreferences != null) {
            return this.openOfficePreferences;
        }
        this.openOfficePreferences = new OpenOfficePreferences(this.get(OO_EXECUTABLE_PATH), this.getBoolean(OO_USE_ALL_OPEN_BASES), this.getBoolean(OO_SYNC_WHEN_CITING), this.getStringList(OO_EXTERNAL_STYLE_FILES), this.get(OO_BIBLIOGRAPHY_STYLE_FILE));
        EasyBind.listen((ObservableValue)this.openOfficePreferences.executablePathProperty(), (obs, oldValue, newValue) -> this.put(OO_EXECUTABLE_PATH, (String)newValue));
        EasyBind.listen((ObservableValue)this.openOfficePreferences.useAllDatabasesProperty(), (obs, oldValue, newValue) -> this.putBoolean(OO_USE_ALL_OPEN_BASES, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.openOfficePreferences.syncWhenCitingProperty(), (obs, oldValue, newValue) -> this.putBoolean(OO_SYNC_WHEN_CITING, (boolean)newValue));
        this.openOfficePreferences.getExternalStyles().addListener(change -> this.putStringList(OO_EXTERNAL_STYLE_FILES, (List<String>)this.openOfficePreferences.getExternalStyles()));
        EasyBind.listen((ObservableValue)this.openOfficePreferences.currentStyleProperty(), (obs, oldValue, newValue) -> this.put(OO_BIBLIOGRAPHY_STYLE_FILE, (String)newValue));
        return this.openOfficePreferences;
    }

    @Override
    public LibraryPreferences getLibraryPreferences() {
        if (this.libraryPreferences != null) {
            return this.libraryPreferences;
        }
        this.libraryPreferences = new LibraryPreferences(this.getBoolean(BIBLATEX_DEFAULT_MODE) ? BibDatabaseMode.BIBLATEX : BibDatabaseMode.BIBTEX, this.getBoolean(REFORMAT_FILE_ON_SAVE_AND_EXPORT), this.getBoolean(LOCAL_AUTO_SAVE));
        EasyBind.listen(this.libraryPreferences.defaultBibDatabaseModeProperty(), (obs, oldValue, newValue) -> this.putBoolean(BIBLATEX_DEFAULT_MODE, newValue == BibDatabaseMode.BIBLATEX));
        EasyBind.listen((ObservableValue)this.libraryPreferences.alwaysReformatOnSaveProperty(), (obs, oldValue, newValue) -> this.putBoolean(REFORMAT_FILE_ON_SAVE_AND_EXPORT, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.libraryPreferences.autoSaveProperty(), (obs, oldValue, newValue) -> this.putBoolean(LOCAL_AUTO_SAVE, (boolean)newValue));
        return this.libraryPreferences;
    }

    @Override
    public DOIPreferences getDOIPreferences() {
        if (this.doiPreferences != null) {
            return this.doiPreferences;
        }
        this.doiPreferences = new DOIPreferences(this.getBoolean(USE_CUSTOM_DOI_URI), this.get(BASE_DOI_URI));
        EasyBind.listen((ObservableValue)this.doiPreferences.useCustomProperty(), (obs, oldValue, newValue) -> this.putBoolean(USE_CUSTOM_DOI_URI, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.doiPreferences.defaultBaseURIProperty(), (obs, oldValue, newValue) -> this.put(BASE_DOI_URI, (String)newValue));
        return this.doiPreferences;
    }

    @Override
    public OwnerPreferences getOwnerPreferences() {
        if (this.ownerPreferences != null) {
            return this.ownerPreferences;
        }
        this.ownerPreferences = new OwnerPreferences(this.getBoolean(USE_OWNER), this.get(DEFAULT_OWNER), this.getBoolean(OVERWRITE_OWNER));
        EasyBind.listen((ObservableValue)this.ownerPreferences.useOwnerProperty(), (obs, oldValue, newValue) -> this.putBoolean(USE_OWNER, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.ownerPreferences.defaultOwnerProperty(), (obs, oldValue, newValue) -> {
            this.put(DEFAULT_OWNER, (String)newValue);
            this.userAndHost = null;
            this.getInternalPreferences().getUserAndHostProperty().setValue(newValue);
        });
        EasyBind.listen((ObservableValue)this.ownerPreferences.overwriteOwnerProperty(), (obs, oldValue, newValue) -> this.putBoolean(OVERWRITE_OWNER, (boolean)newValue));
        return this.ownerPreferences;
    }

    @Override
    public TimestampPreferences getTimestampPreferences() {
        if (this.timestampPreferences != null) {
            return this.timestampPreferences;
        }
        this.timestampPreferences = new TimestampPreferences(this.getBoolean(ADD_CREATION_DATE), this.getBoolean(ADD_MODIFICATION_DATE), this.getBoolean(UPDATE_TIMESTAMP), FieldFactory.parseField(this.get(TIME_STAMP_FIELD)), this.get(TIME_STAMP_FORMAT));
        EasyBind.listen((ObservableValue)this.timestampPreferences.addCreationDateProperty(), (obs, oldValue, newValue) -> this.putBoolean(ADD_CREATION_DATE, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.timestampPreferences.addModificationDateProperty(), (obs, oldValue, newValue) -> this.putBoolean(ADD_MODIFICATION_DATE, (boolean)newValue));
        return this.timestampPreferences;
    }

    @Override
    public GroupsPreferences getGroupsPreferences() {
        if (this.groupsPreferences != null) {
            return this.groupsPreferences;
        }
        this.groupsPreferences = new GroupsPreferences(GroupViewMode.valueOf(this.get(GROUP_INTERSECT_UNION_VIEW_MODE)), this.getBoolean(AUTO_ASSIGN_GROUP), this.getBoolean(DISPLAY_GROUP_COUNT), GroupHierarchyType.valueOf(this.get(DEFAULT_HIERARCHICAL_CONTEXT)));
        EasyBind.listen(this.groupsPreferences.groupViewModeProperty(), (obs, oldValue, newValue) -> this.put(GROUP_INTERSECT_UNION_VIEW_MODE, newValue.name()));
        EasyBind.listen((ObservableValue)this.groupsPreferences.autoAssignGroupProperty(), (obs, oldValue, newValue) -> this.putBoolean(AUTO_ASSIGN_GROUP, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.groupsPreferences.displayGroupCountProperty(), (obs, oldValue, newValue) -> this.putBoolean(DISPLAY_GROUP_COUNT, (boolean)newValue));
        EasyBind.listen(this.groupsPreferences.defaultHierarchicalContextProperty(), (obs, oldValue, newValue) -> this.put(DEFAULT_HIERARCHICAL_CONTEXT, newValue.name()));
        return this.groupsPreferences;
    }

    @Override
    public EntryEditorPreferences getEntryEditorPreferences() {
        if (this.entryEditorPreferences != null) {
            return this.entryEditorPreferences;
        }
        this.entryEditorPreferences = new EntryEditorPreferences(this.getEntryEditorTabs(), this.getDefaultEntryEditorTabs(), this.getBoolean(AUTO_OPEN_FORM), this.getBoolean(SHOW_RECOMMENDATIONS), this.getBoolean(SHOW_LATEX_CITATIONS), this.getBoolean(DEFAULT_SHOW_SOURCE), this.getBoolean(VALIDATE_IN_ENTRY_EDITOR), this.getBoolean(ALLOW_INTEGER_EDITION_BIBTEX), this.getDouble(ENTRY_EDITOR_HEIGHT), this.getBoolean(AUTOLINK_FILES_ENABLED), EntryEditorPreferences.JournalPopupEnabled.fromString(this.get(JOURNAL_POPUP)), this.getBoolean(SHOW_SCITE_TAB), this.getBoolean(SHOW_USER_COMMENTS_FIELDS), this.getDouble(ENTRY_EDITOR_PREVIEW_DIVIDER_POS));
        EasyBind.listen(this.entryEditorPreferences.entryEditorTabs(), (obs, oldValue, newValue) -> this.storeEntryEditorTabs((Map<String, Set<Field>>)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.shouldOpenOnNewEntryProperty(), (obs, oldValue, newValue) -> this.putBoolean(AUTO_OPEN_FORM, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.shouldShowRecommendationsTabProperty(), (obs, oldValue, newValue) -> this.putBoolean(SHOW_RECOMMENDATIONS, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.shouldShowLatexCitationsTabProperty(), (obs, oldValue, newValue) -> this.putBoolean(SHOW_LATEX_CITATIONS, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.showSourceTabByDefaultProperty(), (obs, oldValue, newValue) -> this.putBoolean(DEFAULT_SHOW_SOURCE, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.enableValidationProperty(), (obs, oldValue, newValue) -> this.putBoolean(VALIDATE_IN_ENTRY_EDITOR, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.allowIntegerEditionBibtexProperty(), (obs, oldValue, newValue) -> this.putBoolean(ALLOW_INTEGER_EDITION_BIBTEX, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.dividerPositionProperty(), (obs, oldValue, newValue) -> this.putDouble(ENTRY_EDITOR_HEIGHT, newValue.doubleValue()));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.autoLinkEnabledProperty(), (obs, oldValue, newValue) -> this.putBoolean(AUTOLINK_FILES_ENABLED, (boolean)newValue));
        EasyBind.listen(this.entryEditorPreferences.enableJournalPopupProperty(), (obs, oldValue, newValue) -> this.put(JOURNAL_POPUP, newValue.toString()));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.shouldShowLSciteTabProperty(), (obs, oldValue, newValue) -> this.putBoolean(SHOW_SCITE_TAB, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.showUserCommentsFieldsProperty(), (obs, oldValue, newValue) -> this.putBoolean(SHOW_USER_COMMENTS_FIELDS, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.entryEditorPreferences.previewWidthDividerPositionProperty(), (obs, oldValue, newValue) -> this.putDouble(ENTRY_EDITOR_PREVIEW_DIVIDER_POS, newValue.doubleValue()));
        return this.entryEditorPreferences;
    }

    private Map<String, Set<Field>> getEntryEditorTabs() {
        LinkedHashMap<String, Set<Field>> tabs = new LinkedHashMap<String, Set<Field>>();
        List<String> tabNames = this.getSeries(CUSTOM_TAB_NAME);
        List<String> tabFields = this.getSeries(CUSTOM_TAB_FIELDS);
        if (tabNames.isEmpty() || tabNames.size() != tabFields.size()) {
            tabNames = this.getSeries("customTabName__def");
            tabFields = this.getSeries("customTabFields__def");
        }
        for (int i = 0; i < tabNames.size(); ++i) {
            tabs.put(tabNames.get(i), FieldFactory.parseFieldList(tabFields.get(i)));
        }
        return tabs;
    }

    private void storeEntryEditorTabs(Map<String, Set<Field>> customTabs) {
        String[] names = (String[])customTabs.keySet().toArray(String[]::new);
        String[] fields = (String[])customTabs.values().stream().map(set -> set.stream().map(Field::getName).collect(Collectors.joining(STRINGLIST_DELIMITER.toString()))).toArray(String[]::new);
        for (int i = 0; i < customTabs.size(); ++i) {
            this.put(CUSTOM_TAB_NAME + i, names[i]);
            this.put(CUSTOM_TAB_FIELDS + i, fields[i]);
        }
        this.purgeSeries(CUSTOM_TAB_NAME, customTabs.size());
        this.purgeSeries(CUSTOM_TAB_FIELDS, customTabs.size());
        this.getEntryEditorTabs();
    }

    private SequencedMap<String, Set<Field>> getDefaultEntryEditorTabs() {
        LinkedHashMap<String, Set<Field>> customTabsMap = new LinkedHashMap<String, Set<Field>>();
        int defNumber = 0;
        while (true) {
            String name = (String)this.defaults.get("customTabName__def" + defNumber);
            String fields = (String)this.defaults.get("customTabFields__def" + defNumber);
            if (StringUtil.isNullOrEmpty(name) || StringUtil.isNullOrEmpty(fields)) break;
            customTabsMap.put(name, FieldFactory.parseFieldList((String)this.defaults.get("customTabFields__def" + defNumber)));
            ++defNumber;
        }
        return customTabsMap;
    }

    @Override
    public RemotePreferences getRemotePreferences() {
        if (this.remotePreferences != null) {
            return this.remotePreferences;
        }
        this.remotePreferences = new RemotePreferences(this.getInt(REMOTE_SERVER_PORT), this.getBoolean(USE_REMOTE_SERVER));
        EasyBind.listen((ObservableValue)this.remotePreferences.portProperty(), (obs, oldValue, newValue) -> this.putInt(REMOTE_SERVER_PORT, (Number)newValue));
        EasyBind.listen((ObservableValue)this.remotePreferences.useRemoteServerProperty(), (obs, oldValue, newValue) -> this.putBoolean(USE_REMOTE_SERVER, (boolean)newValue));
        return this.remotePreferences;
    }

    @Override
    public ProxyPreferences getProxyPreferences() {
        if (this.proxyPreferences != null) {
            return this.proxyPreferences;
        }
        this.proxyPreferences = new ProxyPreferences(this.getBoolean(PROXY_USE), this.get(PROXY_HOSTNAME), this.get(PROXY_PORT), this.getBoolean(PROXY_USE_AUTHENTICATION), this.get(PROXY_USERNAME), this.getProxyPassword(), this.getBoolean(PROXY_PERSIST_PASSWORD));
        EasyBind.listen((ObservableValue)this.proxyPreferences.useProxyProperty(), (obs, oldValue, newValue) -> this.putBoolean(PROXY_USE, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.proxyPreferences.hostnameProperty(), (obs, oldValue, newValue) -> this.put(PROXY_HOSTNAME, (String)newValue));
        EasyBind.listen((ObservableValue)this.proxyPreferences.portProperty(), (obs, oldValue, newValue) -> this.put(PROXY_PORT, (String)newValue));
        EasyBind.listen((ObservableValue)this.proxyPreferences.useAuthenticationProperty(), (obs, oldValue, newValue) -> this.putBoolean(PROXY_USE_AUTHENTICATION, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.proxyPreferences.usernameProperty(), (obs, oldValue, newValue) -> this.put(PROXY_USERNAME, (String)newValue));
        EasyBind.listen((ObservableValue)this.proxyPreferences.passwordProperty(), (obs, oldValue, newValue) -> this.setProxyPassword((String)newValue));
        EasyBind.listen((ObservableValue)this.proxyPreferences.persistPasswordProperty(), (obs, oldValue, newValue) -> {
            this.putBoolean(PROXY_PERSIST_PASSWORD, (boolean)newValue);
            if (!newValue.booleanValue()) {
                try (Keyring keyring = Keyring.create();){
                    keyring.deletePassword("org.jabref", "proxy");
                }
                catch (Exception ex) {
                    LOGGER.warn("Unable to remove proxy credentials");
                }
            }
        });
        return this.proxyPreferences;
    }

    private String getProxyPassword() {
        block11: {
            if (this.getBoolean(PROXY_PERSIST_PASSWORD)) {
                String string;
                block10: {
                    Keyring keyring = Keyring.create();
                    try {
                        string = new Password(keyring.getPassword("org.jabref", "proxy"), this.getInternalPreferences().getUserAndHost()).decrypt();
                        if (keyring == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (keyring != null) {
                                try {
                                    keyring.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (PasswordAccessException ex) {
                            LOGGER.warn("JabRef uses proxy password from key store but no password is stored");
                            break block11;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("JabRef could not open the key store", (Throwable)ex);
                        }
                    }
                    keyring.close();
                }
                return string;
            }
        }
        return (String)this.defaults.get(PROXY_PASSWORD);
    }

    private void setProxyPassword(String password) {
        if (this.getProxyPreferences().shouldPersistPassword()) {
            try (Keyring keyring = Keyring.create();){
                if (StringUtil.isBlank(password)) {
                    keyring.deletePassword("org.jabref", "proxy");
                } else {
                    keyring.setPassword("org.jabref", "proxy", new Password(password.trim(), this.getInternalPreferences().getUserAndHost()).encrypt());
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to open key store", (Throwable)ex);
            }
        }
    }

    @Override
    public SSLPreferences getSSLPreferences() {
        if (this.sslPreferences != null) {
            return this.sslPreferences;
        }
        this.sslPreferences = new SSLPreferences(this.get(TRUSTSTORE_PATH));
        return this.sslPreferences;
    }

    private GlobalCitationKeyPatterns getGlobalCitationKeyPattern() {
        GlobalCitationKeyPatterns citationKeyPattern = GlobalCitationKeyPatterns.fromPattern(this.get(DEFAULT_CITATION_KEY_PATTERN));
        Preferences preferences = PREFS_NODE.node(CITATION_KEY_PATTERNS_NODE);
        try {
            String[] keys;
            for (String key : keys = preferences.keys()) {
                citationKeyPattern.addCitationKeyPattern(EntryTypeFactory.parse(key), preferences.get(key, null));
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.info("BackingStoreException in JabRefPreferences.getKeyPattern", (Throwable)ex);
        }
        return citationKeyPattern;
    }

    public void storeGlobalCitationKeyPattern(GlobalCitationKeyPatterns pattern) {
        if (pattern.getDefaultValue() == null || pattern.getDefaultValue().equals(CitationKeyPattern.NULL_CITATION_KEY_PATTERN)) {
            this.put(DEFAULT_CITATION_KEY_PATTERN, "");
        } else {
            this.put(DEFAULT_CITATION_KEY_PATTERN, pattern.getDefaultValue().stringRepresentation());
        }
        Preferences preferences = PREFS_NODE.node(CITATION_KEY_PATTERNS_NODE);
        try {
            preferences.clear();
        }
        catch (BackingStoreException ex) {
            LOGGER.info("BackingStoreException in JabRefPreferences::putKeyPattern", (Throwable)ex);
        }
        for (EntryType entryType : pattern.getAllKeys()) {
            if (pattern.isDefaultValue(entryType)) continue;
            preferences.put(entryType.getName(), pattern.getValue(entryType).stringRepresentation());
        }
    }

    private void clearCitationKeyPatterns() throws BackingStoreException {
        Preferences preferences = PREFS_NODE.node(CITATION_KEY_PATTERNS_NODE);
        preferences.clear();
        this.getCitationKeyPatternPreferences().setKeyPatterns(this.getGlobalCitationKeyPattern());
    }

    @Override
    public CitationKeyPatternPreferences getCitationKeyPatternPreferences() {
        if (this.citationKeyPatternPreferences != null) {
            return this.citationKeyPatternPreferences;
        }
        this.citationKeyPatternPreferences = new CitationKeyPatternPreferences(this.getBoolean(AVOID_OVERWRITING_KEY), this.getBoolean(WARN_BEFORE_OVERWRITING_KEY), this.getBoolean(GENERATE_KEYS_BEFORE_SAVING), this.getKeySuffix(), this.get(KEY_PATTERN_REGEX), this.get(KEY_PATTERN_REPLACEMENT), this.get(UNWANTED_CITATION_KEY_CHARACTERS), this.getGlobalCitationKeyPattern(), (String)this.defaults.get(DEFAULT_CITATION_KEY_PATTERN), (ReadOnlyObjectProperty<Character>)this.getBibEntryPreferences().keywordSeparatorProperty());
        EasyBind.listen((ObservableValue)this.citationKeyPatternPreferences.shouldAvoidOverwriteCiteKeyProperty(), (obs, oldValue, newValue) -> this.putBoolean(AVOID_OVERWRITING_KEY, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.citationKeyPatternPreferences.shouldWarnBeforeOverwriteCiteKeyProperty(), (obs, oldValue, newValue) -> this.putBoolean(WARN_BEFORE_OVERWRITING_KEY, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.citationKeyPatternPreferences.shouldGenerateCiteKeysBeforeSavingProperty(), (obs, oldValue, newValue) -> this.putBoolean(GENERATE_KEYS_BEFORE_SAVING, (boolean)newValue));
        EasyBind.listen(this.citationKeyPatternPreferences.keySuffixProperty(), (obs, oldValue, newValue) -> {
            this.putBoolean(KEY_GEN_ALWAYS_ADD_LETTER, newValue == CitationKeyPatternPreferences.KeySuffix.ALWAYS);
            this.putBoolean(KEY_GEN_FIRST_LETTER_A, newValue == CitationKeyPatternPreferences.KeySuffix.SECOND_WITH_A);
        });
        EasyBind.listen((ObservableValue)this.citationKeyPatternPreferences.keyPatternRegexProperty(), (obs, oldValue, newValue) -> this.put(KEY_PATTERN_REGEX, (String)newValue));
        EasyBind.listen((ObservableValue)this.citationKeyPatternPreferences.keyPatternReplacementProperty(), (obs, oldValue, newValue) -> this.put(KEY_PATTERN_REPLACEMENT, (String)newValue));
        EasyBind.listen((ObservableValue)this.citationKeyPatternPreferences.unwantedCharactersProperty(), (obs, oldValue, newValue) -> this.put(UNWANTED_CITATION_KEY_CHARACTERS, (String)newValue));
        EasyBind.listen(this.citationKeyPatternPreferences.keyPatternsProperty(), (obs, oldValue, newValue) -> this.storeGlobalCitationKeyPattern((GlobalCitationKeyPatterns)newValue));
        return this.citationKeyPatternPreferences;
    }

    private CitationKeyPatternPreferences.KeySuffix getKeySuffix() {
        CitationKeyPatternPreferences.KeySuffix keySuffix = CitationKeyPatternPreferences.KeySuffix.SECOND_WITH_B;
        if (this.getBoolean(KEY_GEN_ALWAYS_ADD_LETTER)) {
            keySuffix = CitationKeyPatternPreferences.KeySuffix.ALWAYS;
        } else if (this.getBoolean(KEY_GEN_FIRST_LETTER_A)) {
            keySuffix = CitationKeyPatternPreferences.KeySuffix.SECOND_WITH_A;
        }
        return keySuffix;
    }

    @Override
    public PushToApplicationPreferences getPushToApplicationPreferences() {
        if (this.pushToApplicationPreferences != null) {
            return this.pushToApplicationPreferences;
        }
        HashMap<String, String> applicationCommands = new HashMap<String, String>();
        applicationCommands.put("Emacs", this.getEmptyIsDefault(PUSH_EMACS_PATH));
        applicationCommands.put("LyX/Kile", this.getEmptyIsDefault(PUSH_LYXPIPE));
        applicationCommands.put("Texmaker", this.getEmptyIsDefault(PUSH_TEXMAKER_PATH));
        applicationCommands.put("TeXstudio", this.getEmptyIsDefault(PUSH_TEXSTUDIO_PATH));
        applicationCommands.put("TeXworks", this.getEmptyIsDefault(PUSH_TEXWORKS_PATH));
        applicationCommands.put("Vim", this.getEmptyIsDefault(PUSH_VIM));
        applicationCommands.put("WinEdt", this.getEmptyIsDefault(PUSH_WINEDT_PATH));
        applicationCommands.put("Sublime Text", this.getEmptyIsDefault(PUSH_SUBLIME_TEXT_PATH));
        this.pushToApplicationPreferences = new PushToApplicationPreferences(this.get(PUSH_TO_APPLICATION), applicationCommands, this.get(PUSH_EMACS_ADDITIONAL_PARAMETERS), this.get(PUSH_VIM_SERVER));
        EasyBind.listen((ObservableValue)this.pushToApplicationPreferences.activeApplicationNameProperty(), (obs, oldValue, newValue) -> this.put(PUSH_TO_APPLICATION, (String)newValue));
        this.pushToApplicationPreferences.getCommandPaths().addListener((obs, oldValue, newValue) -> this.storePushToApplicationPath((Map<String, String>)newValue));
        EasyBind.listen((ObservableValue)this.pushToApplicationPreferences.emacsArgumentsProperty(), (obs, oldValue, newValue) -> this.put(PUSH_EMACS_ADDITIONAL_PARAMETERS, (String)newValue));
        EasyBind.listen((ObservableValue)this.pushToApplicationPreferences.vimServerProperty(), (obs, oldValue, newValue) -> this.put(PUSH_VIM_SERVER, (String)newValue));
        return this.pushToApplicationPreferences;
    }

    private void storePushToApplicationPath(Map<String, String> commandPair) {
        commandPair.forEach((key, value) -> {
            switch (key) {
                case "Emacs": {
                    this.put(PUSH_EMACS_PATH, (String)value);
                    break;
                }
                case "LyX/Kile": {
                    this.put(PUSH_LYXPIPE, (String)value);
                    break;
                }
                case "Texmaker": {
                    this.put(PUSH_TEXMAKER_PATH, (String)value);
                    break;
                }
                case "TeXstudio": {
                    this.put(PUSH_TEXSTUDIO_PATH, (String)value);
                    break;
                }
                case "TeXworks": {
                    this.put(PUSH_TEXWORKS_PATH, (String)value);
                    break;
                }
                case "Vim": {
                    this.put(PUSH_VIM, (String)value);
                    break;
                }
                case "WinEdt": {
                    this.put(PUSH_WINEDT_PATH, (String)value);
                    break;
                }
                case "Sublime Text": {
                    this.put(PUSH_SUBLIME_TEXT_PATH, (String)value);
                }
            }
        });
    }

    @Override
    public ExternalApplicationsPreferences getExternalApplicationsPreferences() {
        if (this.externalApplicationsPreferences != null) {
            return this.externalApplicationsPreferences;
        }
        this.externalApplicationsPreferences = new ExternalApplicationsPreferences(this.get(EMAIL_SUBJECT), this.getBoolean(OPEN_FOLDERS_OF_ATTACHED_FILES), CitationCommandString.from(this.get(CITE_COMMAND)), CitationCommandString.from((String)this.defaults.get(CITE_COMMAND)), !this.getBoolean(USE_DEFAULT_CONSOLE_APPLICATION), this.get(CONSOLE_COMMAND), !this.getBoolean(USE_DEFAULT_FILE_BROWSER_APPLICATION), this.get(FILE_BROWSER_COMMAND), this.get(KINDLE_EMAIL));
        EasyBind.listen((ObservableValue)this.externalApplicationsPreferences.eMailSubjectProperty(), (obs, oldValue, newValue) -> this.put(EMAIL_SUBJECT, (String)newValue));
        EasyBind.listen((ObservableValue)this.externalApplicationsPreferences.autoOpenEmailAttachmentsFolderProperty(), (obs, oldValue, newValue) -> this.putBoolean(OPEN_FOLDERS_OF_ATTACHED_FILES, (boolean)newValue));
        EasyBind.listen(this.externalApplicationsPreferences.citeCommandProperty(), (obs, oldValue, newValue) -> this.put(CITE_COMMAND, newValue.toString()));
        EasyBind.listen((ObservableValue)this.externalApplicationsPreferences.useCustomTerminalProperty(), (obs, oldValue, newValue) -> this.putBoolean(USE_DEFAULT_CONSOLE_APPLICATION, newValue == false));
        EasyBind.listen((ObservableValue)this.externalApplicationsPreferences.customTerminalCommandProperty(), (obs, oldValue, newValue) -> this.put(CONSOLE_COMMAND, (String)newValue));
        EasyBind.listen((ObservableValue)this.externalApplicationsPreferences.useCustomFileBrowserProperty(), (obs, oldValue, newValue) -> this.putBoolean(USE_DEFAULT_FILE_BROWSER_APPLICATION, newValue == false));
        EasyBind.listen((ObservableValue)this.externalApplicationsPreferences.customFileBrowserCommandProperty(), (obs, oldValue, newValue) -> this.put(FILE_BROWSER_COMMAND, (String)newValue));
        EasyBind.listen((ObservableValue)this.externalApplicationsPreferences.kindleEmailProperty(), (obs, oldValue, newValue) -> this.put(KINDLE_EMAIL, (String)newValue));
        return this.externalApplicationsPreferences;
    }

    @Override
    public MainTablePreferences getMainTablePreferences() {
        if (this.mainTablePreferences != null) {
            return this.mainTablePreferences;
        }
        this.mainTablePreferences = new MainTablePreferences(this.getMainTableColumnPreferences(), this.getBoolean(AUTO_RESIZE_MODE), this.getBoolean(EXTRA_FILE_COLUMNS));
        EasyBind.listen((ObservableValue)this.mainTablePreferences.resizeColumnsToFitProperty(), (obs, oldValue, newValue) -> this.putBoolean(AUTO_RESIZE_MODE, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.mainTablePreferences.extraFileColumnsEnabledProperty(), (obs, oldValue, newValue) -> this.putBoolean(EXTRA_FILE_COLUMNS, (boolean)newValue));
        return this.mainTablePreferences;
    }

    @Override
    public ColumnPreferences getMainTableColumnPreferences() {
        if (this.mainTableColumnPreferences != null) {
            return this.mainTableColumnPreferences;
        }
        List<MainTableColumnModel> columns = this.getColumns(COLUMN_NAMES, COLUMN_WIDTHS, COLUMN_SORT_TYPES, 100.0);
        List<MainTableColumnModel> columnSortOrder = this.getColumnSortOrder(COLUMN_SORT_ORDER, columns);
        this.mainTableColumnPreferences = new ColumnPreferences(columns, columnSortOrder);
        this.mainTableColumnPreferences.getColumns().addListener(change -> {
            this.putStringList(COLUMN_NAMES, JabRefPreferences.getColumnNamesAsStringList(this.mainTableColumnPreferences));
            this.putStringList(COLUMN_WIDTHS, JabRefPreferences.getColumnWidthsAsStringList(this.mainTableColumnPreferences));
            this.putStringList(COLUMN_SORT_TYPES, JabRefPreferences.getColumnSortTypesAsStringList(this.mainTableColumnPreferences));
        });
        this.mainTableColumnPreferences.getColumnSortOrder().addListener(change -> this.putStringList(COLUMN_SORT_ORDER, JabRefPreferences.getColumnSortOrderAsStringList(this.mainTableColumnPreferences)));
        return this.mainTableColumnPreferences;
    }

    @Override
    public ColumnPreferences getSearchDialogColumnPreferences() {
        if (this.searchDialogColumnPreferences != null) {
            return this.searchDialogColumnPreferences;
        }
        List<MainTableColumnModel> columns = this.getColumns(COLUMN_NAMES, SEARCH_DIALOG_COLUMN_WIDTHS, SEARCH_DIALOG_COLUMN_SORT_TYPES, 100.0);
        List<MainTableColumnModel> columnSortOrder = this.getColumnSortOrder(SEARCH_DIALOG_COLUMN_SORT_ORDER, columns);
        this.searchDialogColumnPreferences = new ColumnPreferences(columns, columnSortOrder);
        this.searchDialogColumnPreferences.getColumns().addListener(change -> {
            this.putStringList(SEARCH_DIALOG_COLUMN_WIDTHS, JabRefPreferences.getColumnWidthsAsStringList(this.searchDialogColumnPreferences));
            this.putStringList(SEARCH_DIALOG_COLUMN_SORT_TYPES, JabRefPreferences.getColumnSortTypesAsStringList(this.searchDialogColumnPreferences));
        });
        this.searchDialogColumnPreferences.getColumnSortOrder().addListener(change -> this.putStringList(SEARCH_DIALOG_COLUMN_SORT_ORDER, JabRefPreferences.getColumnSortOrderAsStringList(this.searchDialogColumnPreferences)));
        return this.searchDialogColumnPreferences;
    }

    private List<MainTableColumnModel> getColumns(String columnNamesList, String columnWidthList, String sortTypeList, double defaultWidth) {
        List<String> columnNames = this.getStringList(columnNamesList);
        List<Double> columnWidths = this.getStringList(columnWidthList).stream().map(string -> {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Exception while parsing column widths. Choosing default.", (Throwable)e);
                return defaultWidth;
            }
        }).toList();
        List<TableColumn.SortType> columnSortTypes = this.getStringList(sortTypeList).stream().map(TableColumn.SortType::valueOf).toList();
        ArrayList<MainTableColumnModel> columns = new ArrayList<MainTableColumnModel>();
        for (int i = 0; i < columnNames.size(); ++i) {
            MainTableColumnModel columnModel = MainTableColumnModel.parse(columnNames.get(i));
            if (i < columnWidths.size()) {
                columnModel.widthProperty().setValue((Number)columnWidths.get(i));
            }
            if (i < columnSortTypes.size()) {
                columnModel.sortTypeProperty().setValue((Object)columnSortTypes.get(i));
            }
            columns.add(columnModel);
        }
        return columns;
    }

    private List<MainTableColumnModel> getColumnSortOrder(String sortOrderList, List<MainTableColumnModel> tableColumns) {
        ArrayList<MainTableColumnModel> columnsOrdered = new ArrayList<MainTableColumnModel>();
        this.getStringList(sortOrderList).forEach(columnName -> tableColumns.stream().filter(column -> column.getName().equals(columnName)).findFirst().ifPresent(columnsOrdered::add));
        return columnsOrdered;
    }

    private static List<String> getColumnNamesAsStringList(ColumnPreferences columnPreferences) {
        return columnPreferences.getColumns().stream().map(MainTableColumnModel::getName).toList();
    }

    private static List<String> getColumnWidthsAsStringList(ColumnPreferences columnPreferences) {
        return columnPreferences.getColumns().stream().map(column -> column.widthProperty().getValue().toString()).toList();
    }

    private static List<String> getColumnSortTypesAsStringList(ColumnPreferences columnPreferences) {
        return columnPreferences.getColumns().stream().map(column -> ((TableColumn.SortType)column.sortTypeProperty().getValue()).toString()).toList();
    }

    private static List<String> getColumnSortOrderAsStringList(ColumnPreferences columnPreferences) {
        return columnPreferences.getColumnSortOrder().stream().map(MainTableColumnModel::getName).collect(Collectors.toList());
    }

    @Override
    public NameDisplayPreferences getNameDisplayPreferences() {
        if (this.nameDisplayPreferences != null) {
            return this.nameDisplayPreferences;
        }
        this.nameDisplayPreferences = new NameDisplayPreferences(this.getNameDisplayStyle(), this.getNameAbbreviationStyle());
        EasyBind.listen(this.nameDisplayPreferences.displayStyleProperty(), (obs, oldValue, newValue) -> {
            this.putBoolean(NAMES_NATBIB, newValue == NameDisplayPreferences.DisplayStyle.NATBIB);
            this.putBoolean(NAMES_AS_IS, newValue == NameDisplayPreferences.DisplayStyle.AS_IS);
            this.putBoolean(NAMES_FIRST_LAST, newValue == NameDisplayPreferences.DisplayStyle.FIRSTNAME_LASTNAME);
        });
        EasyBind.listen(this.nameDisplayPreferences.abbreviationStyleProperty(), (obs, oldValue, newValue) -> {
            this.putBoolean(ABBR_AUTHOR_NAMES, newValue == NameDisplayPreferences.AbbreviationStyle.FULL);
            this.putBoolean(NAMES_LAST_ONLY, newValue == NameDisplayPreferences.AbbreviationStyle.LASTNAME_ONLY);
        });
        return this.nameDisplayPreferences;
    }

    private NameDisplayPreferences.AbbreviationStyle getNameAbbreviationStyle() {
        NameDisplayPreferences.AbbreviationStyle abbreviationStyle = NameDisplayPreferences.AbbreviationStyle.NONE;
        if (this.getBoolean(ABBR_AUTHOR_NAMES)) {
            abbreviationStyle = NameDisplayPreferences.AbbreviationStyle.FULL;
        } else if (this.getBoolean(NAMES_LAST_ONLY)) {
            abbreviationStyle = NameDisplayPreferences.AbbreviationStyle.LASTNAME_ONLY;
        }
        return abbreviationStyle;
    }

    private NameDisplayPreferences.DisplayStyle getNameDisplayStyle() {
        NameDisplayPreferences.DisplayStyle displayStyle = NameDisplayPreferences.DisplayStyle.LASTNAME_FIRSTNAME;
        if (this.getBoolean(NAMES_NATBIB)) {
            displayStyle = NameDisplayPreferences.DisplayStyle.NATBIB;
        } else if (this.getBoolean(NAMES_AS_IS)) {
            displayStyle = NameDisplayPreferences.DisplayStyle.AS_IS;
        } else if (this.getBoolean(NAMES_FIRST_LAST)) {
            displayStyle = NameDisplayPreferences.DisplayStyle.FIRSTNAME_LASTNAME;
        }
        return displayStyle;
    }

    @Override
    public BibEntryPreferences getBibEntryPreferences() {
        if (this.bibEntryPreferences != null) {
            return this.bibEntryPreferences;
        }
        this.bibEntryPreferences = new BibEntryPreferences(Character.valueOf(this.get(KEYWORD_SEPARATOR).charAt(0)));
        EasyBind.listen(this.bibEntryPreferences.keywordSeparatorProperty(), (observable, oldValue, newValue) -> this.put(KEYWORD_SEPARATOR, String.valueOf(newValue)));
        return this.bibEntryPreferences;
    }

    @Override
    public InternalPreferences getInternalPreferences() {
        if (this.internalPreferences != null) {
            return this.internalPreferences;
        }
        this.internalPreferences = new InternalPreferences(Version.parse(this.get(VERSION_IGNORED_UPDATE)), this.getBoolean(VERSION_CHECK_ENABLED), this.getPath(PREFS_EXPORT_PATH, OS.getNativeDesktop().getDefaultFileChooserDirectory()), this.getUserAndHost(), this.getBoolean(MEMORY_STICK_MODE));
        EasyBind.listen(this.internalPreferences.ignoredVersionProperty(), (obs, oldValue, newValue) -> this.put(VERSION_IGNORED_UPDATE, newValue.toString()));
        EasyBind.listen((ObservableValue)this.internalPreferences.versionCheckEnabledProperty(), (obs, oldValue, newValue) -> this.putBoolean(VERSION_CHECK_ENABLED, (boolean)newValue));
        EasyBind.listen(this.internalPreferences.lastPreferencesExportPathProperty(), (obs, oldValue, newValue) -> this.put(PREFS_EXPORT_PATH, newValue.toString()));
        EasyBind.listen((ObservableValue)this.internalPreferences.memoryStickModeProperty(), (obs, oldValue, newValue) -> {
            this.putBoolean(MEMORY_STICK_MODE, (boolean)newValue);
            if (!newValue.booleanValue()) {
                try {
                    Files.deleteIfExists(Path.of("jabref.xml", new String[0]));
                }
                catch (IOException e) {
                    LOGGER.warn("Error accessing filesystem", (Throwable)e);
                }
            }
        });
        return this.internalPreferences;
    }

    private String getUserAndHost() {
        if (StringUtil.isNotBlank(this.userAndHost)) {
            return this.userAndHost;
        }
        this.userAndHost = this.get(DEFAULT_OWNER) + "-" + OS.getNativeDesktop().getHostName();
        return this.userAndHost;
    }

    @Override
    public WorkspacePreferences getWorkspacePreferences() {
        if (this.workspacePreferences != null) {
            return this.workspacePreferences;
        }
        this.workspacePreferences = new WorkspacePreferences(this.getLanguage(), this.getBoolean(OVERRIDE_DEFAULT_FONT_SIZE), this.getInt(MAIN_FONT_SIZE), (Integer)this.defaults.get(MAIN_FONT_SIZE), new Theme(this.get(THEME)), this.getBoolean(THEME_SYNC_OS), this.getBoolean(OPEN_LAST_EDITED), this.getBoolean(SHOW_ADVANCED_HINTS), this.getBoolean(WARN_ABOUT_DUPLICATES_IN_INSPECTION), this.getBoolean(CONFIRM_DELETE));
        EasyBind.listen(this.workspacePreferences.languageProperty(), (obs, oldValue, newValue) -> {
            this.put(LANGUAGE, newValue.getId());
            if (oldValue != newValue) {
                this.setLanguageDependentDefaultValues();
                Localization.setLanguage(newValue);
            }
        });
        EasyBind.listen((ObservableValue)this.workspacePreferences.shouldOverrideDefaultFontSizeProperty(), (obs, oldValue, newValue) -> this.putBoolean(OVERRIDE_DEFAULT_FONT_SIZE, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.workspacePreferences.mainFontSizeProperty(), (obs, oldValue, newValue) -> this.putInt(MAIN_FONT_SIZE, (Number)newValue));
        EasyBind.listen(this.workspacePreferences.themeProperty(), (obs, oldValue, newValue) -> this.put(THEME, newValue.getName()));
        EasyBind.listen((ObservableValue)this.workspacePreferences.themeSyncOsProperty(), (obs, oldValue, newValue) -> this.putBoolean(THEME_SYNC_OS, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.workspacePreferences.openLastEditedProperty(), (obs, oldValue, newValue) -> this.putBoolean(OPEN_LAST_EDITED, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.workspacePreferences.showAdvancedHintsProperty(), (obs, oldValue, newValue) -> this.putBoolean(SHOW_ADVANCED_HINTS, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.workspacePreferences.warnAboutDuplicatesInInspectionProperty(), (obs, oldValue, newValue) -> this.putBoolean(WARN_ABOUT_DUPLICATES_IN_INSPECTION, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.workspacePreferences.confirmDeleteProperty(), (obs, oldValue, newValue) -> this.putBoolean(CONFIRM_DELETE, (boolean)newValue));
        return this.workspacePreferences;
    }

    private Language getLanguage() {
        return Stream.of(Language.values()).filter(language -> language.getId().equalsIgnoreCase(this.get(LANGUAGE))).findFirst().orElse(Language.ENGLISH);
    }

    @Override
    public FieldPreferences getFieldPreferences() {
        if (this.fieldPreferences != null) {
            return this.fieldPreferences;
        }
        this.fieldPreferences = new FieldPreferences(!this.getBoolean(DO_NOT_RESOLVE_STRINGS), this.getStringList(RESOLVE_STRINGS_FOR_FIELDS).stream().map(FieldFactory::parseField).collect(Collectors.toList()), this.getStringList(NON_WRAPPABLE_FIELDS).stream().map(FieldFactory::parseField).collect(Collectors.toList()));
        EasyBind.listen((ObservableValue)this.fieldPreferences.resolveStringsProperty(), (obs, oldValue, newValue) -> this.putBoolean(DO_NOT_RESOLVE_STRINGS, newValue == false));
        this.fieldPreferences.getResolvableFields().addListener(change -> this.put(RESOLVE_STRINGS_FOR_FIELDS, FieldFactory.serializeFieldsList(this.fieldPreferences.getResolvableFields())));
        this.fieldPreferences.getNonWrappableFields().addListener(change -> this.put(NON_WRAPPABLE_FIELDS, FieldFactory.serializeFieldsList(this.fieldPreferences.getNonWrappableFields())));
        return this.fieldPreferences;
    }

    @Override
    public FilePreferences getFilePreferences() {
        if (this.filePreferences != null) {
            return this.filePreferences;
        }
        this.filePreferences = new FilePreferences(this.getInternalPreferences().getUserAndHost(), this.getPath(MAIN_FILE_DIRECTORY, OS.getNativeDesktop().getDefaultFileChooserDirectory()).toString(), this.getBoolean(STORE_RELATIVE_TO_BIB), this.get(IMPORT_FILENAMEPATTERN), this.get(IMPORT_FILEDIRPATTERN), this.getBoolean(DOWNLOAD_LINKED_FILES), this.getBoolean(FULLTEXT_INDEX_LINKED_FILES), Path.of(this.get(WORKING_DIRECTORY), new String[0]), ExternalFileTypes.fromString(this.get(EXTERNAL_FILE_TYPES)), this.getBoolean(CREATE_BACKUP), this.getPath(BACKUP_DIRECTORY, OS.getNativeDesktop().getBackupDirectory()), this.getBoolean(CONFIRM_LINKED_FILE_DELETE), this.getBoolean(TRASH_INSTEAD_OF_DELETE, OS.getNativeDesktop().moveToTrashSupported()));
        EasyBind.listen((ObservableValue)this.getInternalPreferences().getUserAndHostProperty(), (obs, oldValue, newValue) -> this.filePreferences.getUserAndHostProperty().setValue(newValue));
        EasyBind.listen((ObservableValue)this.filePreferences.mainFileDirectoryProperty(), (obs, oldValue, newValue) -> this.put(MAIN_FILE_DIRECTORY, (String)newValue));
        EasyBind.listen((ObservableValue)this.filePreferences.storeFilesRelativeToBibFileProperty(), (obs, oldValue, newValue) -> this.putBoolean(STORE_RELATIVE_TO_BIB, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.filePreferences.fileNamePatternProperty(), (obs, oldValue, newValue) -> this.put(IMPORT_FILENAMEPATTERN, (String)newValue));
        EasyBind.listen((ObservableValue)this.filePreferences.fileDirectoryPatternProperty(), (obs, oldValue, newValue) -> this.put(IMPORT_FILEDIRPATTERN, (String)newValue));
        EasyBind.listen((ObservableValue)this.filePreferences.downloadLinkedFilesProperty(), (obs, oldValue, newValue) -> this.putBoolean(DOWNLOAD_LINKED_FILES, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.filePreferences.fulltextIndexLinkedFilesProperty(), (obs, oldValue, newValue) -> this.putBoolean(FULLTEXT_INDEX_LINKED_FILES, (boolean)newValue));
        EasyBind.listen(this.filePreferences.workingDirectoryProperty(), (obs, oldValue, newValue) -> this.put(WORKING_DIRECTORY, newValue.toString()));
        this.filePreferences.getExternalFileTypes().addListener(c -> this.put(EXTERNAL_FILE_TYPES, ExternalFileTypes.toStringList(this.filePreferences.getExternalFileTypes())));
        EasyBind.listen((ObservableValue)this.filePreferences.createBackupProperty(), (obs, oldValue, newValue) -> this.putBoolean(CREATE_BACKUP, (boolean)newValue));
        EasyBind.listen(this.filePreferences.backupDirectoryProperty(), (obs, oldValue, newValue) -> this.put(BACKUP_DIRECTORY, newValue.toString()));
        EasyBind.listen((ObservableValue)this.filePreferences.confirmDeleteLinkedFileProperty(), (obs, oldValue, newValue) -> this.putBoolean(CONFIRM_LINKED_FILE_DELETE, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.filePreferences.moveToTrashProperty(), (obs, oldValue, newValue) -> this.putBoolean(TRASH_INSTEAD_OF_DELETE, (boolean)newValue));
        return this.filePreferences;
    }

    @Override
    public AutoLinkPreferences getAutoLinkPreferences() {
        if (this.autoLinkPreferences != null) {
            return this.autoLinkPreferences;
        }
        this.autoLinkPreferences = new AutoLinkPreferences(this.getAutoLinkKeyDependency(), this.get(AUTOLINK_REG_EXP_SEARCH_EXPRESSION_KEY), this.getBoolean(ASK_AUTO_NAMING_PDFS_AGAIN), this.bibEntryPreferences.keywordSeparatorProperty());
        EasyBind.listen(this.autoLinkPreferences.citationKeyDependencyProperty(), (obs, oldValue, newValue) -> {
            this.putBoolean(AUTOLINK_EXACT_KEY_ONLY, newValue == AutoLinkPreferences.CitationKeyDependency.EXACT);
            this.putBoolean(AUTOLINK_USE_REG_EXP_SEARCH_KEY, newValue == AutoLinkPreferences.CitationKeyDependency.REGEX);
        });
        EasyBind.listen((ObservableValue)this.autoLinkPreferences.askAutoNamingPdfsProperty(), (obs, oldValue, newValue) -> this.putBoolean(ASK_AUTO_NAMING_PDFS_AGAIN, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.autoLinkPreferences.regularExpressionProperty(), (obs, oldValue, newValue) -> this.put(AUTOLINK_REG_EXP_SEARCH_EXPRESSION_KEY, (String)newValue));
        return this.autoLinkPreferences;
    }

    private AutoLinkPreferences.CitationKeyDependency getAutoLinkKeyDependency() {
        AutoLinkPreferences.CitationKeyDependency citationKeyDependency = AutoLinkPreferences.CitationKeyDependency.START;
        if (this.getBoolean(AUTOLINK_EXACT_KEY_ONLY)) {
            citationKeyDependency = AutoLinkPreferences.CitationKeyDependency.EXACT;
        } else if (this.getBoolean(AUTOLINK_USE_REG_EXP_SEARCH_KEY)) {
            citationKeyDependency = AutoLinkPreferences.CitationKeyDependency.REGEX;
        }
        return citationKeyDependency;
    }

    @Override
    public ExportPreferences getExportPreferences() {
        if (this.exportPreferences != null) {
            return this.exportPreferences;
        }
        this.exportPreferences = new ExportPreferences(this.get(LAST_USED_EXPORT), Path.of(this.get(EXPORT_WORKING_DIRECTORY), new String[0]), this.getExportSaveOrder(), this.getCustomExportFormats());
        EasyBind.listen((ObservableValue)this.exportPreferences.lastExportExtensionProperty(), (obs, oldValue, newValue) -> this.put(LAST_USED_EXPORT, (String)newValue));
        EasyBind.listen(this.exportPreferences.exportWorkingDirectoryProperty(), (obs, oldValue, newValue) -> this.put(EXPORT_WORKING_DIRECTORY, newValue.toString()));
        EasyBind.listen(this.exportPreferences.exportSaveOrderProperty(), (obs, oldValue, newValue) -> this.storeExportSaveOrder((SaveOrder)newValue));
        this.exportPreferences.getCustomExporters().addListener(c -> this.storeCustomExportFormats((List<TemplateExporter>)this.exportPreferences.getCustomExporters()));
        return this.exportPreferences;
    }

    private SaveOrder getExportSaveOrder() {
        ArrayList<SaveOrder.SortCriterion> sortCriteria = new ArrayList<SaveOrder.SortCriterion>();
        if (!"".equals(this.get(EXPORT_PRIMARY_SORT_FIELD))) {
            sortCriteria.add(new SaveOrder.SortCriterion(FieldFactory.parseField(this.get(EXPORT_PRIMARY_SORT_FIELD)), this.getBoolean(EXPORT_PRIMARY_SORT_DESCENDING)));
        }
        if (!"".equals(this.get(EXPORT_SECONDARY_SORT_FIELD))) {
            sortCriteria.add(new SaveOrder.SortCriterion(FieldFactory.parseField(this.get(EXPORT_SECONDARY_SORT_FIELD)), this.getBoolean(EXPORT_SECONDARY_SORT_DESCENDING)));
        }
        if (!"".equals(this.get(EXPORT_TERTIARY_SORT_FIELD))) {
            sortCriteria.add(new SaveOrder.SortCriterion(FieldFactory.parseField(this.get(EXPORT_TERTIARY_SORT_FIELD)), this.getBoolean(EXPORT_TERTIARY_SORT_DESCENDING)));
        }
        return new SaveOrder(SaveOrder.OrderType.fromBooleans(this.getBoolean(EXPORT_IN_SPECIFIED_ORDER), this.getBoolean(EXPORT_IN_ORIGINAL_ORDER)), sortCriteria);
    }

    private void storeExportSaveOrder(SaveOrder saveOrder) {
        this.putBoolean(EXPORT_IN_ORIGINAL_ORDER, saveOrder.getOrderType() == SaveOrder.OrderType.ORIGINAL);
        this.putBoolean(EXPORT_IN_SPECIFIED_ORDER, saveOrder.getOrderType() == SaveOrder.OrderType.SPECIFIED);
        long saveOrderCount = saveOrder.getSortCriteria().size();
        if (saveOrderCount >= 1L) {
            this.put(EXPORT_PRIMARY_SORT_FIELD, saveOrder.getSortCriteria().getFirst().field.getName());
            this.putBoolean(EXPORT_PRIMARY_SORT_DESCENDING, saveOrder.getSortCriteria().getFirst().descending);
        } else {
            this.put(EXPORT_PRIMARY_SORT_FIELD, "");
            this.putBoolean(EXPORT_PRIMARY_SORT_DESCENDING, false);
        }
        if (saveOrderCount >= 2L) {
            this.put(EXPORT_SECONDARY_SORT_FIELD, saveOrder.getSortCriteria().get((int)1).field.getName());
            this.putBoolean(EXPORT_SECONDARY_SORT_DESCENDING, saveOrder.getSortCriteria().get((int)1).descending);
        } else {
            this.put(EXPORT_SECONDARY_SORT_FIELD, "");
            this.putBoolean(EXPORT_SECONDARY_SORT_DESCENDING, false);
        }
        if (saveOrderCount >= 3L) {
            this.put(EXPORT_TERTIARY_SORT_FIELD, saveOrder.getSortCriteria().get((int)2).field.getName());
            this.putBoolean(EXPORT_TERTIARY_SORT_DESCENDING, saveOrder.getSortCriteria().get((int)2).descending);
        } else {
            this.put(EXPORT_TERTIARY_SORT_FIELD, "");
            this.putBoolean(EXPORT_TERTIARY_SORT_DESCENDING, false);
        }
    }

    public SelfContainedSaveOrder getSelfContainedTableSaveOrder() {
        ObservableList<MainTableColumnModel> sortOrder = this.getMainTableColumnPreferences().getColumnSortOrder();
        return new SelfContainedSaveOrder(SaveOrder.OrderType.SPECIFIED, sortOrder.stream().flatMap(model -> model.getSortCriteria().stream()).toList());
    }

    @Override
    public SelfContainedSaveConfiguration getSelfContainedExportConfiguration() {
        SaveOrder exportSaveOrder = this.getExportSaveOrder();
        SelfContainedSaveOrder saveOrder = switch (exportSaveOrder.getOrderType()) {
            default -> throw new MatchException(null, null);
            case SaveOrder.OrderType.TABLE -> this.getSelfContainedTableSaveOrder();
            case SaveOrder.OrderType.SPECIFIED -> SelfContainedSaveOrder.of(exportSaveOrder);
            case SaveOrder.OrderType.ORIGINAL -> SaveOrder.getDefaultSaveOrder();
        };
        return new SelfContainedSaveConfiguration(saveOrder, (Boolean)false, BibDatabaseWriter.SaveType.WITH_JABREF_META_DATA, (Boolean)this.getLibraryPreferences().shouldAlwaysReformatOnSave());
    }

    private List<TemplateExporter> getCustomExportFormats() {
        LayoutFormatterPreferences layoutPreferences = this.getLayoutFormatterPreferences();
        SelfContainedSaveConfiguration saveConfiguration = this.getSelfContainedExportConfiguration();
        ArrayList<TemplateExporter> formats = new ArrayList<TemplateExporter>();
        for (String toImport : this.getSeries(CUSTOM_EXPORT_FORMAT)) {
            List<String> formatData = JabRefPreferences.convertStringToList(toImport);
            TemplateExporter format = new TemplateExporter(formatData.getFirst(), formatData.get(1), formatData.get(2), layoutPreferences, saveConfiguration.getSelfContainedSaveOrder());
            format.setCustomExport(true);
            formats.add(format);
        }
        return formats;
    }

    private void storeCustomExportFormats(List<TemplateExporter> exporters) {
        if (exporters.isEmpty()) {
            this.purgeSeries(CUSTOM_EXPORT_FORMAT, 0);
        } else {
            for (int i = 0; i < exporters.size(); ++i) {
                ArrayList<String> exporterData = new ArrayList<String>();
                exporterData.addFirst(exporters.get(i).getName());
                exporterData.add(1, exporters.get(i).getLayoutFileName());
                exporterData.add(2, exporters.get(i).getFileType().getExtensions().getFirst());
                this.putStringList(CUSTOM_EXPORT_FORMAT + i, exporterData);
            }
            this.purgeSeries(CUSTOM_EXPORT_FORMAT, exporters.size());
        }
    }

    @Override
    public PreviewPreferences getPreviewPreferences() {
        if (this.previewPreferences != null) {
            return this.previewPreferences;
        }
        String style = this.get(PREVIEW_STYLE);
        List<PreviewLayout> layouts = this.getPreviewLayouts(style);
        this.previewPreferences = new PreviewPreferences(layouts, this.getPreviewCyclePosition(layouts), new TextBasedPreviewLayout(style, this.getLayoutFormatterPreferences(), (JournalAbbreviationRepository)Injector.instantiateModelOrService(JournalAbbreviationRepository.class)), (String)this.defaults.get(PREVIEW_STYLE), this.getBoolean(PREVIEW_AS_TAB), this.getBoolean(PREVIEW_IN_ENTRY_TABLE_TOOLTIP), this.getStringList(PREVIEW_BST_LAYOUT_PATHS).stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()));
        this.previewPreferences.getLayoutCycle().addListener(c -> this.storePreviewLayouts(this.previewPreferences.getLayoutCycle()));
        EasyBind.listen((ObservableValue)this.previewPreferences.layoutCyclePositionProperty(), (obs, oldValue, newValue) -> this.putInt(CYCLE_PREVIEW_POS, (Number)newValue));
        EasyBind.listen(this.previewPreferences.customPreviewLayoutProperty(), (obs, oldValue, newValue) -> this.put(PREVIEW_STYLE, newValue.getText()));
        EasyBind.listen((ObservableValue)this.previewPreferences.showPreviewAsExtraTabProperty(), (obs, oldValue, newValue) -> this.putBoolean(PREVIEW_AS_TAB, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.previewPreferences.showPreviewEntryTableTooltip(), (obs, oldValue, newValue) -> this.putBoolean(PREVIEW_IN_ENTRY_TABLE_TOOLTIP, (boolean)newValue));
        this.previewPreferences.getBstPreviewLayoutPaths().addListener(c -> this.storeBstPaths((List<Path>)this.previewPreferences.getBstPreviewLayoutPaths()));
        return this.previewPreferences;
    }

    private void storeBstPaths(List<Path> bstPaths) {
        this.putStringList(PREVIEW_BST_LAYOUT_PATHS, bstPaths.stream().map(Path::toAbsolutePath).map(Path::toString).toList());
    }

    private List<PreviewLayout> getPreviewLayouts(String style) {
        List<String> cycle = this.getStringList(CYCLE_PREVIEW);
        if (cycle.isEmpty()) {
            cycle.add("Preview");
        }
        return cycle.stream().map(layout -> {
            if (CitationStyle.isCitationStyleFile(layout)) {
                BibEntryTypesManager entryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
                return CitationStyle.createCitationStyleFromFile(layout).map(file -> new CitationStylePreviewLayout((CitationStyle)file, entryTypesManager)).orElse(null);
            }
            if (BstPreviewLayout.isBstStyleFile(layout)) {
                return this.getStringList(PREVIEW_BST_LAYOUT_PATHS).stream().filter(path -> path.endsWith((String)layout)).map(x$0 -> Path.of(x$0, new String[0])).map(file -> new BstPreviewLayout((Path)file)).findFirst().orElse(null);
            }
            return new TextBasedPreviewLayout(style, this.getLayoutFormatterPreferences(), (JournalAbbreviationRepository)Injector.instantiateModelOrService(JournalAbbreviationRepository.class));
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void storePreviewLayouts(ObservableList<PreviewLayout> previewCycle) {
        this.putStringList(CYCLE_PREVIEW, previewCycle.stream().map(layout -> {
            if (layout instanceof CitationStylePreviewLayout) {
                CitationStylePreviewLayout citationStyleLayout = (CitationStylePreviewLayout)layout;
                return citationStyleLayout.getFilePath();
            }
            return layout.getDisplayName();
        }).collect(Collectors.toList()));
    }

    private int getPreviewCyclePosition(List<PreviewLayout> layouts) {
        int storedCyclePos = this.getInt(CYCLE_PREVIEW_POS);
        if (storedCyclePos < layouts.size()) {
            return storedCyclePos;
        }
        return 0;
    }

    @Override
    public SidePanePreferences getSidePanePreferences() {
        if (this.sidePanePreferences != null) {
            return this.sidePanePreferences;
        }
        this.sidePanePreferences = new SidePanePreferences(this.getVisibleSidePanes(), this.getSidePanePreferredPositions(), this.getInt(SELECTED_FETCHER_INDEX));
        this.sidePanePreferences.visiblePanes().addListener(listener -> this.storeVisibleSidePanes((Set<SidePaneType>)this.sidePanePreferences.visiblePanes()));
        this.sidePanePreferences.getPreferredPositions().addListener(listener -> this.storeSidePanePreferredPositions((Map<SidePaneType, Integer>)this.sidePanePreferences.getPreferredPositions()));
        EasyBind.listen((ObservableValue)this.sidePanePreferences.webSearchFetcherSelectedProperty(), (obs, oldValue, newValue) -> this.putInt(SELECTED_FETCHER_INDEX, (Number)newValue));
        return this.sidePanePreferences;
    }

    private Set<SidePaneType> getVisibleSidePanes() {
        HashSet<SidePaneType> visiblePanes = new HashSet<SidePaneType>();
        if (this.getBoolean(WEB_SEARCH_VISIBLE)) {
            visiblePanes.add(SidePaneType.WEB_SEARCH);
        }
        if (this.getBoolean(GROUP_SIDEPANE_VISIBLE)) {
            visiblePanes.add(SidePaneType.GROUPS);
        }
        if (this.getBoolean(OO_SHOW_PANEL)) {
            visiblePanes.add(SidePaneType.OPEN_OFFICE);
        }
        return visiblePanes;
    }

    private void storeVisibleSidePanes(Set<SidePaneType> visiblePanes) {
        this.putBoolean(WEB_SEARCH_VISIBLE, visiblePanes.contains((Object)SidePaneType.WEB_SEARCH));
        this.putBoolean(GROUP_SIDEPANE_VISIBLE, visiblePanes.contains((Object)SidePaneType.GROUPS));
        this.putBoolean(OO_SHOW_PANEL, visiblePanes.contains((Object)SidePaneType.OPEN_OFFICE));
    }

    private Map<SidePaneType, Integer> getSidePanePreferredPositions() {
        HashMap<SidePaneType, Integer> preferredPositions = new HashMap<SidePaneType, Integer>();
        List<String> componentNames = this.getStringList(SIDE_PANE_COMPONENT_NAMES);
        List<String> componentPositions = this.getStringList(SIDE_PANE_COMPONENT_PREFERRED_POSITIONS);
        for (int i = 0; i < componentNames.size(); ++i) {
            String name = componentNames.get(i);
            try {
                SidePaneType type = Enum.valueOf(SidePaneType.class, name);
                preferredPositions.put(type, Integer.parseInt(componentPositions.get(i)));
                continue;
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Invalid number format for side pane component '{}'", (Object)name, (Object)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Following component is not a side pane: '{}'", (Object)name, (Object)e);
            }
        }
        return preferredPositions;
    }

    private void storeSidePanePreferredPositions(Map<SidePaneType, Integer> preferredPositions) {
        List<String> names = preferredPositions.keySet().stream().map(Enum::toString).collect(Collectors.toList());
        List<String> positions = preferredPositions.values().stream().map(integer -> Integer.toString(integer)).collect(Collectors.toList());
        this.putStringList(SIDE_PANE_COMPONENT_NAMES, names);
        this.putStringList(SIDE_PANE_COMPONENT_PREFERRED_POSITIONS, positions);
    }

    @Override
    public CleanupPreferences getCleanupPreferences() {
        if (this.cleanupPreferences != null) {
            return this.cleanupPreferences;
        }
        this.cleanupPreferences = new CleanupPreferences(EnumSet.copyOf(this.getStringList(CLEANUP_JOBS).stream().map(CleanupPreferences.CleanupStep::valueOf).collect(Collectors.toSet())), new FieldFormatterCleanups(this.getBoolean(CLEANUP_FIELD_FORMATTERS_ENABLED), FieldFormatterCleanups.parse(StringUtil.unifyLineBreaks(this.get(CLEANUP_FIELD_FORMATTERS), ""))));
        this.cleanupPreferences.getObservableActiveJobs().addListener(c -> this.putStringList(CLEANUP_JOBS, this.cleanupPreferences.getActiveJobs().stream().map(Enum::name).collect(Collectors.toList())));
        EasyBind.listen(this.cleanupPreferences.fieldFormatterCleanupsProperty(), (fieldFormatters, oldValue, newValue) -> {
            this.putBoolean(CLEANUP_FIELD_FORMATTERS_ENABLED, newValue.isEnabled());
            this.put(CLEANUP_FIELD_FORMATTERS, FieldFormatterCleanups.getMetaDataString(newValue.getConfiguredActions(), OS.NEWLINE));
        });
        return this.cleanupPreferences;
    }

    @Override
    public CleanupPreferences getDefaultCleanupPreset() {
        return new CleanupPreferences(JabRefPreferences.getDefaultCleanupJobs(), new FieldFormatterCleanups((Boolean)this.defaults.get(CLEANUP_FIELD_FORMATTERS_ENABLED), FieldFormatterCleanups.parse((String)this.defaults.get(CLEANUP_FIELD_FORMATTERS))));
    }

    private static EnumSet<CleanupPreferences.CleanupStep> getDefaultCleanupJobs() {
        EnumSet<CleanupPreferences.CleanupStep> activeJobs = EnumSet.allOf(CleanupPreferences.CleanupStep.class);
        activeJobs.removeAll(EnumSet.of(CleanupPreferences.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS, CleanupPreferences.CleanupStep.MOVE_PDF, CleanupPreferences.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS, CleanupPreferences.CleanupStep.CONVERT_TO_BIBLATEX, CleanupPreferences.CleanupStep.CONVERT_TO_BIBTEX));
        return activeJobs;
    }

    @Override
    public GuiPreferences getGuiPreferences() {
        if (this.guiPreferences != null) {
            return this.guiPreferences;
        }
        this.guiPreferences = new GuiPreferences(this.getDouble(POS_X), this.getDouble(POS_Y), this.getDouble(SIZE_X), this.getDouble(SIZE_Y), this.getBoolean(WINDOW_MAXIMISED), this.getBoolean(WINDOW_FULLSCREEN), this.getStringList(LAST_EDITED).stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()), Path.of(this.get(LAST_FOCUSED), new String[0]), this.getFileHistory(), this.get(ID_ENTRY_GENERATOR), this.getDouble(SIDE_PANE_WIDTH));
        EasyBind.listen((ObservableValue)this.guiPreferences.positionXProperty(), (obs, oldValue, newValue) -> this.putDouble(POS_X, newValue.doubleValue()));
        EasyBind.listen((ObservableValue)this.guiPreferences.positionYProperty(), (obs, oldValue, newValue) -> this.putDouble(POS_Y, newValue.doubleValue()));
        EasyBind.listen((ObservableValue)this.guiPreferences.sizeXProperty(), (obs, oldValue, newValue) -> this.putDouble(SIZE_X, newValue.doubleValue()));
        EasyBind.listen((ObservableValue)this.guiPreferences.sizeYProperty(), (obs, oldValue, newValue) -> this.putDouble(SIZE_Y, newValue.doubleValue()));
        EasyBind.listen((ObservableValue)this.guiPreferences.windowMaximisedProperty(), (obs, oldValue, newValue) -> this.putBoolean(WINDOW_MAXIMISED, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.guiPreferences.windowFullScreenProperty(), (obs, oldValue, newValue) -> this.putBoolean(WINDOW_FULLSCREEN, (boolean)newValue));
        this.guiPreferences.getLastFilesOpened().addListener(change -> {
            if (change.getList().isEmpty()) {
                this.prefs.remove(LAST_EDITED);
            } else {
                this.putStringList(LAST_EDITED, this.guiPreferences.getLastFilesOpened().stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toList()));
            }
        });
        EasyBind.listen(this.guiPreferences.lastFocusedFileProperty(), (obs, oldValue, newValue) -> {
            if (newValue != null) {
                this.put(LAST_FOCUSED, newValue.toAbsolutePath().toString());
            } else {
                this.remove(LAST_FOCUSED);
            }
        });
        this.guiPreferences.getFileHistory().addListener(change -> this.storeFileHistory(this.guiPreferences.getFileHistory()));
        EasyBind.listen((ObservableValue)this.guiPreferences.lastSelectedIdBasedFetcherProperty(), (obs, oldValue, newValue) -> this.put(ID_ENTRY_GENERATOR, (String)newValue));
        EasyBind.listen((ObservableValue)this.guiPreferences.sidePaneWidthProperty(), (obs, oldValue, newValue) -> this.putDouble(SIDE_PANE_WIDTH, newValue.doubleValue()));
        return this.guiPreferences;
    }

    private FileHistory getFileHistory() {
        return FileHistory.of(this.getStringList(RECENT_DATABASES).stream().map(x$0 -> Path.of(x$0, new String[0])).toList());
    }

    private void storeFileHistory(FileHistory history) {
        this.putStringList(RECENT_DATABASES, history.stream().map(Path::toAbsolutePath).map(Path::toString).toList());
    }

    @Override
    public MergeDialogPreferences getMergeDialogPreferences() {
        if (this.mergeDialogPreferences != null) {
            return this.mergeDialogPreferences;
        }
        this.mergeDialogPreferences = new MergeDialogPreferences(DiffMode.parse(this.get(MERGE_ENTRIES_DIFF_MODE)), this.getBoolean(MERGE_ENTRIES_SHOULD_SHOW_DIFF), this.getBoolean(MERGE_ENTRIES_SHOULD_SHOW_UNIFIED_DIFF), this.getBoolean(MERGE_ENTRIES_HIGHLIGHT_WORDS), this.getBoolean(MERGE_SHOW_ONLY_CHANGED_FIELDS), this.getBoolean(MERGE_APPLY_TO_ALL_ENTRIES), DuplicateResolverDialog.DuplicateResolverResult.parse(this.get(DUPLICATE_RESOLVER_DECISION_RESULT_ALL_ENTRIES)));
        EasyBind.listen(this.mergeDialogPreferences.mergeDiffModeProperty(), (obs, oldValue, newValue) -> this.put(MERGE_ENTRIES_DIFF_MODE, newValue.name()));
        EasyBind.listen((ObservableValue)this.mergeDialogPreferences.mergeShouldShowDiffProperty(), (obs, oldValue, newValue) -> this.putBoolean(MERGE_ENTRIES_SHOULD_SHOW_DIFF, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.mergeDialogPreferences.mergeShouldShowUnifiedDiffProperty(), (obs, oldValue, newValue) -> this.putBoolean(MERGE_ENTRIES_SHOULD_SHOW_UNIFIED_DIFF, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.mergeDialogPreferences.mergeHighlightWordsProperty(), (obs, oldValue, newValue) -> this.putBoolean(MERGE_ENTRIES_HIGHLIGHT_WORDS, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.mergeDialogPreferences.mergeShowChangedFieldOnlyProperty(), (obs, oldValue, newValue) -> this.putBoolean(MERGE_SHOW_ONLY_CHANGED_FIELDS, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.mergeDialogPreferences.mergeApplyToAllEntriesProperty(), (obs, oldValue, newValue) -> this.putBoolean(MERGE_APPLY_TO_ALL_ENTRIES, (boolean)newValue));
        EasyBind.listen(this.mergeDialogPreferences.allEntriesDuplicateResolverDecisionProperty(), (obs, oldValue, newValue) -> this.put(DUPLICATE_RESOLVER_DECISION_RESULT_ALL_ENTRIES, newValue.name()));
        return this.mergeDialogPreferences;
    }

    @Override
    public SearchPreferences getSearchPreferences() {
        SearchDisplayMode searchDisplayMode;
        if (this.searchPreferences != null) {
            return this.searchPreferences;
        }
        try {
            searchDisplayMode = SearchDisplayMode.valueOf(this.get(SEARCH_DISPLAY_MODE));
        }
        catch (IllegalArgumentException ex) {
            searchDisplayMode = SearchDisplayMode.valueOf((String)this.defaults.get(SEARCH_DISPLAY_MODE));
        }
        this.searchPreferences = new SearchPreferences(searchDisplayMode, this.getBoolean(SEARCH_CASE_SENSITIVE), this.getBoolean(SEARCH_REG_EXP), this.getBoolean(SEARCH_FULLTEXT), this.getBoolean(SEARCH_KEEP_SEARCH_STRING), this.getBoolean(SEARCH_KEEP_GLOBAL_WINDOW_ON_TOP), this.getDouble(SEARCH_WINDOW_HEIGHT), this.getDouble(SEARCH_WINDOW_WIDTH));
        EasyBind.listen(this.searchPreferences.searchDisplayModeProperty(), (obs, oldValue, newValue) -> this.put(SEARCH_DISPLAY_MODE, Objects.requireNonNull(this.searchPreferences.getSearchDisplayMode()).toString()));
        this.searchPreferences.getObservableSearchFlags().addListener(c -> {
            this.putBoolean(SEARCH_CASE_SENSITIVE, this.searchPreferences.getObservableSearchFlags().contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE));
            this.putBoolean(SEARCH_REG_EXP, this.searchPreferences.getObservableSearchFlags().contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION));
            this.putBoolean(SEARCH_FULLTEXT, this.searchPreferences.getObservableSearchFlags().contains((Object)SearchRules.SearchFlags.FULLTEXT));
            this.putBoolean(SEARCH_KEEP_SEARCH_STRING, this.searchPreferences.getObservableSearchFlags().contains((Object)SearchRules.SearchFlags.KEEP_SEARCH_STRING));
        });
        EasyBind.listen((ObservableValue)this.searchPreferences.keepWindowOnTopProperty(), (obs, oldValue, newValue) -> this.putBoolean(SEARCH_KEEP_GLOBAL_WINDOW_ON_TOP, this.searchPreferences.shouldKeepWindowOnTop()));
        EasyBind.listen((ObservableValue)this.searchPreferences.getSearchWindowHeightProperty(), (obs, oldValue, newValue) -> this.putDouble(SEARCH_WINDOW_HEIGHT, this.searchPreferences.getSearchWindowHeight()));
        EasyBind.listen((ObservableValue)this.searchPreferences.getSearchWindowWidthProperty(), (obs, oldValue, newValue) -> this.putDouble(SEARCH_WINDOW_WIDTH, this.searchPreferences.getSearchWindowWidth()));
        return this.searchPreferences;
    }

    @Override
    public XmpPreferences getXmpPreferences() {
        if (this.xmpPreferences != null) {
            return this.xmpPreferences;
        }
        this.xmpPreferences = new XmpPreferences(this.getBoolean(USE_XMP_PRIVACY_FILTER), this.getStringList(XMP_PRIVACY_FILTERS).stream().map(FieldFactory::parseField).collect(Collectors.toSet()), this.getBibEntryPreferences().keywordSeparatorProperty());
        EasyBind.listen((ObservableValue)this.xmpPreferences.useXmpPrivacyFilterProperty(), (obs, oldValue, newValue) -> this.putBoolean(USE_XMP_PRIVACY_FILTER, (boolean)newValue));
        this.xmpPreferences.getXmpPrivacyFilter().addListener(c -> this.putStringList(XMP_PRIVACY_FILTERS, this.xmpPreferences.getXmpPrivacyFilter().stream().map(Field::getName).collect(Collectors.toList())));
        return this.xmpPreferences;
    }

    @Override
    public NameFormatterPreferences getNameFormatterPreferences() {
        if (this.nameFormatterPreferences != null) {
            return this.nameFormatterPreferences;
        }
        this.nameFormatterPreferences = new NameFormatterPreferences(this.getStringList(NAME_FORMATER_KEY), this.getStringList(NAME_FORMATTER_VALUE));
        this.nameFormatterPreferences.getNameFormatterKey().addListener(change -> this.putStringList(NAME_FORMATER_KEY, (List<String>)this.nameFormatterPreferences.getNameFormatterKey()));
        this.nameFormatterPreferences.getNameFormatterValue().addListener(change -> this.putStringList(NAME_FORMATTER_VALUE, (List<String>)this.nameFormatterPreferences.getNameFormatterValue()));
        return this.nameFormatterPreferences;
    }

    @Override
    public AutoCompletePreferences getAutoCompletePreferences() {
        if (this.autoCompletePreferences != null) {
            return this.autoCompletePreferences;
        }
        AutoCompletePreferences.NameFormat nameFormat = AutoCompletePreferences.NameFormat.BOTH;
        if (this.getBoolean(AUTOCOMPLETER_LAST_FIRST)) {
            nameFormat = AutoCompletePreferences.NameFormat.LAST_FIRST;
        } else if (this.getBoolean(AUTOCOMPLETER_FIRST_LAST)) {
            nameFormat = AutoCompletePreferences.NameFormat.FIRST_LAST;
        }
        this.autoCompletePreferences = new AutoCompletePreferences(this.getBoolean(AUTO_COMPLETE), AutoCompleteFirstNameMode.parse(this.get(AUTOCOMPLETER_FIRSTNAME_MODE)), nameFormat, this.getStringList(AUTOCOMPLETER_COMPLETE_FIELDS).stream().map(FieldFactory::parseField).collect(Collectors.toSet()));
        EasyBind.listen((ObservableValue)this.autoCompletePreferences.autoCompleteProperty(), (obs, oldValue, newValue) -> this.putBoolean(AUTO_COMPLETE, (boolean)newValue));
        EasyBind.listen(this.autoCompletePreferences.firstNameModeProperty(), (obs, oldValue, newValue) -> this.put(AUTOCOMPLETER_FIRSTNAME_MODE, newValue.name()));
        this.autoCompletePreferences.getCompleteFields().addListener(c -> this.putStringList(AUTOCOMPLETER_COMPLETE_FIELDS, this.autoCompletePreferences.getCompleteFields().stream().map(Field::getName).collect(Collectors.toList())));
        EasyBind.listen(this.autoCompletePreferences.nameFormatProperty(), (obs, oldValue, newValue) -> {
            if (this.autoCompletePreferences.getNameFormat() == AutoCompletePreferences.NameFormat.BOTH) {
                this.putBoolean(AUTOCOMPLETER_LAST_FIRST, false);
                this.putBoolean(AUTOCOMPLETER_FIRST_LAST, false);
            } else if (this.autoCompletePreferences.getNameFormat() == AutoCompletePreferences.NameFormat.LAST_FIRST) {
                this.putBoolean(AUTOCOMPLETER_LAST_FIRST, true);
                this.putBoolean(AUTOCOMPLETER_FIRST_LAST, false);
            } else {
                this.putBoolean(AUTOCOMPLETER_LAST_FIRST, false);
                this.putBoolean(AUTOCOMPLETER_FIRST_LAST, true);
            }
        });
        return this.autoCompletePreferences;
    }

    @Override
    public SpecialFieldsPreferences getSpecialFieldsPreferences() {
        if (this.specialFieldsPreferences != null) {
            return this.specialFieldsPreferences;
        }
        this.specialFieldsPreferences = new SpecialFieldsPreferences(this.getBoolean(SPECIALFIELDSENABLED));
        EasyBind.listen((ObservableValue)this.specialFieldsPreferences.specialFieldsEnabledProperty(), (obs, oldValue, newValue) -> this.putBoolean(SPECIALFIELDSENABLED, (boolean)newValue));
        return this.specialFieldsPreferences;
    }

    @Override
    public MrDlibPreferences getMrDlibPreferences() {
        if (this.mrDlibPreferences != null) {
            return this.mrDlibPreferences;
        }
        this.mrDlibPreferences = new MrDlibPreferences(this.getBoolean(ACCEPT_RECOMMENDATIONS), this.getBoolean(SEND_LANGUAGE_DATA), this.getBoolean(SEND_OS_DATA), this.getBoolean(SEND_TIMEZONE_DATA));
        EasyBind.listen((ObservableValue)this.mrDlibPreferences.acceptRecommendationsProperty(), (obs, oldValue, newValue) -> this.putBoolean(ACCEPT_RECOMMENDATIONS, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.mrDlibPreferences.sendLanguageProperty(), (obs, oldValue, newValue) -> this.putBoolean(SEND_LANGUAGE_DATA, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.mrDlibPreferences.sendOsProperty(), (obs, oldValue, newValue) -> this.putBoolean(SEND_OS_DATA, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.mrDlibPreferences.sendTimezoneProperty(), (obs, oldValue, newValue) -> this.putBoolean(SEND_TIMEZONE_DATA, (boolean)newValue));
        return this.mrDlibPreferences;
    }

    @Override
    public ProtectedTermsPreferences getProtectedTermsPreferences() {
        if (this.protectedTermsPreferences != null) {
            return this.protectedTermsPreferences;
        }
        this.protectedTermsPreferences = new ProtectedTermsPreferences(this.getStringList(PROTECTED_TERMS_ENABLED_INTERNAL), this.getStringList(PROTECTED_TERMS_ENABLED_EXTERNAL), this.getStringList(PROTECTED_TERMS_DISABLED_INTERNAL), this.getStringList(PROTECTED_TERMS_DISABLED_EXTERNAL));
        this.protectedTermsPreferences.getEnabledExternalTermLists().addListener(change -> this.putStringList(PROTECTED_TERMS_ENABLED_EXTERNAL, (List<String>)this.protectedTermsPreferences.getEnabledExternalTermLists()));
        this.protectedTermsPreferences.getDisabledExternalTermLists().addListener(change -> this.putStringList(PROTECTED_TERMS_DISABLED_EXTERNAL, (List<String>)this.protectedTermsPreferences.getDisabledExternalTermLists()));
        this.protectedTermsPreferences.getEnabledInternalTermLists().addListener(change -> this.putStringList(PROTECTED_TERMS_ENABLED_INTERNAL, (List<String>)this.protectedTermsPreferences.getEnabledInternalTermLists()));
        this.protectedTermsPreferences.getDisabledInternalTermLists().addListener(change -> this.putStringList(PROTECTED_TERMS_DISABLED_INTERNAL, (List<String>)this.protectedTermsPreferences.getDisabledInternalTermLists()));
        return this.protectedTermsPreferences;
    }

    @Override
    public ImporterPreferences getImporterPreferences() {
        if (this.importerPreferences != null) {
            return this.importerPreferences;
        }
        this.importerPreferences = new ImporterPreferences(this.getBoolean(IMPORTERS_ENABLED), this.getBoolean(GENERATE_KEY_ON_IMPORT), Path.of(this.get(IMPORT_WORKING_DIRECTORY), new String[0]), this.getBoolean(WARN_ABOUT_DUPLICATES_IN_INSPECTION), this.getCustomImportFormats(), this.getFetcherKeys(), this.getBoolean(FETCHER_CUSTOM_KEY_PERSIST), this.getStringList(SEARCH_CATALOGS));
        EasyBind.listen((ObservableValue)this.importerPreferences.importerEnabledProperty(), (obs, oldValue, newValue) -> this.putBoolean(IMPORTERS_ENABLED, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.importerPreferences.generateNewKeyOnImportProperty(), (obs, oldValue, newValue) -> this.putBoolean(GENERATE_KEY_ON_IMPORT, (boolean)newValue));
        EasyBind.listen(this.importerPreferences.importWorkingDirectoryProperty(), (obs, oldValue, newValue) -> this.put(IMPORT_WORKING_DIRECTORY, newValue.toString()));
        EasyBind.listen((ObservableValue)this.importerPreferences.warnAboutDuplicatesOnImportProperty(), (obs, oldValue, newValue) -> this.putBoolean(WARN_ABOUT_DUPLICATES_IN_INSPECTION, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.importerPreferences.persistCustomKeysProperty(), (obs, oldValue, newValue) -> this.putBoolean(FETCHER_CUSTOM_KEY_PERSIST, (boolean)newValue));
        this.importerPreferences.getApiKeys().addListener(c -> this.storeFetcherKeys((Set<FetcherApiKey>)this.importerPreferences.getApiKeys()));
        this.importerPreferences.getCustomImporters().addListener(c -> this.storeCustomImportFormats((Set<CustomImporter>)this.importerPreferences.getCustomImporters()));
        this.importerPreferences.getCatalogs().addListener(c -> this.putStringList(SEARCH_CATALOGS, (List<String>)this.importerPreferences.getCatalogs()));
        return this.importerPreferences;
    }

    private Set<CustomImporter> getCustomImportFormats() {
        TreeSet<CustomImporter> importers = new TreeSet<CustomImporter>();
        for (String toImport : this.getSeries(CUSTOM_IMPORT_FORMAT)) {
            List<String> importerString = JabRefPreferences.convertStringToList(toImport);
            try {
                if (importerString.size() == 2) {
                    importers.add(new CustomImporter(importerString.getFirst(), importerString.get(1)));
                    continue;
                }
                importers.add(new CustomImporter(importerString.get(3), importerString.get(2)));
            }
            catch (Exception e) {
                LOGGER.warn("Could not load {} from preferences. Will ignore.", (Object)importerString.getFirst(), (Object)e);
            }
        }
        return importers;
    }

    private void storeCustomImportFormats(Set<CustomImporter> importers) {
        this.purgeSeries(CUSTOM_IMPORT_FORMAT, 0);
        CustomImporter[] importersArray = importers.toArray(new CustomImporter[0]);
        for (int i = 0; i < importersArray.length; ++i) {
            this.putStringList(CUSTOM_IMPORT_FORMAT + i, importersArray[i].getAsStringList());
        }
    }

    private Set<FetcherApiKey> getFetcherKeys() {
        HashSet<FetcherApiKey> fetcherApiKeys = new HashSet<FetcherApiKey>();
        List<String> names = this.getStringList(FETCHER_CUSTOM_KEY_NAMES);
        List<String> uses = this.getStringList(FETCHER_CUSTOM_KEY_USES);
        List<String> keys = this.getFetcherKeysFromKeyring(names);
        for (int i = 0; i < names.size(); ++i) {
            fetcherApiKeys.add(new FetcherApiKey(names.get(i), i < uses.size() && Boolean.parseBoolean(uses.get(i)), i < keys.size() ? keys.get(i) : ""));
        }
        return fetcherApiKeys;
    }

    private List<String> getFetcherKeysFromKeyring(List<String> names) {
        ArrayList<String> keys = new ArrayList<String>();
        try (Keyring keyring = Keyring.create();){
            for (String fetcher : names) {
                try {
                    keys.add(new Password(keyring.getPassword("org.jabref.customapikeys", fetcher), this.getInternalPreferences().getUserAndHost()).decrypt());
                }
                catch (PasswordAccessException ex) {
                    LOGGER.debug("No api key stored for {} fetcher", (Object)fetcher);
                    keys.add("");
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("JabRef could not open the key store");
        }
        return keys;
    }

    private void storeFetcherKeys(Set<FetcherApiKey> fetcherApiKeys) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> uses = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        for (FetcherApiKey apiKey : fetcherApiKeys) {
            names.add(apiKey.getName());
            uses.add(String.valueOf(apiKey.shouldUse()));
            keys.add(apiKey.getKey());
        }
        this.putStringList(FETCHER_CUSTOM_KEY_NAMES, names);
        this.putStringList(FETCHER_CUSTOM_KEY_USES, uses);
        if (this.getBoolean(FETCHER_CUSTOM_KEY_PERSIST)) {
            this.storeFetcherKeysToKeyring(names, keys);
        } else {
            this.clearCustomFetcherKeys();
        }
    }

    private void storeFetcherKeysToKeyring(List<String> names, List<String> keys) {
        try (Keyring keyring = Keyring.create();){
            for (int i = 0; i < names.size(); ++i) {
                if (StringUtil.isNullOrEmpty(keys.get(i))) {
                    try {
                        keyring.deletePassword("org.jabref.customapikeys", names.get(i));
                    }
                    catch (PasswordAccessException passwordAccessException) {}
                    continue;
                }
                keyring.setPassword("org.jabref.customapikeys", names.get(i), new Password(keys.get(i), this.getInternalPreferences().getUserAndHost()).encrypt());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to open key store", (Throwable)ex);
        }
    }

    private void clearCustomFetcherKeys() {
        List<String> names = this.getStringList(FETCHER_CUSTOM_KEY_NAMES);
        try (Keyring keyring = Keyring.create();){
            try {
                for (String name : names) {
                    keyring.deletePassword("org.jabref.customapikeys", name);
                }
            }
            catch (PasswordAccessException passwordAccessException) {
                // empty catch block
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to open key store");
        }
    }

    @Override
    public GrobidPreferences getGrobidPreferences() {
        if (this.grobidPreferences != null) {
            return this.grobidPreferences;
        }
        this.grobidPreferences = new GrobidPreferences(this.getBoolean(GROBID_ENABLED), this.getBoolean(GROBID_OPT_OUT), this.get(GROBID_URL));
        EasyBind.listen((ObservableValue)this.grobidPreferences.grobidEnabledProperty(), (obs, oldValue, newValue) -> this.putBoolean(GROBID_ENABLED, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.grobidPreferences.grobidOptOutProperty(), (obs, oldValue, newValue) -> this.putBoolean(GROBID_OPT_OUT, (boolean)newValue));
        EasyBind.listen((ObservableValue)this.grobidPreferences.grobidURLProperty(), (obs, oldValue, newValue) -> this.put(GROBID_URL, (String)newValue));
        return this.grobidPreferences;
    }

    @Override
    public ImportFormatPreferences getImportFormatPreferences() {
        return new ImportFormatPreferences(this.getBibEntryPreferences(), this.getCitationKeyPatternPreferences(), this.getFieldPreferences(), this.getXmpPreferences(), this.getDOIPreferences(), this.getGrobidPreferences());
    }
}

