/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.util.EnumSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.jabref.gui.search.SearchDisplayMode;
import org.jabref.model.search.rules.SearchRules;

public class SearchPreferences {
    private final ObjectProperty<SearchDisplayMode> searchDisplayMode;
    private final ObservableSet<SearchRules.SearchFlags> searchFlags;
    private final BooleanProperty keepWindowOnTop;
    private final DoubleProperty searchWindowHeight = new SimpleDoubleProperty();
    private final DoubleProperty searchWindowWidth = new SimpleDoubleProperty();

    public SearchPreferences(SearchDisplayMode searchDisplayMode, boolean isCaseSensitive, boolean isRegularExpression, boolean isFulltext, boolean isKeepSearchString, boolean keepWindowOnTop, double searchWindowHeight, double searchWindowWidth) {
        this.searchDisplayMode = new SimpleObjectProperty((Object)searchDisplayMode);
        this.keepWindowOnTop = new SimpleBooleanProperty(keepWindowOnTop);
        this.searchFlags = FXCollections.observableSet(EnumSet.noneOf(SearchRules.SearchFlags.class));
        if (isCaseSensitive) {
            this.searchFlags.add((Object)SearchRules.SearchFlags.CASE_SENSITIVE);
        }
        if (isRegularExpression) {
            this.searchFlags.add((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION);
        }
        if (isFulltext) {
            this.searchFlags.add((Object)SearchRules.SearchFlags.FULLTEXT);
        }
        if (isKeepSearchString) {
            this.searchFlags.add((Object)SearchRules.SearchFlags.KEEP_SEARCH_STRING);
        }
        this.setSearchWindowHeight(searchWindowHeight);
        this.setSearchWindowWidth(searchWindowWidth);
    }

    public SearchPreferences(SearchDisplayMode searchDisplayMode, EnumSet<SearchRules.SearchFlags> searchFlags, boolean keepWindowOnTop) {
        this.searchDisplayMode = new SimpleObjectProperty((Object)searchDisplayMode);
        this.keepWindowOnTop = new SimpleBooleanProperty(keepWindowOnTop);
        this.searchFlags = FXCollections.observableSet(searchFlags);
    }

    public EnumSet<SearchRules.SearchFlags> getSearchFlags() {
        if (this.searchFlags.isEmpty()) {
            return EnumSet.noneOf(SearchRules.SearchFlags.class);
        }
        return EnumSet.copyOf(this.searchFlags);
    }

    protected ObservableSet<SearchRules.SearchFlags> getObservableSearchFlags() {
        return this.searchFlags;
    }

    public SearchDisplayMode getSearchDisplayMode() {
        return (SearchDisplayMode)((Object)this.searchDisplayMode.get());
    }

    public ObjectProperty<SearchDisplayMode> searchDisplayModeProperty() {
        return this.searchDisplayMode;
    }

    public void setSearchDisplayMode(SearchDisplayMode searchDisplayMode) {
        this.searchDisplayMode.set((Object)searchDisplayMode);
    }

    public boolean isCaseSensitive() {
        return this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE);
    }

    public void setSearchFlag(SearchRules.SearchFlags flag, boolean value) {
        if (this.searchFlags.contains((Object)flag) && !value) {
            this.searchFlags.remove((Object)flag);
        } else if (!this.searchFlags.contains((Object)flag) && value) {
            this.searchFlags.add((Object)flag);
        }
    }

    public boolean isRegularExpression() {
        return this.searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION);
    }

    public boolean isFulltext() {
        return this.searchFlags.contains((Object)SearchRules.SearchFlags.FULLTEXT);
    }

    public boolean shouldKeepSearchString() {
        return this.searchFlags.contains((Object)SearchRules.SearchFlags.KEEP_SEARCH_STRING);
    }

    public boolean shouldKeepWindowOnTop() {
        return this.keepWindowOnTop.get();
    }

    public BooleanProperty keepWindowOnTopProperty() {
        return this.keepWindowOnTop;
    }

    public void setKeepWindowOnTop(boolean keepWindowOnTop) {
        this.keepWindowOnTop.set(keepWindowOnTop);
    }

    public double getSearchWindowHeight() {
        return this.searchWindowHeight.get();
    }

    public double getSearchWindowWidth() {
        return this.searchWindowWidth.get();
    }

    public DoubleProperty getSearchWindowHeightProperty() {
        return this.searchWindowHeight;
    }

    public DoubleProperty getSearchWindowWidthProperty() {
        return this.searchWindowWidth;
    }

    public void setSearchWindowHeight(double height) {
        this.searchWindowHeight.set(height);
    }

    public void setSearchWindowWidth(double width) {
        this.searchWindowWidth.set(width);
    }
}

