/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary2;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.TextObject;
import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.mathml.MathMLOperatorElement;
import org.w3c.dom.mathml.MathMLScriptElement;
import org.w3c.dom.mathml.MathMLUnderOverElement;

public final class Mo
extends AbstractJEuclidElement
implements MathMLOperatorElement,
EventListener {
    public static final String ATTR_FORM = "form";
    public static final String ATTR_SEPARATOR = "separator";
    public static final String ATTR_LSPACE = "lspace";
    public static final String ATTR_RSPACE = "rspace";
    public static final String ATTR_MINSIZE = "minsize";
    public static final String ATTR_MAXSIZE = "maxsize";
    public static final String ATTR_MOVEABLEWRONG = "moveablelimits";
    public static final String ATTR_MOVABLELIMITS = "movablelimits";
    public static final String ATTR_ACCENT = "accent";
    public static final String ELEMENT = "mo";
    public static final float LARGEOP_CORRECTOR_INLINE = 1.2f;
    public static final float LARGEOP_CORRECTOR_BLOCK = 1.5f;
    public static final String ATTR_STRETCHY = "stretchy";
    public static final String VALUE_STRETCHY_HORIZONTAL = "horizontal";
    public static final String VALUE_STRETCHY_VERTICAL = "vertical";
    public static final String ATTR_LARGEOP = "largeop";
    public static final String ATTR_SYMMETRIC = "symmetric";
    public static final String ATTR_FENCE = "fence";
    public static final String MOEVENT = "MOEvent";
    private static final long serialVersionUID = 1L;
    private final OperatorDictionary opDict;
    private boolean inChangeHook;

    public Mo(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.setDefaultMathAttribute(ATTR_FORM, "infix");
        this.setDefaultMathAttribute(ATTR_FENCE, "false");
        this.setDefaultMathAttribute(ATTR_SEPARATOR, "false");
        this.setDefaultMathAttribute(ATTR_LSPACE, "0.277778em");
        this.setDefaultMathAttribute(ATTR_RSPACE, "0.277778em");
        this.setDefaultMathAttribute(ATTR_STRETCHY, "false");
        this.setDefaultMathAttribute(ATTR_SYMMETRIC, "true");
        this.setDefaultMathAttribute(ATTR_MAXSIZE, "9999999pt");
        this.setDefaultMathAttribute(ATTR_MINSIZE, "1");
        this.setDefaultMathAttribute(ATTR_LARGEOP, "false");
        this.setDefaultMathAttribute(ATTR_MOVABLELIMITS, "false");
        this.setDefaultMathAttribute(ATTR_ACCENT, "false");
        this.opDict = OperatorDictionary2.getInstance();
    }

    protected Node newNode() {
        return new Mo(this.nodeName, this.ownerDocument);
    }

    private float getLspaceAsFloat(LayoutContext layoutContext) {
        if ((Integer)layoutContext.getParameter(Parameter.SCRIPTLEVEL) > 0) {
            return 0.0f;
        }
        return AttributesHelper.convertSizeToPt(this.getLspace(), layoutContext, "pt");
    }

    public float getLargeOpCorrector(LayoutContext layoutContext) {
        if (Display.BLOCK.equals(layoutContext.getParameter(Parameter.DISPLAY))) {
            return 1.5f;
        }
        return 1.2f;
    }

    private float getRspaceAsFloat(LayoutContext layoutContext) {
        if ((Integer)layoutContext.getParameter(Parameter.SCRIPTLEVEL) > 0) {
            return 0.0f;
        }
        return AttributesHelper.convertSizeToPt(this.getRspace(), layoutContext, "pt");
    }

    private boolean isFence() {
        return Boolean.parseBoolean(this.getFence());
    }

    @Override
    public void setMaxsize(String string) {
        this.setAttribute(ATTR_MAXSIZE, string);
    }

    @Override
    public String getMaxsize() {
        return this.getMathAttribute(ATTR_MAXSIZE);
    }

    @Override
    public void setMinsize(String string) {
        this.setAttribute(ATTR_MINSIZE, string);
    }

    @Override
    public String getMinsize() {
        return this.getMathAttribute(ATTR_MINSIZE);
    }

    private TextLayout produceUnstrechtedLayout(Graphics2D graphics2D, LayoutContext layoutContext) {
        assert (graphics2D != null) : "Graphics2d is null in produceUnstrechtedLayout";
        float f = GraphicsSupport.getFontsizeInPoint(layoutContext);
        if (Boolean.parseBoolean(this.getLargeop())) {
            f *= this.getLargeOpCorrector(layoutContext);
        }
        String string = this.getText();
        AttributedString attributedString = StringUtil.convertStringtoAttributedString(string, this.getMathvariantAsVariant(), f, layoutContext);
        TextLayout textLayout = StringUtil.createTextLayoutFromAttributedString(graphics2D, attributedString, layoutContext);
        return textLayout;
    }

    @Override
    public void changeHook() {
        super.changeHook();
        if (!this.inChangeHook) {
            this.inChangeHook = true;
            this.detectFormParameter();
            this.loadAttributeFromDictionary(ATTR_LARGEOP, "false");
            this.loadAttributeFromDictionary(ATTR_SYMMETRIC, "true");
            this.loadAttributeFromDictionary(ATTR_STRETCHY, "false");
            this.loadAttributeFromDictionary(ATTR_FENCE, "false");
            this.loadAttributeFromDictionary(ATTR_LSPACE, "0.277778em");
            this.loadAttributeFromDictionary(ATTR_RSPACE, "0.277778em");
            this.loadAttributeFromDictionary(ATTR_MOVABLELIMITS, "false");
            this.registerWithParentsForEvents();
            if (this.isFence()) {
                this.setDefaultMathAttribute(ATTR_STRETCHY, VALUE_STRETCHY_VERTICAL);
            }
            this.inChangeHook = false;
        }
    }

    private void registerWithParentsForEvents() {
        JEuclidElement jEuclidElement = this.getParent();
        while (jEuclidElement != null) {
            if (jEuclidElement instanceof EventTarget) {
                ((EventTarget)((Object)jEuclidElement)).addEventListener("DOMSubtreeModified", this, false);
            }
            if (jEuclidElement instanceof Mrow && jEuclidElement.getMathElementCount() > 1) {
                jEuclidElement = null;
                continue;
            }
            jEuclidElement = jEuclidElement.getParent();
        }
    }

    private void loadAttributeFromDictionary(String string, String string2) {
        String string3;
        try {
            string3 = this.opDict.getDefaultAttributeValue(this.getText(), this.getForm(), string);
        }
        catch (UnknownAttributeException unknownAttributeException) {
            string3 = string2;
        }
        if (string3.equals("NULL")) {
            string3 = string2;
        }
        this.setDefaultMathAttribute(string, string3);
    }

    private void detectFormParameter() {
        int n;
        JEuclidElement jEuclidElement = this.getParent();
        String string = jEuclidElement != null && jEuclidElement instanceof Mrow ? ((n = jEuclidElement.getIndexOfMathElement(this)) == 0 && jEuclidElement.getMathElementCount() > 0 ? "prefix" : (n == jEuclidElement.getMathElementCount() - 1 && jEuclidElement.getMathElementCount() > 0 ? "postfix" : "infix")) : "infix";
        this.setDefaultMathAttribute(ATTR_FORM, string);
    }

    @Override
    public String getLargeop() {
        return this.getMathAttribute(ATTR_LARGEOP);
    }

    @Override
    public String getLspace() {
        return this.getMathAttribute(ATTR_LSPACE);
    }

    @Override
    public String getMovablelimits() {
        String string = this.getMathAttribute(ATTR_MOVEABLEWRONG, false);
        if (string == null) {
            return this.getMathAttribute(ATTR_MOVABLELIMITS);
        }
        return string;
    }

    @Override
    public String getRspace() {
        return this.getMathAttribute(ATTR_RSPACE);
    }

    @Override
    public void setAccent(String string) {
        this.setAttribute(ATTR_ACCENT, string);
    }

    @Override
    public void setFence(String string) {
        this.setAttribute(ATTR_FENCE, string);
    }

    @Override
    public void setForm(String string) {
        this.setAttribute(ATTR_FORM, string);
    }

    @Override
    public void setLargeop(String string) {
        this.setAttribute(ATTR_LARGEOP, string);
    }

    @Override
    public void setLspace(String string) {
        this.setAttribute(ATTR_LSPACE, string);
    }

    @Override
    public void setMovablelimits(String string) {
        this.setAttribute(ATTR_MOVABLELIMITS, string);
    }

    @Override
    public void setRspace(String string) {
        this.setAttribute(ATTR_RSPACE, string);
    }

    @Override
    public void setSeparator(String string) {
        this.setAttribute(ATTR_SEPARATOR, string);
    }

    @Override
    public void setStretchy(String string) {
        this.setAttribute(ATTR_STRETCHY, string);
    }

    @Override
    public void setSymmetric(String string) {
        this.setAttribute(ATTR_SYMMETRIC, string);
    }

    @Override
    public String getFence() {
        return this.getMathAttribute(ATTR_FENCE);
    }

    @Override
    public String getForm() {
        return this.getMathAttribute(ATTR_FORM);
    }

    @Override
    public String getSeparator() {
        return this.getMathAttribute(ATTR_SEPARATOR);
    }

    public String getExtendedStretchy() {
        Attr attr = this.getAttributeNodeNS("http://jeuclid.sf.net/ns/ext", ATTR_STRETCHY);
        String string = attr == null ? this.getMathAttribute(ATTR_STRETCHY) : attr.getValue().trim();
        return string;
    }

    @Override
    public String getStretchy() {
        String string = this.getExtendedStretchy();
        if (VALUE_STRETCHY_HORIZONTAL.equalsIgnoreCase(string) || VALUE_STRETCHY_VERTICAL.equalsIgnoreCase(string)) {
            return "true";
        }
        return string;
    }

    private boolean isStretchyHorizontal(String string) {
        return VALUE_STRETCHY_HORIZONTAL.equalsIgnoreCase(string) || Boolean.parseBoolean(string);
    }

    private boolean isStretchyVertical(String string) {
        return VALUE_STRETCHY_VERTICAL.equalsIgnoreCase(string) || Boolean.parseBoolean(string);
    }

    private boolean isStretchy() {
        String string = this.getExtendedStretchy();
        return this.isStretchyHorizontal(string) || this.isStretchyVertical(string);
    }

    @Override
    public String getAccent() {
        return this.getMathAttribute(ATTR_ACCENT);
    }

    @Override
    public String getSymmetric() {
        return this.getMathAttribute(ATTR_SYMMETRIC);
    }

    private boolean isSymmetric() {
        return Boolean.parseBoolean(this.getSymmetric());
    }

    @Override
    public void layoutStage1(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        Graphics2D graphics2D = layoutView.getGraphics();
        TextLayout textLayout = this.produceUnstrechtedLayout(graphics2D, layoutContext2);
        StringUtil.TextLayoutInfo textLayoutInfo = StringUtil.getTextLayoutInfo(textLayout, true);
        float f = textLayoutInfo.getAscent();
        float f2 = textLayoutInfo.getDescent();
        float f3 = textLayoutInfo.getOffset();
        float f4 = textLayoutInfo.getWidth() + f3;
        JEuclidElement jEuclidElement = this.getParent();
        float f5 = this.getLspaceAsFloat(layoutContext2);
        float f6 = this.getRspaceAsFloat(layoutContext2);
        f6 = jEuclidElement != null && jEuclidElement.hasChildPostscripts(this, layoutContext) ? 0.0f : this.getRspaceAsFloat(layoutContext2);
        f5 = jEuclidElement != null && jEuclidElement.hasChildPrescripts(this) ? 0.0f : this.getLspaceAsFloat(layoutContext2);
        layoutInfo.setAscentHeight(f, LayoutStage.STAGE1);
        layoutInfo.setDescentHeight(f2, LayoutStage.STAGE1);
        layoutInfo.setHorizontalCenterOffset(f5 + f4 / 2.0f, LayoutStage.STAGE1);
        layoutInfo.setWidth(f5 + f4 + f6, LayoutStage.STAGE1);
        if (this.isStretchy()) {
            layoutInfo.setLayoutStage(LayoutStage.STAGE1);
            layoutInfo.setStretchAscent(0.0f);
            layoutInfo.setStretchDescent(0.0f);
        } else {
            layoutInfo.setGraphicsObject(new TextObject(textLayout, f5 + textLayoutInfo.getOffset(), 0.0f, null, (Color)layoutContext2.getParameter(Parameter.MATHCOLOR)));
            layoutInfo.setLayoutStage(LayoutStage.STAGE2);
        }
    }

    @Override
    public void layoutStage2(LayoutView layoutView, LayoutInfo layoutInfo, LayoutContext layoutContext) {
        float f;
        float f2;
        float f3;
        Object object;
        boolean bl;
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        Graphics2D graphics2D = layoutView.getGraphics();
        TextLayout textLayout = this.produceUnstrechtedLayout(graphics2D, layoutContext2);
        String string = this.getExtendedStretchy();
        boolean bl2 = this.isStretchyVertical(string);
        boolean bl3 = this.isStretchyHorizontal(string);
        JEuclidElement jEuclidElement = null;
        JEuclidElement jEuclidElement2 = this;
        do {
            boolean bl4;
            Mo mo = jEuclidElement2;
            jEuclidElement2 = jEuclidElement2.getParent();
            bl = false;
            if (jEuclidElement2 instanceof Mrow && jEuclidElement2.getMathElementCount() == 1) {
                bl = true;
                continue;
            }
            if (!(jEuclidElement2 instanceof MathMLUnderOverElement) && !(jEuclidElement2 instanceof MathMLScriptElement)) continue;
            if (jEuclidElement2 instanceof MathMLUnderOverElement) {
                object = (MathMLUnderOverElement)((Object)jEuclidElement2);
                bl4 = object.getBase() == mo;
            } else {
                object = (MathMLScriptElement)((Object)jEuclidElement2);
                boolean bl5 = bl4 = object.getBase() == mo;
            }
            if (!bl4) {
                bl2 = false;
            }
            jEuclidElement = jEuclidElement2;
            bl = true;
        } while (bl);
        if (jEuclidElement == null) {
            jEuclidElement = jEuclidElement2;
        }
        LayoutInfo layoutInfo2 = layoutView.getInfo(jEuclidElement2);
        object = StringUtil.getTextLayoutInfo(textLayout, true);
        if (layoutInfo2 == null) {
            f3 = 1.0f;
            f2 = 1.0f;
            f = 0.0f;
        } else {
            if (bl2) {
                float[] fArray = this.calcYScaleFactorAndBaselineShift(layoutInfo, layoutInfo2, (StringUtil.TextLayoutInfo)object, layoutContext2, graphics2D);
                f2 = fArray[0];
                f = fArray[1];
            } else {
                f2 = 1.0f;
                f = 0.0f;
            }
            f3 = bl3 ? this.calcXScaleFactor(layoutInfo, layoutView.getInfo(jEuclidElement), (StringUtil.TextLayoutInfo)object) : 1.0f;
        }
        layoutInfo.setGraphicsObject(new TextObject(textLayout, this.getLspaceAsFloat(layoutContext2) + ((StringUtil.TextLayoutInfo)object).getOffset() * f3, f, AffineTransform.getScaleInstance(f3, f2), (Color)layoutContext2.getParameter(Parameter.MATHCOLOR)));
        layoutInfo.setLayoutStage(LayoutStage.STAGE2);
    }

    private float calcXScaleFactor(LayoutInfo layoutInfo, LayoutInfo layoutInfo2, StringUtil.TextLayoutInfo textLayoutInfo) {
        float f;
        float f2 = layoutInfo2.getStretchWidth();
        if (f2 > 0.0f) {
            float f3 = textLayoutInfo.getWidth();
            if (f3 > 0.0f) {
                float f4 = Math.max(f3, f2);
                f = f4 / f3;
                layoutInfo.setWidth(f4, LayoutStage.STAGE2);
                layoutInfo.setHorizontalCenterOffset(f4 / 2.0f, LayoutStage.STAGE2);
            } else {
                f = 1.0f;
            }
        } else {
            f = 1.0f;
        }
        return f;
    }

    private float[] calcYScaleFactorAndBaselineShift(LayoutInfo layoutInfo, LayoutInfo layoutInfo2, StringUtil.TextLayoutInfo textLayoutInfo, LayoutContext layoutContext, Graphics2D graphics2D) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7 = textLayoutInfo.getDescent();
        float f8 = textLayoutInfo.getAscent();
        if (this.isFence()) {
            f6 = Math.max(layoutInfo2.getAscentHeight(LayoutStage.STAGE1), f8);
            f5 = Math.max(layoutInfo2.getDescentHeight(LayoutStage.STAGE1), f7);
        } else {
            f6 = Math.max(layoutInfo2.getStretchAscent(), f8);
            f5 = Math.max(layoutInfo2.getStretchDescent(), f7);
        }
        if (this.isSymmetric()) {
            f4 = this.getMiddleShift(graphics2D, layoutContext);
            f3 = f6 - f4;
            f2 = f5 + f4;
            f = Math.max(f3, f2);
            f6 = f + f4;
            f5 = f - f4;
        }
        f4 = f6 + f5;
        f3 = f8 + f7;
        f2 = AttributesHelper.parseRelativeSize(this.getMaxsize(), layoutContext, f3);
        f = AttributesHelper.parseRelativeSize(this.getMinsize(), layoutContext, f3);
        float f9 = Math.max(Math.min(f4, f2), f);
        float f10 = f9 / f4 * (f4 / 2.0f) - (f4 / 2.0f - f5);
        float f11 = f3 > 0.0f ? f9 / f3 : 1.0f;
        float f12 = f7 * f11;
        float f13 = f10 - f12;
        layoutInfo.setDescentHeight(f10, LayoutStage.STAGE2);
        layoutInfo.setAscentHeight(f9 - f10, LayoutStage.STAGE2);
        return new float[]{f11, f13};
    }

    @Override
    public void handleEvent(Event event) {
        this.changeHook();
    }
}

