/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swing;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.DOMBuilder;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.MathMLSerializer;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;
import net.sourceforge.jeuclid.swing.CursorListener;
import net.sourceforge.jeuclid.swing.JMathComponentMouseListener;
import net.sourceforge.jeuclid.swing.MathComponentUI;
import net.sourceforge.jeuclid.swing.MathComponentUI16;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class JMathComponent
extends JComponent
implements SwingConstants {
    private static final String FONT_SEPARATOR = ",";
    private static final Log LOGGER = LogFactory.getLog(JMathComponent.class);
    private static final long serialVersionUID = 1L;
    private Node document;
    private int horizontalAlignment = 0;
    private final MutableLayoutContext parameters = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
    private int verticalAlignment = 0;
    private final CursorListener cursorListener;

    public JMathComponent() {
        this(null);
    }

    public JMathComponent(CursorListener cursorListener) {
        this.cursorListener = cursorListener;
        JMathComponentMouseListener jMathComponentMouseListener = new JMathComponentMouseListener(this);
        this.addMouseListener(jMathComponentMouseListener);
        this.updateUI();
        this.fontCompat();
        this.setDocument(new DocumentElement());
    }

    public CursorListener getCursorListener() {
        return this.cursorListener;
    }

    private void fontCompat() {
        String string = this.getFontsSerif().split(FONT_SEPARATOR)[0];
        float f = this.getFontSize();
        super.setFont(new Font(string, 0, (int)f));
    }

    public String getContent() {
        return MathMLSerializer.serializeDocument(this.getDocument(), false, false);
    }

    public Node getDocument() {
        return this.document;
    }

    private static String join(List<String> list) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(FONT_SEPARATOR);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getFontsDoublestruck() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_DOUBLESTRUCK));
    }

    public String getFontsFraktur() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_FRAKTUR));
    }

    public float getFontSize() {
        return ((Float)this.parameters.getParameter(Parameter.MATHSIZE)).floatValue();
    }

    public String getFontsMonospaced() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_MONOSPACED));
    }

    public String getFontsSanserif() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_SANSSERIF));
    }

    public String getFontsScript() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_SCRIPT));
    }

    public String getFontsSerif() {
        return JMathComponent.join((List)this.parameters.getParameter(Parameter.FONTS_SERIF));
    }

    @Override
    public Color getForeground() {
        return (Color)this.parameters.getParameter(Parameter.MATHCOLOR);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public MathComponentUI getUI() {
        return (MathComponentUI)this.ui;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    private void reval() {
        this.repaint();
        this.revalidate();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.reval();
    }

    public void setContent(String string) {
        try {
            Document document = MathMLParserSupport.parseString(string);
            DocumentElement documentElement = DOMBuilder.getInstance().createJeuclidDom(document, true, true);
            this.setDocument(documentElement);
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    public void setDebug(boolean bl) {
        this.setParameter(Parameter.DEBUG, bl);
    }

    public void setDocument(Node node) {
        Node node2 = this.document;
        this.firePropertyChange("document", node2, node);
        this.document = node;
        if (node != node2) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    @Deprecated
    public void setFont(Font font) {
        super.setFont(font);
        this.setFontSize(font.getSize2D());
        this.setFontsSerif(font.getFamily() + FONT_SEPARATOR + this.getFontsSerif());
    }

    private List<String> splitFonts(String string) {
        return Arrays.asList(string.split(FONT_SEPARATOR));
    }

    public void setFontsDoublestruck(String string) {
        this.setParameter(Parameter.FONTS_DOUBLESTRUCK, this.splitFonts(string));
    }

    public void setFontsFraktur(String string) {
        this.setParameter(Parameter.FONTS_FRAKTUR, this.splitFonts(string));
    }

    public void setParameter(Parameter parameter, Object object) {
        this.setParameters(Collections.singletonMap(parameter, object));
    }

    public void setParameters(Map<Parameter, Object> map) {
        for (Map.Entry<Parameter, Object> entry : map.entrySet()) {
            Parameter parameter = entry.getKey();
            Object object = this.parameters.getParameter(parameter);
            this.parameters.setParameter(parameter, entry.getValue());
            this.firePropertyChange(parameter.name(), object, this.parameters.getParameter(parameter));
        }
        this.revalidate();
        this.repaint();
    }

    public void setFontSize(float f) {
        this.setParameter(Parameter.MATHSIZE, Float.valueOf(f));
    }

    public void setFontsMonospaced(String string) {
        this.setParameter(Parameter.FONTS_MONOSPACED, this.splitFonts(string));
    }

    public void setFontsSanserif(String string) {
        this.setParameter(Parameter.FONTS_SANSSERIF, this.splitFonts(string));
    }

    public void setFontsScript(String string) {
        this.setParameter(Parameter.FONTS_SCRIPT, this.splitFonts(string));
    }

    public void setFontsSerif(String string) {
        this.setParameter(Parameter.FONTS_SERIF, this.splitFonts(string));
        this.fontCompat();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setParameter(Parameter.MATHCOLOR, color);
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.reval();
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) == null) {
            this.setUI(new MathComponentUI16());
        } else {
            this.setUI(UIManager.getUI(this));
        }
    }

    public MutableLayoutContext getParameters() {
        return this.parameters;
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
    }
}

