/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.TIMESTAMP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIaqm {
    static final int ATTR_ORIGINAL_MSGID = 69;
    static final byte ATTR_AGENT_NAME = 64;
    static final byte ATTR_AGENT_ADDRESS = 65;
    static final byte ATTR_AGENT_PROTOCOL = 66;
    static final int AQM_MSG_NO_DELAY = 0;
    static final int AQM_MSG_NO_EXPIRATION = -1;
    static final int AQM_MSGPROP_CORRID_SIZE = 128;
    int aqmpri;
    int aqmdel;
    int aqmexp;
    byte[] aqmcorBytes;
    int aqmcorBytesLength;
    int aqmatt;
    byte[] aqmeqnBytes;
    int aqmeqnBytesLength;
    int aqmsta;
    private byte[] aqmeqtBuffer = new byte[7];
    private int[] retInt = new int[1];
    TIMESTAMP aqmeqt;
    byte[] aqmetiBytes;
    byte[] senderAgentName = null;
    int senderAgentNameLength = 0;
    byte[] senderAgentAddress = null;
    int senderAgentAddressLength = 0;
    byte senderAgentProtocol = 0;
    byte[] originalMsgId;
    T4Ctoh toh;
    int aqmcsn;
    int aqmdsn;
    int aqmflg;
    T4CMAREngine mar;
    T4CConnection connection;

    T4CTTIaqm(T4CConnection t4CConnection, T4Ctoh t4Ctoh) {
        this.toh = t4Ctoh;
        this.connection = t4CConnection;
        this.mar = this.connection.mare;
    }

    void initToDefaultValues() {
        this.aqmpri = 0;
        this.aqmdel = 0;
        this.aqmexp = -1;
        this.aqmcorBytes = null;
        this.aqmcorBytesLength = 0;
        this.aqmatt = 0;
        this.aqmeqnBytes = null;
        this.aqmeqnBytesLength = 0;
        this.aqmsta = 0;
        this.aqmeqt = null;
        this.aqmetiBytes = null;
        this.senderAgentName = null;
        this.senderAgentNameLength = 0;
        this.senderAgentAddress = null;
        this.senderAgentAddressLength = 0;
        this.senderAgentProtocol = 0;
        this.originalMsgId = null;
        this.aqmcsn = 0;
        this.aqmdsn = 0;
        this.aqmflg = 0;
    }

    void marshal() throws IOException {
        this.mar.marshalSB4(this.aqmpri);
        this.mar.marshalSB4(this.aqmdel);
        this.mar.marshalSB4(this.aqmexp);
        if (this.aqmcorBytes != null && this.aqmcorBytes.length != 0) {
            this.mar.marshalSWORD(this.aqmcorBytes.length);
            this.mar.marshalCLR(this.aqmcorBytes, 0, this.aqmcorBytes.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalSB4(0);
        if (this.aqmeqnBytes != null && this.aqmeqnBytes.length != 0) {
            this.mar.marshalSWORD(this.aqmeqnBytes.length);
            this.mar.marshalCLR(this.aqmeqnBytes, 0, this.aqmeqnBytes.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalSB4(this.aqmsta);
        this.mar.marshalSWORD(0);
        if (this.connection.getTTCVersion() >= 3) {
            if (this.aqmetiBytes != null && this.aqmetiBytes.length > 0) {
                this.mar.marshalSWORD(this.aqmetiBytes.length);
                this.mar.marshalCLR(this.aqmetiBytes, 0, this.aqmetiBytes.length);
            } else {
                this.mar.marshalSWORD(0);
            }
        }
        int n2 = 4;
        byte[][] byArrayArray = new byte[n2][];
        byte[][] byArrayArray2 = new byte[n2][];
        int[] nArray = new int[n2];
        byArrayArray[0] = this.senderAgentName;
        byArrayArray2[0] = null;
        nArray[0] = 64;
        byArrayArray[1] = this.senderAgentAddress;
        byArrayArray2[1] = null;
        nArray[1] = 65;
        byArrayArray[2] = null;
        byArrayArray2[2] = new byte[1];
        byArrayArray2[2][0] = this.senderAgentProtocol;
        nArray[2] = 66;
        byArrayArray[3] = null;
        byArrayArray2[3] = this.originalMsgId;
        nArray[3] = 69;
        this.mar.marshalSWORD(n2);
        this.mar.marshalUB1((short)14);
        this.mar.marshalKPDKV(byArrayArray, byArrayArray2, nArray);
        if (this.connection.getTTCVersion() >= 3) {
            this.mar.marshalUB4(1L);
            this.toh.init(T4Ctoh.ANYDATA_TOID, 0);
            this.toh.marshal(this.mar);
            this.mar.marshalUB4(0L);
            this.mar.marshalUB4(0L);
            if (this.connection.getTTCVersion() >= 4) {
                this.mar.marshalUB4(0L);
            }
        }
    }

    void receive() throws SQLException, IOException {
        Object object;
        int n2;
        this.aqmpri = this.mar.unmarshalSB4();
        this.aqmdel = this.mar.unmarshalSB4();
        this.aqmexp = this.mar.unmarshalSB4();
        int n3 = this.mar.unmarshalSWORD();
        if (n3 > 0) {
            this.aqmcorBytes = new byte[n3];
            int[] nArray = new int[1];
            this.mar.unmarshalCLR(this.aqmcorBytes, 0, nArray, this.aqmcorBytes.length);
            this.aqmcorBytesLength = nArray[0];
        } else {
            this.aqmcorBytes = null;
        }
        this.aqmatt = this.mar.unmarshalSB4();
        int n4 = this.mar.unmarshalSWORD();
        if (n4 > 0) {
            this.aqmeqnBytes = new byte[n4];
            int[] nArray = new int[1];
            this.mar.unmarshalCLR(this.aqmeqnBytes, 0, nArray, this.aqmeqnBytes.length);
            this.aqmeqnBytesLength = nArray[0];
        } else {
            this.aqmeqnBytes = null;
        }
        this.aqmsta = this.mar.unmarshalSB4();
        int n5 = this.mar.unmarshalSB4();
        if (n5 > 0) {
            this.mar.unmarshalCLR(this.aqmeqtBuffer, 0, this.retInt, 7);
            this.aqmeqt = new TIMESTAMP(this.aqmeqtBuffer);
        }
        if (this.connection.getTTCVersion() >= 3) {
            n2 = this.mar.unmarshalSWORD();
            if (n2 > 0) {
                this.aqmetiBytes = new byte[n2];
                object = new int[1];
                this.mar.unmarshalCLR(this.aqmetiBytes, 0, (int[])object, this.aqmetiBytes.length);
            } else {
                this.aqmetiBytes = null;
            }
        }
        if ((n2 = this.mar.unmarshalSWORD()) > 0) {
            this.mar.unmarshalUB1();
            object = new byte[n2][];
            int[] nArray = new int[n2];
            byte[][] byArrayArray = new byte[n2][];
            int[] nArray2 = new int[n2];
            this.mar.unmarshalKPDKV((byte[][])object, nArray, byArrayArray, nArray2);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (nArray2[i2] == 64 && object[i2] != null && nArray[i2] > 0) {
                    this.senderAgentName = (byte[])object[i2];
                    this.senderAgentNameLength = nArray[i2];
                }
                if (nArray2[i2] == 65 && object[i2] != null && nArray[i2] > 0) {
                    this.senderAgentAddress = (byte[])object[i2];
                    this.senderAgentAddressLength = nArray[i2];
                }
                if (nArray2[i2] == 66 && byArrayArray[i2] != null && byArrayArray[i2].length > 0) {
                    this.senderAgentProtocol = byArrayArray[i2][0];
                }
                if (nArray2[i2] != 69 || byArrayArray[i2] == null || byArrayArray[i2].length <= 0) continue;
                this.originalMsgId = byArrayArray[i2];
            }
        }
        if (this.connection.getTTCVersion() >= 3) {
            int n6 = this.mar.unmarshalSWORD();
            this.aqmcsn = (int)this.mar.unmarshalUB4();
            this.aqmdsn = (int)this.mar.unmarshalUB4();
            if (this.connection.getTTCVersion() >= 4) {
                this.aqmflg = (int)this.mar.unmarshalUB4();
            }
        }
    }
}

