/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.ErrorGroup;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.CombinerTargetMatcher;
import uk.ac.ed.ph.snuggletex.definitions.CommandType;
import uk.ac.ed.ph.snuggletex.definitions.Globals;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.MathCharacter;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.InterpretableSimpleMathHandler;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.StringUtilities;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.semantics.MathBigLimitOwnerInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathBracketInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathFunctionInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathNegatableInterpretation;

public final class SnugglePackage {
    public static final InterpretableSimpleMathHandler interpretableSimpleMathBuilder = new InterpretableSimpleMathHandler();
    private final String name;
    private final ConcurrentHashMap<String, BuiltinCommand> builtinCommandMap;
    private final ConcurrentHashMap<String, BuiltinEnvironment> builtinEnvironmentMap;
    private final ConcurrentHashMap<Integer, MathCharacter> mathCharacterMap;
    private final List<ErrorGroup> errorGroupList;
    private final ConcurrentHashMap<ErrorGroup, List<ErrorCode>> errorGroupMap;
    private ResourceBundle errorMessageBundle;

    public SnugglePackage(String name) {
        ConstraintUtilities.ensureNotNull(name, "name");
        this.name = name;
        this.builtinCommandMap = new ConcurrentHashMap();
        this.builtinEnvironmentMap = new ConcurrentHashMap();
        this.mathCharacterMap = new ConcurrentHashMap();
        this.errorGroupList = Collections.synchronizedList(new ArrayList());
        this.errorGroupMap = new ConcurrentHashMap();
    }

    public String getName() {
        return this.name;
    }

    public List<ErrorGroup> getErrorGroups() {
        return Collections.unmodifiableList(this.errorGroupList);
    }

    public List<ErrorCode> getErrorCodes(ErrorGroup errorGroup) {
        List<ErrorCode> errorCodes = this.errorGroupMap.get(errorGroup);
        if (errorCodes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(errorCodes);
    }

    public ResourceBundle getErrorMessageBundle() {
        return this.errorMessageBundle;
    }

    public void setErrorMessageBundle(ResourceBundle errorMessageBundle) {
        this.errorMessageBundle = errorMessageBundle;
    }

    public Map<Integer, MathCharacter> getMathCharacterMap() {
        return Collections.unmodifiableMap(this.mathCharacterMap);
    }

    public MathCharacter getMathCharacter(int codePoint) {
        return this.mathCharacterMap.get(codePoint);
    }

    public Map<String, BuiltinCommand> getBuiltinCommandMap() {
        return Collections.unmodifiableMap(this.builtinCommandMap);
    }

    public BuiltinCommand getBuiltinCommandByTeXName(String texName) {
        return this.builtinCommandMap.get(texName);
    }

    public Map<String, BuiltinEnvironment> getBuiltinEnvironmentMap() {
        return Collections.unmodifiableMap(this.builtinEnvironmentMap);
    }

    public BuiltinEnvironment getBuiltinEnvironmentByTeXName(String texName) {
        return this.builtinEnvironmentMap.get(texName);
    }

    public static boolean isInputableTeXName(String texName) {
        return texName != null && (texName.charAt(0) != '<' || texName.length() <= 3 || !texName.endsWith(">"));
    }

    public void loadMathFunctionDefinitions(String resourceLocation) {
        this.readResourceData(resourceLocation, new LineHandler(){

            @Override
            public void handleLine(String line) {
                String outputName;
                String latexName;
                int mapsToIndex = line.indexOf("->");
                if (mapsToIndex != -1) {
                    latexName = line.substring(0, mapsToIndex);
                    outputName = line.substring(mapsToIndex + 2);
                } else {
                    latexName = line;
                    outputName = line;
                }
                SnugglePackage.this.addSimpleMathCommand(latexName, new MathFunctionInterpretation(outputName));
            }
        });
    }

    public void loadMathCharacterDefinitions(String resourceLocation) {
        this.readResourceData(resourceLocation, new LineHandler(){

            @Override
            public void handleLine(String line) {
                String[] fields = line.split(":");
                int codePoint = Integer.parseInt(fields[0], 16);
                String commandName = StringUtilities.nullIfEmpty(fields[1]);
                MathCharacter.MathCharacterType mathCharacterType = MathCharacter.MathCharacterType.valueOf(fields[2]);
                MathCharacter mathCharacter = new MathCharacter(codePoint, commandName, mathCharacterType);
                SnugglePackage.this.mathCharacterMap.put(codePoint, mathCharacter);
                if (commandName != null) {
                    SnugglePackage.this.addMathCharacterCommand(mathCharacter);
                }
            }
        });
    }

    public void loadMathCharacterNegations(String resourceLocation) {
        this.readResourceData(resourceLocation, new LineHandler(){

            @Override
            public void handleLine(String line) {
                String targetName;
                String sourceName;
                int mapsToIndex = line.indexOf("->");
                if (mapsToIndex != -1) {
                    sourceName = line.substring(0, mapsToIndex);
                    targetName = line.substring(mapsToIndex + 2);
                } else {
                    sourceName = line;
                    targetName = "n" + sourceName;
                }
                MathCharacter sourceCharacter = SnugglePackage.this.ensureBuiltinMathCharacterCommand(sourceName, "Source command for negation");
                MathCharacter targetCharacter = SnugglePackage.this.ensureBuiltinMathCharacterCommand(targetName, "Target command for negation");
                sourceCharacter.addInterpretation(new MathNegatableInterpretation(targetCharacter));
            }
        });
    }

    public void loadMathCharacterBrackets(String resourceLocation) {
        this.readResourceData(resourceLocation, new LineHandler(){

            @Override
            public void handleLine(String line) {
                String[] fields = line.split(":");
                String inputCommandName = fields[0];
                String outputBracketCommandName = fields[1];
                MathBracketInterpretation.BracketType bracketType = MathBracketInterpretation.BracketType.valueOf(fields[2]);
                boolean inferFences = "INFER".equals(fields[3]);
                MathCharacter inputMathCharacter = SnugglePackage.this.ensureBuiltinMathCharacterCommand(inputCommandName, "Bracket input command");
                MathCharacter outputBracketMathCharacter = SnugglePackage.this.ensureBuiltinMathCharacterCommand(outputBracketCommandName, "Fence target");
                inputMathCharacter.addInterpretation(new MathBracketInterpretation(outputBracketMathCharacter, bracketType, inferFences));
            }
        });
    }

    public void loadMathCharacterAliases(String resourceLocation) {
        this.readResourceData(resourceLocation, new LineHandler(){

            @Override
            public void handleLine(String line) {
                line = line.replaceFirst("\\s+#.+$", "");
                String[] fields = line.split("->");
                String aliasCommandName = fields[0];
                MathCharacter targetCharacter = SnugglePackage.this.ensureBuiltinMathCharacterCommand(fields[1], "Target command for alias");
                SnugglePackage.this.addMathCharacterCommandAlias(aliasCommandName, targetCharacter);
            }
        });
    }

    public void loadMathCharacterBigLimitTargets(String resourceLocation) {
        final MathBigLimitOwnerInterpretation bigLimitOwner = new MathBigLimitOwnerInterpretation();
        this.readResourceData(resourceLocation, new LineHandler(){

            @Override
            public void handleLine(String line) {
                MathCharacter target = SnugglePackage.this.ensureBuiltinMathCharacterCommand(line, "Target command for big limit owner");
                target.addInterpretation(bigLimitOwner);
            }
        });
    }

    private void readResourceData(String resourceLocation, LineHandler handler) {
        InputStream inputStream = Globals.class.getClassLoader().getResourceAsStream(resourceLocation);
        if (inputStream == null) {
            throw new SnuggleRuntimeException("Could not load ClassPath resource at  " + resourceLocation);
        }
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
            while ((line = inputReader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                line = line.replaceFirst("\\s+#.+$", "");
                handler.handleLine(line);
            }
            inputReader.close();
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Got Exception while reading and parsing math character definitions from resource " + resourceLocation, e);
        }
    }

    private MathCharacter ensureBuiltinMathCharacterCommand(String texName, String errorMessageContext) {
        MathCharacter mathCharacter;
        BuiltinCommand command = this.getBuiltinCommandByTeXName(texName);
        MathCharacter mathCharacter2 = mathCharacter = command != null ? command.getMathCharacter() : null;
        if (command == null || mathCharacter == null) {
            throw new SnuggleRuntimeException(errorMessageContext + " must be a previously-defined math character input command");
        }
        return mathCharacter;
    }

    public BuiltinCommand addSimpleCommand(String name, EnumSet<LaTeXMode> allowedModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, allowedModes, null, null, handler, context, null));
    }

    public BuiltinCommand addSimpleCommand(String name, EnumSet<LaTeXMode> allowedModes, Interpretation[] interpretations, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, allowedModes, null, SnugglePackage.makeInterpretationMap(interpretations), handler, context, null));
    }

    public BuiltinCommand addSimpleCommand(String name, EnumSet<LaTeXMode> allowedModes, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, allowedModes, null, SnugglePackage.makeInterpretationMap(interpretation), handler, context, null));
    }

    public BuiltinCommand addMathCharacterCommand(MathCharacter mathCharacter) {
        return this.addMathCharacterCommandAlias(mathCharacter.getInputCommandName(), mathCharacter);
    }

    public BuiltinCommand addMathCharacterCommandAlias(String name, MathCharacter mathCharacter) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, Globals.MATH_MODE_ONLY, null, mathCharacter.getInterpretationMap(), interpretableSimpleMathBuilder, null, null));
    }

    public BuiltinCommand addSimpleMathCommand(String name, MathInterpretation ... interpretations) {
        return this.addSimpleMathCommand(name, interpretations, (CommandHandler)interpretableSimpleMathBuilder);
    }

    public BuiltinCommand addSimpleMathCommand(String name, MathInterpretation interpretation, CommandHandler handler) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, Globals.MATH_MODE_ONLY, null, SnugglePackage.makeInterpretationMap((Interpretation)interpretation), handler, null, null));
    }

    public BuiltinCommand addSimpleMathCommand(String name, MathInterpretation[] interpretations, CommandHandler handler) {
        return this.addCommand(new BuiltinCommand(name, CommandType.SIMPLE, false, 0, Globals.MATH_MODE_ONLY, null, SnugglePackage.makeInterpretationMap(interpretations), handler, null, null));
    }

    public BuiltinCommand addCombinerCommand(String name, EnumSet<LaTeXMode> allowedModes, CombinerTargetMatcher combinerTargetMatcher, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMBINER, false, 0, allowedModes, null, null, handler, context, combinerTargetMatcher));
    }

    public BuiltinCommand addComplexCommand(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, LaTeXMode[] argumentModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, argumentModes, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandSameArgMode(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, null, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandSameArgMode(String name, boolean allowOptionalArgument, int arguments, EnumSet<LaTeXMode> allowedModes, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, arguments, allowedModes, null, SnugglePackage.makeInterpretationMap(interpretation), handler, context, null));
    }

    public BuiltinCommand addComplexCommandOneArg(String name, boolean allowOptionalArgument, EnumSet<LaTeXMode> allowedModes, LaTeXMode argumentMode, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, 1, allowedModes, new LaTeXMode[]{argumentMode}, null, handler, context, null));
    }

    public BuiltinCommand addComplexCommandOneArg(String name, boolean allowOptionalArgument, EnumSet<LaTeXMode> allowedModes, LaTeXMode argumentMode, Interpretation interpretation, CommandHandler handler, TextFlowContext context) {
        return this.addCommand(new BuiltinCommand(name, CommandType.COMPLEX, allowOptionalArgument, 1, allowedModes, new LaTeXMode[]{argumentMode}, SnugglePackage.makeInterpretationMap(interpretation), handler, context, null));
    }

    public BuiltinCommand addCommand(BuiltinCommand command) {
        if (SnugglePackage.isInputableTeXName(command.getTeXName())) {
            this.builtinCommandMap.put(command.getTeXName(), command);
        }
        return command;
    }

    public void addCommandInterpretation(String name, Interpretation interpretation) {
        BuiltinCommand command = this.getBuiltinCommandByTeXName(name);
        if (command == null) {
            throw new IllegalArgumentException("No command defined with name " + name);
        }
        command.getInterpretationMap().put(interpretation.getType(), interpretation);
    }

    public BuiltinEnvironment addEnvironment(String name, EnumSet<LaTeXMode> allowedModes, LaTeXMode contentMode, Interpretation interpretation, EnvironmentHandler handler, TextFlowContext context) {
        return this.addEnvironment(new BuiltinEnvironment(name, false, 0, allowedModes, contentMode, SnugglePackage.makeInterpretationMap(interpretation), handler, context));
    }

    public BuiltinEnvironment addEnvironment(String name, EnumSet<LaTeXMode> allowedModes, LaTeXMode contentMode, Interpretation[] interpretations, EnvironmentHandler handler, TextFlowContext context) {
        return this.addEnvironment(new BuiltinEnvironment(name, false, 0, allowedModes, contentMode, SnugglePackage.makeInterpretationMap(interpretations), handler, context));
    }

    public BuiltinEnvironment addEnvironment(String name, boolean allowOptionalArgument, int argumentCount, EnumSet<LaTeXMode> allowedModes, LaTeXMode contentMode, Interpretation interpretation, EnvironmentHandler handler, TextFlowContext context) {
        return this.addEnvironment(new BuiltinEnvironment(name, allowOptionalArgument, argumentCount, allowedModes, contentMode, SnugglePackage.makeInterpretationMap(interpretation), handler, context));
    }

    public BuiltinEnvironment addEnvironment(String name, boolean allowOptionalArgument, int argumentCount, EnumSet<LaTeXMode> allowedModes, LaTeXMode contentMode, Interpretation[] interpretations, EnvironmentHandler handler, TextFlowContext context) {
        return this.addEnvironment(new BuiltinEnvironment(name, allowOptionalArgument, argumentCount, allowedModes, contentMode, SnugglePackage.makeInterpretationMap(interpretations), handler, context));
    }

    public BuiltinEnvironment addEnvironment(BuiltinEnvironment environment) {
        if (SnugglePackage.isInputableTeXName(environment.getTeXName())) {
            this.builtinEnvironmentMap.put(environment.getTeXName(), environment);
        }
        return environment;
    }

    public void addErrorCode(ErrorCode errorCode) {
        ConstraintUtilities.ensureNotNull(errorCode, "errorCode");
        ErrorGroup errorGroup = errorCode.getErrorGroup();
        ConstraintUtilities.ensureNotNull(errorGroup, "errorCode.errorGroup");
        List<ErrorCode> errorCodesForGroup = this.errorGroupMap.get(errorGroup);
        if (errorCodesForGroup == null) {
            errorCodesForGroup = Collections.synchronizedList(new ArrayList());
            this.errorGroupList.add(errorGroup);
            this.errorGroupMap.put(errorGroup, errorCodesForGroup);
        }
        errorCodesForGroup.add(errorCode);
    }

    public void addErrorCodes(ErrorCode ... errorCodes) {
        for (ErrorCode errorCode : errorCodes) {
            this.addErrorCode(errorCode);
        }
    }

    public static EnumMap<InterpretationType, Interpretation> makeInterpretationMap(Interpretation interpretation) {
        if (interpretation == null) {
            return null;
        }
        EnumMap<InterpretationType, Interpretation> result = new EnumMap<InterpretationType, Interpretation>(InterpretationType.class);
        result.put(interpretation.getType(), interpretation);
        return result;
    }

    public static EnumMap<InterpretationType, Interpretation> makeInterpretationMap(Interpretation ... interpretations) {
        if (interpretations.length == 0) {
            return null;
        }
        EnumMap<InterpretationType, Interpretation> result = new EnumMap<InterpretationType, Interpretation>(InterpretationType.class);
        for (Interpretation interpretation : interpretations) {
            result.put(interpretation.getType(), interpretation);
        }
        return result;
    }

    private static interface LineHandler {
        public void handleLine(String var1);
    }
}

