/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.helper;

import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.comp.helper.ComponentContext;
import com.sun.star.comp.helper.ComponentContextEntry;
import com.sun.star.comp.loader.JavaLoader;
import com.sun.star.comp.servicemanager.ServiceManager;
import com.sun.star.connection.NoConnectException;
import com.sun.star.container.XSet;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.loader.XImplementationLoader;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;

public class Bootstrap {
    private static boolean m_loaded_juh = false;
    private static final Random randomPipeName = new Random();

    private static void insertBasicFactories(XSet xSet, XImplementationLoader xImpLoader) throws Exception {
        xSet.insert(xImpLoader.activate("com.sun.star.comp.loader.JavaLoader", null, null, null));
        xSet.insert(xImpLoader.activate("com.sun.star.comp.urlresolver.UrlResolver", null, null, null));
        xSet.insert(xImpLoader.activate("com.sun.star.comp.bridgefactory.BridgeFactory", null, null, null));
        xSet.insert(xImpLoader.activate("com.sun.star.comp.connections.Connector", null, null, null));
        xSet.insert(xImpLoader.activate("com.sun.star.comp.connections.Acceptor", null, null, null));
    }

    public static final String[] getDefaultOptions() {
        return new String[]{"--nologo", "--nodefault", "--norestore", "--nolockcheck"};
    }

    public static XComponentContext createInitialComponentContext(Hashtable<String, Object> context_entries) throws Exception {
        return Bootstrap.createInitialComponentContext(context_entries);
    }

    public static XComponentContext createInitialComponentContext(Map<String, Object> context_entries) throws Exception {
        ServiceManager xSMgr = new ServiceManager();
        XImplementationLoader xImpLoader = UnoRuntime.queryInterface(XImplementationLoader.class, (Object)new JavaLoader());
        XInitialization xInit = UnoRuntime.queryInterface(XInitialization.class, (Object)xImpLoader);
        Object[] args = new Object[]{xSMgr};
        xInit.initialize(args);
        if (context_entries == null) {
            context_entries = new HashMap<String, Object>(1);
        }
        context_entries.put("/singletons/com.sun.star.lang.theServiceManager", new ComponentContextEntry(null, xSMgr));
        ComponentContext xContext = new ComponentContext(context_entries, null);
        xSMgr.setDefaultContext(xContext);
        XSet xSet = UnoRuntime.queryInterface(XSet.class, (Object)xSMgr);
        Bootstrap.insertBasicFactories(xSet, xImpLoader);
        return xContext;
    }

    public static XMultiServiceFactory createSimpleServiceManager() throws Exception {
        return UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)Bootstrap.createInitialComponentContext((Map<String, Object>)null).getServiceManager());
    }

    public static final XComponentContext defaultBootstrap_InitialComponentContext() throws Exception {
        return Bootstrap.defaultBootstrap_InitialComponentContext((String)null, (Map<String, String>)null);
    }

    public static final XComponentContext defaultBootstrap_InitialComponentContext(String ini_file, Hashtable<String, String> bootstrap_parameters) throws Exception {
        return Bootstrap.defaultBootstrap_InitialComponentContext(ini_file, bootstrap_parameters);
    }

    public static final XComponentContext defaultBootstrap_InitialComponentContext(String ini_file, Map<String, String> bootstrap_parameters) throws Exception {
        String[] pairs = null;
        if (null != bootstrap_parameters) {
            pairs = new String[2 * bootstrap_parameters.size()];
            int n = 0;
            for (Map.Entry<String, String> bootstrap_parameter : bootstrap_parameters.entrySet()) {
                pairs[n++] = bootstrap_parameter.getKey();
                pairs[n++] = bootstrap_parameter.getValue();
            }
        }
        if (!m_loaded_juh) {
            if ("The Android Project".equals(System.getProperty("java.vendor"))) {
                boolean disable_dynloading = false;
                try {
                    System.loadLibrary("lo-bootstrap");
                }
                catch (UnsatisfiedLinkError e) {
                    disable_dynloading = true;
                }
                if (!disable_dynloading) {
                    NativeLibraryLoader.loadLibrary(Bootstrap.class.getClassLoader(), "juh");
                }
            } else {
                NativeLibraryLoader.loadLibrary(Bootstrap.class.getClassLoader(), "juh");
            }
            m_loaded_juh = true;
        }
        return UnoRuntime.queryInterface(XComponentContext.class, Bootstrap.cppuhelper_bootstrap(ini_file, pairs, Bootstrap.class.getClassLoader()));
    }

    private static native Object cppuhelper_bootstrap(String var0, String[] var1, ClassLoader var2) throws Exception;

    public static final XComponentContext bootstrap() throws BootstrapException {
        String[] defaultArgArray = Bootstrap.getDefaultOptions();
        return Bootstrap.bootstrap(defaultArgArray);
    }

    public static final XComponentContext bootstrap(String[] argArray) throws BootstrapException {
        XComponentContext xContext = null;
        try {
            XComponentContext xLocalContext = Bootstrap.createInitialComponentContext((Map<String, Object>)null);
            if (xLocalContext == null) {
                throw new BootstrapException("no local component context!");
            }
            String sOffice = System.getProperty("os.name").startsWith("Windows") ? "soffice.exe" : "soffice";
            File fOffice = NativeLibraryLoader.getResource(Bootstrap.class.getClassLoader(), sOffice);
            if (fOffice == null) {
                throw new BootstrapException("no office executable found!");
            }
            String sPipeName = "uno" + Long.toString(randomPipeName.nextLong() & Long.MAX_VALUE);
            String[] cmdArray = new String[argArray.length + 2];
            cmdArray[0] = fOffice.getPath();
            cmdArray[1] = "--accept=pipe,name=" + sPipeName + ";urp;";
            System.arraycopy(argArray, 0, cmdArray, 2, argArray.length);
            Process p = Runtime.getRuntime().exec(cmdArray);
            Bootstrap.pipe(p.getInputStream(), System.out, "CO> ");
            Bootstrap.pipe(p.getErrorStream(), System.err, "CE> ");
            XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
            if (xLocalServiceManager == null) {
                throw new BootstrapException("no initial service manager!");
            }
            XUnoUrlResolver xUrlResolver = UnoUrlResolver.create(xLocalContext);
            String sConnect = "uno:pipe,name=" + sPipeName + ";urp;StarOffice.ComponentContext";
            int i = 0;
            while (true) {
                try {
                    Object context = xUrlResolver.resolve(sConnect);
                    xContext = UnoRuntime.queryInterface(XComponentContext.class, context);
                    if (xContext == null) {
                        throw new BootstrapException("no component context!");
                    }
                }
                catch (NoConnectException ex) {
                    if (i == 600) {
                        throw new BootstrapException(ex);
                    }
                    Thread.sleep(500L);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BootstrapException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
        return xContext;
    }

    public static final XComponentContext bootstrapWebsocketConnection(String url) throws BootstrapException {
        XComponentContext xContext = null;
        try {
            XComponentContext xLocalContext = Bootstrap.createInitialComponentContext((Map<String, Object>)null);
            if (xLocalContext == null) {
                throw new BootstrapException("no local component context!");
            }
            XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
            if (xLocalServiceManager == null) {
                throw new BootstrapException("no initial service manager!");
            }
            XUnoUrlResolver xUrlResolver = UnoUrlResolver.create(xLocalContext);
            String sConnect = "uno:websocket,url=" + url + ";urp;StarOffice.ComponentContext";
            try {
                Object xOfficeServiceManager = xUrlResolver.resolve(sConnect);
                xContext = UnoRuntime.queryInterface(XComponentContext.class, xOfficeServiceManager);
                if (xContext == null) {
                    throw new BootstrapException("no component context!");
                }
            }
            catch (NoConnectException ex) {
                throw new BootstrapException(ex);
            }
        }
        catch (BootstrapException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
        return xContext;
    }

    private static void pipe(final InputStream in, final PrintStream out, final String prefix) {
        new Thread("Pipe: " + prefix){

            @Override
            public void run() {
                try {
                    String s;
                    BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    while ((s = r.readLine()) != null) {
                        out.println(prefix + s);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace(System.err);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }
}

