/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class HistoryManager<T> {
    private static final Logger LOG = Logger.getLogger(HistoryManager.class.getName());
    private static final int DEFAULT_MAX_HISTORY_SIZE = 30;
    private final ObservableList<T> history = FXCollections.observableArrayList();
    private final ObservableList<T> unmodifiableHistory = FXCollections.unmodifiableObservableList(this.history);
    private final IntegerProperty maxHistorySize = new SimpleIntegerProperty((Object)this, "maxHistorySize", 30);
    private final ObjectProperty<Predicate<T>> filter = new SimpleObjectProperty((Object)this, "filter", it -> true);

    public HistoryManager() {
        this.maxHistorySizeProperty().addListener(it -> {
            if (this.getMaxHistorySize() < 0) {
                LOG.warning("Max history size must be greater than or equal to 0. ");
            }
            this.trimHistory();
        });
        this.unmodifiableHistory.addListener(it -> this.storeHistory());
    }

    protected abstract void loadHistory();

    protected abstract void storeHistory();

    public final void set(List<T> history) {
        this.history.setAll(this.convertToUniqueList(history));
    }

    public final void add(T item) {
        if (item != null && this.getFilter().test(item)) {
            this.history.remove(item);
            this.history.add(0, item);
            this.trimHistory();
        }
    }

    public final void add(List<T> items) {
        List<T> uniqueItems = this.convertToUniqueList(items);
        if (!uniqueItems.isEmpty()) {
            this.history.removeAll(uniqueItems);
            this.history.addAll(0, uniqueItems);
            this.trimHistory();
        }
    }

    public final boolean remove(T item) {
        return this.history.remove(item);
    }

    public final void remove(List<T> items) {
        this.history.removeAll(items);
    }

    public final void clear() {
        this.history.clear();
    }

    public final ObservableList<T> getAllUnmodifiable() {
        return this.unmodifiableHistory;
    }

    public final IntegerProperty maxHistorySizeProperty() {
        return this.maxHistorySize;
    }

    public final int getMaxHistorySize() {
        return this.maxHistorySize.get();
    }

    public final void setMaxHistorySize(int maxHistorySize) {
        this.maxHistorySizeProperty().set(maxHistorySize);
    }

    public final ObjectProperty<Predicate<T>> filterProperty() {
        return this.filter;
    }

    public final Predicate<T> getFilter() {
        return (Predicate)this.filter.get();
    }

    public final void setFilter(Predicate<T> filter) {
        this.filter.set(filter);
    }

    private void trimHistory() {
        int max = Math.max(0, this.getMaxHistorySize());
        if (this.history.size() > max) {
            this.history.remove(max, this.history.size());
        }
    }

    private List<T> convertToUniqueList(List<T> history) {
        return history.stream().distinct().filter(Objects::nonNull).filter(this.getFilter()).limit(Math.max(0, this.getMaxHistorySize())).toList();
    }
}

