/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class ResizingBehaviour {
    private static final String RESIZE_BEHAVIOUR_INSTALLED = "resizeBehaviourInstalled";
    private final EventHandler<MouseEvent> mouseMovedHandler;
    private final EventHandler<MouseEvent> mousePressedHandler;
    private final EventHandler<MouseEvent> mouseReleasedHandler;
    private final EventHandler<MouseEvent> mouseDraggedHandler;
    private final Region region;
    private double startX;
    private double startY;
    private Operation operation;
    private ObjectProperty<BiConsumer<Double, Double>> onResize;
    private DoubleProperty offset;
    private BooleanProperty resizable;
    private final ListProperty<Operation> supportedOperations = new SimpleListProperty((Object)this, "supportedOperations", FXCollections.observableArrayList((Object[])Operation.values()));

    public static ResizingBehaviour install(Region region) {
        Objects.requireNonNull(region, "Region cannot be null.");
        if (ResizingBehaviour.isInstalled(region)) {
            throw new IllegalStateException("ResizingBehaviour is already installed on this region.");
        }
        ResizingBehaviour behaviour = new ResizingBehaviour(region);
        region.getProperties().put((Object)RESIZE_BEHAVIOUR_INSTALLED, (Object)Boolean.TRUE);
        return behaviour;
    }

    private ResizingBehaviour(Region region) {
        this.region = region;
        this.mouseMovedHandler = this::onMouseMove;
        this.mousePressedHandler = this::onMousePressed;
        this.mouseReleasedHandler = evt -> {
            this.operation = null;
        };
        this.mouseDraggedHandler = this::onMouseDragged;
        region.addEventFilter(MouseEvent.MOUSE_MOVED, this.mouseMovedHandler);
        region.addEventFilter(MouseEvent.MOUSE_ENTERED, this.mouseMovedHandler);
        region.addEventFilter(MouseEvent.MOUSE_ENTERED_TARGET, this.mouseMovedHandler);
        region.addEventFilter(MouseEvent.MOUSE_PRESSED, this.mousePressedHandler);
        region.addEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
        region.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedHandler);
    }

    private void onMouseDragged(MouseEvent evt) {
        if (this.operation == null) {
            return;
        }
        double x = evt.getScreenX();
        double y = evt.getScreenY();
        double deltaX = (evt.getScreenX() - this.startX) * 4.0;
        double deltaY = (evt.getScreenY() - this.startY) * 4.0;
        double width = this.region.getWidth();
        double height = this.region.getHeight();
        double minHeight = this.region.minHeight(width);
        double maxHeight = this.region.maxHeight(width);
        double minWidth = this.region.minWidth(height);
        double maxWidth = this.region.maxWidth(height);
        switch (this.operation) {
            case RESIZE_N: {
                double newHeight = height - deltaY;
                if (newHeight >= minHeight && newHeight <= maxHeight) {
                    this.region.setLayoutY(y);
                    this.region.setPrefHeight(Math.min(maxHeight, Math.max(minHeight, newHeight)));
                    this.startX = x;
                    this.startY = y;
                }
                evt.consume();
                break;
            }
            case RESIZE_S: {
                double newHeight = height + deltaY;
                if (newHeight >= minHeight && newHeight <= maxHeight) {
                    this.region.setPrefHeight(Math.min(maxHeight, Math.max(minHeight, newHeight)));
                    this.startX = x;
                    this.startY = y;
                }
                evt.consume();
                break;
            }
            case RESIZE_W: {
                double newWidth = width - deltaX;
                if (newWidth >= minWidth && newWidth <= maxWidth) {
                    this.region.setLayoutX(x);
                    this.region.setPrefWidth(Math.min(maxWidth, Math.max(minWidth, newWidth)));
                    this.startX = x;
                    this.startY = y;
                }
                evt.consume();
                break;
            }
            case RESIZE_E: {
                double newWidth = width + deltaX;
                if (newWidth >= minWidth && newWidth <= maxWidth) {
                    this.region.setPrefWidth(Math.min(maxWidth, Math.max(minWidth, newWidth)));
                    this.startX = x;
                    this.startY = y;
                }
                evt.consume();
                break;
            }
            case RESIZE_NW: {
                double newHeight;
                double newWidth = width - deltaX;
                if (newWidth >= minWidth && newWidth <= maxWidth) {
                    this.region.setLayoutX(x);
                    this.region.setPrefWidth(Math.min(maxWidth, Math.max(minWidth, newWidth)));
                    this.startX = x;
                }
                if ((newHeight = height - deltaY) >= minHeight && newHeight <= maxHeight) {
                    this.region.setLayoutY(y);
                    this.region.setPrefHeight(Math.min(maxHeight, Math.max(minHeight, newHeight)));
                    this.startY = y;
                }
                evt.consume();
                break;
            }
            case RESIZE_NE: {
                double newHeight;
                double newWidth = width + deltaX;
                if (newWidth >= minWidth && newWidth <= maxWidth) {
                    this.region.setPrefWidth(Math.min(maxWidth, Math.max(minWidth, newWidth)));
                    this.startX = x;
                }
                if ((newHeight = height - deltaY) >= minHeight && newHeight <= maxHeight) {
                    this.region.setLayoutY(y);
                    this.region.setPrefHeight(Math.min(maxHeight, Math.max(minHeight, height - deltaY)));
                    this.startY = y;
                }
                evt.consume();
                break;
            }
            case RESIZE_SW: {
                double newHeight;
                double newWidth = width - deltaX;
                if (newWidth >= minWidth && newWidth <= maxWidth) {
                    this.region.setLayoutX(x);
                    this.region.setPrefWidth(Math.min(maxWidth, Math.max(minWidth, width - deltaX)));
                    this.startX = x;
                }
                if ((newHeight = height + deltaY) >= minHeight && newHeight <= maxHeight) {
                    this.region.setPrefHeight(Math.min(newHeight, Math.max(minHeight, height + deltaY)));
                    this.startY = y;
                }
                evt.consume();
                break;
            }
            case RESIZE_SE: {
                double newHeight;
                double newWidth = width + deltaX;
                if (newWidth >= minWidth && newWidth <= maxWidth) {
                    this.region.setLayoutX(x);
                    this.region.setPrefWidth(Math.min(maxWidth, Math.max(minWidth, newWidth)));
                    this.startX = x;
                }
                if ((newHeight = height + deltaY) >= minHeight && newHeight <= maxHeight) {
                    this.region.setPrefHeight(Math.max(minHeight, newHeight));
                    this.startY = y;
                }
                evt.consume();
            }
        }
        BiConsumer<Double, Double> onResize = this.getOnResize();
        if (onResize != null) {
            onResize.accept(this.region.getWidth(), this.region.getHeight());
        }
    }

    private void onMousePressed(MouseEvent evt) {
        if (!this.isResizable()) {
            return;
        }
        this.startX = evt.getScreenX();
        this.startY = evt.getScreenY();
        double x = evt.getX();
        double y = evt.getY();
        double offset = this.getOffset();
        if (x < offset) {
            if (y < offset) {
                this.setOperationIfSupported(Operation.RESIZE_NW);
            } else if (y > this.region.getHeight() - offset) {
                this.setOperationIfSupported(Operation.RESIZE_SW);
            } else {
                this.setOperationIfSupported(Operation.RESIZE_W);
            }
        } else if (x > this.region.getWidth() - offset) {
            if (y < offset) {
                this.setOperationIfSupported(Operation.RESIZE_NE);
            } else if (y > this.region.getHeight() - offset) {
                this.setOperationIfSupported(Operation.RESIZE_SE);
            } else {
                this.setOperationIfSupported(Operation.RESIZE_E);
            }
        } else if (y < offset) {
            this.setOperationIfSupported(Operation.RESIZE_N);
        } else if (y > this.region.getHeight() - offset) {
            this.setOperationIfSupported(Operation.RESIZE_S);
        } else {
            this.operation = null;
        }
    }

    private void setOperationIfSupported(Operation resizeNw) {
        this.operation = this.getSupportedOperations().contains((Object)resizeNw) ? resizeNw : null;
    }

    private void onMouseMove(MouseEvent evt) {
        if (!this.isResizable()) {
            return;
        }
        double x = evt.getX();
        double y = evt.getY();
        double offset = this.getOffset();
        if (x < offset) {
            if (y < offset) {
                this.setCursorIfOperationSupported(Operation.RESIZE_NW, Cursor.NW_RESIZE);
            } else if (y > this.region.getHeight() - offset) {
                this.setCursorIfOperationSupported(Operation.RESIZE_SW, Cursor.SW_RESIZE);
            } else {
                this.setCursorIfOperationSupported(Operation.RESIZE_W, Cursor.W_RESIZE);
            }
        } else if (x > this.region.getWidth() - offset) {
            if (y < offset) {
                this.setCursorIfOperationSupported(Operation.RESIZE_NE, Cursor.NE_RESIZE);
            } else if (y > this.region.getHeight() - offset) {
                this.setCursorIfOperationSupported(Operation.RESIZE_SE, Cursor.SE_RESIZE);
            } else {
                this.setCursorIfOperationSupported(Operation.RESIZE_E, Cursor.E_RESIZE);
            }
        } else if (y < offset) {
            this.setCursorIfOperationSupported(Operation.RESIZE_N, Cursor.N_RESIZE);
        } else if (y > this.region.getHeight() - offset) {
            this.setCursorIfOperationSupported(Operation.RESIZE_S, Cursor.S_RESIZE);
        } else {
            this.region.setCursor(Cursor.DEFAULT);
        }
    }

    private void setCursorIfOperationSupported(Operation operation, Cursor cursor) {
        this.region.setCursor(this.getSupportedOperations().contains((Object)operation) ? cursor : Cursor.DEFAULT);
    }

    public final BiConsumer<Double, Double> getOnResize() {
        return this.onResize == null ? null : (BiConsumer)this.onResize.get();
    }

    public final ObjectProperty<BiConsumer<Double, Double>> onResizeProperty() {
        if (this.onResize == null) {
            this.onResize = new SimpleObjectProperty((Object)this, "onResize");
        }
        return this.onResize;
    }

    public final void setOnResize(BiConsumer<Double, Double> onResize) {
        this.onResizeProperty().set(onResize);
    }

    public final double getOffset() {
        return this.offset == null ? 5.0 : this.offset.get();
    }

    public final DoubleProperty offsetProperty() {
        if (this.offset == null) {
            this.offset = new SimpleDoubleProperty((Object)this, "offset", 5.0);
        }
        return this.offset;
    }

    public final void setOffset(double offset) {
        this.offsetProperty().set(offset);
    }

    public final boolean isResizable() {
        return this.resizable == null || this.resizable.get();
    }

    public final BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new SimpleBooleanProperty((Object)this, "resizable", true);
        }
        return this.resizable;
    }

    public final void setResizable(boolean resizable) {
        this.resizableProperty().set(resizable);
    }

    public final ListProperty<Operation> supportedOperationsProperty() {
        return this.supportedOperations;
    }

    public final ObservableList<Operation> getSupportedOperations() {
        return (ObservableList)this.supportedOperations.get();
    }

    public final void setSupportedOperations(ObservableList<Operation> supportedOperations) {
        this.supportedOperationsProperty().set(supportedOperations);
    }

    public static boolean isInstalled(Region region) {
        return Boolean.TRUE.equals(region.getProperties().get((Object)RESIZE_BEHAVIOUR_INSTALLED));
    }

    public boolean isInstalled() {
        return ResizingBehaviour.isInstalled(this.region);
    }

    public void uninstall() {
        this.region.removeEventFilter(MouseEvent.MOUSE_MOVED, this.mouseMovedHandler);
        this.region.removeEventFilter(MouseEvent.MOUSE_ENTERED, this.mouseMovedHandler);
        this.region.removeEventFilter(MouseEvent.MOUSE_ENTERED_TARGET, this.mouseMovedHandler);
        this.region.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mousePressedHandler);
        this.region.removeEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
        this.region.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedHandler);
        this.region.getProperties().remove((Object)RESIZE_BEHAVIOUR_INSTALLED);
    }

    public static enum Operation {
        RESIZE_N,
        RESIZE_S,
        RESIZE_W,
        RESIZE_E,
        RESIZE_NW,
        RESIZE_NE,
        RESIZE_SW,
        RESIZE_SE;

    }
}

