/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.canvas;

import com.cburch.contracts.BaseKeyListenerContract;
import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseMouseMotionListenerContract;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.canvas.CanvasTool;
import com.cburch.draw.model.CanvasModelEvent;
import com.cburch.draw.model.CanvasModelListener;
import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.data.Location;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

class CanvasListener
implements BaseMouseListenerContract,
BaseMouseMotionListenerContract,
BaseKeyListenerContract,
CanvasModelListener {
    private final Canvas canvas;
    private CanvasTool tool;
    private CanvasObject selectedPort;

    public CanvasListener(Canvas canvas) {
        this.canvas = canvas;
        this.tool = null;
        this.selectedPort = null;
    }

    public CanvasTool getTool() {
        return this.tool;
    }

    public void setTool(CanvasTool value) {
        CanvasTool oldValue = this.tool;
        if (value != oldValue) {
            this.tool = value;
            if (oldValue != null) {
                oldValue.toolDeselected(this.canvas);
            }
            if (value != null) {
                value.toolSelected(this.canvas);
                this.canvas.setCursor(value.getCursor(this.canvas));
            } else {
                this.canvas.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private void handlePopupTrigger(MouseEvent e) {
        Location loc = Location.create(e.getX(), e.getY(), false);
        List<CanvasObject> objects = this.canvas.getModel().getObjectsFromTop();
        CanvasObject clicked = null;
        for (CanvasObject o : objects) {
            if (!o.contains(loc, false)) continue;
            clicked = o;
            break;
        }
        if (clicked == null) {
            for (CanvasObject o : objects) {
                if (!o.contains(loc, true)) continue;
                clicked = o;
                break;
            }
        }
        this.canvas.showPopupMenu(e, clicked);
    }

    private void handlePorts(MouseEvent e) {
        Location loc = Location.create(e.getX(), e.getY(), true);
        List<CanvasObject> objects = this.canvas.getModel().getObjectsFromTop();
        ArrayList<CanvasObject> ports = new ArrayList<CanvasObject>();
        CanvasObject newSelectedPort = null;
        for (CanvasObject object : objects) {
            if (!(object instanceof AppearancePort)) continue;
            ports.add(object);
        }
        for (CanvasObject port : ports) {
            if (!port.contains(loc, false) && !port.contains(loc, true)) continue;
            newSelectedPort = port;
        }
        if (newSelectedPort != this.selectedPort) {
            if (newSelectedPort == null) {
                this.canvas.setTooltip(null, null);
                this.canvas.repaint(this.canvas.getVisibleRect());
            } else {
                this.canvas.setTooltip(loc, newSelectedPort.getDisplayNameAndLabel());
                this.canvas.repaint(this.canvas.getVisibleRect());
            }
            this.selectedPort = newSelectedPort;
        }
    }

    private boolean isButton1(MouseEvent e) {
        return (e.getModifiersEx() & 0x400) != 0;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.tool != null) {
            this.tool.keyPressed(this.canvas, e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.tool != null) {
            this.tool.keyReleased(this.canvas, e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.tool != null) {
            this.tool.keyTyped(this.canvas, e);
        }
    }

    @Override
    public void modelChanged(CanvasModelEvent event) {
        this.canvas.getSelection().modelChanged(event);
        this.canvas.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.canvas.setTooltip(null, null);
        if (this.isButton1(e)) {
            if (this.tool != null) {
                this.tool.mouseDragged(this.canvas, e);
            }
        } else if (this.tool != null) {
            this.tool.mouseMoved(this.canvas, e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.tool != null) {
            this.tool.mouseEntered(this.canvas, e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.tool != null) {
            this.tool.mouseExited(this.canvas, e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.handlePorts(e);
        if (this.tool != null) {
            this.tool.mouseMoved(this.canvas, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.canvas.requestFocus();
        if (e.isPopupTrigger()) {
            this.handlePopupTrigger(e);
        } else if (e.getButton() == 1 && this.tool != null) {
            this.tool.mousePressed(this.canvas, e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.tool != null) {
                this.tool.cancelMousePress(this.canvas);
            }
            this.handlePopupTrigger(e);
        } else if (e.getButton() == 1 && this.tool != null) {
            this.tool.mouseReleased(this.canvas, e);
        }
    }
}

