/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseMouseMotionListenerContract;
import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.data.ExpressionRenderData;
import com.cburch.logisim.analyze.data.KarnaughMapGroups;
import com.cburch.logisim.analyze.gui.ExpressionView;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.OutputExpressionsEvent;
import com.cburch.logisim.analyze.model.OutputExpressionsListener;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.TruthTableEvent;
import com.cburch.logisim.analyze.model.TruthTableListener;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.LineBuffer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;

public class KarnaughMapPanel
extends JPanel
implements BaseMouseMotionListenerContract,
BaseMouseListenerContract,
Entry.EntryChangedListener {
    private static final long serialVersionUID = 1L;
    public static final int MAX_VARS = 6;
    public static final int[] ROW_VARS = new int[]{0, 0, 1, 1, 2, 2, 3};
    public static final int[] COL_VARS = new int[]{0, 1, 1, 2, 2, 3, 3};
    private static final int[] bigColIndex = new int[]{0, 1, 3, 2, 6, 7, 5, 4};
    private static final int[] bigColPlace = new int[]{0, 1, 3, 2, 7, 6, 4, 5};
    private static final int cellHorizontalSeparator = 10;
    private static final int cellVerticalSeparator = 10;
    private final MyListener myListener = new MyListener();
    private final ExpressionView completeExpression;
    private final AnalyzerModel model;
    private String output;
    private int cellWidth = 1;
    private int cellHeight = 1;
    private int provisionalX;
    private int provisionalY;
    private Entry provisionalValue = null;
    private final Font headerFont;
    private final Font entryFont;
    private boolean isKMapLined;
    private Bounds kMapArea;
    private KMapInfo linedKMapInfo;
    private KMapInfo numberedKMapInfo;
    private final KarnaughMapGroups karnaughMapGroups;
    private Bounds selInfo;
    private final Point hover;
    private Expression.Notation notation = Expression.Notation.MATHEMATICAL;
    private boolean selected;
    private Dimension kMapDim;

    boolean isSelected() {
        return this.selected;
    }

    public KarnaughMapPanel(AnalyzerModel model, ExpressionView expr) {
        super(new GridLayout(1, 1));
        this.completeExpression = expr;
        this.model = model;
        this.entryFont = AppPreferences.getScaledFont(this.getFont());
        this.headerFont = this.entryFont.deriveFont(1);
        model.getOutputExpressions().addOutputExpressionsListener(this.myListener);
        model.getTruthTable().addTruthTableListener(this.myListener);
        this.setToolTipText(" ");
        this.isKMapLined = AppPreferences.KMAP_LINED_STYLE.get();
        this.karnaughMapGroups = new KarnaughMapGroups(model);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.hover = new Point(-1, -1);
        FocusListener f = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                KarnaughMapPanel.this.selected = true;
                KarnaughMapPanel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                KarnaughMapPanel.this.selected = false;
                KarnaughMapPanel.this.repaint();
            }
        };
        this.addFocusListener(f);
        Entry.ZERO.addListener(this);
        Entry.ONE.addListener(this);
        Entry.DONT_CARE.addListener(this);
    }

    private void computePreferredSize() {
        this.selInfo = null;
        Graphics2D g = (Graphics2D)this.getGraphics();
        TruthTable table = this.model.getTruthTable();
        String message = null;
        if (this.output == null) {
            message = Strings.S.get("karnaughNoOutputError");
        } else if (table.getInputColumnCount() > 6) {
            message = Strings.S.get("karnaughTooManyInputsError");
        } else if (table.getInputColumnCount() == 0) {
            message = Strings.S.get("karnaughNoInputsError");
        } else if (table.getInputColumnCount() == 1) {
            message = Strings.S.get("karnaughTooFewInputsError");
        }
        if (message != null) {
            if (g == null) {
                this.setPreferredSize(new Dimension(AppPreferences.getScaled(20 * message.length()), AppPreferences.getScaled(20)));
            } else {
                FontRenderContext ctx = g.getFontRenderContext();
                TextLayout msgLayout = new TextLayout(message, this.headerFont, ctx);
                this.setPreferredSize(new Dimension((int)msgLayout.getBounds().getWidth(), (int)msgLayout.getBounds().getHeight()));
            }
        } else {
            this.computePreferredLinedSize(g, table);
            this.computePreferredNumberedSize(g, table);
            int boxWidth = Math.max(this.linedKMapInfo.getWidth(), this.numberedKMapInfo.getWidth());
            boxWidth = Math.max(boxWidth, AppPreferences.getScaled(300));
            int boxHeight = Math.max(this.linedKMapInfo.getHeight(), this.numberedKMapInfo.getHeight());
            this.linedKMapInfo.calculateOffsets(boxWidth, boxHeight);
            this.numberedKMapInfo.calculateOffsets(boxWidth, boxHeight);
            int selectedHeight = 0;
            if (g != null) {
                FontRenderContext ctx = g.getFontRenderContext();
                TextLayout t1 = new TextLayout(Strings.S.get("SelectedKmapGroup"), this.headerFont, ctx);
                selectedHeight = 3 * (int)t1.getBounds().getHeight();
            }
            this.selInfo = Bounds.create(0, boxHeight, boxWidth, selectedHeight);
            this.setPreferredSize(new Dimension(boxWidth, boxHeight + selectedHeight));
            this.kMapDim = new Dimension(boxWidth, boxHeight);
        }
        this.invalidate();
        if (g != null) {
            this.repaint();
        }
    }

    public Dimension getKMapDim() {
        return this.kMapDim;
    }

    private List<TextLayout> header(List<String> inputs, int start, int end, boolean rowLabel, boolean addComma, FontRenderContext ctx) {
        ArrayList<TextLayout> lines = new ArrayList<TextLayout>();
        if (start >= end) {
            return lines;
        }
        StringBuilder ret = new StringBuilder(inputs.get(start));
        for (int i = start + 1; i < end; ++i) {
            ret.append(", ");
            ret.append(inputs.get(i));
        }
        if (addComma) {
            ret.append(",");
        }
        int maxSize = rowLabel ? (1 << end - start - 1) * this.cellWidth : 100;
        TextLayout myLayout = this.styled(ret.toString(), this.headerFont, ctx);
        if (end - start <= 1 || myLayout.getBounds().getWidth() <= (double)maxSize) {
            lines.add(myLayout);
            return lines;
        }
        int nrOfEntries = end - start;
        if (nrOfEntries > 1) {
            int half = nrOfEntries >> 1;
            lines.addAll(this.header(inputs, start, end - half, rowLabel, true, ctx));
            lines.addAll(this.header(inputs, end - half, end, rowLabel, addComma, ctx));
        } else {
            lines.add(myLayout);
        }
        return lines;
    }

    private void computePreferredNumberedSize(Graphics2D gfx, TruthTable table) {
        int colLabelWidth;
        int headWidth;
        int headHeight;
        List<String> inputs = this.model.getInputs().bits;
        int inputCount = table.getInputColumnCount();
        int rowVars = ROW_VARS[inputCount];
        int colVars = COL_VARS[inputCount];
        if (gfx == null) {
            this.cellHeight = 16;
            this.cellWidth = 24;
        } else {
            FontMetrics fm = gfx.getFontMetrics(this.entryFont);
            this.cellHeight = fm.getAscent() + 10;
            this.cellWidth = fm.stringWidth("00") + 10;
        }
        int rows = 1 << rowVars;
        int cols = 1 << colVars;
        int bodyWidth = this.cellWidth * (cols + 1);
        int bodyHeight = this.cellHeight * (rows + 1);
        if (gfx == null) {
            headHeight = 16;
            headWidth = 80;
            colLabelWidth = 80;
        } else {
            int w;
            FontRenderContext ctx = gfx.getFontRenderContext();
            List<TextLayout> rowHeader = this.header(inputs, 0, rowVars, true, false, ctx);
            List<TextLayout> colHeader = this.header(inputs, rowVars, rowVars + colVars, false, false, ctx);
            headWidth = 0;
            int height = 0;
            for (TextLayout l : rowHeader) {
                w = (int)l.getBounds().getWidth();
                if (w <= headWidth) continue;
                headWidth = w;
            }
            colLabelWidth = 0;
            for (TextLayout l : colHeader) {
                w = (int)l.getBounds().getWidth();
                int h = (int)l.getBounds().getHeight();
                if (w > colLabelWidth) {
                    colLabelWidth = w;
                }
                if (h <= height) continue;
                height = h;
            }
            headHeight = colHeader.size() * height;
        }
        int tableHeight = headHeight + bodyHeight + 5;
        int tableWidth = headWidth + Math.max(bodyWidth, colLabelWidth + this.cellWidth) + 5;
        this.numberedKMapInfo = new KMapInfo(headWidth, headHeight, tableWidth, tableHeight);
    }

    private void computePreferredLinedSize(Graphics2D gfx, TruthTable table) {
        int headHeight;
        if (gfx == null) {
            headHeight = 16;
            this.cellHeight = 16;
            this.cellWidth = 24;
        } else {
            FontRenderContext ctx = gfx.getFontRenderContext();
            FontMetrics fm = gfx.getFontMetrics(this.headerFont);
            int singleheight = this.styledHeight(this.styled("E", this.headerFont), ctx);
            headHeight = this.styledHeight(this.styled("E:2", this.headerFont), ctx) + (fm.getAscent() - singleheight);
            fm = gfx.getFontMetrics(this.entryFont);
            this.cellHeight = fm.getAscent() + 10;
            this.cellWidth = fm.stringWidth("00") + 10;
        }
        int rows = 1 << ROW_VARS[table.getInputColumnCount()];
        int cols = 1 << COL_VARS[table.getInputColumnCount()];
        int tableWidth = headHeight + this.cellWidth * cols + 15;
        int tableHeight = headHeight + this.cellHeight * rows + 15;
        if (cols >= 4 && rows >= 4) {
            tableWidth += headHeight + 11;
        }
        if (cols >= 4) {
            tableHeight += headHeight + 11;
        }
        if (cols > 4) {
            tableHeight += headHeight + (headHeight >> 2) + 11;
        }
        if (rows > 4) {
            tableWidth += headHeight + (headHeight >> 2) + 11;
        }
        int headWidth = 0;
        this.linedKMapInfo = new KMapInfo(headWidth, headHeight, tableWidth, tableHeight);
    }

    public static int getCol(int tableRow, int rows, int cols) {
        int ret = tableRow % cols;
        if (cols > 4) {
            return bigColPlace[ret];
        }
        return switch (ret) {
            case 2 -> 3;
            case 3 -> 2;
            default -> ret;
        };
    }

    public void setStyleLined() {
        this.isKMapLined = true;
        AppPreferences.KMAP_LINED_STYLE.set(true);
        this.repaint();
    }

    public void setStyleNumbered() {
        this.isKMapLined = false;
        AppPreferences.KMAP_LINED_STYLE.set(false);
        this.repaint();
    }

    public int getOutputColumn(MouseEvent event) {
        return this.model.getOutputs().bits.indexOf(this.output);
    }

    public static int getRow(int tableRow, int rows, int cols) {
        int ret = tableRow / cols;
        if (rows > 4) {
            return bigColPlace[ret];
        }
        return switch (ret) {
            case 2 -> 3;
            case 3 -> 2;
            default -> ret;
        };
    }

    public int getRow(MouseEvent event) {
        TruthTable table = this.model.getTruthTable();
        int inputs = table.getInputColumnCount();
        if (inputs >= ROW_VARS.length) {
            return -1;
        }
        int x = event.getX() - this.kMapArea.getX();
        int y = event.getY() - this.kMapArea.getY();
        if (x < 0 || y < 0) {
            return -1;
        }
        int row = y / this.cellHeight;
        int col = x / this.cellWidth;
        int rows = 1 << ROW_VARS[inputs];
        int cols = 1 << COL_VARS[inputs];
        if (row >= rows || col >= cols) {
            return -1;
        }
        return this.getTableRow(row, col, rows, cols);
    }

    private int getTableRow(int row, int col, int rows, int cols) {
        return this.toRow(row, rows) * cols + this.toCol(col, cols);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.kMapArea == null) {
            return null;
        }
        TruthTable table = this.model.getTruthTable();
        int row = this.getRow(event);
        if (row < 0) {
            return null;
        }
        int col = this.getOutputColumn(event);
        Entry entry = table.getOutputEntry(row, col);
        StringBuilder s = new StringBuilder((String)(entry.getErrorMessage() == null ? "" : entry.getErrorMessage() + "<br>"));
        s.append(this.output).append(" = ").append(entry.getDescription());
        List<String> inputs = this.model.getInputs().bits;
        if (inputs.isEmpty()) {
            return "<html>" + String.valueOf(s) + "</html>";
        }
        s.append("<br>When:");
        int n = inputs.size();
        for (int i = 0; i < 6 && i < inputs.size(); ++i) {
            s.append("<br/>&nbsp;&nbsp;&nbsp;&nbsp;").append(inputs.get(i)).append(" = ").append(row >> n - i - 1 & 1);
        }
        return "<html>" + String.valueOf(s) + "</html>";
    }

    public TruthTable getTruthTable() {
        return this.model.getTruthTable();
    }

    void localeChanged() {
        this.computePreferredSize();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics gfx) {
        this.paintKmap(gfx, true);
    }

    public void paintKmap(Graphics gfx, boolean selectionBlock) {
        int y;
        int x;
        if (!(gfx instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)gfx;
        if (AppPreferences.AntiAliassing.getBoolean()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Color col = g2.getColor();
        if (selectionBlock) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            g2.setColor(col);
        }
        TruthTable table = this.model.getTruthTable();
        int inputCount = table.getInputColumnCount();
        Dimension sz = this.getSize();
        String message = null;
        if (this.output == null) {
            message = Strings.S.get("karnaughNoOutputError");
        } else if (inputCount > 6) {
            message = Strings.S.get("karnaughTooManyInputsError");
        } else if (inputCount == 0) {
            message = Strings.S.get("karnaughNoInputsError");
        } else if (inputCount == 1) {
            message = Strings.S.get("karnaughTooFewInputsError");
        }
        if (message != null) {
            gfx.setFont(this.headerFont);
            GraphicsUtil.drawCenteredText(g2, message, sz.width / 2, sz.height / 2);
            return;
        }
        if (this.isKMapLined) {
            x = this.linedKMapInfo.getXOffset();
            y = this.linedKMapInfo.getYOffset();
            this.drawLinedHeader(g2, x, y);
            x += this.linedKMapInfo.getHeaderHeight() + 11;
            y += this.linedKMapInfo.getHeaderHeight() + 11;
        } else {
            x = this.numberedKMapInfo.getXOffset();
            y = this.numberedKMapInfo.getYOffset();
            this.drawNumberedHeader(g2, x, y);
            x += this.numberedKMapInfo.getHeaderWidth() + this.cellWidth;
            y += this.numberedKMapInfo.getHeaderHeight() + this.cellHeight;
        }
        this.doPaintKMap(g2, x, y, table);
        if (!selectionBlock) {
            return;
        }
        Expression expr = this.karnaughMapGroups.getHighlightedExpression();
        FontRenderContext ctx = g2.getFontRenderContext();
        Color ccol = g2.getColor();
        Color bcol = this.karnaughMapGroups.getBackgroundColor();
        if (bcol != null) {
            g2.setColor(bcol);
        } else {
            g2.setColor(this.getBackground());
        }
        g2.fillRect(this.selInfo.getX(), this.selInfo.getY(), this.selInfo.getWidth() - 1, this.selInfo.getHeight() - 1);
        g2.setColor(ccol);
        g2.drawRect(this.selInfo.getX(), this.selInfo.getY(), this.selInfo.getWidth() - 1, this.selInfo.getHeight() - 1);
        if (expr == null) {
            TextLayout t1 = new TextLayout(Strings.S.get("NoSelectedKmapGroup"), this.headerFont, ctx);
            int xoff = (this.selInfo.getWidth() - (int)t1.getBounds().getWidth()) / 2;
            int yoff = (this.selInfo.getHeight() - (int)t1.getBounds().getHeight()) / 2;
            t1.draw(g2, xoff + this.selInfo.getX(), (float)(yoff + this.selInfo.getY()) + t1.getAscent());
        } else {
            TextLayout t1 = new TextLayout(Strings.S.get("SelectedKmapGroup"), this.headerFont, ctx);
            int xoff = (this.selInfo.getWidth() - (int)t1.getBounds().getWidth()) / 2;
            t1.draw(g2, xoff + this.selInfo.getX(), (float)this.selInfo.getY() + t1.getAscent());
            ExpressionRenderData t2 = new ExpressionRenderData(expr, this.selInfo.getWidth(), this.notation);
            xoff = (this.selInfo.getWidth() - t2.getWidth()) / 2;
            t2.paint(gfx, xoff + this.selInfo.getX(), (int)((float)this.selInfo.getY() + t1.getAscent() + t1.getDescent()));
        }
    }

    public void setNotation(Expression.Notation notation) {
        if (notation == this.notation) {
            return;
        }
        this.notation = notation;
    }

    private String label(int row, int rows) {
        if (row < 0 || row >= rows) {
            throw new RuntimeException(LineBuffer.format("Row {{1}} is outside range of {{2}} rows.", row, rows));
        }
        return switch (rows) {
            case 2 -> String.valueOf(row);
            case 4 -> {
                switch (row) {
                    case 0: {
                        yield "00";
                    }
                    case 1: {
                        yield "01";
                    }
                    case 2: {
                        yield "11";
                    }
                    case 3: {
                        yield "10";
                    }
                }
                throw new IllegalStateException(LineBuffer.format("Unexpected value: {{1}} for rows={{2}}", row, rows));
            }
            case 8 -> {
                switch (row) {
                    case 0: {
                        yield "000";
                    }
                    case 1: {
                        yield "001";
                    }
                    case 2: {
                        yield "011";
                    }
                    case 3: {
                        yield "010";
                    }
                    case 4: {
                        yield "110";
                    }
                    case 5: {
                        yield "111";
                    }
                    case 6: {
                        yield "101";
                    }
                    case 7: {
                        yield "100";
                    }
                }
                throw new IllegalStateException(LineBuffer.format("Unexpected value: {{1}} for rows={{2}}", row, rows));
            }
            default -> throw new IllegalStateException(LineBuffer.format("Unhandled number of rows: {{1}}", rows));
        };
    }

    private void drawNumberedHeader(Graphics2D gfx, int x, int y) {
        TextLayout styledLabel;
        String label;
        TruthTable table = this.model.getTruthTable();
        int inputCount = table.getInputColumnCount();
        int tableXstart = x + this.numberedKMapInfo.getHeaderWidth() + this.cellWidth;
        int tableYstart = y + this.numberedKMapInfo.getHeaderHeight() + this.cellHeight;
        int rowVars = ROW_VARS[inputCount];
        int colVars = COL_VARS[inputCount];
        int rows = 1 << rowVars;
        int cols = 1 << colVars;
        FontMetrics headFm = gfx.getFontMetrics(this.headerFont);
        FontRenderContext ctx = gfx.getFontRenderContext();
        Font numberFont = this.headerFont;
        int width2 = headFm.stringWidth("00");
        int width3 = headFm.stringWidth("000");
        float scale = (float)width2 / (float)width3;
        numberFont = this.headerFont.deriveFont(scale * this.headerFont.getSize2D());
        for (int c = 0; c < cols; ++c) {
            label = this.label(c, cols);
            styledLabel = this.styled(label, numberFont, ctx);
            int xoff = this.cellWidth - (int)styledLabel.getBounds().getWidth() >> 1;
            styledLabel.draw(gfx, tableXstart + xoff + c * this.cellWidth, tableYstart - 3 - (int)styledLabel.getDescent());
        }
        for (int r = 0; r < rows; ++r) {
            label = this.label(r, rows);
            styledLabel = this.styled(label, numberFont, ctx);
            styledLabel.draw(gfx, (float)((double)tableXstart - styledLabel.getBounds().getWidth() - (double)styledLabel.getDescent() - 3.0), (float)tableYstart + ((float)this.cellHeight - styledLabel.getAscent()) / 2.0f + styledLabel.getAscent() + (float)(r * this.cellHeight));
        }
        List<TextLayout> rowHeader = this.header(this.model.getInputs().bits, 0, rowVars, true, false, ctx);
        List<TextLayout> colHeader = this.header(this.model.getInputs().bits, rowVars, rowVars + colVars, false, false, ctx);
        int rx = x + 3;
        int ry = y + this.numberedKMapInfo.getHeaderHeight() + this.cellHeight / 2;
        for (TextLayout l : rowHeader) {
            l.draw(gfx, rx, (float)ry + l.getAscent());
            ry += (int)l.getBounds().getHeight();
        }
        rx = x + this.numberedKMapInfo.getHeaderWidth() + this.cellWidth / 2;
        ry = y + 3;
        for (TextLayout l : colHeader) {
            l.draw(gfx, rx, (float)ry + l.getAscent());
            ry += (int)l.getBounds().getHeight();
        }
    }

    private AttributedString styled(String header, Font font) {
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> stops = new ArrayList<Integer>();
        StringBuilder str = new StringBuilder();
        int idx = 0;
        while (header != null && idx < header.length()) {
            if (header.charAt(idx) == ':' || header.charAt(idx) == '[') {
                ++idx;
                starts.add(str.length());
                while (idx < header.length() && "0123456789".indexOf(header.charAt(idx)) >= 0) {
                    str.append(header.charAt(idx++));
                }
                stops.add(str.length());
                if (idx >= header.length() || header.charAt(idx) != ']') continue;
                ++idx;
                continue;
            }
            str.append(header.charAt(idx++));
        }
        AttributedString styled = new AttributedString(str.toString());
        styled.addAttribute(TextAttribute.FAMILY, font.getFamily());
        styled.addAttribute(TextAttribute.SIZE, font.getSize());
        for (int i = 0; i < starts.size(); ++i) {
            styled.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, (Integer)starts.get(i), (Integer)stops.get(i));
        }
        return styled;
    }

    private TextLayout styled(String header, Font font, FontRenderContext ctx) {
        return new TextLayout(this.styled(header, font).getIterator(), ctx);
    }

    private int styledWidth(AttributedString header, FontRenderContext ctx) {
        TextLayout layout = new TextLayout(header.getIterator(), ctx);
        return (int)layout.getBounds().getWidth();
    }

    private int styledHeight(AttributedString header, FontRenderContext ctx) {
        TextLayout layout = new TextLayout(header.getIterator(), ctx);
        return (int)layout.getBounds().getHeight();
    }

    private void drawKmapLine(Graphics2D gfx, Point p1, Point p2) {
        Stroke oldStroke = gfx.getStroke();
        gfx.setStroke(new BasicStroke(2.0f));
        gfx.drawLine(p1.x, p1.y, p2.x, p2.y);
        if (p1.y == p2.y) {
            gfx.drawLine(p1.x, p1.y - 4, p1.x, p1.y + 4);
            gfx.drawLine(p2.x, p2.y - 4, p2.x, p2.y + 4);
        } else {
            gfx.drawLine(p1.x - 4, p1.y, p1.x + 4, p1.y);
            gfx.drawLine(p2.x - 4, p2.y, p2.x + 4, p2.y);
        }
        gfx.setStroke(oldStroke);
    }

    private void drawLinedHeader(Graphics2D gfx, int x, int y) {
        TruthTable table = this.model.getTruthTable();
        int inputCount = table.getInputColumnCount();
        FontMetrics headFm = gfx.getFontMetrics(this.headerFont);
        FontRenderContext ctx = gfx.getFontRenderContext();
        int rowVars = ROW_VARS[inputCount];
        int colVars = COL_VARS[inputCount];
        int rows = 1 << rowVars;
        int cols = 1 << colVars;
        int headHeight = this.linedKMapInfo.getHeaderHeight();
        for (int i = 0; i < inputCount; ++i) {
            AttributedString header = this.styled(this.model.getInputs().bits.get(i), this.headerFont);
            boolean rotated = false;
            int middleOffset = this.styledWidth(header, ctx) >> 1;
            int offsetX = headHeight + 11;
            int offsetY = headHeight + 11;
            switch (i) {
                case 0: {
                    if (inputCount == 1) {
                        rotated = false;
                        offsetX += this.cellWidth + this.cellWidth / 2;
                        offsetY = headFm.getAscent();
                        break;
                    }
                    rotated = true;
                    offsetY += (rows - 1) * this.cellHeight;
                    if (inputCount < 4) {
                        offsetY += this.cellHeight / 2;
                    }
                    if (inputCount > 5) {
                        offsetY -= this.cellHeight;
                    }
                    offsetX = headFm.getAscent();
                    break;
                }
                case 1: {
                    if (inputCount == 2) {
                        rotated = false;
                        offsetX += this.cellWidth + this.cellWidth / 2;
                        offsetY = headFm.getAscent();
                        break;
                    }
                    if (inputCount == 3) {
                        rotated = false;
                        offsetX += 3 * this.cellWidth;
                        offsetY = headFm.getAscent();
                        break;
                    }
                    rotated = true;
                    offsetX += 4 * this.cellWidth + 11 + headFm.getAscent();
                    offsetY += 2 * this.cellHeight;
                    if (inputCount > 4) {
                        offsetX += 4 * this.cellWidth;
                    }
                    if (inputCount <= 5) break;
                    offsetY += 2 * this.cellHeight;
                    break;
                }
                case 2: {
                    rotated = false;
                    if (inputCount == 3) {
                        offsetX += 2 * this.cellWidth;
                        offsetY += 11 + 2 * this.cellHeight + headFm.getAscent();
                        break;
                    }
                    if (inputCount == 4) {
                        offsetX += 3 * this.cellWidth;
                        offsetY = headFm.getAscent();
                        break;
                    }
                    if (inputCount == 6) {
                        offsetX += 11 + 8 * this.cellWidth + headFm.getAscent() + headHeight + (headHeight >> 2);
                        offsetY += 2 * this.cellHeight;
                        rotated = true;
                        break;
                    }
                    offsetX += 6 * this.cellWidth;
                    offsetY += 11 + 4 * this.cellHeight + headFm.getAscent();
                    break;
                }
                case 3: {
                    rotated = false;
                    if (inputCount == 4) {
                        offsetX += 2 * this.cellWidth;
                        offsetY += 11 + 4 * this.cellHeight + headFm.getAscent();
                        break;
                    }
                    if (inputCount == 6) {
                        offsetX += 6 * this.cellWidth;
                        offsetY += 11 + 8 * this.cellHeight + headFm.getAscent();
                        break;
                    }
                    offsetX += 4 * this.cellWidth;
                    offsetY = headFm.getAscent();
                    break;
                }
                case 4: {
                    rotated = false;
                    if (inputCount == 6) {
                        offsetX += 4 * this.cellWidth;
                        offsetY = headFm.getAscent();
                        break;
                    }
                    offsetX += 2 * this.cellWidth;
                    offsetY += 11 + 4 * this.cellHeight + headFm.getAscent() + headHeight + (headHeight >> 2);
                    break;
                }
                case 5: {
                    rotated = false;
                    offsetX += 2 * this.cellWidth;
                    offsetY += 11 + 8 * this.cellHeight + headFm.getAscent() + headHeight + (headHeight >> 2);
                    break;
                }
            }
            if (rotated) {
                gfx.translate(offsetX + x, offsetY + y);
                gfx.rotate(-1.5707963267948966);
                gfx.drawString(header.getIterator(), -middleOffset, 0);
                gfx.rotate(1.5707963267948966);
                gfx.translate(-(offsetX + x), -(offsetY + y));
                if (i == 2 && inputCount == 6) {
                    gfx.translate(offsetX + x, (offsetY += 4 * this.cellHeight) + y);
                    gfx.rotate(-1.5707963267948966);
                    gfx.drawString(header.getIterator(), -middleOffset, 0);
                    gfx.rotate(1.5707963267948966);
                    gfx.translate(-(offsetX + x), -(offsetY + y));
                }
            } else {
                gfx.drawString(header.getIterator(), offsetX + x - middleOffset, offsetY + y);
            }
            if ((i != 4 || inputCount != 5) && i != 5) continue;
            gfx.drawString(header.getIterator(), 4 * this.cellWidth + offsetX + x - middleOffset, offsetY + y);
        }
        x += headHeight + 11;
        y += headHeight + 11;
        switch (cols) {
            case 2: {
                this.drawKmapLine(gfx, new Point(x + this.cellWidth, y - 8), new Point(x + 2 * this.cellWidth, y - 8));
                break;
            }
            case 4: {
                this.drawKmapLine(gfx, new Point(x + 2 * this.cellWidth, y - 8), new Point(x + 4 * this.cellWidth, y - 8));
                this.drawKmapLine(gfx, new Point(x + this.cellWidth, y + 9 + rows * this.cellHeight), new Point(x + 3 * this.cellWidth, y + 9 + rows * this.cellHeight));
                break;
            }
            case 8: {
                this.drawKmapLine(gfx, new Point(x + this.cellWidth, y + 8 + rows * this.cellHeight + headHeight + (headHeight >> 2)), new Point(x + 3 * this.cellWidth, y + 8 + rows * this.cellHeight + headHeight + (headHeight >> 2)));
                this.drawKmapLine(gfx, new Point(x + 5 * this.cellWidth, y + 8 + rows * this.cellHeight + headHeight + (headHeight >> 2)), new Point(x + 7 * this.cellWidth, y + 8 + rows * this.cellHeight + headHeight + (headHeight >> 2)));
                this.drawKmapLine(gfx, new Point(x + 2 * this.cellWidth, y - 8), new Point(x + 6 * this.cellWidth, y - 8));
                this.drawKmapLine(gfx, new Point(x + 4 * this.cellWidth, y + 8 + rows * this.cellHeight), new Point(x + 8 * this.cellWidth, y + 8 + rows * this.cellHeight));
                break;
            }
        }
        switch (rows) {
            case 2: {
                this.drawKmapLine(gfx, new Point(x - 8, y + this.cellHeight), new Point(x - 8, y + 2 * this.cellHeight));
                break;
            }
            case 4: {
                this.drawKmapLine(gfx, new Point(x - 8, y + 2 * this.cellHeight), new Point(x - 8, y + 4 * this.cellHeight));
                this.drawKmapLine(gfx, new Point(x + cols * this.cellWidth + 8, y + this.cellHeight), new Point(x + cols * this.cellWidth + 8, y + 3 * this.cellHeight));
                break;
            }
            case 8: {
                this.drawKmapLine(gfx, new Point(x - 8, y + 4 * this.cellHeight), new Point(x - 8, y + 8 * this.cellHeight));
                this.drawKmapLine(gfx, new Point(x + cols * this.cellWidth + 8, y + 2 * this.cellHeight), new Point(x + cols * this.cellWidth + 8, y + 6 * this.cellHeight));
                this.drawKmapLine(gfx, new Point(x + cols * this.cellWidth + 8 + headHeight + (headHeight >> 2), y + 1 * this.cellHeight), new Point(x + cols * this.cellWidth + 8 + headHeight + (headHeight >> 2), y + 3 * this.cellHeight));
                this.drawKmapLine(gfx, new Point(x + cols * this.cellWidth + 8 + headHeight + (headHeight >> 2), y + 5 * this.cellHeight), new Point(x + cols * this.cellWidth + 8 + headHeight + (headHeight >> 2), y + 7 * this.cellHeight));
                break;
            }
        }
    }

    private void doPaintKMap(Graphics2D gfx, int x, int y, TruthTable table) {
        Entry entry;
        int row;
        int j;
        int i;
        int inputCount = table.getInputColumnCount();
        int rowVars = ROW_VARS[inputCount];
        int colVars = COL_VARS[inputCount];
        int rows = 1 << rowVars;
        int cols = 1 << colVars;
        gfx.setFont(this.entryFont);
        FontMetrics fm = gfx.getFontMetrics();
        int dy = (this.cellHeight + fm.getAscent()) / 2;
        this.kMapArea = Bounds.create(x, y, cols * this.cellWidth, rows * this.cellHeight);
        Stroke oldstroke = gfx.getStroke();
        gfx.setStroke(new BasicStroke(2.0f));
        gfx.drawLine(x - this.cellHeight, y - this.cellHeight, x, y);
        gfx.setStroke(oldstroke);
        int outputColumn = table.getOutputIndex(this.output);
        for (i = 0; i < rows; ++i) {
            for (j = 0; j < cols; ++j) {
                row = this.getTableRow(i, j, rows, cols);
                entry = table.getOutputEntry(row, outputColumn);
                if (this.provisionalValue != null && row == this.provisionalY && outputColumn == this.provisionalX) {
                    entry = this.provisionalValue;
                }
                if (entry.isError()) {
                    gfx.setColor(Value.errorColor);
                    gfx.fillRect(x + j * this.cellWidth, y + i * this.cellHeight, this.cellWidth, this.cellHeight);
                    gfx.setColor(Color.BLACK);
                } else if (this.hover.x == j && this.hover.y == i) {
                    gfx.fillRect(x + j * this.cellWidth, y + i * this.cellHeight, this.cellWidth, this.cellHeight);
                }
                gfx.setStroke(new BasicStroke(2.0f));
                gfx.drawRect(x + j * this.cellWidth, y + i * this.cellHeight, this.cellWidth, this.cellHeight);
                gfx.setStroke(oldstroke);
            }
        }
        if (outputColumn < 0) {
            return;
        }
        this.karnaughMapGroups.paint(gfx, x, y, this.cellWidth, this.cellHeight);
        gfx.setColor(Color.BLUE);
        for (i = 0; i < rows; ++i) {
            for (j = 0; j < cols; ++j) {
                row = this.getTableRow(i, j, rows, cols);
                if (this.provisionalValue != null && row == this.provisionalY && outputColumn == this.provisionalX) {
                    String text = this.provisionalValue.getDescription();
                    gfx.setColor(Color.BLACK);
                    gfx.drawString(text, x + j * this.cellWidth + (this.cellWidth - fm.stringWidth(text)) / 2, y + i * this.cellHeight + dy);
                    gfx.setColor(Color.BLUE);
                    continue;
                }
                entry = table.getOutputEntry(row, outputColumn);
                String text = entry.getDescription();
                gfx.drawString(text, x + j * this.cellWidth + (this.cellWidth - fm.stringWidth(text)) / 2, y + i * this.cellHeight + dy);
            }
        }
        gfx.setColor(Color.BLACK);
    }

    public void setEntryProvisional(int y, int x, Entry value) {
        this.provisionalY = y;
        this.provisionalX = x;
        this.provisionalValue = value;
        this.repaint();
    }

    public void setOutput(String value) {
        boolean recompute = (this.output == null || value == null) && !Objects.equals(this.output, value);
        this.output = value;
        this.karnaughMapGroups.setOutput(value);
        if (recompute) {
            this.computePreferredSize();
        } else {
            this.repaint();
        }
    }

    public void setFormat(int format) {
        this.karnaughMapGroups.setformat(format);
    }

    private int toRow(int row, int rows) {
        if (rows > 4) {
            return bigColIndex[row];
        }
        if (rows == 4) {
            return switch (row) {
                case 2 -> 3;
                case 3 -> 2;
                default -> row;
            };
        }
        return row;
    }

    private int toCol(int col, int cols) {
        if (cols > 4) {
            return bigColIndex[col];
        }
        if (cols == 4) {
            return switch (col) {
                case 2 -> 3;
                case 3 -> 2;
                default -> col;
            };
        }
        return col;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.kMapArea == null) {
            return;
        }
        int posX = e.getX();
        int posY = e.getY();
        if (posX >= this.kMapArea.getX() && posX <= this.kMapArea.getX() + this.kMapArea.getWidth() && posY >= this.kMapArea.getY() && posY <= this.kMapArea.getY() + this.kMapArea.getHeight()) {
            int y;
            int row;
            int x = posX - this.kMapArea.getX();
            int col = x / this.cellWidth;
            if (this.karnaughMapGroups.highlight(col, row = (y = posY - this.kMapArea.getY()) / this.cellHeight)) {
                Expression expr = this.karnaughMapGroups.getHighlightedExpression();
                this.completeExpression.getRenderData().setSubExpression(expr);
                this.completeExpression.repaint();
                this.repaint();
            }
            if (col != this.hover.x || row != this.hover.y) {
                this.hover.x = col;
                this.hover.y = row;
                this.repaint();
            }
        } else {
            if (!this.karnaughMapGroups.clearHighlight()) {
                this.completeExpression.getRenderData().setSubExpression(null);
                this.completeExpression.repaint();
                this.repaint();
            }
            if (this.hover.x >= 0 || this.hover.y >= 0) {
                this.hover.x = -1;
                this.hover.y = -1;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.kMapArea == null) {
            return;
        }
        int row = this.getRow(e);
        if (row < 0) {
            return;
        }
        int col = this.getOutputColumn(e);
        TruthTable tt = this.model.getTruthTable();
        tt.expandVisibleRows();
        Entry entry = tt.getOutputEntry(row, col);
        if (entry.equals(Entry.DONT_CARE)) {
            tt.setOutputEntry(row, col, Entry.ZERO);
        } else if (entry.equals(Entry.ZERO)) {
            tt.setOutputEntry(row, col, Entry.ONE);
        } else if (entry.equals(Entry.ONE)) {
            tt.setOutputEntry(row, col, Entry.DONT_CARE);
        }
    }

    @Override
    public void entryDesriptionChanged() {
        this.repaint();
    }

    private class MyListener
    implements OutputExpressionsListener,
    TruthTableListener {
        private MyListener() {
        }

        @Override
        public void rowsChanged(TruthTableEvent event) {
        }

        @Override
        public void cellsChanged(TruthTableEvent event) {
            KarnaughMapPanel.this.karnaughMapGroups.update();
            KarnaughMapPanel.this.repaint();
        }

        @Override
        public void expressionChanged(OutputExpressionsEvent event) {
            if (event.getType() == 2 && event.getVariable().equals(KarnaughMapPanel.this.output)) {
                KarnaughMapPanel.this.karnaughMapGroups.update();
                KarnaughMapPanel.this.repaint();
            }
        }

        @Override
        public void structureChanged(TruthTableEvent event) {
            KarnaughMapPanel.this.karnaughMapGroups.update();
            KarnaughMapPanel.this.computePreferredSize();
        }
    }

    private static class KMapInfo {
        private final int headWidth;
        private final int headHeight;
        private final int width;
        private final int height;
        private int xOff = 0;
        private int yOff = 0;

        public KMapInfo(int headWidth, int headHeight, int tableWidth, int tableHeight) {
            this.headWidth = headWidth;
            this.headHeight = headHeight;
            this.width = tableWidth;
            this.height = tableHeight;
        }

        public void calculateOffsets(int boxWidth, int boxHeight) {
            this.xOff = (boxWidth - this.width) / 2;
            this.yOff = (boxHeight - this.height) / 2;
        }

        public int getXOffset() {
            return this.xOff;
        }

        public int getYOffset() {
            return this.yOff;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getHeaderWidth() {
            return this.headWidth;
        }

        public int getHeaderHeight() {
            return this.headHeight;
        }
    }
}

