/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.MouseMappings;
import com.cburch.logisim.file.Strings;
import com.cburch.logisim.file.ToolbarData;

public class Options {
    public static final AttributeOption GATE_UNDEFINED_IGNORE = new AttributeOption("ignore", Strings.S.getter("gateUndefinedIgnore"));
    public static final AttributeOption GATE_UNDEFINED_ERROR = new AttributeOption("error", Strings.S.getter("gateUndefinedError"));
    public static final Attribute<Integer> ATTR_SIM_LIMIT = Attributes.forInteger("simlimit", Strings.S.getter("simLimitOption"));
    public static final Attribute<Integer> ATTR_SIM_RAND = Attributes.forInteger("simrand", Strings.S.getter("simRandomOption"));
    public static final Attribute<AttributeOption> ATTR_GATE_UNDEFINED = Attributes.forOption("gateUndefined", Strings.S.getter("gateUndefinedOption"), new AttributeOption[]{GATE_UNDEFINED_IGNORE, GATE_UNDEFINED_ERROR});
    public static final Integer SIM_RAND_DFLT = 32;
    private static final Attribute<?>[] ATTRIBUTES = new Attribute[]{ATTR_GATE_UNDEFINED, ATTR_SIM_LIMIT, ATTR_SIM_RAND};
    private static final Object[] DEFAULTS = new Object[]{GATE_UNDEFINED_IGNORE, 1000, 0};
    private final AttributeSet attrs = AttributeSets.fixedSet(ATTRIBUTES, DEFAULTS);
    private final MouseMappings mmappings = new MouseMappings();
    private final ToolbarData toolbar = new ToolbarData();

    public void copyFrom(Options other, LogisimFile dest) {
        AttributeSets.copy(other.attrs, this.attrs);
        this.toolbar.copyFrom(other.toolbar, dest);
        this.mmappings.copyFrom(other.mmappings, dest);
    }

    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    public MouseMappings getMouseMappings() {
        return this.mmappings;
    }

    public ToolbarData getToolbarData() {
        return this.toolbar;
    }
}

