/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.LedArrayColumnScanningHdlGeneratorFactory;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;

public class RgbArrayColumnScanningHdlGeneratorFactory
extends LedArrayColumnScanningHdlGeneratorFactory {
    public static final String HDL_IDENTIFIER = "RGBArrayColumnScanning";

    public RgbArrayColumnScanningHdlGeneratorFactory() {
        this.myWires.addWire("s_maxRedLedInputs", -7).addWire("s_maxBlueLedInputs", -7).addWire("s_maxGreenLedInputs", -7);
        this.myPorts.removePorts();
        this.myPorts.add("input", "fpgaGlobalClock", 1, 0).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, -1, 1).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, -1, 2).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, -1, 3).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayColumnAddress, -4, 4).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayRowRedOutputs, -2, 5).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayRowGreenOutputs, -2, 6).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayRowBlueOutputs, -2, 7);
    }

    public static LineBuffer getPortMap(int id) {
        HashMap<String, String> ports = new HashMap<String, String>();
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayColumnAddress, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayColumnAddress, id));
        ports.put("fpgaGlobalClock", "fpgaGlobalClock");
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRowRedOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRowRedOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRowGreenOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRowGreenOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRowBlueOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRowBlueOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, id));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(ports, false);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist netlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("nrOfLeds", "nrOfLeds").pair("nrOfRows", "nrOfRows").pair("activeLow", "activeLow").pair("insR", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs).pair("insG", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs).pair("insB", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs).pair("outsR", LedArrayGenericHdlGeneratorFactory.LedArrayRowRedOutputs).pair("outsG", LedArrayGenericHdlGeneratorFactory.LedArrayRowGreenOutputs).pair("outsB", LedArrayGenericHdlGeneratorFactory.LedArrayRowBlueOutputs);
        contents.add(RgbArrayColumnScanningHdlGeneratorFactory.getColumnCounterCode());
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("makeVirtualInputs : {{process}} ( internalRedLeds, internalGreenLeds, internalBlueLeds ) {{is}}\n{{begin}}\n   s_maxRedLedInputs <= ({{others}} => '0');\n   s_maxGreenLedInputs <= ({{others}} => '0');\n   s_maxBlueLedInputs <= ({{others}} => '0');\n   {{if}} ({{activeLow}} = 1) {{then}}\n      s_maxRedLedInputs({{nrOfLeds}}-1 {{downto}} 0)   <= {{not}} {{insR}};\n      s_maxGreenLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{not}} {{insG}};\n      s_maxBlueLedInputs({{nrOfLeds}}-1 {{downto}} 0)  <= {{not}} {{insB}};\n   {{else}}\n      s_maxRedLedInputs({{nrOfLeds}}-1 {{downto}} 0)   <= {{insR}};\n      s_maxGreenLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{insG}};\n      s_maxBlueLedInputs({{nrOfLeds}}-1 {{downto}} 0)  <= {{insB}};\n   {{end}} {{if}};\n{{end}} {{process}} makeVirtualInputs;\n\ngenOutputs : {{for}} n {{in}} {{nrOfRows}}-1 {{downto}} 0 {{generate}}\n   {{outsR}}(n) <= s_maxRedLedInputs(to_integer(unsigned(s_columnCounterReg)) + n*nrOfColumns);\n   {{outsG}}(n) <= s_maxGreenLedInputs(to_integer(unsigned(s_columnCounterReg)) + n*nrOfColumns);\n   {{outsB}}(n) <= s_maxBlueLedInputs(to_integer(unsigned(s_columnCounterReg)) + n*nrOfColumns);\n{{end}} {{generate}} genOutputs;\n").empty();
        } else {
            contents.add("genvar i;\ngenerate\n   for (i = 0; i < {{nrOfRows}}; i = i + 1)\n   begin:outputs\n      assign {{outsR}}[i] = (activeLow == 1)\n          ? ~{{insR }}[i*nrOfColumns+s_columnCounterReg]\n          :  {{insR }}[i*nrOfColumns+s_columnCounterReg];\n      assign {{outsG}}[i] = (activeLow == 1)\n          ? ~{{insG }}[i*nrOfColumns+s_columnCounterReg]\n          :  {{insG }}[i*nrOfColumns+s_columnCounterReg];\n      assign {{outsB}}[i] = (activeLow == 1)\n          ? ~{{insB }}[i*nrOfColumns+s_columnCounterReg]\n          :  {{insB }}[i*nrOfColumns+s_columnCounterReg];\n   end\nendgenerate\n").empty();
        }
        return contents;
    }
}

