/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Vector;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.numbers.core.Precision;

public abstract class EuclideanVector<V extends EuclideanVector<V>>
implements Vector<V>,
Point<V> {
    public abstract V vectorTo(V var1);

    public abstract V directionTo(V var1);

    public abstract V lerp(V var1, double var2);

    public abstract boolean eq(V var1, Precision.DoubleEquivalence var2);

    public boolean isZero(Precision.DoubleEquivalence precision) {
        return this.eq((EuclideanVector)this.getZero(), precision);
    }

    protected double getCheckedNorm() {
        return Vectors.checkedNorm(this);
    }
}

