/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.lab.gui;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.chart.GLChartPanel;
import org.meteoinfo.chart.IChartPanel;
import org.meteoinfo.chart.MouseMode;
import org.meteoinfo.console.jython.PythonInteractiveInterpreter;
import org.meteoinfo.lab.gui.FrmMain;
import org.meteoinfo.ui.ButtonTabComponent;

public class FigureDockable
extends DefaultSingleCDockable {
    private final JTabbedPane tabbedPanel;
    private FrmMain parent;
    private boolean doubleBuffer;

    public FigureDockable(final FrmMain parent, String id, String title, CAction ... actions) {
        super(id, title, actions);
        this.parent = parent;
        this.doubleBuffer = true;
        this.setTitleIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/figure.svg"));
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PythonInteractiveInterpreter interp = parent.getConsoleDockable().getInterpreter();
                if (FigureDockable.this.tabbedPanel.getTabCount() == 0) {
                    try {
                        interp.exec("mipylib.plotlib.miplot.g_figure = None");
                        interp.exec("mipylib.plotlib.miplot.gca = None");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    interp.set("cp", (Object)FigureDockable.this.getCurrentFigure());
                    interp.exec("mipylib.plotlib.miplot.g_figure = cp");
                    interp.exec("mipylib.plotlib.miplot.gca = None");
                }
            }
        });
        this.getContentPane().add(this.tabbedPanel);
        CButton button = new CButton();
        button.setText("Select");
        button.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/select.svg"));
        button.setTooltip("Select");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.SELECT);
                }
            }
        });
        this.addAction((CAction)button);
        this.addSeparator();
        button = new CButton();
        button.setText("Zoom In");
        button.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/zoom-in.svg"));
        button.setTooltip("Zoom In");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.ZOOM_IN);
                }
            }
        });
        this.addAction((CAction)button);
        button = new CButton();
        button.setText("Zoom Out");
        button.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/zoom-out.svg"));
        button.setTooltip("Zoom Out");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.ZOOM_OUT);
                }
            }
        });
        this.addAction((CAction)button);
        button = new CButton();
        button.setText("Pan");
        button.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/hand.svg"));
        button.setTooltip("Pan");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.PAN);
                }
            }
        });
        this.addAction((CAction)button);
        button = new CButton();
        button.setText("Rotate");
        button.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/rotate_16.svg"));
        button.setTooltip("Rotate");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.ROTATE);
                }
            }
        });
        this.addAction((CAction)button);
        button = new CButton();
        button.setText("Full Extent");
        button.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/full-extent.svg"));
        button.setTooltip("Full Extent");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.onUndoZoomClick();
                }
            }
        });
        this.addAction((CAction)button);
        this.addSeparator();
        button = new CButton();
        button.setText("Identifer");
        button.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/lab/icons/information.svg"));
        button.setTooltip("Identifer");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IChartPanel cp = FigureDockable.this.getCurrentFigure();
                if (cp != null) {
                    cp.setMouseMode(MouseMode.IDENTIFIER);
                }
            }
        });
        this.addAction((CAction)button);
        this.addSeparator();
    }

    public final IChartPanel addNewFigure(String title, final JPanel cp) {
        if (cp instanceof GLChartPanel) {
            ((GLChartPanel)((Object)cp)).setDoubleBuffer(this.doubleBuffer);
        }
        JScrollPane sp = new JScrollPane(cp);
        this.tabbedPanel.add((Component)sp, title);
        this.tabbedPanel.setSelectedComponent(sp);
        ButtonTabComponent btc = new ButtonTabComponent(this.tabbedPanel);
        ButtonTabComponent.TabButton button = btc.getTabButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FigureDockable.this.removeFigure(cp);
            }
        });
        this.tabbedPanel.setTabComponentAt(this.tabbedPanel.indexOfComponent(sp), (Component)btc);
        return (IChartPanel)((Object)cp);
    }

    public final IChartPanel addFigure(final JPanel ncp) {
        ((IChartPanel)((Object)ncp)).setLoading(true);
        if (ncp instanceof GLChartPanel) {
            ((GLChartPanel)((Object)ncp)).setDoubleBuffer(this.doubleBuffer);
        }
        int idx = 1;
        if (this.tabbedPanel.getTabCount() > 0) {
            Object text;
            ArrayList<Integer> idxes = new ArrayList<Integer>();
            for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
                text = this.tabbedPanel.getTitleAt(i);
                String[] strs = ((String)text).split("\\s+");
                if (strs.length <= 1) continue;
                String idxStr = strs[strs.length - 1];
                try {
                    idx = Integer.parseInt(idxStr);
                    idxes.add(idx);
                    continue;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            Collections.sort(idxes);
            idx = 1;
            boolean isIn = false;
            text = idxes.iterator();
            while (text.hasNext()) {
                int i = (Integer)text.next();
                if (idx < i) {
                    isIn = true;
                    break;
                }
                ++idx;
            }
            if (!isIn) {
                idx = idxes.size() + 1;
            }
        }
        JScrollPane sp = new JScrollPane(ncp);
        this.tabbedPanel.add((Component)sp, "Figure " + String.valueOf(idx));
        this.tabbedPanel.setSelectedComponent(sp);
        ButtonTabComponent btc = new ButtonTabComponent(this.tabbedPanel);
        ButtonTabComponent.TabButton button = btc.getTabButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FigureDockable.this.removeFigure(ncp);
            }
        });
        this.tabbedPanel.setTabComponentAt(this.tabbedPanel.indexOfComponent(sp), (Component)btc);
        ((IChartPanel)((Object)ncp)).setLoading(false);
        return (IChartPanel)((Object)ncp);
    }

    public void removeFigure(JPanel cp) {
        JScrollPane sp = (JScrollPane)cp.getParent().getParent();
        if (this.tabbedPanel.getTabCount() > 0) {
            this.tabbedPanel.remove(sp);
        }
        PythonInteractiveInterpreter interp = this.parent.getConsoleDockable().getInterpreter();
        if (this.tabbedPanel.getTabCount() == 0) {
            try {
                interp.exec("mipylib.plotlib.miplot.g_figure = None");
                interp.exec("mipylib.plotlib.miplot.g_axes = None");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            interp.set("cp", (Object)this.getCurrentFigure());
            interp.exec("mipylib.plotlib.miplot.g_figure = cp");
            interp.exec("mipylib.plotlib.miplot.g_axes = None");
        }
    }

    public IChartPanel getCurrentFigure() {
        if (this.tabbedPanel.getTabCount() == 0) {
            return null;
        }
        JScrollPane sp = (JScrollPane)this.tabbedPanel.getSelectedComponent();
        return (IChartPanel)((Object)sp.getViewport().getView());
    }

    public GLChartPanel getFigure(int idx) {
        if (this.tabbedPanel.getTabCount() > idx) {
            JScrollPane sp = (JScrollPane)this.tabbedPanel.getComponentAt(idx);
            return (GLChartPanel)((Object)sp.getViewport().getView());
        }
        return null;
    }

    public int getFigureNumber() {
        return this.tabbedPanel.getTabCount();
    }

    public List<GLChartPanel> getFigures() {
        ArrayList<GLChartPanel> figures = new ArrayList<GLChartPanel>();
        for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
            figures.add(this.getFigure(i));
        }
        return figures;
    }

    public void setCurrentFigure(final JPanel cp) {
        if (this.tabbedPanel.getTabCount() > 0) {
            JScrollPane sp = new JScrollPane(cp);
            this.tabbedPanel.setComponentAt(this.tabbedPanel.getSelectedIndex(), sp);
            ButtonTabComponent btc = (ButtonTabComponent)this.tabbedPanel.getTabComponentAt(this.tabbedPanel.getSelectedIndex());
            ButtonTabComponent.TabButton button = btc.getTabButton();
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FigureDockable.this.removeFigure(cp);
                }
            });
        }
    }

    public void setDoubleBuffer(boolean doubleBuffer) {
        this.doubleBuffer = doubleBuffer;
        List<GLChartPanel> figures = this.getFigures();
        for (GLChartPanel figure : figures) {
            figure.setDoubleBuffer(this.doubleBuffer);
            figure.repaintNew();
        }
    }
}

