/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.transform;

import java.util.function.DoubleUnaryOperator;
import org.meteoinfo.math.transform.TransformException;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.DataType;

final class TransformUtils {
    private static final int NUM_PARTS = 2;

    private TransformUtils() {
    }

    static double[] scaleInPlace(double[] f, double d) {
        int i = 0;
        while (i < f.length) {
            int n = i++;
            f[n] = f[n] * d;
        }
        return f;
    }

    static Complex[] scaleInPlace(Complex[] f, double d) {
        for (int i = 0; i < f.length; ++i) {
            f[i] = Complex.ofCartesian((double)(d * f[i].getReal()), (double)(d * f[i].getImaginary()));
        }
        return f;
    }

    static double[][] createRealImaginary(Complex[] dataC) {
        double[][] dataRI = new double[2][dataC.length];
        double[] dataR = dataRI[0];
        double[] dataI = dataRI[1];
        for (int i = 0; i < dataC.length; ++i) {
            Complex c = dataC[i];
            dataR[i] = c.getReal();
            dataI[i] = c.getImaginary();
        }
        return dataRI;
    }

    static double[][] createRealImaginary(Array dataC) {
        dataC.copyIfView();
        double[][] dataRI = new double[2][(int)dataC.getSize()];
        double[] dataR = dataRI[0];
        double[] dataI = dataRI[1];
        int i = 0;
        while ((long)i < dataC.getSize()) {
            Complex c = dataC.getComplex(i);
            dataR[i] = c.getReal();
            dataI[i] = c.getImaginary();
            ++i;
        }
        return dataRI;
    }

    static Complex[] createComplex(double[][] dataRI) {
        if (dataRI.length != 2) {
            throw new TransformException("Size mismatch: {0} != {1}", dataRI.length, 2);
        }
        double[] dataR = dataRI[0];
        double[] dataI = dataRI[1];
        if (dataR.length != dataI.length) {
            throw new TransformException("Size mismatch: {0} != {1}", dataI.length, dataR.length);
        }
        int n = dataR.length;
        Complex[] c = new Complex[n];
        for (int i = 0; i < n; ++i) {
            c[i] = Complex.ofCartesian((double)dataR[i], (double)dataI[i]);
        }
        return c;
    }

    static Array createComplexArray(double[][] dataRI) {
        if (dataRI.length != 2) {
            throw new TransformException("Size mismatch: {0} != {1}", dataRI.length, 2);
        }
        double[] dataR = dataRI[0];
        double[] dataI = dataRI[1];
        if (dataR.length != dataI.length) {
            throw new TransformException("Size mismatch: {0} != {1}", dataI.length, dataR.length);
        }
        int n = dataR.length;
        Array c = Array.factory((DataType)DataType.COMPLEX, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            c.setComplex(i, Complex.ofCartesian((double)dataR[i], (double)dataI[i]));
        }
        return c;
    }

    static double[] sample(DoubleUnaryOperator f, double min, double max, int n) {
        if (n <= 0) {
            throw new TransformException("Number {0} is not strictly positive", n);
        }
        if (min >= max) {
            throw new TransformException("Number {0} is larger than {1}", min, max);
        }
        double[] s = new double[n];
        double h = (max - min) / (double)n;
        for (int i = 0; i < n; ++i) {
            s[i] = f.applyAsDouble(min + (double)i * h);
        }
        return s;
    }

    public static boolean isPowerOfTwo(int n) {
        return (long)n > 0L && ((long)n & (long)n - 1L) == 0L;
    }

    public static int nextPowerOfTwo(int number) {
        if (TransformUtils.isPowerOfTwo(number)) {
            return number;
        }
        int x = number;
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }
}

