/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.gui;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class FrmMeasurement
extends JDialog {
    private MeasureTypes _measureType;
    private boolean _isArea;
    private double _previousValue;
    private double _currentValue;
    private double _totalValue;
    private Double areaValue = null;
    private String _unitStr;
    private JButton jButton_Area;
    private JButton jButton_Distance;
    private JButton jButton_Feature;
    private JComboBox jComboBox_Units;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JTextArea jTextArea_Content;
    private JToolBar jToolBar1;

    public FrmMeasurement(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Measurement");
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton_Feature = new JButton();
        this.jButton_Distance = new JButton();
        this.jButton_Area = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.jComboBox_Units = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea_Content = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                FrmMeasurement.this.formWindowOpened(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton_Feature.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/measurement.svg"));
        this.jButton_Feature.setToolTipText("Feature");
        this.jButton_Feature.setFocusable(false);
        this.jButton_Feature.setHorizontalTextPosition(0);
        this.jButton_Feature.setVerticalTextPosition(3);
        this.jButton_Feature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeasurement.this.jButton_FeatureActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Feature);
        this.jButton_Distance.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/new-line.svg"));
        this.jButton_Distance.setToolTipText("Distance");
        this.jButton_Distance.setFocusable(false);
        this.jButton_Distance.setHorizontalTextPosition(0);
        this.jButton_Distance.setVerticalTextPosition(3);
        this.jButton_Distance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeasurement.this.jButton_DistanceActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Distance);
        this.jButton_Area.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/area.svg"));
        this.jButton_Area.setToolTipText("Area");
        this.jButton_Area.setFocusable(false);
        this.jButton_Area.setHorizontalTextPosition(0);
        this.jButton_Area.setVerticalTextPosition(3);
        this.jButton_Area.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeasurement.this.jButton_AreaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Area);
        this.jToolBar1.add(this.jSeparator1);
        this.jLabel1.setText("Units:");
        this.jToolBar1.add(this.jLabel1);
        this.jComboBox_Units.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Units.setMinimumSize(new Dimension(30, 24));
        this.jComboBox_Units.setPreferredSize(new Dimension(40, 24));
        this.jComboBox_Units.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMeasurement.this.jComboBox_UnitsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jComboBox_Units);
        this.jComboBox_Units.getAccessibleContext().setAccessibleName("");
        this.jComboBox_Units.getAccessibleContext().setAccessibleDescription("");
        this.jTextArea_Content.setColumns(20);
        this.jTextArea_Content.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea_Content);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 378, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 267, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 133, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.jComboBox_Units.removeAllItems();
        this.jComboBox_Units.addItem("Meters");
        this.jComboBox_Units.addItem("Kilometers");
        this.jComboBox_Units.setSelectedItem("Kilometers");
        this._unitStr = "Kilometers";
        this.jButton_Feature.doClick();
        this.jTextArea_Content.setText("");
        this._previousValue = 0.0;
        this._currentValue = 0.0;
        this._totalValue = 0.0;
    }

    private void jButton_FeatureActionPerformed(ActionEvent evt) {
        this.jButton_Feature.setSelected(true);
        this.jButton_Area.setSelected(false);
        this.jButton_Distance.setSelected(false);
        this._measureType = MeasureTypes.Feature;
        this.jTextArea_Content.setText("");
        this._previousValue = 0.0;
        this._currentValue = 0.0;
        this._totalValue = 0.0;
    }

    private void jButton_AreaActionPerformed(ActionEvent evt) {
        this.jButton_Feature.setSelected(false);
        this.jButton_Area.setSelected(true);
        this.jButton_Distance.setSelected(false);
        this._measureType = MeasureTypes.Area;
        this._isArea = true;
        this.jTextArea_Content.setText("");
        this._previousValue = 0.0;
        this._currentValue = 0.0;
        this._totalValue = 0.0;
    }

    private void jButton_DistanceActionPerformed(ActionEvent evt) {
        this.jButton_Feature.setSelected(false);
        this.jButton_Area.setSelected(false);
        this.jButton_Distance.setSelected(true);
        this._measureType = MeasureTypes.Length;
        this._isArea = false;
        this.jTextArea_Content.setText("");
        this._previousValue = 0.0;
        this._currentValue = 0.0;
        this._totalValue = 0.0;
    }

    private void jComboBox_UnitsActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Units.getItemCount() > 0) {
            this._unitStr = this.jComboBox_Units.getSelectedItem().toString();
        }
    }

    public MeasureTypes getMeasureType() {
        return this._measureType;
    }

    public boolean isArea() {
        return this._isArea;
    }

    public void setArea(boolean istrue) {
        this._isArea = istrue;
        this.areaValue = null;
    }

    public double getPreviousValue() {
        return this._previousValue;
    }

    public void setPreviousValue(double value) {
        this._previousValue = value;
    }

    public double getCurrentValue() {
        return this._currentValue;
    }

    public void setCurrentValue(double value) {
        this._currentValue = value;
        this.showValue();
    }

    public double getTotalValue() {
        return this._totalValue;
    }

    public void setTotalValue(double value) {
        this._totalValue = value;
    }

    public double getAreaValue() {
        return this.areaValue;
    }

    public void setAreaValue(double value) {
        this.areaValue = value;
    }

    private double convertValue(double aValue) {
        return this.convertValue(aValue, this._isArea);
    }

    private double convertValue(double aValue, boolean isArea) {
        double bValue = aValue;
        if (this._unitStr.equals("Kilometers")) {
            bValue = isArea ? aValue / 1000000.0 : aValue / 1000.0;
        }
        return bValue;
    }

    private void showValue() {
        String lines;
        String unitStr = this._unitStr;
        String tStr = "Length";
        double currentValue = this.convertValue(this._currentValue);
        if (this._isArea) {
            unitStr = unitStr + "^2";
            lines = "Area: " + String.format("%1$,f", currentValue) + " " + unitStr;
        } else {
            lines = "Segement " + tStr + ": " + String.format("%1$,f", currentValue) + " " + unitStr;
            this._totalValue = this._previousValue + this._currentValue;
            lines = lines + "\nTotal " + tStr + ": " + String.format("%1$,f", this.convertValue(this._totalValue)) + " " + unitStr;
            if (this.areaValue != null) {
                unitStr = unitStr + "^2";
                double area = this.convertValue(this.areaValue, true);
                lines = lines + "\nArea: " + String.format("%1$,f", area) + " " + unitStr;
            }
        }
        this.jTextArea_Content.setText(lines);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmMeasurement.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmMeasurement dialog = new FrmMeasurement((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static enum MeasureTypes {
        Length,
        Area,
        Feature;

    }
}

