/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.function.IntSupplier;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.concurrent.Parallelism;
import org.ojalgo.type.management.MBeanUtils;
import org.ojalgo.type.management.Throughput;

abstract class ReaderWriterBuilder<B extends ReaderWriterBuilder<B>> {
    private static volatile ExecutorService EXECUTOR = null;
    private ExecutorService myExecutor = null;
    private final File[] myFiles;
    private String myManagerName = null;
    private IntSupplier myParallelism = Parallelism.CORES.limit(32);
    private int myQueueCapacity = 1024;
    private Throughput myStatisticsCollector = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ExecutorService executor() {
        if (EXECUTOR != null) return EXECUTOR;
        Class<ReaderWriterBuilder> clazz = ReaderWriterBuilder.class;
        synchronized (ReaderWriterBuilder.class) {
            if (EXECUTOR != null) return EXECUTOR;
            EXECUTOR = DaemonPoolExecutor.newCachedThreadPool("ojAlgo IO");
            // ** MonitorExit[var0] (shouldn't be in output)
            return EXECUTOR;
        }
    }

    ReaderWriterBuilder(File[] files) {
        this.myFiles = files;
    }

    public B executor(ExecutorService executor) {
        this.myExecutor = executor;
        return (B)this;
    }

    public B manager(String name) {
        this.myManagerName = name;
        return (B)this;
    }

    public B parallelism(int parallelism) {
        return this.parallelism(() -> parallelism);
    }

    public B parallelism(IntSupplier parallelism) {
        this.myParallelism = parallelism;
        return (B)this;
    }

    public B queue(int capacity) {
        this.myQueueCapacity = capacity;
        return (B)this;
    }

    public B statistics(Throughput collector) {
        this.myStatisticsCollector = collector;
        return (B)this;
    }

    ExecutorService getExecutor() {
        if (this.myExecutor == null) {
            this.myExecutor = ReaderWriterBuilder.executor();
        }
        return this.myExecutor;
    }

    File[] getFiles() {
        return this.myFiles;
    }

    int getParallelism() {
        return this.myParallelism.getAsInt();
    }

    int getQueueCapacity() {
        return this.myQueueCapacity;
    }

    Throughput getStatisticsCollector() {
        if (this.myStatisticsCollector == null && this.myManagerName != null) {
            this.myStatisticsCollector = new Throughput();
            MBeanUtils.register(this.myStatisticsCollector, this.myManagerName);
        }
        return this.myStatisticsCollector;
    }

    boolean isStatisticsCollector() {
        return this.myStatisticsCollector != null || this.myManagerName != null;
    }
}

