/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

public class ModifierMask {
    public static int KEY_MASK = 9152;
    private int onmask;
    private int offmask;

    public ModifierMask(int mask) {
        this(mask, ~mask);
    }

    public ModifierMask(int on, int off) {
        this.onmask = on & KEY_MASK;
        this.offmask = off & KEY_MASK;
    }

    public String onMaskToString() {
        StringBuilder builder = new StringBuilder();
        this.put(builder, 512, "alt");
        this.put(builder, 8192, "alt graph");
        this.put(builder, 128, "ctrl");
        this.put(builder, 256, "meta");
        this.put(builder, 64, "shift");
        return builder.toString();
    }

    private void put(StringBuilder builder, int mask, String text) {
        if ((this.onmask & mask) == mask) {
            if (builder.length() > 0) {
                builder.append(" + ");
            }
            builder.append(text);
        }
    }

    public boolean matches(int modifiers) {
        return (modifiers & (this.onmask | this.offmask)) == this.onmask;
    }

    public void setOnmask(int onmask) {
        this.onmask = onmask & KEY_MASK;
    }

    public int getOnmask() {
        return this.onmask;
    }

    public void setOffmask(int offmask) {
        this.offmask = offmask & KEY_MASK;
    }

    public int getOffmask() {
        return this.offmask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.offmask;
        result = 31 * result + this.onmask;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModifierMask other = (ModifierMask)obj;
        if (this.offmask != other.offmask) {
            return false;
        }
        return this.onmask == other.onmask;
    }
}

